/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.segmentation.Rule;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.omegat.util.Token;

public class FindMatches {
    private static final int PENALTY_FOR_FUZZY = 20;
    private static final int PENALTY_FOR_REMOVED = 5;
    private static final int SUBSEGMENT_MATCH_THRESHOLD = 85;
    private static final boolean ALLOW_PARTIALY_MATCH = true;
    private final ISimilarityCalculator distance = new LevenshteinDistance();
    private final Pattern removePattern = PatternConsts.getRemovePattern();
    private static final ITokenizer ALT_TOKENIZER = new DefaultTokenizer();
    private ITokenizer tok;
    private final Locale srcLocale;
    private final int maxCount;
    private List<NearString> result = new ArrayList<NearString>(6);
    private final boolean searchExactlyTheSame;
    private String originalText;
    private String srcText;
    private String removedText;
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;
    FindMatches separateSegmentMatcher;
    private final IExternalMemory[] externalMemories;
    private String memoryPath = null;
    Map<String, Token[]> tokenizeStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeNoStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeAllCache = new HashMap<String, Token[]>();

    public FindMatches(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this(sourceTokenizer, externalMemories, maxCount, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.memoryPath = memoryPath;
    }

    public FindMatches(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, int maxCount, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this.tok = sourceTokenizer;
        this.srcLocale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        this.maxCount = maxCount;
        this.searchExactlyTheSame = searchExactlyTheSame;
        this.externalMemories = externalMemories;
        if (allowSeparateSegmentMatch) {
            this.separateSegmentMatcher = new FindMatches(sourceTokenizer, externalMemories, 1, false, true);
        }
    }

    public List<NearString> search(IProject project, String searchText, boolean requiresTranslation, boolean fillSimilarityData, IStopped stop) throws StoppedException {
        this.result.clear();
        this.originalText = searchText;
        this.srcText = searchText;
        this.removedText = "";
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(this.srcText);
            while (removeMatcher.find()) {
                this.removedText = this.removedText + this.srcText.substring(removeMatcher.start(), removeMatcher.end());
            }
            this.srcText = removeMatcher.replaceAll("");
        }
        this.strTokensStem = this.tokenizeStem(this.srcText);
        this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
        this.strTokensAll = this.tokenizeAll(this.srcText);
        ITokenizer tempTokenizer = this.tok;
        if (this.strTokensStem.length == 0 || this.strTokensNoStem.length == 0) {
            this.tok = ALT_TOKENIZER;
            this.tokenizeStemCache.clear();
            this.tokenizeNoStemCache.clear();
            this.tokenizeAllCache.clear();
            this.strTokensStem = this.tokenizeStem(this.srcText);
            this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
            this.strTokensAll = this.tokenizeAll(this.srcText);
        }
        if (this.memoryPath == null) {
            this.searchInProject(project, requiresTranslation, stop);
        }
        Language sourceLang = project.getProjectProperties().getSourceLanguage();
        Language targetLang = project.getProjectProperties().getTargetLanguage();
        String prefForeign = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");
        Pattern SEARCH_FOR_PENALTY = Pattern.compile("penalty-(\\d+)");
        for (Map.Entry<String, IExternalMemory> en : project.getTransMemories().entrySet()) {
            if (this.memoryPath != null && !en.getKey().contains(this.memoryPath)) continue;
            int penalty = 0;
            Matcher matcher = SEARCH_FOR_PENALTY.matcher(en.getKey());
            if (matcher.find()) {
                penalty = Integer.parseInt(matcher.group(1));
            }
            try {
                for (ITMXEntry iTMXEntry : en.getValue().findMatchingTranslations(sourceLang, targetLang, this.originalText, 30, this.maxCount)) {
                    this.checkStopped(stop);
                    if (iTMXEntry.getSourceText() == null || requiresTranslation && iTMXEntry.getTranslationText() == null) continue;
                    int penalty1 = 0;
                    try {
                        penalty1 = Integer.parseInt(iTMXEntry.getPropValue("omegat.penalty"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int penalty2 = 0;
                    String traLang2 = iTMXEntry.getPropValue("x-target-lang");
                    if (traLang2 != null) {
                        matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang2);
                        if (matcher.find()) {
                            traLang2 = matcher.group(1);
                        }
                        if (!traLang2.equalsIgnoreCase(targetLang.getLanguageCode())) {
                            if (prefForeign.endsWith("false")) continue;
                            if (prefForeign.contains(";")) {
                                String[] prefs = prefForeign.split(";");
                                for (int i = 0; i < prefs.length - 1; ++i) {
                                    String[] parts = prefs[i].split(" ");
                                    matcher = PatternConsts.LANG_AND_COUNTRY.matcher(parts[0]);
                                    if (matcher.find()) {
                                        parts[0] = matcher.group(1);
                                    }
                                    if (!parts[0].equalsIgnoreCase(traLang2)) continue;
                                    try {
                                        penalty2 = Integer.parseInt(parts[1]);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (penalty2 == 0) {
                                try {
                                    String pref = prefForeign;
                                    if (pref.contains(";")) {
                                        pref = pref.substring(pref.lastIndexOf(59) + 1);
                                    }
                                    penalty2 = Integer.parseInt(pref.substring(0, pref.indexOf(32)));
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    this.processEntry(null, iTMXEntry.getSourceText(), iTMXEntry.getTranslationText(), NearString.MATCH_SOURCE.TM, false, penalty + penalty1 + penalty2, en.getValue().getMemoryName(), iTMXEntry.getCreator(), iTMXEntry.getCreationDate(), iTMXEntry.getChanger(), iTMXEntry.getChangeDate(), iTMXEntry.getPropValue("revisor"), iTMXEntry.getNote(), iTMXEntry.getProperties());
                }
            }
            catch (StoppedException stopex) {
                throw stopex;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        for (IExternalMemory provider : this.externalMemories) {
            try {
                if (this.memoryPath != null && !provider.getMemoryName().contains(this.memoryPath)) continue;
                for (ITMXEntry iTMXEntry : provider.findMatchingTranslations(sourceLang, targetLang, this.originalText, 30, this.maxCount)) {
                    this.checkStopped(stop);
                    this.processEntry(null, iTMXEntry.getSourceText(), iTMXEntry.getTranslationText(), NearString.MATCH_SOURCE.TM, false, 0, provider.getMemoryName(), iTMXEntry.getCreator(), iTMXEntry.getCreationDate(), iTMXEntry.getChanger(), iTMXEntry.getChangeDate(), iTMXEntry.getPropValue("revisor"), iTMXEntry.getNote(), iTMXEntry.getProperties());
                }
            }
            catch (StoppedException stopex) {
                throw stopex;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        for (SourceTextEntry ste : project.getAllEntries()) {
            this.checkStopped(stop);
            if (this.memoryPath != null && ste.getKey() != null && ste.getKey().file != null && ste.getKey().file.contains(this.memoryPath) || ste.getSourceTranslation() == null) continue;
            this.processEntry(ste.getKey(), ste.getSrcText(), ste.getSourceTranslation(), NearString.MATCH_SOURCE.MEMORY, ste.isSourceTranslationFuzzy(), 0, ste.getKey().file, "", 0L, "", 0L, "", ste.getComment(), null);
        }
        if (this.separateSegmentMatcher != null && this.memoryPath == null && !project.getProjectProperties().isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            List<String> segments = Core.getSegmenter().segment(sourceLang, this.srcText, spaces, brules);
            if (segments.size() > 1) {
                short s;
                ArrayList<String> fsrc = new ArrayList<String>(segments.size());
                ArrayList<String> ftrans = new ArrayList<String>(segments.size());
                boolean bl = false;
                while (s < segments.size()) {
                    String onesrc = segments.get(s);
                    List<NearString> segmentMatch = this.separateSegmentMatcher.search(project, onesrc, requiresTranslation, false, stop);
                    if (!segmentMatch.isEmpty() && segmentMatch.get((int)0).score >= 85) {
                        fsrc.add(segmentMatch.get((int)0).source);
                        ftrans.add(segmentMatch.get((int)0).translation);
                    } else {
                        fsrc.add("");
                        ftrans.add("");
                    }
                    s = (short)(s + true);
                }
                String string = Core.getSegmenter().glue(sourceLang, sourceLang, fsrc, spaces, brules);
                String foundTrans = Core.getSegmenter().glue(sourceLang, targetLang, ftrans, spaces, brules);
                this.processEntry(null, string, foundTrans, NearString.MATCH_SOURCE.TM, false, 0, "", "", 0L, "", 0L, "", "", null);
            }
        }
        if (fillSimilarityData) {
            for (NearString near : this.result) {
                byte[] similarityData = FuzzyMatcher.buildSimilarityData(this.strTokensAll, this.tokenizeAll(near.source));
                near.attr = similarityData;
            }
        }
        this.tok = tempTokenizer;
        return this.result;
    }

    private void searchInProject(IProject project, boolean requiresTranslation, IStopped stop) {
        String orphanedFileName = OStrings.getString("CT_ORPHAN_STRINGS");
        if (project.getProjectProperties().isSupportDefaultTranslations()) {
            project.iterateByDefaultTranslations((source, trans) -> {
                this.checkStopped(stop);
                if (!this.searchExactlyTheSame && source.equals(this.originalText)) {
                    return;
                }
                if (requiresTranslation && trans.translation == null) {
                    return;
                }
                String fileName = project.isOrphaned(source) ? orphanedFileName : null;
                this.processEntry(null, source, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, trans.revisor, trans.note, null);
            });
        }
        project.iterateByMultipleTranslations((source, trans) -> {
            this.checkStopped(stop);
            if (!this.searchExactlyTheSame && source.sourceText.equals(this.originalText)) {
                return;
            }
            if (requiresTranslation && trans.translation == null) {
                return;
            }
            String fileName = project.isOrphaned(source) ? orphanedFileName : null;
            this.processEntry(source, source.sourceText, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, trans.revisor, trans.note, null);
        });
    }

    protected void processEntry(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int penalty, String tmxName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        String realSource = source;
        String entryRemovedText = "";
        int realPenaltyForRemoved = 0;
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(realSource);
            while (removeMatcher.find()) {
                entryRemovedText = entryRemovedText + source.substring(removeMatcher.start(), removeMatcher.end());
            }
            realSource = removeMatcher.replaceAll("");
            if (!entryRemovedText.equals(this.removedText)) {
                realPenaltyForRemoved = 5;
            }
        }
        Token[] candTokens = this.tokenizeStem(realSource);
        int similarityStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensStem, candTokens);
        similarityStem -= penalty;
        if (fuzzy) {
            similarityStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem -= realPenaltyForRemoved, Integer.MAX_VALUE, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensNoStem = this.tokenizeNoStem(realSource);
        int similarityNoStem = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensNoStem, candTokensNoStem);
        similarityNoStem -= penalty;
        if (fuzzy) {
            similarityNoStem -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem -= realPenaltyForRemoved, Integer.MAX_VALUE)) {
            return;
        }
        Token[] candTokensAll = this.tokenizeAll(realSource);
        int simAdjusted = FuzzyMatcher.calcSimilarity(this.distance, this.strTokensAll, candTokensAll);
        simAdjusted -= penalty;
        if (fuzzy) {
            simAdjusted -= 20;
        }
        if (!this.haveChanceToAdd(similarityStem, similarityNoStem, simAdjusted -= realPenaltyForRemoved)) {
            return;
        }
        this.addNearString(key, source, translation, comesFrom, fuzzy, similarityStem, similarityNoStem, simAdjusted, null, tmxName, creator, creationDate, changer, changedDate, revisor, note, props);
    }

    protected boolean haveChanceToAdd(int simStem, int simNoStem, int simExactly) {
        if (simStem < 30 && simNoStem < 30) {
            return false;
        }
        if (this.result.size() < this.maxCount) {
            return true;
        }
        NearString st = this.result.get(this.result.size() - 1);
        int chance = this.checkScore(st.score, simStem);
        if (chance == 0) {
            chance = this.checkScore(st.scoreNoStem, simNoStem);
        }
        if (chance == 0) {
            chance = this.checkScore(st.adjustedScore, simExactly);
        }
        return chance != 1;
    }

    private int checkScore(int storedScore, int checkedStore) {
        return storedScore < checkedStore ? -1 : (storedScore > checkedStore ? 1 : 0);
    }

    protected void addNearString(EntryKey key, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int similarity, int similarityNoStem, int simAdjusted, byte[] similarityData, String tmxName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> tuProperties) {
        int pos = 0;
        for (int i = 0; i < this.result.size(); ++i) {
            NearString st = this.result.get(i);
            if (Preferences.isPreferenceDefault("ext_tmx_do_merge", true) && source.equals(st.source) && (translation == null && st.translation == null || translation != null && translation.equals(st.translation))) {
                this.result.set(i, NearString.merge(st, key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, revisor, note, tuProperties));
                return;
            }
            if (st.score < similarity) break;
            if (st.score == similarity) {
                if (st.scoreNoStem < similarityNoStem) break;
                if (st.scoreNoStem == similarityNoStem) {
                    if (st.adjustedScore < simAdjusted) break;
                    String entrySource = this.srcText;
                    if (similarity == 100 && !st.source.equals(entrySource) && source.equals(entrySource)) break;
                }
            }
            pos = i + 1;
        }
        this.result.add(pos, new NearString(key, source, translation, comesFrom, fuzzy, similarity, similarityNoStem, simAdjusted, similarityData, tmxName, creator, creationDate, changer, changedDate, revisor, note, tuProperties));
        if (this.result.size() > this.maxCount) {
            this.result.remove(this.result.size() - 1);
        }
    }

    public Token[] tokenizeStem(String str) {
        Token[] result = this.tokenizeStemCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.MATCHING);
            this.tokenizeStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeNoStem(String str) {
        Token[] result = this.tokenizeNoStemCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.NONE);
            this.tokenizeNoStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeAll(String str) {
        Token[] result = this.tokenizeAllCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeVerbatim(str);
            this.tokenizeAllCache.put(str, result);
        }
        return result;
    }

    protected void checkStopped(IStopped stop) throws StoppedException {
        if (stop.isStopped()) {
            throw new StoppedException();
        }
    }

    public static class StoppedException
    extends RuntimeException {
    }
}

