/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters3.xml;

import java.util.ArrayList;
import java.util.List;
import org.omegat.filters3.xml.Entity;
import org.omegat.filters3.xml.XMLPseudoTag;

public class DTD
extends XMLPseudoTag {
    private String name;
    private String publicId;
    private String systemId;
    private List<Entity> entities;

    public String getPublicId() {
        return this.publicId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public DTD(String name, String publicId, String systemId) {
        this.name = name;
        this.publicId = publicId;
        this.systemId = systemId;
        this.entities = new ArrayList<Entity>();
    }

    public void addEntity(Entity entity) {
        this.entities.add(entity);
    }

    @Override
    public String toOriginal() {
        StringBuilder res = new StringBuilder();
        res.append("<!DOCTYPE");
        res.append(" ");
        res.append(this.name);
        if (this.publicId != null) {
            res.append(" ");
            res.append("PUBLIC");
            res.append(" ");
            res.append("\"" + this.publicId + "\"");
        }
        if (this.systemId != null) {
            res.append(" ");
            res.append("\"" + this.systemId + "\"");
        }
        if (!this.entities.isEmpty()) {
            res.append("\n[\n");
            for (Entity entity : this.entities) {
                res.append(entity.toString());
                res.append("\n");
            }
            res.append("]");
        }
        res.append(">");
        res.append("\n");
        return res.toString();
    }
}

