/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class GlossaryAutoCompleterOptionsDialog
extends JDialog {
    private JButton cancelButton;
    private JCheckBox displaySourceCheckBox;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JCheckBox longerFirstCheckBox;
    private JButton okButton;
    private JCheckBox sortBySourceCheckBox;
    private JCheckBox sortEntriesCheckBox;
    private ButtonGroup sourceButtonGroup;
    private JRadioButton sourceFirstRadioButton;
    private JRadioButton targetFirstRadioButton;

    public GlossaryAutoCompleterOptionsDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.displaySourceCheckBox.setSelected(Preferences.isPreference("ac_glossary_show_source"));
        this.activateSourceItems(this.displaySourceCheckBox.isSelected());
        this.sourceFirstRadioButton.setSelected(!Preferences.isPreference("ac_glossary_show_target_before_source"));
        this.targetFirstRadioButton.setSelected(Preferences.isPreference("ac_glossary_show_target_before_source"));
        this.sortBySourceCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_by_source"));
        this.longerFirstCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_by_length"));
        this.sortEntriesCheckBox.setSelected(Preferences.isPreference("ac_glossary_sort_alphabetically"));
        DockingUI.displayCentered(this);
    }

    private void initComponents() {
        this.sourceButtonGroup = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.displaySourceCheckBox = new JCheckBox();
        this.sourceFirstRadioButton = new JRadioButton();
        this.targetFirstRadioButton = new JRadioButton();
        this.sortBySourceCheckBox = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.longerFirstCheckBox = new JCheckBox();
        this.sortEntriesCheckBox = new JCheckBox();
        this.jPanel4 = new JPanel();
        this.jPanel3 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("AC_OPTIONS_GLOSSARY_FRAME"));
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel2.setLayout(new GridBagLayout());
        this.displaySourceCheckBox.setText(OStrings.getString("AC_OPTIONS_DISPLAY_SOURCE"));
        this.displaySourceCheckBox.setToolTipText(OStrings.getString("AC_OPTIONS_DISPLAY_SOURCE_TOOLTIP"));
        this.displaySourceCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryAutoCompleterOptionsDialog.this.displaySourceCheckBoxActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.displaySourceCheckBox, gridBagConstraints);
        this.sourceButtonGroup.add(this.sourceFirstRadioButton);
        this.sourceFirstRadioButton.setText(OStrings.getString("AC_OPTIONS_SOURCE_FIRST"));
        this.sourceFirstRadioButton.setToolTipText(OStrings.getString("AC_OPTIONS_SOURCE_FIRST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel2.add((Component)this.sourceFirstRadioButton, gridBagConstraints);
        this.sourceButtonGroup.add(this.targetFirstRadioButton);
        this.targetFirstRadioButton.setText(OStrings.getString("AC_OPTIONS_TARGET_FIRST"));
        this.targetFirstRadioButton.setToolTipText(OStrings.getString("AC_OPTIONS_TARGET_FIRST_TOOLTIP"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel2.add((Component)this.targetFirstRadioButton, gridBagConstraints);
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        this.sortBySourceCheckBox.setText(bundle.getString("AC_OPTIONS_SORT_SOURCE_ALPHABETICALLY"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        this.jPanel2.add((Component)this.sortBySourceCheckBox, gridBagConstraints);
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(OStrings.getString("AC_GLOSSARY_TARGET_PANEL")));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.longerFirstCheckBox.setText(OStrings.getString("AC_OPTIONS_SORT_BY_LENGTH"));
        this.longerFirstCheckBox.setToolTipText(OStrings.getString("AC_OPTIONS_SORT_BY_LENGTH_TOOLTIP"));
        this.jPanel1.add(this.longerFirstCheckBox);
        this.sortEntriesCheckBox.setText(OStrings.getString("AC_OPTIONS_SORT_TARGET_ALPHABETICALLY"));
        this.sortEntriesCheckBox.setToolTipText(OStrings.getString("AC_OPTIONS_SORT_ALPHABETICALLY_TOOLTIP"));
        this.jPanel1.add(this.sortEntriesCheckBox);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.jPanel2.add((Component)this.jPanel1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel3.setLayout(new BoxLayout(this.jPanel3, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryAutoCompleterOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GlossaryAutoCompleterOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel3.add(this.cancelButton);
        this.jPanel4.add((Component)this.jPanel3, "East");
        this.getContentPane().add((Component)this.jPanel4, "South");
        this.pack();
    }

    private void doClose() {
        this.setVisible(false);
        this.dispose();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose();
    }

    private void activateSourceItems(boolean activate) {
        this.sortBySourceCheckBox.setEnabled(activate);
        this.sourceFirstRadioButton.setEnabled(activate);
        this.targetFirstRadioButton.setEnabled(activate);
    }

    private void displaySourceCheckBoxActionPerformed(ActionEvent evt) {
        this.activateSourceItems(this.displaySourceCheckBox.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("ac_glossary_show_source", this.displaySourceCheckBox.isSelected());
        if (this.displaySourceCheckBox.isSelected()) {
            Preferences.setPreference("ac_glossary_show_target_before_source", this.targetFirstRadioButton.isSelected());
            Preferences.setPreference("ac_glossary_sort_by_source", this.sortBySourceCheckBox.isSelected());
        }
        Preferences.setPreference("ac_glossary_sort_by_length", this.longerFirstCheckBox.isSelected());
        Preferences.setPreference("ac_glossary_sort_alphabetically", this.sortEntriesCheckBox.isSelected());
        this.doClose();
    }
}

