/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.mark;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import javax.swing.text.AttributeSet;
import javax.swing.text.Highlighter;
import org.apache.commons.lang.StringEscapeUtils;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.mark.IMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.editor.mark.TransparentHighlightPainter;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;

public class ProtectedPartsMarker
implements IMarker {
    protected static final Highlighter.HighlightPainter PAINTERrtl = new TransparentHighlightPainter(Styles.EditorColor.COLOR_PLACEHOLDER.getColor(), 0.2f);
    protected static final AttributeSet ATTRIBUTESltr = Styles.createAttributeSet(Styles.EditorColor.COLOR_PLACEHOLDER.getColor(), null, null, null);

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) throws Exception {
        Highlighter.HighlightPainter painter;
        AttributeSet attrs;
        if (((EditorController)Core.getEditor()).getOrientation() == Document3.ORIENTATION.ALL_LTR) {
            attrs = ATTRIBUTESltr;
            painter = null;
        } else {
            attrs = null;
            painter = PAINTERrtl;
        }
        ArrayList<Mark> r = new ArrayList<Mark>();
        for (ProtectedPart pp : ste.getProtectedParts()) {
            Mark m;
            int pos;
            if (sourceText != null) {
                pos = -1;
                while ((pos = sourceText.indexOf(pp.getTextInSourceSegment(), pos + 1)) >= 0) {
                    m = new Mark(Mark.ENTRY_PART.SOURCE, pos, pos + pp.getTextInSourceSegment().length());
                    m.painter = painter;
                    m.attributes = attrs;
                    m.toolTipText = this.escapeHtml(pp.getDetailsFromSourceFile());
                    r.add(m);
                }
            }
            if (translationText == null) continue;
            pos = -1;
            while ((pos = translationText.indexOf(pp.getTextInSourceSegment(), pos + 1)) >= 0) {
                m = new Mark(Mark.ENTRY_PART.TRANSLATION, pos, pos + pp.getTextInSourceSegment().length());
                m.painter = painter;
                m.attributes = attrs;
                m.toolTipText = this.escapeHtml(pp.getDetailsFromSourceFile());
                r.add(m);
            }
        }
        return r;
    }

    private String escapeHtml(String s) {
        boolean doSimplify = Preferences.isPreferenceDefault("view_option_ppt_simplify", true);
        Matcher m = PatternConsts.PROTECTED_PARTS_PAIRED_TAG_DECOMPILE.matcher(s);
        if (m.find()) {
            s = s.replace("&", "&amp;");
            StringBuilder text = new StringBuilder(s.length() * 2);
            if (!doSimplify) {
                text.append(m.group(1).replace("<", "&lt;").replace(">", "&gt;"));
                text.append("<b>");
            }
            text.append(m.group(2).replace("<", "&lt;").replace(">", "&gt;"));
            if (!doSimplify) {
                text.append("</b>");
                text.append(m.group(3).replace("<", "&lt;").replace(">", "&gt;"));
            }
            return text.toString();
        }
        if (doSimplify && (m = PatternConsts.EQUIV_TEXT_ATTRIBUTE_DECOMPILE.matcher(s)).find()) {
            s = StringEscapeUtils.unescapeHtml((String)m.group(1));
        }
        return s.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;");
    }
}

