/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.EncodingDetector;

public class GlossaryReaderCSV {
    protected static final char SEPARATOR = ',';

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws IOException {
        String encoding = EncodingDetector.detectEncodingDefault(file, "UTF-8");
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        try (BufferedReader in = new BufferedReader(reader);){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("#") && (tokens = GlossaryReaderCSV.parseLine(s)).length >= 2 && !tokens[0].isEmpty()) {
                    String comment = "";
                    if (tokens.length >= 3) {
                        comment = tokens[2];
                    }
                    result.add(new GlossaryEntry(tokens[0], tokens[1], comment, priorityGlossary));
                }
                s = in.readLine();
            }
        }
        return result;
    }

    private static String[] parseLine(String line) {
        int cp;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder w = new StringBuilder();
        boolean fopened = false;
        block6: for (int i = 0; i < line.length(); i += Character.charCount(cp)) {
            int cpn;
            cp = line.codePointAt(i);
            try {
                cpn = line.codePointAt(i + Character.charCount(cp));
            }
            catch (StringIndexOutOfBoundsException ex) {
                cpn = 0;
            }
            switch (cp) {
                case 34: {
                    if (w.length() == 0 && !fopened) {
                        fopened = true;
                        continue block6;
                    }
                    if (cpn == 34) {
                        w.appendCodePoint(cp);
                        ++i;
                        continue block6;
                    }
                    fopened = false;
                    continue block6;
                }
                case 44: {
                    if (fopened) {
                        w.appendCodePoint(cp);
                        continue block6;
                    }
                    result.add(w.toString());
                    w.setLength(0);
                    continue block6;
                }
                default: {
                    w.appendCodePoint(cp);
                }
            }
        }
        result.add(w.toString());
        return result.toArray(new String[result.size()]);
    }
}

