/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.omegat.core.Core;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

public class GlossaryReaderTBX {
    private static final XMLInputFactory factory = XMLInputFactory.newInstance();

    public static List<GlossaryEntry> read(File file, boolean priorityGlossary) throws Exception {
        return GlossaryReaderTBX.readMartif(new FileInputStream(file), priorityGlossary);
    }

    public static List<GlossaryEntry> read(String data, boolean priorityGlossary) throws Exception {
        return GlossaryReaderTBX.readMartif(new ByteArrayInputStream(data.getBytes()), priorityGlossary);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<GlossaryEntry> readMartif(InputStream is, boolean priorityGlossary) throws Exception {
        try {
            XMLStreamReader reader = factory.createXMLStreamReader(is);
            ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
            while (reader.hasNext()) {
                if (reader.next() != 1 || !reader.getLocalName().equals("termEntry") && !reader.getLocalName().equals("conceptEntry")) continue;
                GlossaryReaderTBX.readTermEntry(result, reader, priorityGlossary);
            }
            Log.log("Read " + result.size() + " entries");
            ArrayList<GlossaryEntry> arrayList = result;
            return arrayList;
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void readTermEntry(List<GlossaryEntry> result, XMLStreamReader reader, boolean priorityGlossary) throws Exception {
        String sLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguageCode();
        String tLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguageCode();
        StringBuilder note = new StringBuilder();
        StringBuilder descTerm = new StringBuilder();
        StringBuilder descTig = new StringBuilder();
        ArrayList<String> sTerms = new ArrayList<String>();
        ArrayList<String> tTerms = new ArrayList<String>();
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && (reader.getLocalName().equals("termEntry") || reader.getLocalName().equals("conceptEntry"))) {
                StringBuilder comment = new StringBuilder();
                GlossaryReaderTBX.appendLine(comment, descTerm.toString());
                GlossaryReaderTBX.appendLine(comment, descTig.toString());
                GlossaryReaderTBX.appendLine(comment, note.toString());
                for (String s : sTerms) {
                    boolean addedForLang = false;
                    for (String t : tTerms) {
                        result.add(new GlossaryEntry(s, t, comment.toString(), priorityGlossary));
                        addedForLang = true;
                    }
                    if (addedForLang) continue;
                    result.add(new GlossaryEntry(s, "", comment.toString(), priorityGlossary));
                }
                return;
            }
            if (next != 1) continue;
            if (reader.getLocalName().equals("descripGrp")) {
                GlossaryReaderTBX.appendDescOrNote(reader, descTerm);
                continue;
            }
            if (reader.getLocalName().equals("descrip")) {
                GlossaryReaderTBX.appendDescOrNote(reader, descTerm);
                continue;
            }
            if (reader.getLocalName().equals("note")) {
                GlossaryReaderTBX.appendDescOrNote(reader, descTerm);
                continue;
            }
            if (!reader.getLocalName().equals("langSet") && !reader.getLocalName().equals("langSec")) continue;
            String lang = reader.getAttributeValue(null, "lang");
            lang = new Language(lang).getLanguageCode();
            GlossaryReaderTBX.appendDescOrNote(reader, descTig);
            while (reader.hasNext() && ((next = reader.next()) != 2 || !reader.getLocalName().equals("langSet") && !reader.getLocalName().equals("langSec"))) {
                if (next != 1) continue;
                if (reader.getLocalName().equals("tig") || reader.getLocalName().equals("ntig") || reader.getLocalName().equals("termSec")) {
                    if (sLang.equalsIgnoreCase(lang)) {
                        sTerms.add(GlossaryReaderTBX.readContent(reader, "term"));
                        continue;
                    }
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    tTerms.add(GlossaryReaderTBX.readContent(reader, "term"));
                    continue;
                }
                if (reader.getLocalName().equals("termNote")) {
                    if (!tLang.equalsIgnoreCase(lang)) continue;
                    GlossaryReaderTBX.appendDescOrNote(reader, note);
                    continue;
                }
                if (reader.getLocalName().equals("descripGrp")) {
                    GlossaryReaderTBX.appendDescOrNote(reader, descTig);
                    continue;
                }
                if (reader.getLocalName().equals("descrip")) {
                    GlossaryReaderTBX.appendDescOrNote(reader, descTig);
                    continue;
                }
                if (!reader.getLocalName().equals("admin")) continue;
                GlossaryReaderTBX.appendDescOrNote(reader, descTig);
            }
        }
    }

    protected static void appendDescOrNote(XMLStreamReader reader, StringBuilder str) throws XMLStreamException {
        String line = null;
        if (reader.getLocalName().equals("descrip")) {
            if ("context".equals(reader.getAttributeValue(null, "type"))) {
                if (Preferences.isPreferenceDefault("glossary_tbx_display_context", true)) {
                    line = "context: " + GlossaryReaderTBX.readContent(reader, "descrip");
                }
            } else {
                line = "" + reader.getAttributeValue(null, "type") + ": " + GlossaryReaderTBX.readContent(reader, "descrip");
            }
        }
        if (reader.getLocalName().equals("descripGrp")) {
            int next;
            while (reader.hasNext() && ((next = reader.next()) != 2 || !reader.getLocalName().equals("descripGrp"))) {
                if (next != 1 || !reader.getLocalName().equals("descrip")) continue;
                GlossaryReaderTBX.appendDescOrNote(reader, str);
            }
        }
        if (reader.getLocalName().equals("termNote")) {
            line = GlossaryReaderTBX.readContent(reader, "termNote");
        }
        if (reader.getLocalName().equals("note")) {
            line = GlossaryReaderTBX.readContent(reader, "note");
        }
        if (reader.getLocalName().equals("admin")) {
            line = GlossaryReaderTBX.readContent(reader, "admin");
        }
        if (line != null) {
            GlossaryReaderTBX.appendLine(str, line);
        }
    }

    protected static void appendLine(StringBuilder str, String line) {
        if (line.isEmpty()) {
            return;
        }
        if (str.length() > 0) {
            str.append('\n');
        }
        str.append(line);
    }

    protected static String readContent(XMLStreamReader reader, String mark) throws XMLStreamException {
        StringBuilder res = new StringBuilder();
        boolean in = reader.getLocalName().equals(mark);
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2) {
                if (reader.getLocalName().equals(mark)) break;
                if (reader.getLocalName().equals("hi") && in) {
                    res.append("* ");
                }
            }
            if (next == 1) {
                if (reader.getLocalName().equals(mark)) {
                    in = true;
                } else if (reader.getLocalName().equals("hi") && in) {
                    res.append(" *");
                }
            }
            if (next != 4 || !in) continue;
            res.append(reader.getText());
        }
        return res.toString();
    }
}

