/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.omegat.core.Core;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.StringEntry;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.core.search.TextExpression;
import org.omegat.gui.common.EntryInfoThreadPane;
import org.omegat.gui.dialogs.CreateGlossaryEntry;
import org.omegat.gui.editor.EditorUtils;
import org.omegat.gui.glossary.FindGlossaryThread;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.TransTipsMarker;
import org.omegat.gui.glossary.TransTipsPopup;
import org.omegat.gui.main.DockableScrollPane;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DragTargetOverlay;
import org.omegat.util.gui.JTextPaneLinkifier;
import org.omegat.util.gui.StaticUIUtils;
import org.omegat.util.gui.Styles;
import org.omegat.util.gui.UIThreadsUtil;

public class GlossaryTextArea
extends EntryInfoThreadPane<List<GlossaryEntry>> {
    private static final String EXPLANATION = OStrings.getString("GUI_GLOSSARYWINDOW_explanation");
    public static final AttributeSet NO_ATTRIBUTES = Styles.createAttributeSet(null, null, false, null);
    public static final AttributeSet PRIORITY_ATTRIBUTES = Styles.createAttributeSet(null, null, true, null);
    public static final AttributeSet SOURCE_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_SOURCE.getColor(), null, null, null);
    public static final AttributeSet TARGET_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_TARGET.getColor(), null, null, null);
    public static final AttributeSet NOTES_ATTRIBUTES = Styles.createAttributeSet(Styles.EditorColor.COLOR_GLOSSARY_NOTE.getColor(), null, null, null);
    public static final String DEFAULT_TEMPLATE = "result.appendSource(entry.srcText); result.append(\": \");\ndef map = entry.translationWithComments\ndef count = map.size()\nmap.each { tra,commentsList -> \n\tresult.appendTarget(tra, entry.hasPriorities(tra));\n\tfor (com in commentsList) if ((com != null) && (com.length() > 0)) {\n\t\tresult.append(\"\\n -> \"); result.appendComment(com); \n\t}\n\tif (count-- > 1) result.append(\",\");\n}\nresult.append(\"\\n\");\n";
    protected StringEntry processedEntry;
    protected static List<GlossaryEntry> nowEntries;
    protected JPopupMenu popup;
    private CreateGlossaryEntry createGlossaryEntryDialog;
    private List<GlossaryEntry.StyledString.TooltipPart> tooltips = null;
    protected MouseListener mouseListener = new PopupListener(this);

    public GlossaryTextArea(MainWindow mw) {
        super(true);
        ToolTipManager.sharedInstance().registerComponent(this);
        String title = OStrings.getString("GUI_MATCHWINDOW_SUBWINDOWTITLE_Glossary");
        final DockableScrollPane scrollPane = new DockableScrollPane("GLOSSARY", title, this, true);
        Core.getMainWindow().addDockable(scrollPane);
        this.setEditable(false);
        StaticUIUtils.makeCaretAlwaysVisible(this);
        this.setText(EXPLANATION);
        this.setDragEnabled(true);
        this.setMinimumSize(new Dimension(100, 50));
        this.popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
        menuItem.addActionListener(e -> Core.getGlossary().showCreateGlossaryEntryDialog());
        this.popup.add(menuItem);
        menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_restrict_caseSensitive"));
        menuItem.addActionListener(e -> {
            String entry = Core.getEditor().getCurrentEntry().getSrcText();
            if (Preferences.isPreferenceDefault("glossary_remove_tags", false)) {
                entry = entry.replaceAll("</?\\w+/?>", "");
            }
            Iterator<GlossaryEntry> I = nowEntries.iterator();
            while (I.hasNext()) {
                if (entry.contains(I.next().getSrcText())) continue;
                I.remove();
            }
            this.setFoundResult(Core.getEditor().getCurrentEntry(), nowEntries);
            Core.getEditor().remarkOneMarker("org.omegat.gui.glossary.TransTipsMarker");
        });
        this.popup.add(menuItem);
        menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_restrict_wholeWords"));
        menuItem.addActionListener(e -> {
            String entry = Core.getEditor().getCurrentEntry().getSrcText();
            if (Preferences.isPreferenceDefault("glossary_remove_tags", false)) {
                entry = entry.replaceAll("</?\\w+/?>", "");
            }
            int flags = 256;
            if (!Preferences.isPreferenceDefault("transtips_search_window_case_sensitive", false)) {
                flags += 66;
            }
            Iterator<GlossaryEntry> I = nowEntries.iterator();
            while (I.hasNext()) {
                if (Pattern.compile("\\b" + I.next().getSrcText() + "\\b", flags).matcher(entry).find()) continue;
                I.remove();
            }
            this.setFoundResult(Core.getEditor().getCurrentEntry(), nowEntries);
            Core.getEditor().remarkOneMarker("org.omegat.gui.glossary.TransTipsMarker");
        });
        this.popup.add(menuItem);
        menuItem = new JMenuItem(OStrings.getString("GUI_GLOSSARYWINDOW_restrict_subords"));
        menuItem.addActionListener(e -> {
            SearchModeBox dummyBox = new SearchModeBox(0, ITokenizer.StemmingMode.GLOSSARY, null);
            dummyBox.loadPreferences("transtips_");
            HashSet<GlossaryEntry> toRemove = new HashSet<GlossaryEntry>();
            block0: for (int i = 0; i < nowEntries.size(); ++i) {
                TextExpression expr = dummyBox.buildExpression(nowEntries.get(i).getSrcText(), false, true);
                for (int j = 0; j < nowEntries.size(); ++j) {
                    if (i == j || expr.searchString(nowEntries.get(j).getSrcText()) == null) continue;
                    toRemove.add(nowEntries.get(i));
                    continue block0;
                }
            }
            nowEntries.removeAll(toRemove);
            this.setFoundResult(Core.getEditor().getCurrentEntry(), nowEntries);
        });
        this.popup.add(menuItem);
        this.addMouseListener(this.mouseListener);
        Core.getEditor().registerPopupMenuConstructors(300, new TransTipsPopup());
        if (!GraphicsEnvironment.isHeadless()) {
            DragTargetOverlay.apply(this, new DragTargetOverlay.FileDropInfo(mw, false){

                @Override
                public boolean canAcceptDrop() {
                    return Core.getProject().isProjectLoaded();
                }

                @Override
                public String getOverlayMessage() {
                    return OStrings.getString("DND_ADD_GLOSSARY_FILE");
                }

                @Override
                public String getImportDestination() {
                    return Core.getProject().getProjectProperties().getGlossaryRoot();
                }

                @Override
                public boolean acceptFile(File pathname) {
                    String name = pathname.getName().toLowerCase();
                    return name.endsWith(".csv") || name.endsWith(".tbx") || name.endsWith(".tab") || name.endsWith(".txt") || name.endsWith(".utf8");
                }

                @Override
                public Component getComponentToOverlay() {
                    return scrollPane;
                }
            });
        }
        JTextPaneLinkifier.linkify(this);
    }

    @Override
    protected void onProjectOpen() {
        this.clear();
        Core.getGlossaryManager().start();
    }

    @Override
    protected void onProjectClose() {
        this.clear();
        this.setText(EXPLANATION);
        Core.getGlossaryManager().stop();
    }

    @Override
    protected void startSearchThread(SourceTextEntry newEntry) {
        this.setText(StringUtil.format(OStrings.getString("SW_SEARCHING_PARAM"), "segment " + newEntry.entryNum() + " (" + newEntry.getSrcText() + ")"));
        this.getStyledDocument().setCharacterAttributes(0, this.getText().length(), NO_ATTRIBUTES, true);
        this.getStyledDocument().setCharacterAttributes(this.getText().indexOf(40) + 1, this.getText().lastIndexOf(41) - this.getText().indexOf(40) - 1, SOURCE_ATTRIBUTES, true);
        new FindGlossaryThread(this, newEntry, Core.getGlossaryManager()).start();
    }

    public void refresh() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        if (ste != null) {
            this.startSearchThread(ste);
        }
    }

    @Override
    protected void setFoundResult(SourceTextEntry en, List<GlossaryEntry> entries) {
        UIThreadsUtil.mustBeSwingThread();
        this.clear();
        if (entries == null) {
            return;
        }
        nowEntries = entries;
        if (Preferences.isPreference("transtips_src") || Preferences.isPreference("transtips_tra")) {
            Core.getEditor().remarkOneMarker(TransTipsMarker.class.getName());
        }
        GlossaryEntry.StyledString buf = new GlossaryEntry.StyledString();
        Collections.sort(entries);
        for (GlossaryEntry entry : entries) {
            GlossaryEntry.StyledString str = entry.toStyledString(false);
            buf.append(str);
        }
        this.setText(buf.text.toString());
        StyledDocument doc = this.getStyledDocument();
        doc.setCharacterAttributes(0, doc.getLength(), NO_ATTRIBUTES, true);
        for (GlossaryEntry.StyledString.AttributesPart part : buf.attrParts) {
            part.apply(doc);
        }
        for (GlossaryEntry.StyledString.AttributesPart part : buf.attrBolds) {
            part.apply(doc);
        }
        this.tooltips = buf.tooltips;
    }

    @Override
    public void clear() {
        super.clear();
        nowEntries = Collections.emptyList();
    }

    List<GlossaryEntry> getDisplayedEntries() {
        return nowEntries;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (this.tooltips == null) {
            return null;
        }
        int pos = this.viewToModel(event.getPoint());
        for (GlossaryEntry.StyledString.TooltipPart part : this.tooltips) {
            if (!part.contains(pos)) continue;
            return part.getText();
        }
        return null;
    }

    private void insertTerm(String selTxt) {
        Core.getEditor().insertText(selTxt);
    }

    public void showCreateGlossaryEntryDialog() {
        JFrame parent = Core.getMainWindow().getApplicationFrame();
        this.showCreateGlossaryEntryDialog(parent);
    }

    public void showCreateGlossaryEntryDialog(final Frame parent) {
        CreateGlossaryEntry d = this.createGlossaryEntryDialog;
        if (d != null) {
            d.requestFocus();
            return;
        }
        ProjectProperties props = Core.getProject().getProjectProperties();
        final File out = new File(props.getWriteableGlossary());
        final CreateGlossaryEntry dialog = new CreateGlossaryEntry(parent);
        String txt = dialog.getGlossaryFileText().getText();
        txt = MessageFormat.format(txt, out.getAbsolutePath());
        dialog.getGlossaryFileText().setText(txt);
        dialog.setVisible(true);
        dialog.getSourceText().requestFocus();
        dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
                String sel = null;
                Component component = parent.getMostRecentFocusOwner();
                if (component instanceof JTextComponent && !StringUtil.isEmpty(sel = ((JTextComponent)component).getSelectedText())) {
                    sel = EditorUtils.removeDirectionChars(sel);
                }
                if (!StringUtil.isEmpty(sel)) {
                    if (StringUtil.isEmpty(dialog.getSourceText().getText())) {
                        this.setText(dialog.getSourceText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getTargetText().getText())) {
                        this.setText(dialog.getTargetText(), sel);
                    } else if (StringUtil.isEmpty(dialog.getCommentText().getText())) {
                        this.setText(dialog.getCommentText(), sel);
                    }
                }
            }

            private void setText(JTextComponent comp, String text) {
                comp.setText(text);
                comp.requestFocus();
                comp.selectAll();
            }
        });
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                GlossaryTextArea.this.createGlossaryEntryDialog = null;
                if (dialog.getReturnStatus() == 1) {
                    String src = StringUtil.normalizeUnicode(dialog.getSourceText().getText());
                    String loc = StringUtil.normalizeUnicode(dialog.getTargetText().getText());
                    String com = StringUtil.normalizeUnicode(dialog.getCommentText().getText());
                    if (!StringUtil.isEmpty(src) && !StringUtil.isEmpty(loc)) {
                        try {
                            IWritableGlossary external = (IWritableGlossary)((Object)Core.getGlossaryManager().externalGlossaries.get(out.getPath()));
                            if (external != null) {
                                external.addEntry(Core.getProject().getProjectProperties().getSourceLanguage(), Core.getProject().getProjectProperties().getTargetLanguage(), new GlossaryEntry(src, loc, com, true));
                                return;
                            }
                        }
                        catch (Exception ex) {
                            Log.log(ex);
                        }
                        try {
                            GlossaryReaderTSV.append(out, new GlossaryEntry(src, loc, com, true));
                        }
                        catch (Exception ex) {
                            Log.log(ex);
                        }
                    }
                }
            }
        });
        this.createGlossaryEntryDialog = dialog;
    }

    class PopupListener
    extends MouseAdapter {
        private GlossaryTextArea glossaryTextArea;

        public PopupListener(GlossaryTextArea gte) {
            this.glossaryTextArea = gte;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger() || e.getButton() == 3) {
                String selTxt = this.glossaryTextArea.getSelectedText();
                if (selTxt == null) {
                    if (Core.getProject().isProjectLoaded()) {
                        GlossaryTextArea.this.popup.show(this.glossaryTextArea, e.getX(), e.getY());
                    }
                } else {
                    GlossaryTextArea.this.insertTerm(selTxt);
                }
            }
        }
    }
}

