/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.text.Highlighter;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.gui.editor.Document3;
import org.omegat.gui.editor.MarkerController;
import org.omegat.gui.editor.UnderlineFactory;
import org.omegat.gui.editor.mark.IFastMarker;
import org.omegat.gui.editor.mark.Mark;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.TransTips;
import org.omegat.util.Preferences;
import org.omegat.util.gui.Styles;

public class TransTipsMarker
implements IFastMarker {
    protected static final Highlighter.HighlightPainter transTipsUnderliner = new UnderlineFactory.SolidBoldUnderliner(Styles.EditorColor.COLOR_TRANSTIPS.getColor());

    @Override
    public List<Mark> getMarksForEntry(SourceTextEntry ste, String sourceText, String translationText, boolean isActive) {
        if (!isActive || sourceText == null) {
            return null;
        }
        if (!Preferences.isPreference("transtips_src") && !Preferences.isPreference("transtips_tra")) {
            return null;
        }
        List<GlossaryEntry> glossaryEntries = Core.getGlossary().getDisplayedEntries();
        if (glossaryEntries == null || glossaryEntries.isEmpty()) {
            return null;
        }
        final ArrayList<Mark> marks = new ArrayList<Mark>();
        class MarkerCallback
        implements TransTips.Search {
            private Mark.ENTRY_PART mark;

            public MarkerCallback(boolean isSource) {
                this.mark = isSource ? Mark.ENTRY_PART.SOURCE : Mark.ENTRY_PART.TRANSLATION;
            }

            @Override
            public void found(GlossaryEntry ge, int start, int end) {
                Mark m = new Mark(this.mark, start, end);
                m.painter = transTipsUnderliner;
                m.toolTipText = ge.toStyledString(true).toHTML();
                marks.add(m);
            }
        }
        MarkerCallback srcCallback = new MarkerCallback(true);
        MarkerCallback traCallback = new MarkerCallback(false);
        for (GlossaryEntry ent : glossaryEntries) {
            if (Preferences.isPreference("transtips_src")) {
                TransTips.search(sourceText, ent, srcCallback, true);
            }
            if (!Preferences.isPreference("transtips_tra")) continue;
            TransTips.search(translationText, ent, traCallback, false);
        }
        return marks;
    }

    @Override
    public List<MarkerController.MarkInfo> toRemove(DocumentEvent ev, List<MarkerController.MarkInfo> oriList) {
        if (!Preferences.isPreference("transtips_tra")) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<MarkerController.MarkInfo> res = new ArrayList<MarkerController.MarkInfo>(1 + ev.getLength() / 5);
        for (MarkerController.MarkInfo ori : oriList) {
            if (ori.highlight == null || ori.highlight.getEndOffset() < ev.getOffset() || ev.getType() == DocumentEvent.EventType.INSERT && ori.highlight.getStartOffset() > ev.getOffset() + ev.getLength() || ev.getType() == DocumentEvent.EventType.REMOVE && ori.highlight.getStartOffset() > ev.getOffset()) continue;
            res.add(ori);
        }
        return res;
    }

    @Override
    public List<Mark> toAdd(final DocumentEvent ev) throws Exception {
        if (!Preferences.isPreference("transtips_tra")) {
            return Collections.EMPTY_LIST;
        }
        List<GlossaryEntry> glossaryEntries = Core.getGlossary().getDisplayedEntries();
        if (glossaryEntries == null || glossaryEntries.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        final Document3 doc = (Document3)ev.getDocument();
        String translationText = doc.getText(doc.getTranslationStart(), doc.getTranslationEnd() - doc.getTranslationStart());
        final ArrayList<Mark> marks = new ArrayList<Mark>();
        TransTips.Search traCallback = new TransTips.Search(){

            @Override
            public void found(GlossaryEntry ge, int start, int end) {
                if (end < ev.getOffset() - doc.getTranslationStart()) {
                    return;
                }
                if (start > ev.getOffset() + ev.getLength() - doc.getTranslationStart()) {
                    return;
                }
                Mark m = new Mark(Mark.ENTRY_PART.TRANSLATION, start, end);
                m.painter = transTipsUnderliner;
                marks.add(m);
            }
        };
        for (GlossaryEntry ent : glossaryEntries) {
            TransTips.search(translationText, ent, traCallback, false);
        }
        return marks;
    }
}

