/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.text.DateFormat;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.CrossSourceSearchResultEntry;
import org.omegat.core.search.PreTranslateSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.gui.search.ReplaceDialog;
import org.omegat.util.OStrings;
import org.omegat.util.VarExpansion;

public class SearchVarExpansion
extends VarExpansion<SearchResultEntry> {
    public static final String VAR_PREAMBLE = "${preamble}";
    public static final String VAR_CREATION_ID = "${creationId}";
    public static final String VAR_CREATION_DATE = "${creationDate}";
    public static final String VAR_NOTE = "${note}";
    public static final String VAR_TARGET_REPLACED = "${replacedTarget}";
    public static final String VAR_PRE_TRANSLATION = "${preTranslation}";
    public static final String VAR_GROUP_COUNT = "${groupCount}";
    public static final String VAR_XSRC_SOURCES = "${allSources}";
    public static final String DEFAULT_TEMPLATE_PROJECT = "${preamble}\n${sourceText}\n${targetText}\n\n-----------------------\n";
    public static final String DEFAULT_TEMPLATE_DIRECTORY = "${preamble}\n${sourceText}\n\n-----------------------\n";
    public static final String DEFAULT_TEMPLATE_REPLACE = "${preamble}\n${targetText}\n${replacedTarget}\n\n-----------------------\n";
    public static final String DEFAULT_TEMPLATE_PRETRA = "${preamble}\n${sourceText}\n${preTranslation}\n\n-----------------------\n";
    public static final String DEFAULT_TEMPLATE_PRETRA_SRC = "${groupCount} " + OStrings.getString("SW_PRETRA_MATCH_GROUP_ENTRIES") + "\n" + "${allSources}" + "\n\n-----------------------\n";
    public List<SearchMatch> replMatches;
    public ReplaceDialog replaceDialog;

    public SearchVarExpansion(String template) {
        super(template);
    }

    @Override
    public String expandVariables(SearchResultEntry entry) {
        String localTemplate = this.template;
        localTemplate = localTemplate.replace(VAR_PREAMBLE, entry.getPreamble());
        localTemplate = localTemplate.replace(VAR_CREATION_ID, entry.getAuthor() == null ? "" : entry.getAuthor());
        localTemplate = localTemplate.replace(VAR_CREATION_DATE, entry.getDate() == null ? "" : DateFormat.getInstance().format(entry.getDate()));
        localTemplate = localTemplate.replace(VAR_NOTE, entry.getNote() == null ? "" : entry.getNote());
        localTemplate = this.expandFileName(localTemplate, entry.getFileName(), Core.getProject().getProjectProperties().getProjectRoot());
        localTemplate = localTemplate.replace("@{revisor}", entry.getRevisor() != null ? entry.getRevisor() : "");
        if ((localTemplate = localTemplate.replace("@{revised}", entry.getRevisor() != null ? "revised" : "")).contains(VAR_GROUP_COUNT)) {
            try {
                localTemplate = localTemplate.replace(VAR_GROUP_COUNT, Integer.toString(((CrossSourceSearchResultEntry)entry).entries().size()));
            }
            catch (Exception e) {
                localTemplate = localTemplate.replace(VAR_GROUP_COUNT, entry.getMoreString());
            }
        }
        if (localTemplate.contains(VAR_XSRC_SOURCES)) {
            try {
                CrossSourceSearchResultEntry xe = (CrossSourceSearchResultEntry)entry;
                List<SourceTextEntry> projEntries = Core.getProject().getAllEntries();
                StringBuffer buf = new StringBuffer();
                for (int idx : xe.entries()) {
                    buf.append("  ").append(idx).append(": ").append(projEntries.get(idx - 1).getSrcText()).append("\n");
                }
                localTemplate = localTemplate.replace(VAR_XSRC_SOURCES, buf.toString());
            }
            catch (Exception e) {
                localTemplate = localTemplate.replace(VAR_XSRC_SOURCES, OStrings.getString("SW_ERROR_VARIABLE").replace("{0}", VAR_XSRC_SOURCES));
            }
        }
        return localTemplate;
    }

    public String apply(SearchResultEntry entry) {
        String localTemplate = this.template;
        try {
            localTemplate = this.expandVariables(entry);
            localTemplate = this.expandProperties(localTemplate, entry.getProperties());
            int srcIndex = localTemplate.indexOf("${sourceText}");
            int traIndex = localTemplate.indexOf("${targetText}");
            int replaceIndex = localTemplate.indexOf(VAR_TARGET_REPLACED);
            int pretraIndex = localTemplate.indexOf(VAR_PRE_TRANSLATION);
            TreeMap<Integer, ExpandTextVariable> variables = new TreeMap<Integer, ExpandTextVariable>();
            if (srcIndex >= 0) {
                variables.put(srcIndex, new ExpandTextVariable("${sourceText}", entry.getSrcText(), srcIndex, entry.getSrcMatch()));
            }
            if (traIndex >= 0) {
                variables.put(traIndex, new ExpandTextVariable("${targetText}", entry.getTranslation(), traIndex, entry.getTargetMatch()));
            }
            if (replaceIndex >= 0) {
                if (this.replaceDialog == null) {
                    String replText = this.replaceDialog.buildReplacedString(entry.getTranslation(), entry.getTargetMatch());
                    this.replMatches = this.replaceDialog.buildReplacedMatches(entry.getTranslation(), entry.getTargetMatch());
                    variables.put(replaceIndex, new ExpandTextVariable(VAR_TARGET_REPLACED, replText, replaceIndex, this.replMatches));
                } else {
                    variables.put(replaceIndex, new ExpandTextVariable(VAR_TARGET_REPLACED, OStrings.getString("SW_ERROR_VARIABLE").replace("{0}", VAR_TARGET_REPLACED), replaceIndex, Collections.singletonList(new SearchMatch(replaceIndex, 5))));
                }
            }
            if (pretraIndex >= 0) {
                try {
                    PreTranslateSearchResultEntry ptEntry = (PreTranslateSearchResultEntry)entry;
                    String replText = ptEntry.getTranslationResult();
                    this.replMatches = ptEntry.getHighlights();
                    variables.put(pretraIndex, new ExpandTextVariable(VAR_PRE_TRANSLATION, replText, pretraIndex, this.replMatches));
                }
                catch (Exception e) {
                    variables.put(pretraIndex, new ExpandTextVariable(VAR_TARGET_REPLACED, OStrings.getString("SW_ERROR_VARIABLE").replace("{0}", VAR_PRE_TRANSLATION), pretraIndex, Collections.singletonList(new SearchMatch(pretraIndex, 5))));
                }
            }
            Integer[] keys = variables.navigableKeySet().toArray(new Integer[0]);
            for (int i = 0; i < keys.length; ++i) {
                localTemplate = ((ExpandTextVariable)variables.get(keys[i])).expandTextVariable(localTemplate);
                for (int j = i + 1; j < keys.length; ++j) {
                    ((ExpandTextVariable)variables.get(keys[j])).shift((ExpandTextVariable)variables.get(keys[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localTemplate;
    }

    private class ExpandTextVariable {
        private String varName;
        private String varValue;
        private int index;
        private List<SearchMatch> matches;

        public ExpandTextVariable(String varName, String varValue, int index, List<SearchMatch> matches) {
            this.varName = varName;
            this.varValue = varValue;
            this.index = index;
            this.matches = matches;
        }

        public String expandTextVariable(String localTemplate) {
            if (this.matches != null) {
                for (SearchMatch match : this.matches) {
                    match.move(this.index);
                }
            }
            return localTemplate.replace(this.varName, this.varValue == null ? "" : this.varValue);
        }

        public void shift(ExpandTextVariable prev) {
            int diff = prev.varValue.length() - prev.varName.length();
            this.index += diff;
        }
    }
}

