/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.Arrays;
import java.util.List;
import org.languagetool.Language;
import org.languagetool.language.AmericanEnglish;
import org.languagetool.language.Contributor;
import org.languagetool.language.Contributors;
import org.languagetool.rules.CommaWhitespaceRule;
import org.languagetool.rules.DoublePunctuationRule;
import org.languagetool.rules.LongSentenceRule;
import org.languagetool.rules.Rule;
import org.languagetool.rules.UppercaseSentenceStartRule;
import org.languagetool.rules.WhitespaceRule;
import org.languagetool.rules.en.AvsAnRule;
import org.languagetool.rules.en.CompoundRule;
import org.languagetool.rules.en.EnglishUnpairedBracketsRule;
import org.languagetool.rules.en.EnglishWordRepeatBeginningRule;
import org.languagetool.rules.en.EnglishWordRepeatRule;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.synthesis.en.EnglishSynthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.rules.en.EnglishRuleDisambiguator;
import org.languagetool.tagging.en.EnglishTagger;
import org.languagetool.tokenizers.SRXSentenceTokenizer;
import org.languagetool.tokenizers.SentenceTokenizer;

public class English
extends Language {
    private static final Language AMERICAN_ENGLISH = new AmericanEnglish();
    private Tagger tagger;
    private SentenceTokenizer sentenceTokenizer;
    private Synthesizer synthesizer;
    private Disambiguator disambiguator;

    public Language getDefaultVariant() {
        return AMERICAN_ENGLISH;
    }

    public final SentenceTokenizer getSentenceTokenizer() {
        if (this.sentenceTokenizer == null) {
            this.sentenceTokenizer = new SRXSentenceTokenizer((Language)this);
        }
        return this.sentenceTokenizer;
    }

    public String getName() {
        return "English";
    }

    public final String getShortName() {
        return "en";
    }

    public String[] getCountryVariants() {
        return new String[]{"ANY"};
    }

    public final Tagger getTagger() {
        if (this.tagger == null) {
            this.tagger = new EnglishTagger();
        }
        return this.tagger;
    }

    public final Synthesizer getSynthesizer() {
        if (this.synthesizer == null) {
            this.synthesizer = new EnglishSynthesizer();
        }
        return this.synthesizer;
    }

    public final Disambiguator getDisambiguator() {
        if (this.disambiguator == null) {
            this.disambiguator = new EnglishRuleDisambiguator();
        }
        return this.disambiguator;
    }

    public final Contributor[] getMaintainers() {
        return new Contributor[]{Contributors.MARCIN_MILKOWSKI, Contributors.DANIEL_NABER};
    }

    public List<Class<? extends Rule>> getRelevantRules() {
        return Arrays.asList(CommaWhitespaceRule.class, DoublePunctuationRule.class, EnglishUnpairedBracketsRule.class, UppercaseSentenceStartRule.class, WhitespaceRule.class, LongSentenceRule.class, EnglishWordRepeatRule.class, AvsAnRule.class, EnglishWordRepeatBeginningRule.class, CompoundRule.class);
    }
}

