/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.history;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.omegat.gui.editor.autocompleter.AutoCompleterItem;

public class WordPredictor {
    static final double MIN_FREQUENCY = 5.0;
    private Map<String, FrequencyStrings> data;

    void reset() {
        this.data = new HashMap<String, FrequencyStrings>();
    }

    void trainStringPrediction(String text, String[] tokens) {
        for (int i = 0; i < tokens.length - 1; ++i) {
            String token = tokens[i];
            FrequencyStrings strings = this.data.get(token);
            if (strings == null) {
                strings = new FrequencyStrings();
                this.data.put(token, strings);
            }
            strings.encounter(tokens[i + 1]);
        }
    }

    List<AutoCompleterItem> predictWord(String[] tokens) {
        String seed = this.lastFullWordToken(tokens);
        if (this.data == null || seed == null) {
            return new ArrayList<AutoCompleterItem>(1);
        }
        ArrayList<AutoCompleterItem> result = new ArrayList<AutoCompleterItem>();
        FrequencyStrings predictions = this.data.get(seed);
        if (predictions == null) {
            return new ArrayList<AutoCompleterItem>(1);
        }
        List<Map.Entry<String, Integer>> entries = predictions.getSortedEntries();
        int total = 0;
        for (Map.Entry<String, Integer> e : entries) {
            total += e.getValue().intValue();
        }
        for (Map.Entry<String, Integer> e : entries) {
            double percent = (double)e.getValue().intValue() / (double)total * 100.0;
            if (!(percent >= 5.0)) continue;
            result.add(new AutoCompleterItem(e.getKey(), new String[]{String.valueOf(Math.round(percent)) + "%"}, 0));
        }
        return result;
    }

    private String lastFullWordToken(String[] tokens) {
        for (int i = tokens.length - 2; i >= 0; --i) {
            String token = tokens[i];
            if (token.trim().isEmpty()) continue;
            return token;
        }
        return null;
    }

    static class FrequencyStrings {
        private final Map<String, Integer> map = new HashMap<String, Integer>();

        FrequencyStrings() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encounter(String string) {
            Map<String, Integer> map = this.map;
            synchronized (map) {
                Integer count = this.map.get(string);
                this.map.put(string, count == null ? 0 : count + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<Map.Entry<String, Integer>> getSortedEntries() {
            ArrayList<Map.Entry<String, Integer>> entries;
            Map<String, Integer> map = this.map;
            synchronized (map) {
                entries = new ArrayList<Map.Entry<String, Integer>>(this.map.entrySet());
            }
            Collections.sort(entries, new Comparator<Map.Entry<String, Integer>>(){

                @Override
                public int compare(Map.Entry<String, Integer> o1, Map.Entry<String, Integer> o2) {
                    return -Integer.compare(o1.getValue(), o2.getValue());
                }
            });
            return entries;
        }
    }
}

