/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import gen.core.filters.Filters;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.omegat.core.data.ProjectException;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;

public class ProjectProperties {
    public static final String[] DEFAULT_EXCLUDES = new String[]{"**/.svn/**", "**/CVS/**", "**/.cvs/**", "**/desktop.ini", "**/Thumbs.db", "**/.DS_Store"};
    private String projectName;
    private String projectRoot;
    private String sourceRoot;
    private final List<String> sourceRootExcludes = new ArrayList<String>();
    private String glossaryRoot;
    private String writeableGlossaryFile;
    private String tmRoot;
    private String dictRoot;
    private Language sourceLanguage;
    private Language targetLanguage;
    private Class<?> sourceTokenizer;
    private Class<?> targetTokenizer;
    private boolean sentenceSegmentingOn;
    private boolean supportDefaultTranslations;
    private boolean removeTags;
    private ISegmentationData projectSegmentationData;
    private Filters projectFilters;
    private String externalCommand;

    protected ProjectProperties() {
    }

    public ProjectProperties(File projectDir) throws Exception {
        this.setProjectName(projectDir.getCanonicalFile().getName());
        this.setProjectRoot(projectDir.getAbsolutePath() + File.separator);
        this.setSourceRoot(this.projectRoot + "source" + File.separator);
        this.sourceRootExcludes.addAll(Arrays.asList(DEFAULT_EXCLUDES));
        this.setGlossaryRoot(this.projectRoot + "glossary" + File.separator);
        this.setWriteableGlossary(this.projectRoot + "glossary" + File.separator + "glossary.txt");
        this.setTMRoot(this.projectRoot + "tm" + File.separator);
        this.setDictRoot(this.projectRoot + "dictionary" + File.separator);
        this.setSentenceSegmentingEnabled(true);
        this.setSupportDefaultTranslations(true);
        this.setRemoveTags(false);
        String sourceLocale = Preferences.getPreference("source_lang");
        if (!StringUtil.isEmpty(sourceLocale)) {
            this.setSourceLanguage(sourceLocale);
        } else {
            this.setSourceLanguage("EN-US");
        }
        String targetLocale = Preferences.getPreference("target_lang");
        if (!StringUtil.isEmpty(targetLocale)) {
            this.setTargetLanguage(targetLocale);
        } else {
            this.setTargetLanguage("EN-GB");
        }
        this.projectSegmentationData = ISegmentationData.loadFromDir(new File(this.getProjectInternal()), false);
        this.projectFilters = FilterMaster.loadConfig(this.getProjectInternal());
        this.setSourceTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage()));
        this.setTargetTokenizer(PluginUtils.getTokenizerClassForLanguage(this.getTargetLanguage()));
    }

    public String getTargetRoot() {
        return this.projectRoot + "target" + File.separator;
    }

    public String getGlossaryRoot() {
        return this.glossaryRoot;
    }

    public void setGlossaryRoot(String glossaryRoot) {
        if (!StringUtil.isEmpty(glossaryRoot)) {
            this.glossaryRoot = glossaryRoot;
        }
    }

    public String getWriteableGlossary() {
        return this.writeableGlossaryFile;
    }

    public String getWriteableGlossaryDir() {
        File fDir = new File(this.writeableGlossaryFile);
        String sDir = fDir.getParent();
        return sDir;
    }

    public void setWriteableGlossary(String writeableGlossaryFile) {
        if (!StringUtil.isEmpty(writeableGlossaryFile)) {
            this.writeableGlossaryFile = writeableGlossaryFile;
        }
    }

    public boolean isDefaultWriteableGlossaryFile() {
        return this.writeableGlossaryFile.equals(this.computeDefaultWriteableGlossaryFile());
    }

    public String computeDefaultWriteableGlossaryFile() {
        String glossaryDir = this.getGlossaryRoot();
        if (glossaryDir.startsWith(this.projectRoot)) {
            return glossaryDir + "glossary.txt";
        }
        return glossaryDir + this.projectName + "-glossary.txt";
    }

    public String getTMRoot() {
        return this.tmRoot;
    }

    public void setTMRoot(String tmRoot) {
        if (!StringUtil.isEmpty(tmRoot)) {
            this.tmRoot = tmRoot;
        }
    }

    public String getTMOtherLangRoot() {
        return this.tmRoot + "tmx2source" + File.separator;
    }

    public String getTMAutoRoot() {
        return this.tmRoot + "auto" + File.separator;
    }

    public String getDictRoot() {
        return this.dictRoot;
    }

    public void setDictRoot(String dictRoot) {
        if (!StringUtil.isEmpty(dictRoot)) {
            this.dictRoot = dictRoot;
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectRoot() {
        return this.projectRoot;
    }

    public void setProjectRoot(String projectRoot) {
        this.projectRoot = projectRoot;
    }

    public String getProjectInternal() {
        return this.projectRoot + "omegat" + File.separator;
    }

    public String getSourceRoot() {
        return this.sourceRoot;
    }

    public void setSourceRoot(String sourceRoot) {
        if (!StringUtil.isEmpty(sourceRoot)) {
            this.sourceRoot = sourceRoot;
        }
    }

    public List<String> getSourceRootExcludes() {
        return this.sourceRootExcludes;
    }

    public Language getSourceLanguage() {
        return this.sourceLanguage;
    }

    public void setSourceLanguage(Language sourceLanguage) {
        this.sourceLanguage = sourceLanguage;
    }

    public void setSourceLanguage(String sourceLanguage) {
        this.sourceLanguage = new Language(sourceLanguage);
    }

    public Language getTargetLanguage() {
        return this.targetLanguage;
    }

    public void setTargetLanguage(Language targetLanguage) {
        this.targetLanguage = targetLanguage;
    }

    public void setTargetLanguage(String targetLanguage) {
        this.targetLanguage = new Language(targetLanguage);
    }

    public Class<?> getSourceTokenizer() {
        if (this.sourceTokenizer == null) {
            Class<?> cls = PluginUtils.getTokenizerClassForLanguage(this.getSourceLanguage());
            this.setSourceTokenizer(cls);
        }
        return this.sourceTokenizer;
    }

    public void setSourceTokenizer(Class<?> sourceTokenizer) {
        this.sourceTokenizer = sourceTokenizer;
    }

    public Class<?> getTargetTokenizer() {
        return this.targetTokenizer;
    }

    public void setTargetTokenizer(Class<?> targetTokenizer) {
        this.targetTokenizer = targetTokenizer;
    }

    public boolean isSentenceSegmentingEnabled() {
        return this.sentenceSegmentingOn;
    }

    public void setSentenceSegmentingEnabled(boolean sentenceSegmentingOn) {
        this.sentenceSegmentingOn = sentenceSegmentingOn;
    }

    public boolean isSupportDefaultTranslations() {
        return this.supportDefaultTranslations;
    }

    public void setSupportDefaultTranslations(boolean supportDefaultTranslations) {
        this.supportDefaultTranslations = supportDefaultTranslations;
    }

    public boolean isRemoveTags() {
        return this.removeTags;
    }

    public void setRemoveTags(boolean removeTags) {
        this.removeTags = removeTags;
    }

    public ISegmentationData getProjectSegmentationData() {
        return this.projectSegmentationData;
    }

    public void setProjectSegmentationData(ISegmentationData projectSegmentationData) {
        this.projectSegmentationData = projectSegmentationData;
    }

    public Filters getProjectFilters() {
        return this.projectFilters;
    }

    public void setProjectFilters(Filters projectFilters) {
        this.projectFilters = projectFilters;
    }

    public String getExternalCommand() {
        return this.externalCommand;
    }

    public void setExternalCommand(String command) {
        this.externalCommand = command;
    }

    public boolean isProjectValid() {
        boolean returnValue;
        try {
            this.verifyProject();
            returnValue = true;
        }
        catch (ProjectException ex) {
            returnValue = false;
        }
        return returnValue;
    }

    public void verifyProject() throws ProjectException {
        String srcDir = this.getSourceRoot();
        File src = new File(srcDir);
        if (!src.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_SOURCE_FOLDER"), srcDir));
        }
        String glsDir = this.getGlossaryRoot();
        File gls = new File(glsDir);
        if (!gls.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_GLOSSARY_FOLDER"), glsDir));
        }
        String wGlsDir = this.getWriteableGlossaryDir();
        if (!wGlsDir.endsWith(File.separator)) {
            wGlsDir = wGlsDir + File.separator;
        }
        if (!wGlsDir.contains(this.getGlossaryRoot())) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_W_GLOSSARY"), glsDir));
        }
        String tmxDir = this.getTMRoot();
        File tmx = new File(tmxDir);
        if (!tmx.exists()) {
            throw new ProjectException(StringUtil.format(OStrings.getString("PROJECT_TM_FOLDER"), tmxDir));
        }
        File dict = new File(this.getDictRoot());
        if (!dict.exists() && this.getDictRoot().equals(this.projectRoot + "dictionary" + File.separator)) {
            dict.mkdirs();
        }
    }

    private static boolean verifyLangCode(String code) {
        int cp;
        for (int i = 0; i < code.length(); i += Character.charCount(cp)) {
            cp = code.codePointAt(i);
            if (Character.isLetter(cp)) continue;
            return false;
        }
        return !new Language(code).getDisplayName().isEmpty();
    }

    public static boolean verifySingleLangCode(String code) {
        int cpc = code.codePointCount(0, code.length());
        if (cpc == 2 || cpc == 3) {
            return ProjectProperties.verifyLangCode(code);
        }
        if (cpc == 5 || cpc == 6) {
            int shift = 0;
            if (cpc == 6) {
                shift = 1;
            }
            int sepOffset = code.offsetByCodePoints(0, 2 + shift);
            int sep = code.codePointAt(sepOffset);
            return ProjectProperties.verifyLangCode(code.substring(0, sepOffset)) && (sep == 45 || sep == 95) && ProjectProperties.verifyLangCode(code.substring(code.offsetByCodePoints(sepOffset, 1), code.offsetByCodePoints(sepOffset, 3)));
        }
        return false;
    }
}

