/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import gen.core.filters.Filters;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.util.Version;
import org.madlonkay.supertmxmerge.StmProperties;
import org.madlonkay.supertmxmerge.SuperTmxMerge;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.KnownException;
import org.omegat.core.data.CommandVarExpansion;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ImportFromAutoTMX;
import org.omegat.core.data.LastSegmentManager;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProjectTMX;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.data.TranslateEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.CacheWritableExternalMemory;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.matching.external.IWritableExternalMemory;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.core.team.RepositoryUtils;
import org.omegat.core.threads.CommandMonitor;
import org.omegat.filehooks.IFileHook;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.main.MainWindow;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.FileUtil;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.ProjectFileStorage;
import org.omegat.util.RuntimePreferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.gui.UIThreadsUtil;
import org.xml.sax.SAXParseException;

public class RealProject
implements IProject {
    private static final Logger LOGGER = Logger.getLogger(RealProject.class.getName());
    protected final ProjectProperties m_config;
    private final IRemoteRepository repository;
    private boolean isOnlineMode;
    private RandomAccessFile raFile;
    private FileChannel lockChannel;
    private FileLock lock;
    private boolean m_modifiedFlag;
    protected List<SourceTextEntry> allProjectEntries = new ArrayList<SourceTextEntry>(4096);
    protected ImportFromAutoTMX importHandler;
    private final StatisticsInfo hotStat = new StatisticsInfo();
    private final ITokenizer sourceTokenizer;
    private final ITokenizer targetTokenizer;
    private DirectoryMonitor tmMonitor;
    private DirectoryMonitor tmOtherLanguagesMonitor;
    private boolean isSaving = false;
    private Map<String, IExternalMemory> transMemories = new TreeMap<String, IExternalMemory>();
    private Set<IWritableExternalMemory> updatedExternalMemories = new HashSet<IWritableExternalMemory>();
    private Map<Language, ProjectTMX> otherTargetLangTMs = new TreeMap<Language, ProjectTMX>();
    protected ProjectTMX projectTMX;
    private boolean loaded = false;
    private Set<String> existSource = new HashSet<String>();
    private Set<EntryKey> existKeys = new HashSet<EntryKey>();
    protected List<IProject.FileInfo> projectFilesList = new ArrayList<IProject.FileInfo>();
    private final TMXEntry EMPTY_TRANSLATION;
    private boolean allowTranslationEqualToSource = Preferences.isPreference("wf_allowTransEqualToSrc");
    private Stack<Process> processCache = new Stack();
    private Exception lastCompileException = null;
    ProjectTMX.CheckOrphanedCallback checkOrphanedCallback = new ProjectTMX.CheckOrphanedCallback(){

        @Override
        public boolean existSourceInProject(String src) {
            return RealProject.this.existSource.contains(src);
        }

        @Override
        public boolean existEntryInProject(EntryKey key) {
            return RealProject.this.existKeys.contains(key);
        }
    };

    public RealProject(ProjectProperties props) {
        this(props, null);
    }

    public RealProject(ProjectProperties props, IRemoteRepository repository) {
        PrepareTMXEntry empty = new PrepareTMXEntry();
        empty.source = "";
        this.EMPTY_TRANSLATION = new TMXEntry(empty, true, null);
        this.m_config = props;
        this.repository = repository;
        this.sourceTokenizer = this.createTokenizer(Core.getParams().get("ITokenizer"), props.getSourceTokenizer());
        this.configTokenizer(Core.getParams().get("ITokenizerBehavior"), this.sourceTokenizer);
        Log.log("Source tokenizer: " + this.sourceTokenizer.getClass().getName() + " (" + this.sourceTokenizer.getBehavior() + ")");
        this.targetTokenizer = this.createTokenizer(Core.getParams().get("ITokenizerTarget"), props.getTargetTokenizer());
        this.configTokenizer(Core.getParams().get("ITokenizerTargetBehavior"), this.targetTokenizer);
        Log.log("Target tokenizer: " + this.targetTokenizer.getClass().getName() + " (" + this.targetTokenizer.getBehavior() + ")");
    }

    @Override
    public IRemoteRepository getRepository() {
        return this.repository;
    }

    @Override
    public void saveProjectProperties() throws Exception {
        this.unlockProject();
        try {
            ProjectFileStorage.writeProjectFile(this.m_config);
        }
        finally {
            this.lockProject();
        }
        Preferences.setPreference("source_lang", this.m_config.getSourceLanguage().toString());
        Preferences.setPreference("target_lang", this.m_config.getTargetLanguage().toString());
    }

    public void createProject() {
        Log.logInfoRB("LOG_DATAENGINE_CREATE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        try {
            if (!this.lockProject()) {
                throw new KnownException("PROJECT_LOCKED", new Object[0]);
            }
            this.createDirectory(this.m_config.getProjectRoot(), null);
            this.createDirectory(this.m_config.getProjectInternal(), "omegat");
            this.createDirectory(this.m_config.getSourceRoot(), "source");
            this.createDirectory(this.m_config.getGlossaryRoot(), "glossary");
            this.createDirectory(this.m_config.getTMRoot(), "tm");
            this.createDirectory(this.m_config.getTMAutoRoot(), "auto");
            this.createDirectory(this.m_config.getDictRoot(), "dictionary");
            this.createDirectory(this.m_config.getTargetRoot(), "target");
            this.saveProjectProperties();
            ISegmentationData srx = this.m_config.getProjectSegmentationData();
            Core.getSegmenter().setSegmentationData(srx == null ? Preferences.getSegmentationData() : srx);
            this.loadTranslations();
            this.setProjectModified(true);
            this.saveProject(false);
            this.loadSourceFiles();
            this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
            this.importHandler = new ImportFromAutoTMX(this, this.allProjectEntries);
            this.importTranslationsFromSources();
            this.loadTM();
            this.loadOtherLanguages();
            this.loaded = true;
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "CT_ERROR_CREATING_PROJECT", new Object[0]);
        }
        Log.logInfoRB("LOG_DATAENGINE_CREATE_END", new Object[0]);
    }

    public void loadProject(boolean onlineMode) {
        Log.logInfoRB("LOG_DATAENGINE_LOAD_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        try {
            if (!this.lockProject()) {
                throw new KnownException("PROJECT_LOCKED", new Object[0]);
            }
            this.isOnlineMode = onlineMode;
            if (RuntimePreferences.isLocationSaveEnabled()) {
                Preferences.setPreference("current_folder", new File(this.m_config.getProjectRoot()).getParentFile().getAbsolutePath());
                Preferences.save();
            }
            Core.getMainWindow().showStatusMessageRB("CT_LOADING_PROJECT", new Object[0]);
            Filters filterMasterConfig = FilterMaster.loadConfig(this.m_config.getProjectInternal());
            if (filterMasterConfig == null) {
                filterMasterConfig = FilterMaster.loadConfig(StaticUtils.getConfigDir());
            }
            if (filterMasterConfig == null) {
                filterMasterConfig = FilterMaster.createDefaultFiltersConfig();
            }
            Core.setFilterMaster(new FilterMaster(filterMasterConfig));
            EntryKey.setIgnoreFileContext(filterMasterConfig.isIgnoreFileContext());
            ISegmentationData segData = this.m_config.getProjectSegmentationData();
            Core.getSegmenter().setSegmentationData(segData == null ? Preferences.getSegmentationData() : segData);
            this.loadSourceFiles();
            this.loadTranslations();
            this.allProjectEntries = Collections.unmodifiableList(this.allProjectEntries);
            this.importHandler = new ImportFromAutoTMX(this, this.allProjectEntries);
            this.importTranslationsFromSources();
            this.loadTM();
            this.loadOtherLanguages();
            String stat = CalcStandardStatistics.buildProjectStats(this, this.hotStat);
            String fn = this.m_config.getProjectInternal() + "project_stats.txt";
            Statistics.writeStat(fn, stat);
            this.loaded = true;
            Core.getMainWindow().showStatusMessageRB(null, new Object[0]);
            this.setProjectModified(false);
        }
        catch (Exception e) {
            Log.logErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
            Core.getMainWindow().displayErrorRB(e, "TF_LOAD_ERROR", new Object[0]);
            if (!this.loaded) {
                this.unlockProject();
            }
        }
        catch (OutOfMemoryError oome) {
            this.allProjectEntries.clear();
            this.projectFilesList.clear();
            this.transMemories.clear();
            this.projectTMX = null;
            System.gc();
            long memory = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            Log.logErrorRB("OUT_OF_MEMORY", memory);
            Log.log(oome);
            Core.getMainWindow().showErrorDialogRB("TF_ERROR", "OUT_OF_MEMORY", memory);
            System.exit(0);
        }
        Log.logInfoRB("LOG_DATAENGINE_LOAD_END", new Object[0]);
    }

    public Map<String, TMXEntry> align(ProjectProperties props, File translatedDir) throws Exception {
        FilterMaster fm = Core.getFilterMaster();
        File root = new File(this.m_config.getSourceRoot());
        List<File> srcFileList = StaticUtils.buildFileList(root, true);
        AlignFilesCallback alignFilesCallback = new AlignFilesCallback(props);
        String srcRoot = this.m_config.getSourceRoot();
        for (File file : srcFileList) {
            String midName = file.getPath().substring(srcRoot.length());
            fm.alignFile(srcRoot, midName, translatedDir.getPath(), new FilterContext(props), alignFilesCallback);
        }
        return alignFilesCallback.data;
    }

    @Override
    public boolean isProjectLoaded() {
        return this.loaded;
    }

    @Override
    public StatisticsInfo getStatistics() {
        return this.hotStat;
    }

    @Override
    public void closeProject() {
        this.loaded = false;
        this.flushProcessCache();
        this.tmMonitor.fin();
        this.tmOtherLanguagesMonitor.fin();
        this.unlockProject();
        Log.logInfoRB("LOG_DATAENGINE_CLOSE", new Object[0]);
    }

    protected boolean lockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return true;
        }
        if (this.repository != null && !this.repository.isFilesLockingAllowed()) {
            return true;
        }
        try {
            File lockFile = new File(this.m_config.getProjectRoot(), "omegat.project");
            this.raFile = new RandomAccessFile(lockFile, "rw");
            this.lockChannel = this.raFile.getChannel();
            this.lock = this.lockChannel.tryLock();
        }
        catch (Throwable ex) {
            Log.log(ex);
        }
        if (this.lock == null) {
            IOUtils.closeQuietly((Closeable)this.lockChannel);
            IOUtils.closeQuietly((Closeable)this.raFile);
            this.lockChannel = null;
            this.raFile = null;
            return false;
        }
        return true;
    }

    protected void unlockProject() {
        if (!RuntimePreferences.isProjectLockingEnabled()) {
            return;
        }
        if (this.repository != null && !this.repository.isFilesLockingAllowed()) {
            return;
        }
        try {
            if (this.lock != null) {
                this.lock.release();
            }
            if (this.lockChannel != null) {
                this.lockChannel.close();
            }
            if (this.raFile != null) {
                this.raFile.close();
            }
        }
        catch (Throwable ex) {
            Log.log(ex);
        }
        finally {
            IOUtils.closeQuietly((Closeable)this.lockChannel);
            IOUtils.closeQuietly((Closeable)this.raFile);
        }
    }

    @Override
    public void compileProject(String sourcePattern) throws IOException, TranslationException {
        try {
            this.lastCompileException = null;
            this.compileProject(sourcePattern, true);
        }
        catch (IOException | TranslationException e) {
            this.lastCompileException = e;
            throw e;
        }
    }

    @Override
    public Exception lastCompileException() {
        return this.lastCompileException;
    }

    @Override
    public void startCompilation() {
        this.lastCompileException = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compileProject(String sourcePattern, boolean doPostProcessing) throws IOException, TranslationException {
        List<File> fileList;
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Pattern FILE_PATTERN = Pattern.compile(sourcePattern);
        if (sourcePattern.equals(".*")) {
            try {
                this.exportTMX("-omegat", false, false, false);
                this.exportTMX("-level1", true, false, false);
                this.exportTMX("-level2", false, true, false);
            }
            catch (Exception e) {
                Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
                Log.log(e);
                throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
            }
        }
        String srcRoot = this.m_config.getSourceRoot();
        String locRoot = this.m_config.getTargetRoot();
        FilterMaster fm = Core.getFilterMaster();
        try {
            fileList = StaticUtils.buildFileList(new File(srcRoot), true);
        }
        catch (Exception e) {
            Log.logErrorRB("CT_ERROR_CREATING_TMX", new Object[0]);
            Log.log(e);
            throw new IOException(OStrings.getString("CT_ERROR_CREATING_TMX") + "\n" + e.getMessage());
        }
        ArrayList<String> pathList = new ArrayList<String>(fileList.size());
        for (File file : fileList) {
            pathList.add(file.getPath().substring(this.m_config.getSourceRoot().length()).replace('\\', '/'));
        }
        StaticUtils.removeFilesByMasks(pathList, this.m_config.getSourceRootExcludes());
        TranslateFilesCallback translateFilesCallback = new TranslateFilesCallback();
        File locRootDir = new File(locRoot);
        File locRootDirTmp = new File(locRootDir.getParentFile(), "target.tmp");
        locRootDirTmp.mkdir();
        try {
            StaticUtils.deltree(locRootDir);
        }
        catch (NoSuchFileException noSuchFileException) {
            // empty catch block
        }
        int numberOfCompiled = 0;
        try {
            for (String midName : pathList) {
                IFileHook hook;
                if (!FILE_PATTERN.matcher(midName).matches() || (hook = IFileHook.hookForFile(midName)).isNotToCompile(midName)) continue;
                File tmpDestFile = new File(locRootDirTmp, midName);
                if (!tmpDestFile.getParentFile().exists() && !tmpDestFile.getParentFile().mkdirs()) {
                    throw new IOException(OStrings.getString("CT_ERROR_CREATING_TARGET_DIR") + tmpDestFile.getParentFile());
                }
                Core.getMainWindow().showStatusMessageRB("CT_COMPILE_FILE_MX", midName);
                translateFilesCallback.fileStarted(midName);
                fm.translateFile(srcRoot, midName, locRootDirTmp.getPath(), new FilterContext(this.m_config), translateFilesCallback);
                translateFilesCallback.fileFinished();
                ++numberOfCompiled;
                hook.postCompile(locRootDirTmp, midName);
                this.lastCompileException = hook.lastCompileException();
            }
        }
        finally {
            Files.move(locRootDirTmp.toPath(), locRootDir.toPath(), new CopyOption[0]);
        }
        if (numberOfCompiled == 1) {
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX_SINGULAR", new Object[0]);
        } else {
            Core.getMainWindow().showStatusMessageRB("CT_COMPILE_DONE_MX", new Object[0]);
        }
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.COMPILE);
        if (doPostProcessing) {
            this.flushProcessCache();
            if (Preferences.isPreference("allow_project_extern_cmd")) {
                this.doExternalCommand(this.m_config.getExternalCommand());
            }
            this.doExternalCommand(Preferences.getPreference("external_command"));
        }
        Log.logInfoRB("LOG_DATAENGINE_COMPILE_END", new Object[0]);
    }

    private void exportTMX(String fName, boolean forceValidTMX, boolean levelTwo, boolean useOrphaned) throws Exception {
        fName = this.m_config.getProjectRoot() + this.m_config.getProjectName() + fName + ".tmx";
        File tmpFile = new File(fName + ".tmp");
        File endFile = new File(fName);
        this.projectTMX.exportTMX(this.m_config, tmpFile, forceValidTMX, levelTwo, useOrphaned);
        endFile.delete();
        tmpFile.renameTo(endFile);
    }

    private void doExternalCommand(String command) {
        if (StringUtil.isEmpty(command)) {
            return;
        }
        Core.getMainWindow().showStatusMessageRB("CT_START_EXTERNAL_CMD", new Object[0]);
        CommandVarExpansion expander = new CommandVarExpansion(command);
        command = expander.expandVariables(this.m_config);
        Log.log("Executing command: " + command);
        try {
            Process p = Runtime.getRuntime().exec(StaticUtils.parseCLICommand(command));
            this.processCache.push(p);
            CommandMonitor stdout = CommandMonitor.newStdoutMonitor(p);
            CommandMonitor stderr = CommandMonitor.newStderrMonitor(p);
            stdout.start();
            stderr.start();
        }
        catch (IOException e) {
            Throwable cause = e.getCause();
            String message = cause == null ? e.getLocalizedMessage() : cause.getLocalizedMessage();
            Core.getMainWindow().showStatusMessageRB("CT_ERROR_STARTING_EXTERNAL_CMD", message);
        }
    }

    private void flushProcessCache() {
        while (!this.processCache.isEmpty()) {
            Process p = this.processCache.pop();
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException ex) {
                p.destroy();
            }
        }
    }

    @Override
    public synchronized void saveProject() {
        this.saveProject(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void saveProject(boolean doTeamSync) {
        if (this.isSaving) {
            return;
        }
        this.isSaving = true;
        Log.logInfoRB("LOG_DATAENGINE_SAVE_START", new Object[0]);
        UIThreadsUtil.mustNotBeSwingThread();
        Core.getAutoSave().disable();
        try {
            Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(false);
            try {
                Preferences.save();
                String s = this.m_config.getProjectInternal() + "project_save.tmx";
                try {
                    this.saveProjectProperties();
                    this.projectTMX.save(this.m_config, s, this.isProjectModified());
                    if (this.repository != null && doTeamSync) {
                        Core.getMainWindow().showStatusMessageRB("TEAM_SYNCHRONIZE", new Object[0]);
                        this.rebaseProject();
                    }
                    this.setProjectModified(false);
                }
                catch (KnownException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    Log.logErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                    Core.getMainWindow().displayErrorRB(e, "CT_ERROR_SAVING_PROJ", new Object[0]);
                }
                LastSegmentManager.saveLastSegment();
                String stat = CalcStandardStatistics.buildProjectStats(this, this.hotStat);
                String fn = this.m_config.getProjectInternal() + "project_stats.txt";
                Statistics.writeStat(fn, stat);
            }
            finally {
                Core.getMainWindow().getMainMenu().getProjectMenu().setEnabled(true);
            }
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.SAVE);
        }
        finally {
            Core.getAutoSave().enable();
        }
        Log.logInfoRB("LOG_DATAENGINE_SAVE_END", new Object[0]);
        this.isSaving = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebaseProject() throws Exception {
        boolean again;
        boolean updateGlossary;
        File[] modifiedFiles;
        List<GlossaryEntry> glossaryEntries = null;
        List<GlossaryEntry> baseGlossaryEntries = null;
        List<GlossaryEntry> headGlossaryEntries = null;
        Log.logInfoRB("TEAM_REBASE_START", new Object[0]);
        String projectTMXFilename = this.m_config.getProjectInternal() + "project_save.tmx";
        final File projectTMXFile = new File(projectTMXFilename);
        boolean needUpload = false;
        final StringBuilder commitDetails = new StringBuilder();
        String glossaryFilename = this.m_config.getWriteableGlossary();
        final File glossaryFile = new File(glossaryFilename);
        if (this.repository.isUnderVersionControl(glossaryFile)) {
            Log.logDebug(LOGGER, "rebaseProject: glossary file {0} is under version control", glossaryFile);
            modifiedFiles = new File[]{projectTMXFile, glossaryFile};
            updateGlossary = true;
        } else {
            Log.logDebug(LOGGER, "rebaseProject: glossary file {0} is not under version control", glossaryFile);
            modifiedFiles = new File[]{projectTMXFile};
            updateGlossary = false;
        }
        if (this.isProjectModified() || this.repository.isChanged(glossaryFile) || this.repository.isChanged(projectTMXFile)) {
            needUpload = true;
        }
        do {
            File filenameGlossarywithLocalChangesOnHead;
            File filenameTMXwithLocalChangesOnHead;
            again = false;
            if (updateGlossary) {
                glossaryEntries = GlossaryReaderTSV.read(glossaryFile, true);
            }
            String baseRevTMX = this.repository.getBaseRevisionId(projectTMXFile);
            Log.logDebug(LOGGER, "rebaseProject: TMX base revision: {0}", baseRevTMX);
            String baseRevGlossary = null;
            if (updateGlossary) {
                baseRevGlossary = this.repository.getBaseRevisionId(glossaryFile);
                Log.logDebug(LOGGER, "rebaseProject: glossary base revision: {0}", baseRevGlossary);
            }
            File filenameTMXwithLocalChangesOnBase = new File(projectTMXFilename + "-based_on_" + baseRevTMX + ".new");
            File filenameGlossarywithLocalChangesOnBase = null;
            this.projectTMX.exportTMX(this.m_config, filenameTMXwithLocalChangesOnBase, false, false, true);
            if (System.getProperty("team.supersafe") != null) {
                File bak = new File(projectTMXFilename + "-based_on_" + baseRevTMX + "_at_" + new SimpleDateFormat("MMdd-HHmmss").format(new Date()) + ".bak");
                this.projectTMX.exportTMX(this.m_config, bak, false, false, true);
            }
            if (updateGlossary) {
                filenameGlossarywithLocalChangesOnBase = new File(glossaryFilename + "-based_on_" + baseRevGlossary + ".new");
                if (filenameGlossarywithLocalChangesOnBase.exists()) {
                    filenameGlossarywithLocalChangesOnBase.delete();
                }
                filenameGlossarywithLocalChangesOnBase.createNewFile();
                for (GlossaryEntry ge : glossaryEntries) {
                    GlossaryReaderTSV.append(filenameGlossarywithLocalChangesOnBase, ge);
                }
            }
            this.repository.restoreBase(modifiedFiles);
            ProjectTMX baseTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), projectTMXFile, null);
            if (updateGlossary) {
                baseGlossaryEntries = GlossaryReaderTSV.read(glossaryFile, true);
            }
            this.unlockProject();
            try {
                this.repository.reset();
            }
            finally {
                this.lockProject();
            }
            try {
                this.repository.download(modifiedFiles);
                this.setOnlineMode();
            }
            catch (IRemoteRepository.NetworkException ex) {
                this.setOfflineMode();
                needUpload = false;
            }
            catch (Exception ex) {
                needUpload = false;
            }
            String headRevTMX = this.repository.getBaseRevisionId(projectTMXFile);
            Log.logDebug(LOGGER, "rebaseProject: TMX head revision: {0}", headRevTMX);
            if (headRevTMX.equals(baseRevTMX)) {
                Log.logDebug(LOGGER, "rebaseProject: head equals base", new Object[0]);
                filenameTMXwithLocalChangesOnHead = filenameTMXwithLocalChangesOnBase;
                filenameTMXwithLocalChangesOnBase = null;
                baseTMX = null;
            } else {
                Log.logDebug(LOGGER, "rebaseProject: real rebase", new Object[0]);
                again = true;
                ProjectTMX headTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), projectTMXFile, null);
                this.mergeTMX(baseTMX, headTMX, commitDetails);
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        Core.getEditor().refreshView(false);
                    }
                });
                filenameTMXwithLocalChangesOnHead = new File(projectTMXFilename + "-based_on_" + headRevTMX + ".new");
                this.projectTMX.exportTMX(this.m_config, filenameTMXwithLocalChangesOnHead, false, false, true);
                if (System.getProperty("team.supersafe") != null) {
                    File bak = new File(projectTMXFilename + "-merged_on_" + headRevTMX + "_at_" + new SimpleDateFormat("MMdd-HHmmss").format(new Date()) + ".bak");
                    this.projectTMX.exportTMX(this.m_config, bak, false, false, true);
                }
                headTMX = null;
            }
            if (updateGlossary) {
                String headRevGlossary = this.repository.getBaseRevisionId(glossaryFile);
                Log.logDebug(LOGGER, "rebaseProject: glossary head revision: {0}", headRevGlossary);
                if (headRevGlossary.equals(baseRevGlossary)) {
                    filenameGlossarywithLocalChangesOnHead = filenameGlossarywithLocalChangesOnBase;
                    filenameGlossarywithLocalChangesOnBase = null;
                    baseGlossaryEntries = null;
                } else {
                    again = true;
                    headGlossaryEntries = GlossaryReaderTSV.read(glossaryFile, true);
                    ArrayList<GlossaryEntry> deltaAddedGlossaryLocal = new ArrayList<GlossaryEntry>(glossaryEntries);
                    deltaAddedGlossaryLocal.removeAll(baseGlossaryEntries);
                    ArrayList<GlossaryEntry> deltaRemovedGlossaryLocal = new ArrayList<GlossaryEntry>(baseGlossaryEntries);
                    deltaRemovedGlossaryLocal.removeAll(glossaryEntries);
                    headGlossaryEntries.addAll(deltaAddedGlossaryLocal);
                    headGlossaryEntries.removeAll(deltaRemovedGlossaryLocal);
                    filenameGlossarywithLocalChangesOnHead = new File(glossaryFilename + "-based_on_" + headRevGlossary + ".new");
                    filenameGlossarywithLocalChangesOnHead.createNewFile();
                    for (GlossaryEntry ge : headGlossaryEntries) {
                        GlossaryReaderTSV.append(filenameGlossarywithLocalChangesOnHead, ge);
                    }
                    headGlossaryEntries = null;
                    baseGlossaryEntries = null;
                }
            } else {
                filenameGlossarywithLocalChangesOnHead = null;
            }
            projectTMXFile.delete();
            FileUtil.rename(filenameTMXwithLocalChangesOnHead, projectTMXFile);
            if (filenameTMXwithLocalChangesOnBase != null && !filenameTMXwithLocalChangesOnBase.delete()) {
                throw new IOException("Error remove old file");
            }
            if (!updateGlossary) continue;
            glossaryFile.delete();
            FileUtil.rename(filenameGlossarywithLocalChangesOnHead, glossaryFile);
            if (filenameGlossarywithLocalChangesOnBase == null || filenameGlossarywithLocalChangesOnBase.delete()) continue;
            throw new IOException("Error remove old glossary file");
        } while (again);
        glossaryEntries = null;
        if (needUpload) {
            final String author = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
            try {
                new RepositoryUtils.AskCredentials(){

                    @Override
                    public void callRepository() throws Exception {
                        RealProject.this.repository.upload(projectTMXFile, "Translated by " + author + commitDetails.toString());
                        if (updateGlossary) {
                            RealProject.this.repository.upload(glossaryFile, "Added glossaryitem(s) by " + author);
                        }
                    }
                }.execute(this.repository);
                this.setOnlineMode();
            }
            catch (IRemoteRepository.NetworkException ex) {
                this.setOfflineMode();
            }
            catch (Exception ex) {
                throw new KnownException(ex, "TEAM_SYNCHRONIZATION_ERROR", new Object[0]);
            }
        }
        Log.logInfoRB("TEAM_REBASE_END", new Object[0]);
    }

    protected void mergeTMX(ProjectTMX baseTMX, ProjectTMX headTMX, StringBuilder commitDetails) {
        StmProperties props = new StmProperties().setBaseTmxName(OStrings.getString("TMX_MERGE_BASE")).setTmx1Name(OStrings.getString("TMX_MERGE_MINE")).setTmx2Name(OStrings.getString("TMX_MERGE_THEIRS")).setLanguageResource(OStrings.getResourceBundle()).setParentWindow((Window)Core.getMainWindow().getApplicationFrame()).setListViewThreshold(5);
        ProjectTMX mergedTMX = SuperTmxMerge.merge((ProjectTMX)baseTMX, (ProjectTMX)this.projectTMX, (ProjectTMX)headTMX, (String)this.m_config.getSourceLanguage().getLanguage(), (String)this.m_config.getTargetLanguage().getLanguage(), (StmProperties)props);
        this.projectTMX.replaceContent(mergedTMX);
        Log.logDebug(LOGGER, "Merge report: {0}", props.getReport());
        commitDetails.append('\n');
        commitDetails.append(props.getReport().toString());
    }

    private void createDirectory(String dir, String dirType) throws IOException {
        File d = new File(dir);
        if (!d.isDirectory() && !d.mkdirs()) {
            StringBuilder msg = new StringBuilder(OStrings.getString("CT_ERROR_CREATE"));
            if (dirType != null) {
                msg.append("\n(.../").append(dirType).append("/)");
            }
            throw new IOException(msg.toString());
        }
    }

    private void loadTranslations() throws Exception {
        File tmxFile = new File(this.m_config.getProjectInternal() + "project_save.tmx");
        try {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_TMX", new Object[0]);
            this.projectTMX = new ProjectTMX(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), tmxFile, this.checkOrphanedCallback);
            if (tmxFile.exists()) {
                FileUtil.backupFile(tmxFile);
                FileUtil.removeOldBackups(tmxFile, System.getProperty("team.supersafe") != null ? 300 : 11);
            }
        }
        catch (SAXParseException ex) {
            Log.logErrorRB(ex, "TMXR_FATAL_ERROR_WHILE_PARSING", ex.getLineNumber(), ex.getColumnNumber());
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB(ex, "TMXR_EXCEPTION_WHILE_PARSING", tmxFile.getAbsolutePath(), Log.getLogLocation());
            throw ex;
        }
        File propertiesFile = new File(this.m_config.getProjectInternal() + "project_save.properties");
        if (propertiesFile.exists()) {
            try {
                this.projectTMX = new ProjectMemory(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), this.m_config.isSentenceSegmentingEnabled(), tmxFile, this.checkOrphanedCallback, this, propertiesFile);
            }
            catch (Exception e) {
                String filename = propertiesFile.getPath();
                Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
            }
        }
    }

    private void loadSourceFiles() throws Exception {
        long st = System.currentTimeMillis();
        FilterMaster fm = Core.getFilterMaster();
        File root = new File(this.m_config.getSourceRoot());
        List<File> srcFileList = StaticUtils.buildFileList(root, true);
        ArrayList<String> srcPathList = new ArrayList<String>(srcFileList.size());
        for (File file : srcFileList) {
            if (!file.getPath().startsWith(this.m_config.getSourceRoot())) {
                throw new RuntimeException("Can't calculate relative path: " + file.getPath() + " does not appear to begin with " + this.m_config.getSourceRoot());
            }
            srcPathList.add(file.getPath().substring(this.m_config.getSourceRoot().length()).replace('\\', '/'));
        }
        StaticUtils.removeFilesByMasks(srcPathList, this.m_config.getSourceRootExcludes());
        StaticUtils.sortByList(srcPathList, this.getSourceFilesOrder());
        for (String filepath : srcPathList) {
            Core.getMainWindow().showStatusMessageRB("CT_LOAD_FILE_MX", filepath);
            LoadFilesCallback loadFilesCallback = new LoadFilesCallback(this.existSource, this.existKeys);
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = filepath;
            loadFilesCallback.setCurrentFile(fi);
            IFilter filter = fm.loadFile(this.m_config.getSourceRoot() + filepath, new FilterContext(this.m_config), loadFilesCallback);
            loadFilesCallback.fileFinished();
            if (filter == null || fi.entries.isEmpty()) continue;
            fi.filterClass = filter.getClass();
            fi.filterFileFormatName = filter.getFileFormatName();
            try {
                fi.fileEncoding = filter.getInEncodingLastParsedFile();
            }
            catch (Error e) {
                fi.fileEncoding = "";
            }
            this.projectFilesList.add(fi);
        }
        this.findNonUniqueSegments();
        Core.getMainWindow().showStatusMessageRB("CT_LOAD_SRC_COMPLETE", new Object[0]);
        long en = System.currentTimeMillis();
        Log.log("Load project source files: " + (en - st) + "ms");
    }

    protected void findNonUniqueSegments() {
        HashMap<String, SourceTextEntry> exists = new HashMap<String, SourceTextEntry>(16384);
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                SourceTextEntry ste = fi.entries.get(i);
                SourceTextEntry prevSte = (SourceTextEntry)exists.get(ste.getSrcText());
                if (prevSte == null) {
                    exists.put(ste.getSrcText(), ste);
                    continue;
                }
                if (prevSte.duplicates == null) {
                    prevSte.duplicates = new ArrayList<SourceTextEntry>();
                }
                prevSte.duplicates.add(ste);
                ste.firstInstance = prevSte;
            }
        }
    }

    void importTranslationsFromSources() {
        HashMap<String, String> allowToImport = new HashMap<String, String>();
        for (IProject.FileInfo fi : this.projectFilesList) {
            for (int i = 0; i < fi.entries.size(); ++i) {
                SourceTextEntry ste = fi.entries.get(i);
                if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy() || ste.getSrcText().equals(ste.getSourceTranslation()) && !this.allowTranslationEqualToSource) continue;
                PrepareTMXEntry prepare = ste.getSourceTranslationInfo().asPrepareEntry(ste.getSrcText());
                if (this.m_config.isSupportDefaultTranslations()) {
                    TMXEntry enDefault = this.projectTMX.getDefaultTranslation(ste.getSrcText());
                    if (enDefault == null) {
                        this.projectTMX.setTranslation(ste, new TMXEntry(prepare, true, TMXEntry.ExternalLinked.xSRC), true);
                        allowToImport.put(ste.getSrcText(), ste.getSourceTranslation());
                        continue;
                    }
                    String justImported = (String)allowToImport.get(ste.getSrcText());
                    if (justImported == null || ste.getSourceTranslation().equals(justImported)) continue;
                    this.projectTMX.setTranslation(ste, new TMXEntry(prepare, false, TMXEntry.ExternalLinked.xSRC), false);
                    continue;
                }
                TMXEntry en = this.projectTMX.getMultipleTranslation(ste.getKey());
                if (en != null) continue;
                this.projectTMX.setTranslation(ste, new TMXEntry(prepare, false, TMXEntry.ExternalLinked.xSRC), false);
            }
        }
    }

    private void loadTM() throws IOException {
        final File tmRoot = new File(this.m_config.getTMRoot());
        this.tmMonitor = new DirectoryMonitor(tmRoot, new DirectoryMonitor.Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            @Override
            public void fileChanged(File file) {
                if (file.getPath().replace('\\', '/').startsWith(RealProject.this.m_config.getTMOtherLangRoot().replace('\\', '/'))) {
                    return;
                }
                newTransMemories = new TreeMap<String, IExternalMemory>(RealProject.access$100(RealProject.this));
                newUpdatedExternalMemories = new HashSet<IWritableExternalMemory>(RealProject.access$200(RealProject.this));
                resynchronizedMemories = new HashSet<IExternalMemory>(RealProject.access$200(RealProject.this));
                if (file.exists()) {
                    try {
                        newMemory = null;
                        if (file.getPath().endsWith(".properties")) {
                            is = null;
                            try {
                                config = new Properties();
                                is = new FileInputStream(file);
                                config.load((InputStream)is);
                                memoryClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
                                cons = memoryClass.getConstructor(new Class[]{Properties.class});
                                newMemory = (IExternalMemory)cons.newInstance(new Object[]{config});
                                newTransMemories.put(file.getPath(), newMemory);
                                if (!"true".equalsIgnoreCase(config.getProperty("resync-on-fail"))) ** GOTO lbl43
                                resynchronizedMemories.add(newMemory);
                            }
                            catch (Exception e) {
                                filename = file.getPath();
                                Log.logErrorRB(e, "TF_TM_LOAD_ERROR", new Object[]{filename});
                                Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", new Object[]{filename});
                            }
                            finally {
                                if (is != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Exception e) {}
                                }
                            }
                        } else {
                            for (Map.Entry<String, Class<?>> entry : PluginUtils.getTranslationMemoryFormatClasses().entrySet()) {
                                if (!file.getPath().toLowerCase().endsWith(entry.getKey().toLowerCase())) continue;
                                cons = entry.getValue().getConstructor(new Class[]{ProjectProperties.class, File.class, Boolean.TYPE, Boolean.TYPE});
                                newMemory = (IExternalMemory)cons.newInstance(new Object[]{RealProject.this.m_config, file, Preferences.isPreference("ext_tmx_show_level2"), Preferences.isPreference("ext_tmx_use_slash")});
                                newTransMemories.put(file.getPath(), newMemory);
                                break;
                            }
                        }
lbl43:
                        // 5 sources

                        if (newMemory == null) {
                            throw new Exception("Unknown file format");
                        }
                        try {
                            uNewMemory = (IWritableExternalMemory)newMemory;
                            if (uNewMemory.isWriteMode()) {
                                if (resynchronizedMemories.contains(uNewMemory)) {
                                    newUpdatedExternalMemories.add(new CacheWritableExternalMemory(uNewMemory));
                                } else {
                                    newUpdatedExternalMemories.add(uNewMemory);
                                }
                            }
                        }
                        catch (ClassCastException uNewMemory) {
                            // empty catch block
                        }
                        if (FileUtil.computeRelativePath(tmRoot, file).startsWith("auto/")) {
                            RealProject.this.appendFromAutoMemory((IBrowsableMemory)newMemory, false);
                        } else if (FileUtil.computeRelativePath(tmRoot, file).startsWith("enforce/")) {
                            RealProject.this.appendFromAutoMemory((IBrowsableMemory)newMemory, true);
                        }
                    }
                    catch (Exception e) {
                        filename = file.getPath();
                        Log.logErrorRB(e, "TF_TM_LOAD_ERROR", new Object[]{filename});
                        Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", new Object[]{filename});
                    }
                } else {
                    newUpdatedExternalMemories.remove(newTransMemories.get(file.getPath()));
                    newTransMemories.remove(file.getPath());
                }
                RealProject.access$102(RealProject.this, newTransMemories);
                RealProject.access$202(RealProject.this, newUpdatedExternalMemories);
            }
        });
        this.tmMonitor.checkChanges();
        this.tmMonitor.start();
    }

    private void loadOtherLanguages() throws IOException {
        File tmOtherLanguagesRoot = new File(this.m_config.getTMOtherLangRoot());
        this.tmOtherLanguagesMonitor = new DirectoryMonitor(tmOtherLanguagesRoot, new DirectoryMonitor.Callback(){
            private final Pattern fileNamePattern = Pattern.compile("([A-Z]{2}([-_][A-Z]{2})?)\\.(tmx|properties)$");

            @Override
            public void fileChanged(File file) {
                Matcher matcher = this.fileNamePattern.matcher(file.getName());
                if (!matcher.matches()) {
                    return;
                }
                Language targetLanguage = new Language(matcher.group(1));
                TreeMap<Language, ProjectTMX> newOtherTargetLangTMs = new TreeMap<Language, ProjectTMX>(RealProject.this.otherTargetLangTMs);
                if (file.exists()) {
                    if (matcher.group(3).equals("tmx")) {
                        newOtherTargetLangTMs.put(targetLanguage, this.loadTmx(file, targetLanguage));
                    }
                    if (matcher.group(3).equals("properties")) {
                        newOtherTargetLangTMs.put(targetLanguage, this.loadExternal(file, targetLanguage));
                    }
                } else {
                    newOtherTargetLangTMs.remove(targetLanguage);
                }
                RealProject.this.otherTargetLangTMs = newOtherTargetLangTMs;
            }

            private ProjectTMX loadTmx(File file, Language targetLanguage) {
                try {
                    return new ProjectTMX(RealProject.this.m_config.getSourceLanguage(), targetLanguage, RealProject.this.m_config.isSentenceSegmentingEnabled(), file, RealProject.this.checkOrphanedCallback);
                }
                catch (Exception e) {
                    String filename = file.getPath();
                    Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    return null;
                }
            }

            private ProjectTMX loadExternal(File file, Language targetLanguage) {
                File tmxFile = new File(file.getParentFile(), file.getName().substring(0, file.getName().lastIndexOf(".")) + ".tmx");
                try {
                    RealProject dummyProject = new RealProject(new ProjectProperties());
                    dummyProject.allProjectEntries = Collections.unmodifiableList(RealProject.this.allProjectEntries);
                    dummyProject.projectTMX = new ProjectMemory(RealProject.this.m_config.getSourceLanguage(), targetLanguage, RealProject.this.m_config.isSentenceSegmentingEnabled(), tmxFile, RealProject.this.checkOrphanedCallback, dummyProject, file);
                    return dummyProject.projectTMX;
                }
                catch (Exception e) {
                    String filename = file.getPath();
                    Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    return null;
                }
            }
        });
        this.tmOtherLanguagesMonitor.checkChanges();
        this.tmOtherLanguagesMonitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appendFromAutoMemory(IBrowsableMemory tmx, boolean isEnforcedTMX) throws Exception {
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            this.importHandler.process(tmx, isEnforcedTMX);
        }
    }

    @Override
    public List<SourceTextEntry> getAllEntries() {
        return this.allProjectEntries;
    }

    @Override
    public TMXEntry getTranslationInfo(SourceTextEntry ste) {
        TMXEntry r = this.projectTMX.getMultipleTranslation(ste.getKey());
        if (r == null) {
            r = this.projectTMX.getDefaultTranslation(ste.getSrcText());
        }
        if (r == null) {
            r = this.EMPTY_TRANSLATION;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProject.AllTranslations getAllTranslations(SourceTextEntry ste) {
        IProject.AllTranslations r = new IProject.AllTranslations();
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            r.defaultTranslation = this.projectTMX.getDefaultTranslation(ste.getSrcText());
            r.alternativeTranslation = this.projectTMX.getMultipleTranslation(ste.getKey());
            r.currentTranslation = r.alternativeTranslation != null ? r.alternativeTranslation : (r.defaultTranslation != null ? r.defaultTranslation : this.EMPTY_TRANSLATION);
            if (r.defaultTranslation == null) {
                r.defaultTranslation = this.EMPTY_TRANSLATION;
            }
            if (r.alternativeTranslation == null) {
                r.alternativeTranslation = this.EMPTY_TRANSLATION;
            }
        }
        return r;
    }

    @Override
    public ProjectProperties getProjectProperties() {
        return this.m_config;
    }

    @Override
    public boolean isProjectModified() {
        return this.m_modifiedFlag;
    }

    private void setProjectModified(boolean isModified) {
        this.m_modifiedFlag = isModified;
        if (isModified) {
            CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.MODIFIED);
        }
    }

    public void setModified() {
        this.m_modifiedFlag = true;
        CoreEvents.fireProjectChange(IProjectEventListener.PROJECT_CHANGE_TYPE.MODIFIED);
    }

    public void sendToWritableMemories(SourceTextEntry entry, PrepareTMXEntry trans) {
        System.out.println("Updating " + this.updatedExternalMemories);
        for (IWritableExternalMemory provider : this.updatedExternalMemories) {
            try {
                System.out.println("Updating " + provider);
                if (!provider.mustWrite(trans, entry)) continue;
                provider.registerTranslation(this.m_config.getSourceLanguage(), this.m_config.getTargetLanguage(), trans, entry);
            }
            catch (ClassCastException classCastException) {
            }
            catch (Exception other) {
                Log.log(other);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked, IProject.AllTranslations previous) throws IProject.OptimisticLockingFail {
        if (trans == null) {
            throw new IllegalArgumentException("RealProject.setTranslation(tr) can't be null");
        }
        ProjectTMX projectTMX = this.projectTMX;
        synchronized (projectTMX) {
            IProject.AllTranslations current = this.getAllTranslations(entry);
            boolean wasAlternative = current.alternativeTranslation.isTranslated();
            if (defaultTranslation) {
                if (!current.defaultTranslation.equals(previous.defaultTranslation)) {
                    throw new IProject.OptimisticLockingFail(previous.getDefaultTranslation().translation, current.getDefaultTranslation().translation, current);
                }
                if (wasAlternative) {
                    if (!current.alternativeTranslation.equals(previous.alternativeTranslation)) {
                        throw new IProject.OptimisticLockingFail(previous.getAlternativeTranslation().translation, current.getAlternativeTranslation().translation, current);
                    }
                    this.setTranslation(entry, new PrepareTMXEntry(), false, null);
                }
            } else if (!current.alternativeTranslation.equals(previous.alternativeTranslation)) {
                throw new IProject.OptimisticLockingFail(previous.getAlternativeTranslation().translation, current.getAlternativeTranslation().translation, current);
            }
            this.setTranslation(entry, trans, defaultTranslation, externalLinked);
        }
    }

    @Override
    public void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        TMXEntry newTrEntry;
        if (trans == null) {
            throw new IllegalArgumentException("RealProject.setTranslation(tr) can't be null");
        }
        TMXEntry prevTrEntry = defaultTranslation ? this.projectTMX.getDefaultTranslation(entry.getSrcText()) : this.projectTMX.getMultipleTranslation(entry.getKey());
        trans.changer = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
        trans.changeDate = System.currentTimeMillis();
        if (prevTrEntry == null) {
            prevTrEntry = this.EMPTY_TRANSLATION;
            trans.creationDate = trans.changeDate;
            trans.creator = trans.changer;
        } else {
            trans.creationDate = prevTrEntry.creationDate;
            trans.creator = prevTrEntry.creator;
        }
        if (StringUtil.isEmpty(trans.note)) {
            trans.note = null;
        }
        trans.source = entry.getSrcText();
        if (trans.translation == null && trans.note == null) {
            newTrEntry = null;
        } else {
            newTrEntry = new TMXEntry(trans, defaultTranslation, externalLinked);
            newTrEntry.revisor = prevTrEntry.revisor;
            if (((MainWindow)Core.getMainWindow()).menu.revisionModeMenuItem.isSelected()) {
                newTrEntry.revisor = Preferences.getPreferenceDefault("team_Author", System.getProperty("user.name"));
            }
        }
        this.setProjectModified(true);
        this.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
        if (trans.translation != null) {
            this.sendToWritableMemories(entry, trans);
        }
        int diff = prevTrEntry.translation == null ? 0 : -1;
        this.hotStat.numberofTranslatedSegments = Math.max(0, Math.min(this.hotStat.numberOfUniqueSegments, this.hotStat.numberofTranslatedSegments + (diff += trans.translation == null ? 0 : 1)));
    }

    @Override
    public void setNote(SourceTextEntry entry, TMXEntry oldTE, String note) {
        TMXEntry prevTrEntry;
        if (oldTE == null) {
            throw new IllegalArgumentException("RealProject.setNote(tr) can't be null");
        }
        if (note != null && note.isEmpty()) {
            note = null;
        }
        TMXEntry tMXEntry = prevTrEntry = oldTE.defaultTranslation ? this.projectTMX.getDefaultTranslation(entry.getSrcText()) : this.projectTMX.getMultipleTranslation(entry.getKey());
        if (prevTrEntry != null) {
            PrepareTMXEntry en = new PrepareTMXEntry(prevTrEntry);
            en.note = note;
            this.projectTMX.setTranslation(entry, new TMXEntry(en, prevTrEntry.defaultTranslation, prevTrEntry.linked), prevTrEntry.defaultTranslation);
        } else {
            PrepareTMXEntry en = new PrepareTMXEntry();
            en.source = entry.getSrcText();
            en.note = note;
            en.translation = null;
            this.projectTMX.setTranslation(entry, new TMXEntry(en, true, null), true);
        }
        this.setProjectModified(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByDefaultTranslations(IProject.DefaultTranslationsIterator it) {
        Map.Entry[] entryArray = this.projectTMX;
        synchronized (this.projectTMX) {
            Set<Map.Entry<String, TMXEntry>> set = this.projectTMX.defaults.entrySet();
            Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Map.Entry en : entries) {
                it.iterate((String)en.getKey(), (TMXEntry)en.getValue());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void iterateByMultipleTranslations(IProject.MultipleTranslationsIterator it) {
        Map.Entry[] entryArray = this.projectTMX;
        synchronized (this.projectTMX) {
            Set<Map.Entry<EntryKey, TMXEntry>> set = this.projectTMX.alternatives.entrySet();
            Map.Entry[] entries = set.toArray(new Map.Entry[set.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Map.Entry en : entries) {
                it.iterate((EntryKey)en.getKey(), (TMXEntry)en.getValue());
            }
            return;
        }
    }

    @Override
    public boolean isOrphaned(String source) {
        return !this.checkOrphanedCallback.existSourceInProject(source);
    }

    @Override
    public boolean isOrphaned(EntryKey entry) {
        return !this.checkOrphanedCallback.existEntryInProject(entry);
    }

    @Override
    public Map<String, IExternalMemory> getTransMemories() {
        return this.transMemories;
    }

    @Override
    public Map<Language, ProjectTMX> getOtherTargetLanguageTMs() {
        return this.otherTargetLangTMs;
    }

    @Override
    public ITokenizer getSourceTokenizer() {
        return this.sourceTokenizer;
    }

    @Override
    public ITokenizer getTargetTokenizer() {
        return this.targetTokenizer;
    }

    protected ITokenizer createTokenizer(String cmdLine, Class<?> projectPref) {
        if (!StringUtil.isEmpty(cmdLine)) {
            try {
                return (ITokenizer)PluginUtils.getPluginsClassLoader().loadClass(cmdLine).newInstance();
            }
            catch (ClassNotFoundException e) {
                Log.log(e.toString());
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return (ITokenizer)projectPref.newInstance();
        }
        catch (Throwable e) {
            Log.log(e);
            return new DefaultTokenizer();
        }
    }

    protected void configTokenizer(String cmdLine, ITokenizer tokenizer) {
        if (!StringUtil.isEmpty(cmdLine)) {
            try {
                tokenizer.setBehavior(Version.valueOf((String)cmdLine));
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
        String vString = Preferences.getPreferenceDefault("tokenizer_behavior_" + tokenizer.getClass().getName(), null);
        if (!StringUtil.isEmpty(vString)) {
            try {
                tokenizer.setBehavior(Version.valueOf((String)vString));
                return;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public List<IProject.FileInfo> getProjectFiles() {
        return Collections.unmodifiableList(this.projectFilesList);
    }

    @Override
    public String getTargetPathForSourceFile(String currentSource) {
        if (StringUtil.isEmpty(currentSource)) {
            return null;
        }
        try {
            return Core.getFilterMaster().getTargetForSource(this.m_config.getSourceRoot(), currentSource, new FilterContext(this.m_config));
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    @Override
    public List<String> getSourceFilesOrder() {
        String file = this.m_config.getProjectInternal() + "files_order.txt";
        try {
            String s;
            BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            ArrayList<String> result = new ArrayList<String>();
            while ((s = rd.readLine()) != null) {
                result.add(s);
            }
            rd.close();
            return result;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void setSourceFilesOrder(List<String> filesList) {
        String file = this.m_config.getProjectInternal() + "files_order.txt";
        try {
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (String f : filesList) {
                wr.write(f);
                wr.write(10);
            }
            wr.close();
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    protected String patchFileNameForEntryKey(String filename) {
        String f = Core.getParams().get("alternate-filename-from");
        String t = Core.getParams().get("alternate-filename-to");
        String fn = filename.replace('\\', '/');
        if (f != null && t != null) {
            fn = fn.replaceAll(f, t);
        }
        return fn;
    }

    void setOnlineMode() {
        if (!this.isOnlineMode) {
            Log.logInfoRB("VCS_ONLINE", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_ONLINE", "VCS_OFFLINE", new Object[0]);
        }
        this.isOnlineMode = true;
    }

    void setOfflineMode() {
        if (this.isOnlineMode) {
            Log.logInfoRB("VCS_OFFLINE", new Object[0]);
            Core.getMainWindow().displayWarningRB("VCS_OFFLINE", "VCS_ONLINE", new Object[0]);
        }
        this.isOnlineMode = false;
    }

    static /* synthetic */ Map access$100(RealProject x0) {
        return x0.transMemories;
    }

    static /* synthetic */ Set access$200(RealProject x0) {
        return x0.updatedExternalMemories;
    }

    static /* synthetic */ Map access$102(RealProject x0, Map x1) {
        x0.transMemories = x1;
        return x0.transMemories;
    }

    static /* synthetic */ Set access$202(RealProject x0, Set x1) {
        x0.updatedExternalMemories = x1;
        return x0.updatedExternalMemories;
    }

    static class AlignFilesCallback
    implements IAlignCallback {
        Map<String, TMXEntry> data = new HashMap<String, TMXEntry>();
        private ProjectProperties config;

        public AlignFilesCallback(ProjectProperties props) {
            this.config = props;
        }

        @Override
        public void addTranslation(String id, String source, String translation, boolean isFuzzy, String path, IFilter filter) {
            if (source != null && translation != null) {
                ParseEntry.ParseEntryResult spr = new ParseEntry.ParseEntryResult();
                boolean removeSpaces = Core.getFilterMaster().getConfig().isRemoveSpacesNonseg();
                String sourceS = ParseEntry.stripSomeChars(source, spr, this.config.isRemoveTags(), removeSpaces);
                String transS = ParseEntry.stripSomeChars(translation, spr, this.config.isRemoveTags(), removeSpaces);
                PrepareTMXEntry tr = new PrepareTMXEntry();
                if (this.config.isSentenceSegmentingEnabled()) {
                    List<String> segmentsSource = Core.getSegmenter().segment(this.config.getSourceLanguage(), sourceS, null, null);
                    List<String> segmentsTranslation = Core.getSegmenter().segment(this.config.getTargetLanguage(), transS, null, null);
                    if (segmentsTranslation.size() != segmentsSource.size()) {
                        if (isFuzzy) {
                            transS = "[" + filter.getFuzzyMark() + "] " + transS;
                        }
                        tr.source = sourceS;
                        tr.translation = transS;
                        this.data.put(sourceS, new TMXEntry(tr, true, null));
                    } else {
                        for (int i = 0; i < segmentsSource.size(); i = (int)((short)(i + 1))) {
                            String oneSrc = segmentsSource.get(i);
                            String oneTrans = segmentsTranslation.get(i);
                            if (isFuzzy) {
                                oneTrans = "[" + filter.getFuzzyMark() + "] " + oneTrans;
                            }
                            tr.source = oneSrc;
                            tr.translation = oneTrans;
                            this.data.put(oneSrc, new TMXEntry(tr, true, null));
                        }
                    }
                } else {
                    if (isFuzzy) {
                        transS = "[" + filter.getFuzzyMark() + "] " + transS;
                    }
                    tr.source = sourceS;
                    tr.translation = transS;
                    this.data.put(sourceS, new TMXEntry(tr, true, null));
                }
            }
        }
    }

    private class TranslateFilesCallback
    extends TranslateEntry {
        private String currentFile;

        @Override
        protected String getCurrentFile() {
            return this.currentFile;
        }

        public TranslateFilesCallback() {
            super(RealProject.this.m_config);
        }

        protected void fileStarted(String fn) {
            this.currentFile = RealProject.this.patchFileNameForEntryKey(fn);
            super.fileStarted();
        }

        @Override
        protected TMXEntry getSegmentEntry(String id, int segmentIndex, String segmentSource, String prevSegment, String nextSegment, String path) {
            EntryKey ek = new EntryKey(this.currentFile, segmentSource, id, prevSegment, nextSegment, path);
            TMXEntry tr = RealProject.this.projectTMX.getMultipleTranslation(ek);
            if (tr == null) {
                tr = RealProject.this.projectTMX.getDefaultTranslation(ek.sourceText);
            }
            return tr != null ? tr : null;
        }
    }

    protected class LoadFilesCallback
    extends ParseEntry {
        private IProject.FileInfo fileInfo;
        private String entryKeyFilename;
        private final Set<String> existSource;
        private final Set<EntryKey> existKeys;

        public LoadFilesCallback(Set<String> existSource, Set<EntryKey> existKeys) {
            super(RealProject.this.m_config);
            this.existSource = existSource;
            this.existKeys = existKeys;
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            this.fileInfo = fi;
            super.setCurrentFile(fi);
            this.entryKeyFilename = RealProject.this.patchFileNameForEntryKey(this.fileInfo.filePath);
        }

        @Override
        public void fileFinished() {
            super.fileFinished();
            this.fileInfo = null;
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, SourceTextEntry.SourceTranslationInfo traInfo, String prevSegment, String nextSegment, String path) {
            if (segmentSource.trim().isEmpty()) {
                throw new RuntimeException("Segment must not be empty");
            }
            EntryKey ek = new EntryKey(this.entryKeyFilename, segmentSource, id, prevSegment, nextSegment, path);
            protectedParts = TagUtil.applyCustomProtectedParts(segmentSource, PatternConsts.getPlaceholderPattern(), protectedParts);
            if (traInfo != null && ek.sourceText.equals(traInfo.getTranslation()) && !RealProject.this.allowTranslationEqualToSource) {
                traInfo.setUntranslated();
            }
            SourceTextEntry srcTextEntry = new SourceTextEntry(ek, RealProject.this.allProjectEntries.size() + 1, traInfo, protectedParts, segmentIndex == 0);
            RealProject.this.allProjectEntries.add(srcTextEntry);
            this.fileInfo.entries.add(srcTextEntry);
            this.existSource.add(segmentSource);
            this.existKeys.add(srcTextEntry.getKey());
        }
    }
}

