/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.machinetranslators;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ExternalTMX;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.machinetranslators.BaseTranslate;
import org.omegat.core.matching.FuzzyMatcher;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.Token;

public class LocalTranslate
extends BaseTranslate
implements IProjectEventListener {
    public static final int MIN_MATCHING = 80;
    private DirectoryMonitor tmMonitor;
    private Map<String, ExternalTMX> transMemories = new TreeMap<String, ExternalTMX>();
    private ITokenizer tok;

    public LocalTranslate() {
        CoreEvents.registerProjectChangeListener(this);
        if (Core.getProject() instanceof RealProject) {
            this.onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE.LOAD);
        }
    }

    @Override
    public String getName() {
        return "Local";
    }

    @Override
    protected String getPreferenceName() {
        return "allow_locale_translate";
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case LOAD: {
                try {
                    this.loadTM();
                    this.tok = Core.getProject().getSourceTokenizer();
                    break;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void loadTM() throws IOException {
        File tmRoot = new File(Core.getProject().getProjectProperties().getProjectRoot() + "mt" + File.separator);
        if (!tmRoot.exists()) {
            return;
        }
        this.tmMonitor = new DirectoryMonitor(tmRoot, new DirectoryMonitor.Callback(){

            @Override
            public void fileChanged(File file) {
                if (!file.getName().endsWith(".tmx")) {
                    return;
                }
                TreeMap<String, ExternalTMX> newTransMemories = new TreeMap<String, ExternalTMX>(LocalTranslate.this.transMemories);
                if (file.exists()) {
                    try {
                        Log.log("LocalTranslate : Load " + file);
                        ExternalTMX newTMX = new ExternalTMX(Core.getProject().getProjectProperties(), file, Preferences.isPreference("ext_tmx_show_level2"), Preferences.isPreference("ext_tmx_use_slash"));
                        newTransMemories.put(file.getPath(), newTMX);
                        Log.log("LocalTranslate : Load " + file + " ok.");
                    }
                    catch (Exception e) {
                        String filename = file.getPath();
                        Log.logErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                        Core.getMainWindow().displayErrorRB(e, "TF_TM_LOAD_ERROR", filename);
                    }
                } else {
                    newTransMemories.remove(file.getPath());
                }
                LocalTranslate.this.transMemories = newTransMemories;
            }
        });
        this.tmMonitor.checkChanges();
        this.tmMonitor.start();
    }

    @Override
    public String translate(Language sLang, Language tLang, String text) {
        Token[] strTokensStem = this.tok.tokenizeWords(text, ITokenizer.StemmingMode.MATCHING);
        LevenshteinDistance distance = new LevenshteinDistance();
        String result = null;
        int max = -1;
        for (ExternalTMX tmx : this.transMemories.values()) {
            for (PrepareTMXEntry entry : tmx.getEntries()) {
                Token[] candTokens = this.tok.tokenizeWords(entry.source, ITokenizer.StemmingMode.MATCHING);
                int similarityStem = FuzzyMatcher.calcSimilarity(distance, strTokensStem, candTokens);
                if (similarityStem <= 80 || similarityStem <= max) continue;
                result = entry.translation;
                max = similarityStem;
            }
        }
        return result;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }
}

