/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.io.File;
import java.util.List;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ParseEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.search.FileSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.Searcher;
import org.omegat.core.search.TextExpression;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.gui.search.DirectorySearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public class DirectorySearcher
extends Searcher {
    private ProjectProperties m_properties;
    private TextExpression m_textExpr;
    private String m_searchDir;
    private boolean m_searchRecursive;
    protected static final int ENTRY_ORIGIN_TEXT = -5;

    public DirectorySearcher(DirectorySearchWindow window, ProjectProperties properties, TextExpression text, boolean removeDup, int numberOfResults, String rootDir, boolean recursive) {
        super(window, removeDup, numberOfResults);
        this.m_properties = properties;
        this.m_searchDir = rootDir;
        this.m_searchRecursive = recursive;
        this.m_textExpr = text;
    }

    @Override
    protected void doSearch() throws Exception {
        if (!this.m_searchDir.endsWith(File.separator)) {
            this.m_searchDir = this.m_searchDir + File.separator;
        }
        FilterMaster fm = Core.getFilterMaster();
        SearchCallback searchCallback = new SearchCallback(this.m_properties);
        FilterContext ctxt = new FilterContext(Core.getProject().getProjectProperties());
        StaticUtils.iterateFileTree(new File(this.m_searchDir), this.m_searchRecursive, file -> {
            String filename = file.getPath();
            IProject.FileInfo fi = new IProject.FileInfo();
            fi.filePath = filename.substring(this.m_searchDir.length());
            searchCallback.setCurrentFile(fi);
            fm.loadFile(filename, ctxt, searchCallback);
            searchCallback.fileFinished();
            this.checkInterrupted();
        });
    }

    protected class SearchCallback
    extends ParseEntry
    implements IParseCallback {
        private File currentFile;

        public SearchCallback(ProjectProperties config) {
            super(config);
        }

        @Override
        public void setCurrentFile(IProject.FileInfo fi) {
            super.setCurrentFile(fi);
            this.currentFile = new File(DirectorySearcher.this.m_searchDir, fi.filePath);
        }

        @Override
        protected void fileFinished() {
            super.fileFinished();
        }

        @Override
        protected void addSegment(String id, short segmentIndex, String segmentSource, List<ProtectedPart> protectedParts, SourceTextEntry.SourceTranslationInfo traInfo, String prevSegment, String nextSegment, String path) {
            if (DirectorySearcher.this.m_numFinds >= DirectorySearcher.this.m_maxResults) {
                return;
            }
            DirectorySearcher.this.checkInterrupted();
            List<SearchMatch> matches = DirectorySearcher.this.m_textExpr.searchString(segmentSource);
            if (matches != null) {
                String segmentTranslation;
                String string = segmentTranslation = traInfo == null ? null : traInfo.getTranslation();
                if (traInfo != null && traInfo.sourceTranslationFuzzy && segmentTranslation != null) {
                    segmentTranslation = segmentTranslation + " " + OStrings.getString("WF_DEFAULT_PREFIX");
                }
                DirectorySearcher.this.addEntry(new FileSearchResultEntry(this.currentFile, segmentSource, segmentTranslation, traInfo == null ? null : traInfo.comment, matches));
            }
        }
    }
}

