/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.search;

import java.util.Iterator;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.Searcher;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.TranslationStateFilter;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.util.OStrings;

public abstract class ProjectSearcher
extends Searcher {
    public static final int SEARCH_SCOPE_ONGOING = 1;
    public static final int SEARCH_SCOPE_ORPHANS = 2;
    public static final int SEARCH_SCOPE_SOURCE_FILES = 16;
    protected final IProject m_project;
    protected TextExpression m_author;
    protected TextExpression m_translator;
    protected long m_dateBefore;
    protected long m_dateAfter;
    protected boolean m_trueMissing;

    protected ProjectSearcher(ProjectSearchWindow window, IProject project, boolean removeDup, boolean trueMissing, int numberOfResults, TextExpression author, TextExpression translator, long dateAfter, long dateBefore) {
        super(window, removeDup, numberOfResults);
        this.m_project = project;
        this.m_author = author;
        this.m_translator = translator;
        this.m_dateBefore = dateBefore;
        this.m_dateAfter = dateAfter;
        this.m_trueMissing = trueMissing;
    }

    @Override
    protected void doSearch() {
        this.m_numFinds = 0;
        if (this.searchOn(17)) {
            int count = this.m_project.getAllEntries().size();
            int progress = 0;
            Iterator<SourceTextEntry> iter = this.projectEntries();
            while (iter.hasNext()) {
                SourceTextEntry entry = iter.next();
                this.m_window.displayProgress("ONGOING:" + entry.getKey().file, progress++, count, this.m_numFinds);
                if (this.m_numFinds >= this.m_maxResults) break;
                if (this.searchOn(16)) {
                    this.testSourceDocument(entry);
                }
                if (this.searchOn(1)) {
                    this.testOngoing(entry);
                }
                this.checkInterrupted();
            }
        }
        if (this.searchOn(2)) {
            String file = OStrings.getString("CT_ORPHAN_STRINGS");
            this.m_window.displayProgress("ORPHAN", 1, 2, this.m_numFinds);
            this.m_project.iterateByDefaultTranslations((source, en) -> {
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
                if (this.m_project.isOrphaned(source)) {
                    this.testInternalEntry(file, en);
                }
            });
            this.m_window.displayProgress("ORPHAN", 2, 2, this.m_numFinds);
            this.m_project.iterateByMultipleTranslations((source, en) -> {
                if (this.m_numFinds >= this.m_maxResults) {
                    return;
                }
                this.checkInterrupted();
                if (this.m_project.isOrphaned(source)) {
                    this.testInternalEntry(file, en);
                }
            });
        }
    }

    protected Iterator<SourceTextEntry> projectEntries() {
        return this.m_project.getAllEntries().iterator();
    }

    protected abstract void testOngoing(SourceTextEntry var1);

    protected boolean testSourceDocument(SourceTextEntry ste) {
        block10: {
            try {
                SourceTextEntry.SourceTranslationEntry info = (SourceTextEntry.SourceTranslationEntry)ste.getSourceTranslationInfo();
                if (this.m_author != null) {
                    String author = info.changer;
                    if (author == null) {
                        author = info.creator;
                    }
                    if (author == null) {
                        return this.m_trueMissing;
                    }
                    return this.m_author.matchesString(author);
                }
                long date = info.changeDate;
                if (date == 0L) {
                    date = info.creationDate;
                }
                if (date == 0L) {
                    if (this.m_trueMissing) {
                        return true;
                    }
                    return this.m_dateBefore == Long.MIN_VALUE && this.m_dateAfter == Long.MAX_VALUE;
                }
                if (this.m_dateBefore > Long.MIN_VALUE && date >= this.m_dateBefore) {
                    return false;
                }
                if (this.m_dateAfter < Long.MAX_VALUE && date <= this.m_dateAfter) {
                    return false;
                }
            }
            catch (Exception e) {
                if (this.m_author == null && this.m_dateAfter >= Long.MAX_VALUE && this.m_dateBefore <= Long.MIN_VALUE) break block10;
                return this.m_trueMissing;
            }
        }
        return true;
    }

    protected boolean testInternalEntry(String fileName, TMXEntry entry) {
        return this.checkFilters(entry);
    }

    public boolean checkFilters(ITMXEntry tmxEntry) {
        if (this.m_author != null && !this.searchAuthor(tmxEntry)) {
            return false;
        }
        if (this.m_translator != null && !this.searchTranslator(tmxEntry)) {
            return false;
        }
        long date = tmxEntry.getChangeDate();
        if (date == 0L) {
            date = tmxEntry.getCreationDate();
        }
        if (date == 0L) {
            if (this.m_trueMissing) {
                return true;
            }
            return this.m_dateBefore == Long.MIN_VALUE && this.m_dateAfter == Long.MAX_VALUE;
        }
        if (this.m_dateBefore > Long.MIN_VALUE && date >= this.m_dateBefore) {
            return false;
        }
        return this.m_dateAfter >= Long.MAX_VALUE || date > this.m_dateAfter;
    }

    protected boolean searchAuthor(ITMXEntry te) {
        if (this.m_author == null) {
            return true;
        }
        if (te == null) {
            return false;
        }
        String author = te.getChanger();
        if (author == null) {
            author = te.getCreator();
        }
        if (author != null && this.m_author.searchString(author) != null) {
            return true;
        }
        author = te.getPropValue("Txt::Stored by");
        if (author != null) {
            return this.m_author.searchString(author) != null;
        }
        return this.m_trueMissing;
    }

    private boolean searchTranslator(ITMXEntry te) {
        if (te == null) {
            return false;
        }
        if (this.m_translator == null) {
            return true;
        }
        String author = te.getPropValue("Txt::Translator");
        if (author != null) {
            return this.m_translator.searchString(author) != null;
        }
        return this.m_trueMissing;
    }

    public abstract TranslationStateFilter getTranslationStateFilter();

    protected abstract boolean searchOn(int var1);
}

