/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class CSC
implements ISegmentationData {
    public static final String CSC_URI = "http://culter.silvestris-lab.org/compatible";
    private static final XMLInputFactory staxInputFactory = XMLInputFactory.newInstance();
    private static final QName Q_name = new QName(null, "name");
    private static final QName Q_languagepattern = new QName(null, "languagepattern");
    private static final QName Q_languagerulename = new QName(null, "languagerulename");
    private static final QName Q_break = new QName(null, "break");
    private static final Pattern PATTERN_CSC_VARIABLE = Pattern.compile("%\\{(\\w+)\\}");
    private HashMap<String, List<ApplyRuleTemplate>> namedLists = new HashMap();
    private static final QName Q_val = new QName(null, "value");
    private boolean cascade = true;
    private List<MapRule> mappingRules = new ArrayList<MapRule>();
    private HashMap<String, Rule> templatesMap = new HashMap();

    public CSC() {
    }

    public CSC(SRX ori) {
        this.cascade = ori.isCascade();
        this.mappingRules = ori.getMappingRules();
        for (MapRule mr : this.mappingRules) {
            if (this.namedLists.get(mr.getLanguageCode()) != null) continue;
            ArrayList<ApplyRuleTemplate> newList = new ArrayList<ApplyRuleTemplate>(mr.getRules().size());
            this.namedLists.put(mr.getLanguageCode(), newList);
            for (Rule rule0 : mr.getRules()) {
                newList.add(new ApplyRuleTemplate(rule0));
            }
        }
    }

    protected static CSC loadCscxFile(URL rulesUrl) throws Exception {
        CSC data = new CSC();
        CSC base = null;
        try (InputStream io = rulesUrl.openStream();){
            XMLEventReader reader = staxInputFactory.createXMLEventReader(io);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement()) {
                    StartElement startEl = event.asStartElement();
                    switch (startEl.getName().getLocalPart()) {
                        case "seg-rules": {
                            Attribute extendsAttr = startEl.getAttributeByName(new QName(null, "extends"));
                            if (extendsAttr == null) break;
                            String val = extendsAttr.getValue();
                            if (val.toUpperCase().equals("#DEFAULT-CONFIG")) {
                                base = new CSC(ISegmentationData.getDefault());
                            } else if (val.toUpperCase().equals("#GLOBAL-CONFIG")) {
                                ISegmentationData baseData = ISegmentationData.loadFromDir(new File(StaticUtils.getConfigDir()), true);
                                if (baseData instanceof SRX) {
                                    base = new CSC((SRX)baseData);
                                }
                                if (baseData instanceof CSC) {
                                    base = (CSC)baseData;
                                }
                            } else {
                                URL baseUrl = new URL(rulesUrl, val);
                                if (val.toLowerCase().endsWith(".srx")) {
                                    base = new CSC(SRX.loadSrxFile(baseUrl));
                                }
                                if (val.toLowerCase().endsWith(".cscx")) {
                                    base = CSC.loadCscxFile(baseUrl);
                                }
                            }
                            data.templatesMap = (HashMap)base.templatesMap.clone();
                            data.namedLists = (HashMap)base.namedLists.clone();
                            break;
                        }
                        case "rules-mapping": {
                            data.readRulesMapping(reader, base, startEl);
                            break;
                        }
                        case "rule-templates": {
                            data.readRuleTemplates(reader);
                            break;
                        }
                        case "languagerules": {
                            data.readLanguageRules(reader, rulesUrl);
                        }
                    }
                }
                if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("seg-rules") || base == null || data.mappingRules.size() != 0) continue;
                data.mappingRules.addAll(base.mappingRules);
            }
            reader.close();
        }
        return data;
    }

    private void readRulesMapping(XMLEventReader reader, CSC base, StartElement startEl) throws Exception {
        Attribute extensionMode = startEl.getAttributeByName(new QName(null, "extension-mode"));
        if (extensionMode != null && "after".equals(extensionMode)) {
            this.mappingRules.addAll(base.mappingRules);
        }
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("rules-mapping")) {
                return;
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("languagemap")) continue;
            try {
                StartElement el = (StartElement)event;
                this.mappingRules.add(new MapRule(el.getAttributeByName(Q_languagerulename).getValue(), el.getAttributeByName(Q_languagepattern).getValue(), null));
            }
            catch (Exception e) {
                Log.log("Warning: wrong map rule in CSC file: " + event);
            }
        }
        if (extensionMode != null && "before".equals(extensionMode)) {
            this.mappingRules.addAll(base.mappingRules);
        }
    }

    private void readRuleTemplates(XMLEventReader reader) throws Exception {
        Rule currentRule = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("rule-templates")) {
                return;
            }
            try {
                StartElement el = (StartElement)event;
                if (el.getName().getLocalPart().equals("rule-template")) {
                    currentRule = new Rule();
                    this.templatesMap.put(el.getAttributeByName(Q_name).getValue(), currentRule);
                }
                if (el.getName().getLocalPart().equals("rule")) {
                    currentRule.setBreakRule("yes".equals(el.getAttributeByName(Q_break).getValue()));
                    this.readRule(reader, currentRule);
                }
                if (el.getName().getLocalPart().equals("break-rule")) {
                    currentRule.setBreakRule(true);
                    this.readRule(reader, currentRule);
                }
                if (!el.getName().getLocalPart().equals("exception-rule")) continue;
                currentRule.setBreakRule(false);
                this.readRule(reader, currentRule);
            }
            catch (ClassCastException el) {
            }
            catch (NullPointerException npe) {
                Log.log("Error [CSC]: something wrong (probably missing attribute) with rule template : " + event);
            }
        }
    }

    private void readRule(XMLEventReader reader, Rule currentRule) throws Exception {
        StringBuffer text = new StringBuffer();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().endsWith("rule")) {
                return;
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("beforebreak")) {
                text.setLength(0);
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("afterbreak")) {
                text.setLength(0);
            }
            if (event.isCharacters()) {
                text.append(event.asCharacters().getData());
            }
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("beforebreak")) {
                currentRule.setBeforebreak(PATTERN_CSC_VARIABLE.matcher(text.toString()).replaceAll("%<$1>"));
                text.setLength(0);
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals("afterbreak")) continue;
            currentRule.setAfterbreak(PATTERN_CSC_VARIABLE.matcher(text.toString()).replaceAll("%<$1>"));
            text.setLength(0);
        }
    }

    private void readLanguageRules(XMLEventReader reader, URL dataURL) throws Exception {
        ArrayList<ApplyRuleTemplate> currentList = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().endsWith("languagerules")) {
                return;
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("languagerule")) continue;
            currentList = new ArrayList<ApplyRuleTemplate>();
            this.readSingleLanguageRule(reader, currentList, dataURL);
            Attribute extensionMode = event.asStartElement().getAttributeByName(new QName(null, "extension-mode"));
            if (extensionMode == null || extensionMode.getValue().equals("overwrite")) {
                this.namedLists.put(event.asStartElement().getAttributeByName(Q_languagerulename).getValue(), currentList);
                continue;
            }
            if (extensionMode.getValue().equals("before")) {
                this.namedLists.get(event.asStartElement().getAttributeByName(Q_languagerulename).getValue()).addAll(0, currentList);
                continue;
            }
            if (!extensionMode.getValue().equals("after")) continue;
            this.namedLists.get(event.asStartElement().getAttributeByName(Q_languagerulename).getValue()).addAll(currentList);
        }
    }

    private void readSingleLanguageRule(XMLEventReader reader, List<ApplyRuleTemplate> currentList, URL dataURL) throws Exception {
        Rule currentRule = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().endsWith("languagerule")) {
                return;
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule("yes".equals(event.asStartElement().getAttributeByName(Q_break).getValue()));
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("break-rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule(true);
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("exception-rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule(false);
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("apply-rule-template")) continue;
            currentRule = this.templatesMap.get(event.asStartElement().getAttributeByName(Q_name).getValue());
            ApplyRuleTemplate withParams = new ApplyRuleTemplate(currentRule, new HashMap<String, List<String>>(), new ArrayList<String>());
            this.readParameters(reader, withParams.params, withParams.paramOrder, dataURL);
            currentList.add(withParams);
        }
    }

    private void readParameters(XMLEventReader reader, HashMap<String, List<String>> params, List<String> order, URL dataURL) throws Exception {
        String curName = null;
        ArrayList<String> curList = null;
        StringBuffer buf = new StringBuffer();
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().endsWith("apply-rule-template")) {
                return;
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("param")) {
                StartElement el = event.asStartElement();
                curName = el.getAttributeByName(Q_name).getValue();
                order.add(curName);
                if (el.getAttributeByName(Q_val) != null) {
                    params.put(curName, Collections.singletonList(el.getAttributeByName(Q_val).getValue()));
                } else {
                    curList = new ArrayList<String>();
                    params.put(curName, curList);
                }
            }
            if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals("item")) {
                buf.setLength(0);
            }
            if (event.isCharacters()) {
                buf.append(event.asCharacters().getData());
            }
            if (event.isEndElement() && event.asEndElement().getName().getLocalPart().equals("item")) {
                curList.add(buf.toString());
            }
            if (!event.isStartElement() || !event.asStartElement().getName().getLocalPart().equals("item-list-file")) continue;
            InputStream is = new URL(dataURL, event.asStartElement().getAttributeByName(Q_name).getValue()).openStream();
            Throwable throwable = null;
            try {
                String encoding = "UTF-8";
                Attribute attr = event.asStartElement().getAttributeByName(new QName(null, "format"));
                if (attr != null) {
                    encoding = attr.getValue();
                    encoding = encoding.substring(encoding.indexOf(58) + 1);
                }
                Pattern remove = null;
                attr = event.asStartElement().getAttributeByName(new QName(null, "remove"));
                if (attr != null) {
                    remove = Pattern.compile(attr.getValue());
                }
                Pattern comments = null;
                attr = event.asStartElement().getAttributeByName(new QName(null, "comments"));
                if (attr != null) {
                    comments = Pattern.compile(attr.getValue());
                }
                BufferedReader fileReader = new BufferedReader(new InputStreamReader(is, encoding));
                Throwable throwable2 = null;
                try {
                    String line = "";
                    while ((line = fileReader.readLine()) != null) {
                        if (comments != null && comments.matcher(line).matches()) continue;
                        line = remove.matcher(line).replaceAll("");
                        curList.add(line);
                    }
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fileReader == null) continue;
                    if (throwable2 != null) {
                        try {
                            fileReader.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    fileReader.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    @Override
    public List<Rule> lookupRulesForLanguage(Language srclang) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < this.mappingRules.size(); ++i) {
            MapRule maprule = this.mappingRules.get(i);
            if (!maprule.getCompiledPattern().matcher(srclang.getLanguageCode()).matches()) continue;
            for (ApplyRuleTemplate tpl : this.namedLists.get(maprule.getLanguageCode())) {
                if (tpl.params == null) {
                    rules.add(tpl.rule);
                    continue;
                }
                String before = tpl.rule.getBeforebreak();
                String after = tpl.rule.getAfterbreak();
                for (String paramName : tpl.paramOrder) {
                    before = before.replace("%<" + paramName + ">", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)tpl.params.get(paramName)));
                    after = after.replace("%<" + paramName + ">", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)tpl.params.get(paramName)));
                }
                rules.add(new Rule(tpl.rule.isBreakRule(), before, after));
            }
            if (!this.cascade) break;
        }
        return rules;
    }

    @Override
    public SRX toSRX() {
        SRX res = new SRX();
        res.setCascade(this.cascade);
        ArrayList<MapRule> newRules = new ArrayList<MapRule>(this.mappingRules.size());
        for (MapRule mapRule0 : this.mappingRules) {
            ArrayList<Rule> srxRules = new ArrayList<Rule>();
            for (ApplyRuleTemplate tpl : this.namedLists.get(mapRule0.getLanguageCode())) {
                if (tpl.params == null) {
                    srxRules.add(tpl.rule);
                    continue;
                }
                CSC.toSrxRules(tpl.rule.getBeforebreak(), tpl.rule.getAfterbreak(), tpl, 0, srxRules);
            }
            newRules.add(new MapRule(mapRule0.getLanguageCode(), mapRule0.getPattern(), srxRules));
        }
        res.setMappingRules(newRules);
        return res;
    }

    private static void toSrxRules(String before, String after, ApplyRuleTemplate tpl, int paramId, List<Rule> srxRules) {
        if (paramId >= tpl.paramOrder.size()) {
            srxRules.add(new Rule(tpl.rule.isBreakRule(), before, after));
        } else {
            String paramName = tpl.paramOrder.get(paramId);
            for (String paramVal : tpl.params.get(paramName)) {
                CSC.toSrxRules(before.replace("%<" + paramName + ">", paramVal), after.replace("%<" + paramName + ">", paramVal), tpl, paramId + 1, srxRules);
            }
        }
    }

    private static class ApplyRuleTemplate {
        Rule rule;
        HashMap<String, List<String>> params;
        List<String> paramOrder;

        ApplyRuleTemplate(Rule rule) {
            this.rule = rule;
            this.params = null;
            this.paramOrder = null;
        }

        ApplyRuleTemplate(Rule rule, HashMap<String, List<String>> params, List<String> order) {
            this.rule = rule;
            this.params = params;
            this.paramOrder = order;
        }
    }
}

