/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.LsRemoteCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.errors.NoRemoteRepositoryException;
import org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.omegat.core.Core;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.gui.dialogs.TeamUserPassDialog;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class GITRemoteRepository
implements IRemoteRepository {
    private static final Logger LOGGER = Logger.getLogger(GITRemoteRepository.class.getName());
    protected static String LOCAL_BRANCH = "master";
    protected static String REMOTE_BRANCH = "origin/master";
    protected static String REMOTE = "origin";
    boolean readOnly;
    File localDirectory;
    protected Repository repository;
    private MyCredentialsProvider myCredentialsProvider;
    static ProgressMonitor gitProgress = new ProgressMonitor(){

        public void update(int completed) {
            System.out.println("update: " + completed);
        }

        public void start(int totalTasks) {
            System.out.println("start: " + totalTasks);
        }

        public boolean isCancelled() {
            return false;
        }

        public void endTask() {
            System.out.println("endTask");
        }

        public void beginTask(String title, int totalWork) {
            System.out.println("beginTask: " + title + " total: " + totalWork);
        }
    };

    public static boolean isGITDirectory(File localDirectory) {
        return GITRemoteRepository.getLocalRepositoryRoot(localDirectory) != null;
    }

    @Override
    public boolean isFilesLockingAllowed() {
        return true;
    }

    public GITRemoteRepository(File localDirectory) throws Exception {
        try {
            localDirectory = localDirectory.getCanonicalFile();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.localDirectory = localDirectory;
        CredentialsProvider prevProvider = CredentialsProvider.getDefault();
        this.myCredentialsProvider = new MyCredentialsProvider(this);
        if (prevProvider instanceof MyCredentialsProvider) {
            this.myCredentialsProvider.setCredentials(((MyCredentialsProvider)prevProvider).credentials);
        }
        CredentialsProvider.setDefault((CredentialsProvider)this.myCredentialsProvider);
        File localRepositoryDirectory = GITRemoteRepository.getLocalRepositoryRoot(localDirectory);
        if (localRepositoryDirectory != null) {
            this.repository = Git.open((File)localRepositoryDirectory).getRepository();
        }
    }

    @Override
    public void checkoutFullProject(String repositoryURL) throws Exception {
        Log.logInfoRB("GIT_START", "clone");
        CloneCommand c = Git.cloneRepository();
        c.setURI(repositoryURL);
        c.setDirectory(this.localDirectory);
        try {
            c.call();
        }
        catch (InvalidRemoteException e) {
            FileUtil.deleteTree(this.localDirectory);
            Throwable cause = e.getCause();
            if (cause != null && cause instanceof NoRemoteRepositoryException) {
                IRemoteRepository.BadRepositoryException bre = new IRemoteRepository.BadRepositoryException(((NoRemoteRepositoryException)cause).getLocalizedMessage());
                bre.initCause(e);
                throw bre;
            }
            throw e;
        }
        this.repository = Git.open((File)this.localDirectory).getRepository();
        new Git(this.repository).submoduleInit().call();
        new Git(this.repository).submoduleUpdate().call();
        StoredConfig config = this.repository.getConfig();
        if ("\r\n".equals(FileUtil.LINE_SEPARATOR)) {
            config.setBoolean("core", null, "autocrlf", true);
        } else {
            config.setString("core", null, "autocrlf", "input");
        }
        config.save();
        this.myCredentialsProvider.saveCredentials();
        Log.logInfoRB("GIT_FINISH", "clone");
    }

    @Override
    public boolean isChanged(File file) throws Exception {
        Log.logInfoRB("GIT_START", "status");
        String relativeFile = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
        Status status = new Git(this.repository).status().call();
        Log.logInfoRB("GIT_FINISH", "status");
        boolean result = status.getModified().contains(relativeFile);
        Log.logDebug(LOGGER, "GIT modified status of {0} is {1}", relativeFile, result);
        return result;
    }

    @Override
    public boolean isUnderVersionControl(File file) throws Exception {
        boolean result = file.exists();
        String relativeFile = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
        Status status = new Git(this.repository).status().call();
        if (status.getAdded().contains(relativeFile) || status.getModified().contains(relativeFile) || status.getChanged().contains(relativeFile) || status.getConflicting().contains(relativeFile) || status.getMissing().contains(relativeFile) || status.getRemoved().contains(relativeFile)) {
            result = true;
        }
        if (status.getUntracked().contains(relativeFile)) {
            result = false;
        }
        Log.logDebug(LOGGER, "GIT file {0} is under version control: {1}", relativeFile, result);
        return result;
    }

    @Override
    public void setCredentials(IRemoteRepository.Credentials credentials) {
        if (credentials == null) {
            return;
        }
        this.myCredentialsProvider.setCredentials(credentials);
        this.setReadOnly(credentials.readOnly);
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Override
    public String getBaseRevisionId(File file) throws Exception {
        RevWalk walk = new RevWalk(this.repository);
        Ref localBranch = this.repository.getRef("HEAD");
        Ref remoteBranch = this.repository.getRef(REMOTE_BRANCH);
        RevCommit headCommit = walk.lookupCommit((AnyObjectId)localBranch.getObjectId());
        RevCommit upstreamCommit = walk.lookupCommit((AnyObjectId)remoteBranch.getObjectId());
        Log.logDebug(LOGGER, "GIT HEAD rev: {0}", headCommit.getName());
        Log.logDebug(LOGGER, "GIT origin/master rev: {0}", upstreamCommit.getName());
        LogCommand cmd = new Git(this.repository).log().addRange((AnyObjectId)upstreamCommit, (AnyObjectId)headCommit);
        Iterable commitsToUse = cmd.call();
        RevCommit last = null;
        Iterator iterator = commitsToUse.iterator();
        while (iterator.hasNext()) {
            RevCommit commit;
            last = commit = (RevCommit)iterator.next();
        }
        RevCommit commonBase = last != null ? last.getParent(0) : upstreamCommit;
        Log.logDebug(LOGGER, "GIT commonBase rev: {0}", commonBase.getName());
        return commonBase.getName();
    }

    @Override
    public void restoreBase(File[] files) throws Exception {
        String baseRevisionId = this.getBaseRevisionId(files[0]);
        Log.logDebug(LOGGER, "GIT restore base {0} for {1}", baseRevisionId, files);
        CheckoutCommand checkoutCommand = new Git(this.repository).checkout();
        for (File f : files) {
            String relativeFileName = FileUtil.computeRelativePath(this.repository.getWorkTree(), f);
            checkoutCommand.addPath(relativeFileName);
        }
        checkoutCommand.call();
        new Git(this.repository).checkout().setName(baseRevisionId).call();
    }

    @Override
    public void reset() throws Exception {
        Log.logInfoRB("GIT_START", "reset");
        try {
            new Git(this.repository).reset().setMode(ResetCommand.ResetType.HARD).call();
            Log.logInfoRB("GIT_FINISH", "reset");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "reset", ex.getMessage());
            this.checkAndThrowException(ex);
        }
    }

    @Override
    public void updateFullProject() throws IRemoteRepository.NetworkException, Exception {
        Log.logInfoRB("GIT_START", "pull");
        try {
            new Git(this.repository).fetch().call();
            new Git(this.repository).checkout().setName(REMOTE_BRANCH).call();
            new Git(this.repository).branchDelete().setBranchNames(new String[]{LOCAL_BRANCH}).setForce(true).call();
            new Git(this.repository).checkout().setStartPoint(REMOTE_BRANCH).setCreateBranch(true).setName(LOCAL_BRANCH).setForce(true).call();
            new Git(this.repository).submoduleUpdate().call();
            Log.logInfoRB("GIT_FINISH", "pull");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "pull", ex.getMessage());
            this.checkAndThrowException(ex);
        }
    }

    @Override
    public void download(File[] files) throws IRemoteRepository.NetworkException, Exception {
        Log.logInfoRB("GIT_START", "download");
        try {
            new Git(this.repository).fetch().call();
            new Git(this.repository).checkout().setName(REMOTE_BRANCH).call();
            new Git(this.repository).branchDelete().setBranchNames(new String[]{LOCAL_BRANCH}).setForce(true).call();
            new Git(this.repository).checkout().setStartPoint(REMOTE_BRANCH).setCreateBranch(true).setName(LOCAL_BRANCH).setForce(true).call();
            Log.logInfoRB("GIT_FINISH", "download");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "download", ex.getMessage());
            this.checkAndThrowException(ex);
        }
    }

    @Override
    public void upload(File file, String commitMessage) throws IRemoteRepository.NetworkException, Exception {
        if (this.readOnly) {
            Log.logInfoRB("GIT_READONLY", new Object[0]);
            return;
        }
        boolean ok = true;
        Log.logInfoRB("GIT_START", "upload");
        try {
            String filePattern = FileUtil.computeRelativePath(this.repository.getWorkTree(), file);
            new Git(this.repository).add().addFilepattern(filePattern).call();
            new Git(this.repository).commit().setMessage(commitMessage).call();
            Iterable results = new Git(this.repository).push().setRemote(REMOTE).add(LOCAL_BRANCH).call();
            int count = 0;
            for (PushResult r : results) {
                for (RemoteRefUpdate update : r.getRemoteUpdates()) {
                    ++count;
                    if (update.getStatus() == RemoteRefUpdate.Status.OK) continue;
                    ok = false;
                }
            }
            if (count < 1) {
                ok = false;
            }
            Log.logInfoRB("GIT_FINISH", "upload");
        }
        catch (Exception ex) {
            Log.logErrorRB("GIT_ERROR", "upload", ex.getMessage());
            this.checkAndThrowException(ex);
        }
        if (!ok) {
            Log.logWarningRB("GIT_CONFLICT", new Object[0]);
        }
    }

    private void checkAndThrowException(Exception ex) throws IRemoteRepository.NetworkException, Exception {
        if (ex instanceof TransportException) {
            throw new IRemoteRepository.NetworkException(ex);
        }
        throw ex;
    }

    private static File getLocalRepositoryRoot(File path) {
        if (path == null) {
            return null;
        }
        File possibleControlDir = new File(path, ".git");
        if (possibleControlDir.exists() && possibleControlDir.isDirectory()) {
            return path;
        }
        return GITRemoteRepository.getLocalRepositoryRoot(path.getAbsoluteFile().getParentFile());
    }

    private static String extractFingerprint(String text) {
        Pattern p = Pattern.compile("The authenticity of host '.*' can't be established\\.\\nRSA key fingerprint is (([0-9a-f]{2}:){15}[0-9a-f]{2})\\.\\nAre you sure you want to continue connecting\\?");
        Matcher fingerprintMatcher = p.matcher(text);
        if (fingerprintMatcher.find()) {
            int start = fingerprintMatcher.start(1);
            int end = fingerprintMatcher.end(1);
            return text.substring(start, end);
        }
        return null;
    }

    public static boolean isGitRepository(String url, IRemoteRepository.Credentials credentials) throws IRemoteRepository.AuthenticationException {
        if (url.startsWith("svn://") || url.startsWith("svn+")) {
            return false;
        }
        try {
            Collection result;
            if (credentials != null) {
                MyCredentialsProvider provider = new MyCredentialsProvider(null);
                provider.setCredentials(credentials);
                CredentialsProvider.setDefault((CredentialsProvider)provider);
            }
            return !(result = new LsRemoteCommand(null).setRemote(url).call()).isEmpty();
        }
        catch (TransportException ex) {
            String message = ex.getMessage();
            if (message.endsWith("not authorized") || message.endsWith("Auth fail") || message.contains("Too many authentication failures") || message.contains("Authentication is required")) {
                throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
            }
            return false;
        }
        catch (GitAPIException ex) {
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (JGitInternalException ex) {
            return false;
        }
    }

    public static String guessRepoName(String url) {
        url = StringUtil.stripFromEnd(url, "/", ".git");
        return url.substring(url.lastIndexOf(47) + 1);
    }

    private static class MyCredentialsProvider
    extends CredentialsProvider {
        GITRemoteRepository gitRemoteRepository;
        File credentialsFile;
        private IRemoteRepository.Credentials credentials;

        public MyCredentialsProvider(GITRemoteRepository repo) {
            this.gitRemoteRepository = repo;
            if (repo != null) {
                this.credentialsFile = new File(this.gitRemoteRepository.localDirectory, "credentials.properties");
            }
        }

        public void setCredentials(IRemoteRepository.Credentials credentials) {
            if (credentials == null) {
                return;
            }
            this.credentials = credentials.clone();
        }

        private void loadCredentials() {
            if (this.credentialsFile == null || !this.credentialsFile.exists()) {
                this.credentials = new IRemoteRepository.Credentials();
                return;
            }
            try {
                this.credentials = IRemoteRepository.Credentials.fromFile(this.credentialsFile);
            }
            catch (FileNotFoundException ex) {
                this.credentials = new IRemoteRepository.Credentials();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }

        private void saveCredentials() {
            if (this.credentials == null || this.credentialsFile == null || !this.credentials.saveAsPlainText) {
                return;
            }
            try {
                this.credentials.saveToPlainTextFile(this.credentialsFile);
            }
            catch (FileNotFoundException e) {
                Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
            }
            catch (IOException e) {
                Core.getMainWindow().displayErrorRB(e, "TEAM_ERROR_SAVE_CREDENTIALS", null, "TF_ERROR");
            }
        }

        public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
            if (this.credentials == null) {
                this.loadCredentials();
            }
            boolean ok = false;
            for (CredentialItem i : items) {
                if (i instanceof CredentialItem.Username) {
                    if (this.credentials.username == null && !(ok = this.askCredentials(uri.getUser()))) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    ((CredentialItem.Username)i).setValue(this.credentials.username);
                    continue;
                }
                if (i instanceof CredentialItem.Password) {
                    if (this.credentials.password == null && !(ok = this.askCredentials(uri.getUser()))) {
                        throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                    }
                    ((CredentialItem.Password)i).setValue(this.credentials.password);
                    if (this.credentials.password == null) continue;
                    uri.setPass(new String(this.credentials.password));
                    continue;
                }
                if (i instanceof CredentialItem.StringType) {
                    if (i.getPromptText().equals("Password: ")) {
                        if (this.credentials.password == null && !ok && !(ok = this.askCredentials(uri.getUser()))) {
                            throw new UnsupportedCredentialItem(uri, OStrings.getString("TEAM_CREDENTIALS_DENIED"));
                        }
                        ((CredentialItem.StringType)i).setValue(new String(this.credentials.password));
                        continue;
                    }
                } else {
                    if (i instanceof CredentialItem.YesNoType) {
                        String promptText = i.getPromptText();
                        String promptedFingerprint = GITRemoteRepository.extractFingerprint(promptText);
                        if (promptedFingerprint.equals(this.credentials.fingerprint)) {
                            ((CredentialItem.YesNoType)i).setValue(true);
                            continue;
                        }
                        int choice = Core.getMainWindow().showConfirmDialog(promptText, null, 0, 2);
                        if (choice == 0) {
                            ((CredentialItem.YesNoType)i).setValue(true);
                            if (promptedFingerprint != null) {
                                this.credentials.fingerprint = promptedFingerprint;
                            }
                            this.saveCredentials();
                            continue;
                        }
                        ((CredentialItem.YesNoType)i).setValue(false);
                        continue;
                    }
                    if (i instanceof CredentialItem.InformationalMessage) {
                        Core.getMainWindow().showMessageDialog(i.getPromptText());
                        continue;
                    }
                }
                throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
            }
            return true;
        }

        public boolean isInteractive() {
            return true;
        }

        public boolean supports(CredentialItem ... items) {
            for (CredentialItem i : items) {
                if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
                return false;
            }
            return true;
        }

        private boolean askCredentials(String usernameInUri) {
            TeamUserPassDialog userPassDialog = new TeamUserPassDialog(Core.getMainWindow().getApplicationFrame());
            userPassDialog.descriptionTextArea.setText(OStrings.getString(this.credentials.username == null ? "TEAM_USERPASS_FIRST" : "TEAM_USERPASS_WRONG"));
            if (!StringUtil.isEmpty(usernameInUri)) {
                userPassDialog.setFixedUsername(usernameInUri);
            }
            userPassDialog.setVisible(true);
            if (userPassDialog.getReturnStatus() == 1) {
                this.credentials.username = userPassDialog.userText.getText();
                this.credentials.password = userPassDialog.getPasswordCopy();
                this.credentials.readOnly = userPassDialog.cbReadOnly.isSelected();
                if (this.gitRemoteRepository != null) {
                    this.gitRemoteRepository.setReadOnly(this.credentials.readOnly);
                }
                this.credentials.saveAsPlainText = userPassDialog.cbForceSavePlainPassword.isSelected();
                this.saveCredentials();
                return true;
            }
            return false;
        }

        public void reset(URIish uri) {
            this.credentials.clear();
        }
    }
}

