/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import gen.core.filters.Files;
import gen.core.filters.Filter;
import gen.core.filters.Filters;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.FileUtils;
import org.omegat.core.Core;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.IAlignCallback;
import org.omegat.filters2.IFilter;
import org.omegat.filters2.IParseCallback;
import org.omegat.filters2.ITranslateCallback;
import org.omegat.filters2.Instance;
import org.omegat.filters2.TranslationException;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;

public class FilterMaster {
    private static final String FILE_FILTERS = "filters.xml";
    public static String INITIAL_VERSION = "";
    public static String OT160RC12a_VERSION = "1.6 RC12a";
    public static String OT160FINAL_VERSION = "1.6.0";
    public static String OT161_VERSION = "1.6.1";
    public static String OT170_VERSION = "1.7.0";
    public static String CURRENT_VERSION = "2.0";
    private final Filters config;
    private static List<Class<?>> filtersClasses;
    private static List<String> supportedEncodings;
    private static final XMLInputFactory staxInputFactory;
    private static final XMLOutputFactory staxOutputFactory;

    public FilterMaster(Filters config) {
        this.config = config;
    }

    public Filters getConfig() {
        return this.config;
    }

    private static boolean addNewFiltersToConfig(Filters conf) {
        boolean result = false;
        for (Class<?> fclass : filtersClasses) {
            boolean found = false;
            for (Filter fc : conf.getFilters()) {
                if (!fclass.getName().equals(fc.getClassName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            conf.getFilters().add(FilterMaster.getDefaultSettingsFromFilter(fclass.getName()));
            result = true;
        }
        return result;
    }

    public static IFilter getFilterInstance(String classname) {
        for (Class<?> f : filtersClasses) {
            if (!f.getName().equals(classname)) continue;
            try {
                return (IFilter)f.newInstance();
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
        return null;
    }

    public IFilter loadFile(String filename, FilterContext fc, IParseCallback parseCallback) throws IOException, TranslationException {
        IFilter filterObject = null;
        try {
            LookupInformation lookup = this.lookupFilter(new File(filename), fc);
            if (lookup == null) {
                return null;
            }
            File inFile = new File(filename);
            fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
            fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
            filterObject = lookup.filterObject;
            filterObject.parseFile(inFile, lookup.config, fc, parseCallback);
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
            throw new IOException(filename + "\n" + ioe);
        }
        return filterObject;
    }

    public void translateFile(String sourcedir, String filename, String targetdir, FilterContext fc, ITranslateCallback translateCallback) throws IOException, TranslationException {
        File outFile;
        LookupInformation lookup = this.lookupFilter(new File(sourcedir, filename), fc);
        if (lookup == null) {
            FileUtils.copyFile((File)new File(sourcedir, filename), (File)new File(targetdir, filename));
            return;
        }
        File inFile = new File(sourcedir, filename).getCanonicalFile();
        if (inFile.equals(outFile = new File(targetdir, FilterMaster.getTargetForSource(filename, lookup, fc.getTargetLang())).getCanonicalFile())) {
            throw new TranslationException(StringUtil.format(OStrings.getString("FILTERMASTER_ERROR_SRC_TRG_SAME_FILE"), inFile.getPath()));
        }
        fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
        fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
        IFilter filterObject = lookup.filterObject;
        try {
            filterObject.translateFile(inFile, outFile, lookup.config, fc, translateCallback);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    public void alignFile(String sourceDir, String fileName, String targetdir, FilterContext fc, IAlignCallback alignCallback) throws Exception {
        LookupInformation lookup = this.lookupFilter(new File(sourceDir, fileName), fc);
        if (lookup == null) {
            return;
        }
        File inFile = new File(sourceDir, fileName);
        File outFile = new File(targetdir, FilterMaster.getTargetForSource(fileName, lookup, fc.getTargetLang()));
        if (!outFile.exists()) {
            return;
        }
        fc.setInEncoding(lookup.outFilesInfo.getSourceEncoding());
        fc.setOutEncoding(lookup.outFilesInfo.getTargetEncoding());
        IFilter filterObject = lookup.filterObject;
        try {
            filterObject.alignFile(inFile, outFile, lookup.config, fc, alignCallback);
        }
        catch (Exception ex) {
            Log.log(ex);
        }
    }

    private LookupInformation lookupFilter(File inFile, FilterContext fc) throws TranslationException, IOException {
        block0: for (Filter f : this.config.getFilters()) {
            if (!f.isEnabled()) continue;
            for (Files ff : f.getFiles()) {
                IFilter filterObject;
                if (!this.matchesMask(inFile.getName(), ff.getSourceFilenameMask()) || (filterObject = FilterMaster.getFilterInstance(f.getClassName())) == null) continue;
                fc.setInEncoding(ff.getSourceEncoding());
                fc.setOutEncoding(ff.getTargetEncoding());
                Map<String, String> config = FilterMaster.forFilter(f.getOption());
                if (!filterObject.isFileSupported(inFile, config, fc)) continue block0;
                return new LookupInformation(filterObject, ff, config);
            }
        }
        return null;
    }

    public static List<String> getSupportedEncodings() {
        if (supportedEncodings == null) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(AbstractFilter.ENCODING_AUTO_HUMAN);
            list.addAll(Charset.availableCharsets().keySet());
            supportedEncodings = list;
        }
        return supportedEncodings;
    }

    public static Filters createDefaultFiltersConfig() {
        Filters c = new Filters();
        FilterMaster.addNewFiltersToConfig(c);
        return c;
    }

    public static Filters loadConfig(String configDir) {
        Filters result;
        File configFile = new File(configDir, FILE_FILTERS);
        if (!configFile.exists()) {
            return null;
        }
        try {
            result = new Filters();
            try (FileInputStream io = new FileInputStream(configFile);){
                XMLStreamReader reader = staxInputFactory.createXMLStreamReader(io);
                while (reader.hasNext()) {
                    if (reader.next() != 1) continue;
                    if (reader.getName().getLocalPart().equals("filters")) {
                        if (reader.getAttributeValue(null, "removeTags") != null) {
                            result.setRemoveTags("true".equals(reader.getAttributeValue(null, "removeTags")));
                        }
                        if (reader.getAttributeValue(null, "removeSpacesNonseg") != null) {
                            result.setRemoveSpacesNonseg("true".equals(reader.getAttributeValue(null, "removeSpacesNonseg")));
                        }
                        if (reader.getAttributeValue(null, "preserveSpaces") != null) {
                            result.setPreserveSpaces("true".equals(reader.getAttributeValue(null, "preserveSpaces")));
                        }
                        if (reader.getAttributeValue(null, "ignoreFileContext") == null) continue;
                        result.setIgnoreFileContext("true".equals(reader.getAttributeValue(null, "ignoreFileContext")));
                        continue;
                    }
                    if (!reader.getName().getLocalPart().equals("filter")) continue;
                    Filter filter0 = FilterMaster.readSingleFilter(reader);
                    try {
                        Class.forName(filter0.getClassName());
                        result.getFilters().add(filter0);
                    }
                    catch (ClassNotFoundException classNotFoundException) {}
                }
            }
        }
        catch (Exception e) {
            Log.logErrorRB("FILTERMASTER_ERROR_LOADING_FILTERS_CONFIG", new Object[0]);
            Log.log(e);
            result = new Filters();
        }
        if (FilterMaster.addNewFiltersToConfig(result)) {
            FilterMaster.saveConfig(result, configDir);
        }
        return result;
    }

    private static Filter readSingleFilter(XMLStreamReader reader) throws XMLStreamException {
        Filter result = new Filter();
        result.setClassName(reader.getAttributeValue(null, "className"));
        if (reader.getAttributeValue(null, "enabled") != null) {
            result.setEnabled("true".equals(reader.getAttributeValue(null, "enabled")));
        }
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().equals("filter")) {
                return result;
            }
            if (next != 1) continue;
            if (reader.getName().getLocalPart().equals("files")) {
                Files f = new Files();
                if (reader.getAttributeValue(null, "sourceFilenameMask") != null) {
                    f.setSourceFilenameMask(reader.getAttributeValue(null, "sourceFilenameMask"));
                }
                if (reader.getAttributeValue(null, "targetFilenamePattern") != null) {
                    f.setTargetFilenamePattern(reader.getAttributeValue(null, "targetFilenamePattern"));
                }
                if (reader.getAttributeValue(null, "sourceEncoding") != null) {
                    f.setSourceEncoding(reader.getAttributeValue(null, "sourceEncoding"));
                }
                if (reader.getAttributeValue(null, "targetEncoding") != null) {
                    f.setTargetEncoding(reader.getAttributeValue(null, "targetEncoding"));
                }
                result.getFiles().add(f);
                continue;
            }
            if (!reader.getName().getLocalPart().equals("option")) continue;
            Filter.Option opt = new Filter.Option();
            if (reader.getAttributeValue(null, "name") != null) {
                opt.setName(reader.getAttributeValue(null, "name"));
            }
            if (reader.getAttributeValue(null, "value") != null) {
                opt.setValue(reader.getAttributeValue(null, "value"));
            }
            result.getOption().add(opt);
        }
        return result;
    }

    public static void saveConfig(Filters config, String configDir) {
        File configFile = new File(configDir, FILE_FILTERS);
        if (config == null) {
            configFile.delete();
            return;
        }
        try (OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(configFile), "UTF-8");){
            XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(fos);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeCharacters("\n");
            writer.writeStartElement("filters");
            writer.writeAttribute("removeTags", Boolean.toString(config.isRemoveTags()));
            writer.writeAttribute("removeSpacesNonseg", Boolean.toString(config.isRemoveSpacesNonseg()));
            writer.writeAttribute("preserveSpaces", Boolean.toString(config.isPreserveSpaces()));
            writer.writeAttribute("ignoreFileContext", Boolean.toString(config.isIgnoreFileContext()));
            for (Filter filter0 : config.getFilters()) {
                writer.writeCharacters("\n    ");
                writer.writeStartElement("filter");
                writer.writeAttribute("className", filter0.getClassName());
                writer.writeAttribute("enabled", Boolean.toString(filter0.isEnabled()));
                for (Files file0 : filter0.getFiles()) {
                    writer.writeCharacters("\n        ");
                    writer.writeEmptyElement("files");
                    writer.writeAttribute("sourceFilenameMask", file0.getSourceFilenameMask());
                    writer.writeAttribute("targetFilenamePattern", file0.getTargetFilenamePattern());
                    if (file0.getSourceEncoding() != null) {
                        writer.writeAttribute("sourceEncoding", file0.getSourceEncoding());
                    }
                    if (file0.getTargetEncoding() == null) continue;
                    writer.writeAttribute("targetEncoding", file0.getTargetEncoding());
                }
                for (Filter.Option opt0 : filter0.getOption()) {
                    writer.writeCharacters("\n        ");
                    writer.writeEmptyElement("option");
                    writer.writeAttribute("name", opt0.getName());
                    writer.writeAttribute("value", opt0.getValue());
                }
                writer.writeCharacters("\n    ");
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.close();
        }
        catch (Exception e) {
            Log.logErrorRB("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG", new Object[0]);
            Log.log(e);
            JOptionPane.showMessageDialog(Core.getMainWindow().getApplicationFrame(), OStrings.getString("FILTERMASTER_ERROR_SAVING_FILTERS_CONFIG") + "\n" + e, OStrings.getString("ERROR_TITLE"), 0);
        }
    }

    private boolean matchesMask(String filename, String mask) {
        mask = mask.replaceAll("\\.", "\\\\.");
        mask = mask.replaceAll("\\*", ".*");
        mask = mask.replaceAll("\\?", ".");
        return filename.matches("(?iu)" + mask);
    }

    public static String now(String dateFormat) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        return sdf.format(cal.getTime());
    }

    public String getTargetForSource(String sourceDir, String srcRelPath, FilterContext fc) throws IOException, TranslationException {
        File srcFile = new File(sourceDir, srcRelPath);
        if (!srcFile.isFile()) {
            throw new IllegalArgumentException("The sourceDir and srcRelPath arguments must together point to an existing file.");
        }
        LookupInformation lookup = this.lookupFilter(srcFile, fc);
        return FilterMaster.getTargetForSource(srcRelPath, lookup, fc.getTargetLang());
    }

    private static String getTargetForSource(String srcRelPath, LookupInformation lookup, Language targetLang) {
        File srcRelFile = new File(srcRelPath);
        return new File(srcRelFile.getParent(), FilterMaster.constructTargetFilename(lookup.outFilesInfo.getSourceFilenameMask(), srcRelFile.getName(), lookup.outFilesInfo.getTargetFilenamePattern(), targetLang, lookup.outFilesInfo.getSourceEncoding(), lookup.outFilesInfo.getTargetEncoding(), lookup.filterObject.getFileFormatName())).getPath();
    }

    private static String constructTargetFilename(String sourceMask, String filename, String pattern, Language targetLang, String sourceEncoding, String targetEncoding, String filterFormatName) {
        int lastStarPos = sourceMask.lastIndexOf(42);
        int dot = 0;
        if (lastStarPos >= 0) {
            int lastDotPos = sourceMask.indexOf(46, lastStarPos);
            int extlength = sourceMask.length() - lastDotPos;
            dot = filename.length() - extlength;
        } else {
            dot = filename.lastIndexOf(46);
        }
        String nameOnly = filename;
        String extension = "";
        if (dot >= 0) {
            nameOnly = filename.substring(0, dot);
            extension = filename.substring(dot + 1);
        }
        String res = pattern;
        res = res.replace("${filename}", filename);
        res = res.replace("${nameOnly}", nameOnly);
        res = res.replace("${extension}", extension);
        res = res.replace("${targetLocale}", targetLang.getLocaleCode());
        res = res.replace("${targetLanguage}", targetLang.getLanguage());
        res = res.replace("${targetLanguageCode}", targetLang.getLanguageCode());
        res = res.replace("${targetCountryCode}", targetLang.getCountryCode());
        res = res.replace("${targetCoutryCode}", targetLang.getCountryCode());
        res = res.replace("${targetLocaleLCID}", targetLang.getLocaleLCID());
        res = res.replace("${timestamp-a}", FilterMaster.now("a"));
        res = res.replace("${timestamp-d}", FilterMaster.now("d"));
        res = res.replace("${timestamp-dd}", FilterMaster.now("dd"));
        res = res.replace("${timestamp-h}", FilterMaster.now("h"));
        res = res.replace("${timestamp-hh}", FilterMaster.now("hh"));
        res = res.replace("${timestamp-m}", FilterMaster.now("m"));
        res = res.replace("${timestamp-mm}", FilterMaster.now("mm"));
        res = res.replace("${timestamp-s}", FilterMaster.now("s"));
        res = res.replace("${timestamp-ss}", FilterMaster.now("ss"));
        res = res.replace("${timestamp-yyyy}", FilterMaster.now("yyyy"));
        res = res.replace("${timestamp-D}", FilterMaster.now("D"));
        res = res.replace("${timestamp-EEE}", FilterMaster.now("EEE"));
        res = res.replace("${timestamp-EEEE}", FilterMaster.now("EEEE"));
        res = res.replace("${timestamp-H}", FilterMaster.now("H"));
        res = res.replace("${timestamp-HH}", FilterMaster.now("HH"));
        res = res.replace("${timestamp-M}", FilterMaster.now("M"));
        res = res.replace("${timestamp-MM}", FilterMaster.now("MM"));
        res = res.replace("${timestamp-MMM}", FilterMaster.now("MMM"));
        res = res.replace("${system-os-name}", System.getProperty("os.name"));
        res = res.replace("${system-os-version}", System.getProperty("os.arch"));
        res = res.replace("${system-os-arch}", System.getProperty("os.version"));
        res = res.replace("${system-user-name}", System.getProperty("user.name"));
        String hostName = null;
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            hostName = "";
        }
        res = res.replace("${system-host-name}", hostName);
        String sourceEncodingText = "auto";
        if (sourceEncoding != null) {
            sourceEncodingText = sourceEncoding;
        }
        res = res.replace("${file-source-encoding}", sourceEncodingText);
        String targetEncodingText = "auto";
        if (targetEncoding != null) {
            targetEncodingText = targetEncoding;
        }
        res = res.replace("${file-target-encoding}", targetEncodingText);
        res = res.replace("${file-filter-name}", filterFormatName);
        String sourceMaskPattern = sourceMask.replaceAll("\\?", "(.)").replaceAll("\\*", "(.*?)");
        Matcher sourceMatcher = Pattern.compile(sourceMaskPattern).matcher(filename);
        if (sourceMatcher.find()) {
            for (int i = 1; i <= sourceMatcher.groupCount(); ++i) {
                res = res.replaceAll("\\$\\{" + i + "\\}", sourceMatcher.group(i));
            }
        }
        String[] splitName = filename.split("\\.");
        StringBuilder nameOnlyBuf = new StringBuilder(splitName[0]);
        StringBuilder extensionBuf = new StringBuilder(splitName[splitName.length - 1]);
        for (int i = 0; i < splitName.length; ++i) {
            res = res.replaceAll("\\$\\{nameOnly-" + i + "\\}", nameOnlyBuf.toString());
            res = res.replaceAll("\\$\\{extension-" + i + "\\}", extensionBuf.toString());
            if (i + 1 >= splitName.length) continue;
            nameOnlyBuf.append(".").append(splitName[i + 1]);
            extensionBuf.insert(0, splitName[splitName.length - i - 2] + '.');
        }
        return res;
    }

    public static Filters cloneConfig(Filters orig) {
        Filters c = new Filters();
        c.setRemoveTags(orig.isRemoveTags());
        c.setRemoveSpacesNonseg(orig.isRemoveSpacesNonseg());
        c.setPreserveSpaces(orig.isPreserveSpaces());
        c.setIgnoreFileContext(orig.isIgnoreFileContext());
        for (Filter f : orig.getFilters()) {
            c.getFilters().add(FilterMaster.cloneFilter(f));
        }
        return c;
    }

    public static Filter cloneFilter(Filter filter) {
        Filter f = new Filter();
        f.setClassName(filter.getClassName());
        f.setEnabled(filter.isEnabled());
        for (Files ff : filter.getFiles()) {
            f.getFiles().add(FilterMaster.cloneFiles(ff));
        }
        for (Filter.Option o : filter.getOption()) {
            Filter.Option fo = new Filter.Option();
            fo.setName(o.getName());
            fo.setValue(o.getValue());
            f.getOption().add(fo);
        }
        return f;
    }

    private static Files cloneFiles(Files files) {
        Files ff = new Files();
        ff.setSourceEncoding(files.getSourceEncoding());
        ff.setSourceFilenameMask(files.getSourceFilenameMask());
        ff.setTargetEncoding(files.getTargetEncoding());
        ff.setTargetFilenamePattern(files.getTargetFilenamePattern());
        return ff;
    }

    public static Filter getDefaultSettingsFromFilter(String filterClassname) {
        IFilter f = FilterMaster.getFilterInstance(filterClassname);
        Filter fc = new Filter();
        fc.setClassName(f.getClass().getName());
        fc.setEnabled(true);
        for (Instance ins : f.getDefaultInstances()) {
            Files ff = new Files();
            ff.setSourceEncoding(ins.getSourceEncoding());
            ff.setSourceFilenameMask(ins.getSourceFilenameMask());
            ff.setTargetEncoding(ins.getTargetEncoding());
            ff.setTargetFilenamePattern(ins.getTargetFilenamePattern());
            fc.getFiles().add(ff);
        }
        return fc;
    }

    public static Map<String, String> forFilter(List<Filter.Option> options) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Filter.Option opt : options) {
            result.put(opt.getName(), opt.getValue());
        }
        return result;
    }

    public static void setOptions(Filter f, Map<String, String> newOptions) {
        f.getOption().clear();
        for (Map.Entry<String, String> en : newOptions.entrySet()) {
            Filter.Option opt = new Filter.Option();
            opt.setName(en.getKey());
            opt.setValue(en.getValue());
            f.getOption().add(opt);
        }
    }

    static {
        try {
            filtersClasses = new ArrayList();
            filtersClasses.addAll(PluginUtils.getFilterClasses());
        }
        catch (Exception ex) {
            throw new ExceptionInInitializerError(ex);
        }
        supportedEncodings = null;
        staxInputFactory = XMLInputFactory.newInstance();
        staxOutputFactory = XMLOutputFactory.newInstance();
    }

    static class LookupInformation {
        public final Files outFilesInfo;
        public final IFilter filterObject;
        public final Map<String, String> config;

        public LookupInformation(IFilter filterObject, Files outFilesInfo, Map<String, String> config) {
            this.filterObject = filterObject;
            this.outFilesInfo = outFilesInfo;
            this.config = config;
        }
    }
}

