/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.omegat.core.matching.NearString;
import org.omegat.gui.matches.MatchesVarExpansion;
import org.omegat.util.Language;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DelegatingComboBoxRenderer;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.LanguageComboBoxRenderer;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class ExternalTMXMatchesDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private JButton cancelButton;
    private JCheckBox displayLevel2Tags;
    private JButton insertButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JScrollPane jScrollPane1;
    private JLabel matchCountLabel;
    private JSpinner matchesCountSpinner;
    private JTextArea matchesTemplate;
    private JButton okButton;
    private JLabel sortMatchesLabel;
    private JComboBox sortMatchesList;
    private JLabel tagHandlingLabel;
    private JLabel templateLabel;
    private JCheckBox useSlash;
    private JCheckBox doMerge;
    private JLabel variablesLabel;
    private JComboBox variablesList;
    private JCheckBox sourceDiffBox;
    private JCheckBox targetDiffBox;
    private JCheckBox keepForeignMatches;
    private JSpinner foreignPenaltySpinner;
    private JList foreignLanguagesList;
    private int returnStatus = 0;

    public ExternalTMXMatchesDialog(Frame parent) {
        super(parent, true);
        StaticUIUtils.setEscapeClosable(this);
        this.initComponents();
        this.sortMatchesList.setModel(new DefaultComboBoxModel<NearString.SORT_KEY>(new NearString.SORT_KEY[]{NearString.SORT_KEY.SCORE, NearString.SORT_KEY.SCORE_NO_STEM, NearString.SORT_KEY.ADJUSTED_SCORE}));
        this.sortMatchesList.setRenderer(new DelegatingComboBoxRenderer<NearString.SORT_KEY>(){

            @Override
            protected Object getDisplayText(NearString.SORT_KEY value) {
                return OStrings.getString("EXT_TMX_SORT_KEY_" + value.name());
            }
        });
        this.getRootPane().setDefaultButton(this.okButton);
        this.sortMatchesList.setSelectedItem((Object)Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", NearString.SORT_KEY.SCORE));
        this.displayLevel2Tags.setSelected(Preferences.isPreference("ext_tmx_show_level2"));
        this.useSlash.setSelected(Preferences.isPreference("ext_tmx_use_slash"));
        this.doMerge.setSelected(Preferences.isPreference("ext_tmx_do_merge"));
        this.matchesTemplate.setText(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>"));
        this.matchesTemplate.getDocument().addDocumentListener(new RegexHighlightListener(this.matchesTemplate, 32));
        this.matchesTemplate.setCaretPosition(0);
        this.matchesCountSpinner.setValue(new Integer(Preferences.getPreferenceDefault("ext_tmx_match_display_count", 5)));
        String forLangSpec = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");
        if (forLangSpec.contains(";")) {
            String[] forLangSpecs = forLangSpec.split(";");
            DefaultListModel lm = (DefaultListModel)this.foreignLanguagesList.getModel();
            for (int i = 0; i < forLangSpecs.length - 1; ++i) {
                lm.addElement(forLangSpecs[i]);
            }
            forLangSpec = forLangSpec.substring(forLangSpec.lastIndexOf(59) + 1);
        }
        this.keepForeignMatches.setSelected(!forLangSpec.toLowerCase().endsWith("false"));
        try {
            this.foreignPenaltySpinner.setValue(Integer.parseInt(forLangSpec.substring(0, forLangSpec.indexOf(32))));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.keepForeignMatches.isSelected()) {
            this.foreignPenaltySpinner.setEnabled(false);
            this.foreignLanguagesList.setEnabled(false);
        }
        this.invalidate();
        this.pack();
        DockingUI.displayCentered(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jPanel1 = new JPanel();
        this.sortMatchesLabel = new JLabel();
        this.sortMatchesList = new JComboBox();
        this.jPanel7 = new JPanel();
        this.tagHandlingLabel = new JLabel();
        this.displayLevel2Tags = new JCheckBox();
        this.useSlash = new JCheckBox();
        this.doMerge = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.templateLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.matchesTemplate = new JTextArea();
        this.jPanel4 = new JPanel();
        this.variablesLabel = new JLabel();
        this.variablesList = new JComboBox();
        this.insertButton = new JButton();
        this.matchCountLabel = new JLabel();
        this.matchesCountSpinner = new JSpinner();
        this.sourceDiffBox = new JCheckBox();
        this.targetDiffBox = new JCheckBox();
        this.jPanel5 = new JPanel();
        this.jPanel6 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.foreignPenaltySpinner = new JSpinner();
        this.setTitle(OStrings.getString("EXT_TMX_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ExternalTMXMatchesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel2.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 2));
        Mnemonics.setLocalizedText(this.sortMatchesLabel, OStrings.getString("EXT_TMX_SORT_KEY"));
        this.jPanel1.add(this.sortMatchesLabel);
        this.jPanel1.add(this.sortMatchesList);
        this.jPanel2.add((Component)this.jPanel1, "North");
        this.jPanel7.setLayout(new BoxLayout(this.jPanel7, 1));
        Mnemonics.setLocalizedText(this.tagHandlingLabel, OStrings.getString("EXT_TMX_DESCRIPTION"));
        this.jPanel7.add(this.tagHandlingLabel);
        this.displayLevel2Tags.setSelected(true);
        Mnemonics.setLocalizedText(this.displayLevel2Tags, OStrings.getString("EXT_TMX_SHOW_LEVEL2"));
        this.jPanel7.add(this.displayLevel2Tags);
        this.useSlash.setSelected(true);
        Mnemonics.setLocalizedText(this.useSlash, OStrings.getString("EXT_TMX_USE_XML"));
        this.jPanel7.add(this.useSlash);
        this.jPanel2.add((Component)this.jPanel7, "Last");
        this.getContentPane().add((Component)this.jPanel2, "North");
        this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel3.setLayout(new BorderLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/omegat/Bundle");
        Mnemonics.setLocalizedText(this.templateLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE"));
        this.jPanel3.add((Component)this.templateLabel, "North");
        this.jScrollPane1.setCursor(new Cursor(0));
        this.jScrollPane1.setMinimumSize(new Dimension(525, 25));
        this.jScrollPane1.setPreferredSize(new Dimension(446, 96));
        this.matchesTemplate.setColumns(30);
        this.matchesTemplate.setRows(5);
        this.jScrollPane1.setViewportView(this.matchesTemplate);
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.jPanel4.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText(this.variablesLabel, bundle.getString("EXT_TMX_MATCHES_TEMPLATE_VARIABLES"));
        this.jPanel4.add((Component)this.variablesLabel, "West");
        this.variablesList.setModel(new DefaultComboBoxModel<String>(MatchesVarExpansion.MATCHES_VARIABLES));
        this.jPanel4.add((Component)this.variablesList, "Center");
        Mnemonics.setLocalizedText(this.insertButton, bundle.getString("BUTTON_INSERT"));
        this.insertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.insertButtonActionPerformed(evt);
            }
        });
        this.jPanel4.add((Component)this.insertButton, "East");
        this.jPanel3.add((Component)this.jPanel4, "Last");
        this.getContentPane().add((Component)this.jPanel3, "Center");
        this.jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel5.setLayout(new BorderLayout());
        this.jPanel6.setLayout(new BoxLayout(this.jPanel6, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExternalTMXMatchesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel6.add(this.cancelButton);
        this.jPanel5.add((Component)this.jPanel6, "East");
        Mnemonics.setLocalizedText(this.matchCountLabel, OStrings.getString("EXT_TMX_MATCHES_COUNT"));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 2));
        jPanel8.add(this.matchCountLabel);
        this.matchesCountSpinner.setModel(new SpinnerNumberModel(5, 0, 50, 1));
        jPanel8.add(this.matchesCountSpinner);
        this.doMerge.setSelected(true);
        Mnemonics.setLocalizedText(this.doMerge, OStrings.getString("EXT_TMX_DO_MERGE"));
        jPanel8.add(this.doMerge);
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 2));
        jPanel9.add(this.sourceDiffBox);
        jPanel9.add(this.targetDiffBox);
        this.sourceDiffBox.setSelected(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>").contains("${diff}"));
        Mnemonics.setLocalizedText(this.sourceDiffBox, OStrings.getString("EXT_TMX_DIFF_SOURCE"));
        this.sourceDiffBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (ExternalTMXMatchesDialog.this.sourceDiffBox.isSelected()) {
                    ExternalTMXMatchesDialog.this.matchesTemplate.setText(ExternalTMXMatchesDialog.this.matchesTemplate.getText().replace("${sourceText}", "${diff}"));
                } else {
                    ExternalTMXMatchesDialog.this.matchesTemplate.setText(ExternalTMXMatchesDialog.this.matchesTemplate.getText().replace("${diff}", "${sourceText}"));
                }
            }
        });
        this.targetDiffBox.setSelected(Preferences.getPreferenceDefault("ext_tmx_match_template", "${id}. ${fuzzyFlag}${sourceText}\n${targetText}\n<${score}/${noStemScore}/${adjustedScore}% ${filePath}>").contains("${diffTra}"));
        Mnemonics.setLocalizedText(this.targetDiffBox, OStrings.getString("EXT_TMX_DIFF_TARGET"));
        this.targetDiffBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                if (ExternalTMXMatchesDialog.this.targetDiffBox.isSelected()) {
                    ExternalTMXMatchesDialog.this.matchesTemplate.setText(ExternalTMXMatchesDialog.this.matchesTemplate.getText().replace("${targetText}", "${diffTra}"));
                } else {
                    ExternalTMXMatchesDialog.this.matchesTemplate.setText(ExternalTMXMatchesDialog.this.matchesTemplate.getText().replace("${diffTra}", "${targetText}"));
                }
            }
        });
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new BoxLayout(jPanel11, 1));
        JPanel jPanel12 = new JPanel();
        jPanel11.add(jPanel12);
        jPanel12.setLayout(new BoxLayout(jPanel12, 2));
        this.keepForeignMatches = new JCheckBox(OStrings.getString("EXT_TMX_KEEP_FOREIGN_MATCHES"));
        jPanel12.add(this.keepForeignMatches);
        jPanel12.add(new JLabel("     "));
        jPanel12.add(new JLabel(OStrings.getString("EXT_TMX_PENALTY_FOR_FOREIGN_MATCHES")));
        jPanel12.add(this.foreignPenaltySpinner);
        this.foreignPenaltySpinner.setModel(new SpinnerNumberModel(30, 0, 100, 1));
        JPanel jPanel13 = new JPanel();
        jPanel11.add(jPanel13);
        jPanel13.setLayout(new BoxLayout(jPanel13, 2));
        jPanel13.add(new JLabel(OStrings.getString("EXT_TMX_CHOOSE_FOREIGN_LANGUAGES") + "   "));
        DefaultListModel lm = new DefaultListModel();
        this.foreignLanguagesList = new JList(lm);
        JScrollPane scrollList = new JScrollPane(this.foreignLanguagesList);
        jPanel13.add(scrollList);
        scrollList.setPreferredSize(new Dimension(40, 100));
        JPanel jPanel14 = new JPanel();
        jPanel13.add(jPanel14);
        jPanel14.setLayout(new BoxLayout(jPanel14, 1));
        JButton btnAdd = new JButton(OStrings.getString("EXT_TMX_CHOOSE_FOREIGN_LANGUAGES_ADD"));
        JButton btnRemove = new JButton(OStrings.getString("EXT_TMX_CHOOSE_FOREIGN_LANGUAGES_REMOVE"));
        JButton btnUp = new JButton(OStrings.getString("EXT_TMX_CHOOSE_FOREIGN_LANGUAGES_UP"));
        JButton btnDown = new JButton(OStrings.getString("EXT_TMX_CHOOSE_FOREIGN_LANGUAGES_DOWN"));
        jPanel14.add(btnAdd);
        jPanel14.add(btnRemove);
        jPanel14.add(btnUp);
        jPanel14.add(btnDown);
        btnAdd.addActionListener(ev -> {
            JDialog newLangDlg = new JDialog((Dialog)this, true);
            Container pane = newLangDlg.getContentPane();
            pane.setLayout(new BoxLayout(pane, 1));
            Box boxLg = Box.createHorizontalBox();
            pane.add(boxLg);
            boxLg.add(new JLabel(OStrings.getString("EXT_TMX_DIALOG_FOREIGN_LANGUAGE") + "\u00a0"));
            JComboBox<Language> cbLang = new JComboBox<Language>(Language.LANGUAGES);
            boxLg.add(cbLang);
            if (cbLang.getMaximumRowCount() < 20) {
                cbLang.setMaximumRowCount(20);
            }
            cbLang.setEditable(true);
            cbLang.setRenderer(new LanguageComboBoxRenderer());
            Box boxPen = Box.createHorizontalBox();
            pane.add(boxPen);
            boxPen.add(new JLabel(OStrings.getString("EXT_TMX_DIALOG_FOREIGN_PENALTY") + "\u00a0"));
            JSpinner spLocalPenalty = new JSpinner();
            boxPen.add(spLocalPenalty);
            spLocalPenalty.setModel(new SpinnerNumberModel(30, 0, 100, 1));
            JCheckBox doInsert = new JCheckBox(OStrings.getString("EXT_TMX_DIALOG_FOREIGN_INSERT"));
            pane.add(doInsert);
            JButton btnOk = new JButton(OStrings.getString("BUTTON_OK").replace("&", ""));
            JButton btnCancel = new JButton(OStrings.getString("BUTTON_CANCEL").replace("&", ""));
            Box btnBox = Box.createHorizontalBox();
            pane.add(btnBox);
            btnBox.add(btnOk);
            btnBox.add(btnCancel);
            btnCancel.addActionListener(ev1 -> newLangDlg.setVisible(false));
            btnOk.addActionListener(ev1 -> {
                lm.addElement(cbLang.getSelectedItem().toString() + " " + spLocalPenalty.getValue() + " " + (doInsert.isSelected() ? "with-insert" : "no-insert"));
                newLangDlg.setVisible(false);
            });
            int x = this.getX();
            int y = this.getY();
            newLangDlg.pack();
            newLangDlg.setLocation(x + 100, y + 100);
            newLangDlg.setVisible(true);
        });
        btnRemove.addActionListener(ev -> {
            for (Object val : this.foreignLanguagesList.getSelectedValuesList()) {
                lm.removeElement(val);
            }
        });
        btnUp.addActionListener(ev -> {
            Object sel = this.foreignLanguagesList.getSelectedValue();
            int idx = this.foreignLanguagesList.getSelectedIndex();
            if (sel == null) {
                return;
            }
            lm.removeElement(sel);
            lm.insertElementAt(sel, idx - 1);
        });
        btnDown.addActionListener(ev -> {
            Object sel = this.foreignLanguagesList.getSelectedValue();
            int idx = this.foreignLanguagesList.getSelectedIndex();
            if (sel == null) {
                return;
            }
            lm.removeElement(sel);
            lm.insertElementAt(sel, idx + 1);
        });
        this.keepForeignMatches.addChangeListener(ev -> {
            this.foreignPenaltySpinner.setEnabled(this.keepForeignMatches.isSelected());
            this.foreignLanguagesList.setEnabled(this.keepForeignMatches.isSelected());
            btnUp.setEnabled(this.keepForeignMatches.isSelected());
            btnDown.setEnabled(this.keepForeignMatches.isSelected());
            btnAdd.setEnabled(this.keepForeignMatches.isSelected());
            btnRemove.setEnabled(this.keepForeignMatches.isSelected());
        });
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new BoxLayout(jPanel10, 1));
        jPanel10.add(jPanel8);
        jPanel10.add(jPanel9);
        jPanel10.add(jPanel11);
        this.jPanel7.add(jPanel10);
        this.getContentPane().add((Component)this.jPanel5, "South");
    }

    private void insertButtonActionPerformed(ActionEvent evt) {
        this.matchesTemplate.replaceSelection(this.variablesList.getSelectedItem().toString());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        Preferences.setPreference("ext_tmx_sort_key", (Object)((NearString.SORT_KEY)((Object)this.sortMatchesList.getSelectedItem())));
        Preferences.setPreference("ext_tmx_show_level2", this.displayLevel2Tags.isSelected());
        Preferences.setPreference("ext_tmx_use_slash", this.useSlash.isSelected());
        Preferences.setPreference("ext_tmx_do_merge", this.doMerge.isSelected());
        Preferences.setPreference("ext_tmx_match_template", this.matchesTemplate.getText());
        Preferences.setPreference("ext_tmx_match_display_count", this.matchesCountSpinner.getValue().toString());
        Preferences.setPreference("keep_foreign_matches", this.buildForeignMatchesString());
        this.doClose(1);
    }

    private String buildForeignMatchesString() {
        StringBuffer buf = new StringBuffer();
        ListModel lm = this.foreignLanguagesList.getModel();
        for (int i = 0; i < lm.getSize(); ++i) {
            buf.append(lm.getElementAt(i).toString()).append(";");
        }
        buf.append(this.foreignPenaltySpinner.getValue()).append(" ").append(this.keepForeignMatches.isSelected());
        return buf.toString();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

