/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor.filter;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.search.PreTranslateSearchResultEntry;
import org.omegat.core.search.PreTranslateSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.SearchResultEntry;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.editor.IEditorFilter;
import org.omegat.gui.editor.filter.FilterBarReplace;

public class PreTranslateFilter
implements IEditorFilter {
    private final Map<Integer, PreTranslateSearchResultEntry> entries = new HashMap<Integer, PreTranslateSearchResultEntry>();
    private FilterBarReplace controlComponent;
    private PreTranslateSearcher searcher;
    private int minEntryNum;
    private int maxEntryNum;

    public PreTranslateFilter(PreTranslateSearcher searcher) {
        this.searcher = searcher;
        this.minEntryNum = Integer.MAX_VALUE;
        this.maxEntryNum = Integer.MIN_VALUE;
        for (SearchResultEntry sre : searcher.getSearchResults()) {
            this.minEntryNum = Math.min(this.minEntryNum, sre.getEntryNum());
            this.maxEntryNum = Math.max(this.maxEntryNum, sre.getEntryNum());
            this.entries.put(sre.getEntryNum(), (PreTranslateSearchResultEntry)sre);
        }
        this.controlComponent = new FilterBarReplace();
        this.controlComponent.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Core.getEditor().commitAndDeactivate();
                Core.getEditor().removeFilter();
            }
        });
        this.controlComponent.btnSkip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreTranslateFilter.this.skip();
            }
        });
        this.controlComponent.btnReplaceNext.setText("Translate next");
        this.controlComponent.btnReplaceNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreTranslateFilter.this.translate();
            }
        });
    }

    @Override
    public boolean isSourceAsEmptyTranslation() {
        return true;
    }

    public void translateAll(JLabel label) {
        EditorController ec = (EditorController)Core.getEditor();
        ec.commitAndDeactivate();
        int i = 0;
        boolean transDefault = !this.searcher.translateAsAlternative();
        for (PreTranslateSearchResultEntry sre : this.entries.values()) {
            SourceTextEntry ste = Core.getProject().getAllEntries().get(sre.getEntryNum() - 1);
            if (transDefault && ste.getDuplicate() == SourceTextEntry.DUPLICATE.NEXT) continue;
            PrepareTMXEntry prepare = new PrepareTMXEntry(Core.getProject().getTranslationInfo(ste));
            prepare.translation = sre.getTranslationResult();
            Core.getProject().setTranslation(ste, prepare, transDefault, null);
            if (label == null) continue;
            label.setText("" + ++i / this.entries.size() + "/" + this.entries.size() + " translated.");
        }
        ec.refreshEntries(this.entries.keySet());
        ec.activateEntry();
    }

    @Override
    public boolean allowed(SourceTextEntry ste) {
        return this.entries.containsKey(ste.entryNum());
    }

    @Override
    public Component getControlComponent() {
        return this.controlComponent;
    }

    public List<SearchMatch> getMatchesForEntry(String srcText) {
        return this.searcher.searchInSource(srcText);
    }

    private void skip() {
        Iterator<SearchMatch> iterator;
        List<SearchMatch> found;
        String trans;
        TMXEntry en;
        PreTranslateSearchResultEntry sre;
        int i;
        EditorController ec = (EditorController)Core.getEditor();
        int currentEntryNumber = ec.getCurrentEntryNumber();
        ec.commitAndDeactivate();
        for (i = currentEntryNumber + 1; i <= this.maxEntryNum; ++i) {
            sre = this.entries.get(i);
            if (sre == null) continue;
            en = Core.getProject().getTranslationInfo(Core.getProject().getAllEntries().get(i));
            trans = sre.getSrcText();
            if (trans == null || (found = this.getMatchesForEntry(trans)) == null || !(iterator = found.iterator()).hasNext()) continue;
            SearchMatch m = iterator.next();
            ec.gotoEntry(i, new IEditor.CaretPosition(m.getStart(), m.getEnd()));
            ec.requestFocus();
            return;
        }
        for (i = this.minEntryNum; i < currentEntryNumber; ++i) {
            sre = this.entries.get(i);
            if (sre == null) continue;
            en = Core.getProject().getTranslationInfo(Core.getProject().getAllEntries().get(i));
            trans = sre.getSrcText();
            if (trans == null || (found = this.getMatchesForEntry(trans)) == null || !(iterator = found.iterator()).hasNext()) continue;
            SearchMatch m = iterator.next();
            ec.gotoEntry(i, new IEditor.CaretPosition(m.getStart(), m.getEnd()));
            ec.requestFocus();
            return;
        }
        ec.activateEntry();
    }

    private void translate() {
        EditorController ec = (EditorController)Core.getEditor();
        int pos = ec.getCurrentPositionInEntryTranslation();
        String str = ec.getCurrentTranslation();
        PreTranslateSearchResultEntry rEntry = this.searcher.testSingleEntry(ec.getCurrentEntry());
        if (rEntry != null) {
            ec.replaceEditText(rEntry.getTranslationResult());
            ec.setAlternateTranslationForCurrentEntry(this.searcher.translateAsAlternative());
        }
        this.skip();
    }
}

