/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.omegat.core.Core;
import org.omegat.core.glossaries.IGlossary;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.glossary.GlossaryEntry;
import org.omegat.gui.glossary.GlossaryReaderCSV;
import org.omegat.gui.glossary.GlossaryReaderTBX;
import org.omegat.gui.glossary.GlossaryReaderTSV;
import org.omegat.gui.glossary.GlossaryTextArea;
import org.omegat.util.DirectoryMonitor;
import org.omegat.util.Language;
import org.omegat.util.Log;

public class GlossaryManager
implements DirectoryMonitor.Callback {
    protected DirectoryMonitor monitor;
    private final GlossaryTextArea pane;
    private final Map<String, List<GlossaryEntry>> glossaries = new TreeMap<String, List<GlossaryEntry>>();
    protected File priorityGlossary;
    protected Map<String, IGlossary> externalGlossaries = new TreeMap<String, IGlossary>();

    public GlossaryManager(GlossaryTextArea pane) {
        this.pane = pane;
        for (Class<?> glc : PluginUtils.getGlossaryClasses()) {
            try {
                this.externalGlossaries.put(glc.getName(), (IGlossary)glc.newInstance());
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public void addGlossaryProvider(IGlossary provider) {
        this.externalGlossaries.put(provider.getClass().getName(), provider);
    }

    public void start() {
        File dir = new File(Core.getProject().getProjectProperties().getGlossaryRoot());
        this.priorityGlossary = new File(Core.getProject().getProjectProperties().getWriteableGlossary());
        this.monitor = new DirectoryMonitor(dir, this);
        this.monitor.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.monitor.fin();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            this.glossaries.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fileChanged(File file) {
        block11: {
            GlossaryManager glossaryManager = this;
            synchronized (glossaryManager) {
                this.glossaries.remove(file.getPath());
            }
            if (file.exists()) {
                try {
                    List<GlossaryEntry> entries = this.loadGlossaryFile(file);
                    if (entries != null) {
                        GlossaryManager glossaryManager2 = this;
                        synchronized (glossaryManager2) {
                            Log.logRB("CT_LOADING_GLOSSARY_DETAILS", entries.size(), file.getName());
                            this.glossaries.put(file.getPath(), entries);
                            break block11;
                        }
                    }
                    IGlossary externalGlossary = this.buildExternalGlossaryFromFile(file);
                    if (externalGlossary != null) {
                        TreeMap<String, IGlossary> newExternalGlossaries = new TreeMap<String, IGlossary>(this.externalGlossaries);
                        newExternalGlossaries.put(file.getPath(), externalGlossary);
                        this.externalGlossaries = newExternalGlossaries;
                    }
                }
                catch (Exception ex) {
                    Log.logRB("CT_ERROR_ACCESS_GLOSSARY_DIR", new Object[0]);
                    Log.log(ex);
                }
            }
        }
        this.pane.refresh();
    }

    public void forceReloadTBX() {
        Set<File> files = this.monitor.getExistFiles();
        for (File f : files) {
            if (!f.getName().toLowerCase().endsWith(".tbx")) continue;
            this.fileChanged(f);
        }
    }

    public void forceUpdateGlossary() {
        this.pane.refresh();
    }

    private List<GlossaryEntry> loadGlossaryFile(File file) throws Exception {
        boolean isPriority = this.priorityGlossary.equals(file);
        return GlossaryManager.loadGlossaryFile(file, isPriority);
    }

    public static List<GlossaryEntry> loadGlossaryFile(File file, boolean isPriority) throws Exception {
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file, isPriority);
        }
        if (fname_lower.endsWith(".utf8") || fname_lower.endsWith(".txt")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTSV.read(file, isPriority);
        }
        if (fname_lower.endsWith(".csv")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderCSV.read(file, isPriority);
        }
        if (fname_lower.endsWith(".tbx")) {
            Log.logRB("CT_LOADING_GLOSSARY", file.getName());
            return GlossaryReaderTBX.read(file, isPriority);
        }
        return null;
    }

    private IGlossary buildExternalGlossaryFromFile(File file) throws Exception {
        boolean isPriority = this.priorityGlossary.equals(file);
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".properties")) {
            Properties config = new Properties();
            config.load(new FileInputStream(file));
            if (config.getProperty("name") == null) {
                config.setProperty("name", file.toString());
            }
            if (file.equals(this.priorityGlossary)) {
                config.setProperty("##PriorityGlossary##", "true");
            }
            Class<?> glosClass = PluginUtils.getPluginsClassLoader().loadClass(config.getProperty("class"));
            Constructor<?> cons = glosClass.getConstructor(Properties.class);
            return (IGlossary)cons.newInstance(config);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> getGlossaryEntries(String src) {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> en : this.glossaries.values()) {
                result.addAll(en);
            }
        }
        this.addExternalGlossaryEntries(result, src);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GlossaryEntry> search(String src) {
        ArrayList<GlossaryEntry> result = new ArrayList<GlossaryEntry>();
        GlossaryManager glossaryManager = this;
        synchronized (glossaryManager) {
            for (List<GlossaryEntry> en : this.glossaries.values()) {
                result.addAll(en);
            }
        }
        return result;
    }

    private void addExternalGlossaryEntries(List<GlossaryEntry> result, String src) {
        Language source = Core.getProject().getProjectProperties().getSourceLanguage();
        Language target = Core.getProject().getProjectProperties().getTargetLanguage();
        for (IGlossary gl : this.externalGlossaries.values()) {
            try {
                result.addAll(gl.search(source, target, src));
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }
}

