/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.search.ReplaceMatch;
import org.omegat.core.search.ReplaceSearcher;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.search.Searcher;
import org.omegat.gui.editor.filter.ReplaceFilter;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.ProjectSearchWindow;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class ReplaceDialog
extends ProjectSearchWindow {
    private static final Map<String, Set<String>> theMap = new HashMap<String, Set<String>>();
    private SearchWindow.SetRef searchRef;
    private SearchWindow.SetRef replaceRef;
    public static final String REPL_WORD_WHOLE = "WHOLE";
    public static final String REPL_EXACT = "EXACT";
    public static final String REPL_SEGMENT = "SEGMENT";
    private JComboBox m_searchField;
    private JComboBox m_replaceField;
    private JButton m_replaceInt;
    private JButton m_replaceAll;
    private JRadioButton m_replaceSegment;
    private JRadioButton m_replaceWhole;
    private JRadioButton m_replaceExact;
    private JCheckBox m_replaceWithVars;
    private JCheckBox m_orphansSearchCB;

    public ReplaceDialog(MainWindow par, String startText, String replaceText) {
        super(par, startText);
        this.setTitle(OStrings.getString("SW_TITLE_REPLACE"));
        this.refreshLists(true);
        if (startText != null) {
            this.getMainSearchTextField().setSelectedItem(startText);
        }
        if (replaceText != null) {
            this.m_replaceField.setSelectedItem(replaceText);
        }
        for (JComboBox box : new JComboBox[]{this.m_searchField, this.m_replaceField}) {
            JTextComponent searchFieldArea = (JTextComponent)box.getEditor().getEditorComponent();
            searchFieldArea.addMouseListener(new SearchWindow.PopupFactory(searchFieldArea));
        }
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, (JTextComponent)this.m_searchField.getEditor().getEditorComponent()));
        this.m_replaceWithVars.addActionListener(new ActionListener(){
            private JTextComponent receiver;
            private RegexHighlightListener listener;
            {
                this.receiver = (JTextComponent)ReplaceDialog.this.m_replaceField.getEditor().getEditorComponent();
                this.listener = new RegexHighlightListener(this.receiver, 24);
                this.actionPerformed(null);
            }

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ReplaceDialog.this.m_replaceWithVars.isSelected()) {
                    this.receiver.getDocument().addDocumentListener(this.listener);
                } else {
                    this.receiver.getDocument().removeDocumentListener(this.listener);
                }
            }
        });
    }

    @Override
    protected String getScopeText() {
        return OStrings.getString("SW_HELP_SCOPE_REPLACE");
    }

    @Override
    protected boolean isReplace() {
        return true;
    }

    @Override
    public void refreshLists(boolean removeContents) {
        String selected = removeContents ? "" : this.m_searchField.getSelectedItem().toString();
        this.m_searchField.removeAllItems();
        this.m_searchField.addItem(selected);
        this.searchRef.theSet = theMap.get("SW_SEARCH_TEXT:" + this.m_modePanel.searchTypeString());
        for (String item : this.searchRef.theSet) {
            this.m_searchField.addItem(SearchModeBox.MemorizedExpression.forString(item));
        }
        this.m_searchField.setSelectedItem(selected);
        selected = removeContents ? "" : this.m_replaceField.getSelectedItem().toString();
        this.m_replaceField.removeAllItems();
        this.m_replaceField.addItem(selected);
        this.replaceRef.theSet = theMap.get("SW_REPLACE_BY:" + this.m_modePanel.searchTypeString());
        for (String item : this.replaceRef.theSet) {
            this.m_replaceField.addItem(SearchModeBox.MemorizedExpression.forString(item));
        }
        this.m_replaceField.setSelectedItem(selected);
    }

    @Override
    protected JComponent textPanel(String startText) {
        JLabel m_searchLabel = new JLabel();
        Mnemonics.setLocalizedText(m_searchLabel, OStrings.getString("SW_SEARCH_TEXT"));
        this.m_searchField = new JComboBox();
        this.m_searchField.setEditable(true);
        this.m_searchField.addActionListener(ev -> {
            try {
                SearchModeBox.MemorizedExpression item = (SearchModeBox.MemorizedExpression)this.m_searchField.getSelectedItem();
                item.applyTo(this.m_modePanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (startText != null) {
            this.m_searchField.setSelectedItem(startText);
        }
        JLabel m_replaceLabel = new JLabel();
        Mnemonics.setLocalizedText(m_replaceLabel, OStrings.getString("SW_REPLACE_TEXT"));
        this.m_replaceField = new JComboBox();
        this.m_replaceField.setEditable(true);
        Box bSearch = Box.createHorizontalBox();
        bSearch.add(m_searchLabel);
        bSearch.add(this.m_searchField);
        this.searchRef = new SearchWindow.SetRef(theMap.get("SW_SEARCH_TEXT:EXACT"));
        bSearch.add(this.createMemorizeButton(this.getY(), true, this.m_searchField, null, "SW_SEARCH_TEXT", this.searchRef));
        Box bReplace = Box.createHorizontalBox();
        bReplace.add(m_replaceLabel);
        bReplace.add(this.m_replaceField);
        this.replaceRef = new SearchWindow.SetRef(theMap.get("SW_REPLACE_BY:EXACT"));
        bReplace.add(this.createMemorizeButton(this.getY(), true, this.m_replaceField, null, "SW_REPLACE_BY", this.replaceRef));
        Box bBoth = Box.createVerticalBox();
        bBoth.add(bSearch);
        bBoth.add(bReplace);
        return bBoth;
    }

    @Override
    public JComboBox getMainSearchTextField() {
        return this.m_searchField;
    }

    @Override
    protected Box buttonsPanel() {
        Box bButtons = super.buttonsPanel();
        this.m_replaceInt = new JButton();
        bButtons.add(this.m_replaceInt);
        this.m_replaceAll = new JButton();
        bButtons.add(this.m_replaceAll);
        this.m_replaceInt.setEnabled(false);
        this.m_replaceAll.setEnabled(false);
        Mnemonics.setLocalizedText(this.m_replaceInt, OStrings.getString("BUTTON_REPLACE_INT"));
        Mnemonics.setLocalizedText(this.m_replaceAll, OStrings.getString("BUTTON_REPLACE_ALL"));
        this.m_replaceInt.addActionListener(e -> {
            Core.getEditor().commitAndLeave();
            try {
                Core.getEditor().setFilter(new ReplaceFilter(this.m_viewer.getEntryList(), this.buildSearcher(null), this));
            }
            catch (Exception eMissing) {
                JOptionPane.showMessageDialog(this, eMissing.getMessage());
            }
        });
        this.m_replaceAll.addActionListener(e -> {
            Core.getEditor().commitAndDeactivate();
            int count = this.m_viewer.getEntryList().size();
            String msg = MessageFormat.format(OStrings.getString("SW_REPLACE_ALL_CONFIRM"), count);
            int r = JOptionPane.showConfirmDialog(this, msg, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
            if (r == 0) {
                this.m_replaceAll.setEnabled(false);
                this.m_replaceInt.setEnabled(false);
                this.m_resultsLabel.setText(OStrings.getString("SW_REPLACE_WAIT"));
                SwingUtilities.invokeLater(() -> {
                    try {
                        new ReplaceFilter(this.m_viewer.getEntryList(), this.buildSearcher(null), this).replaceAll(this.m_resultsLabel);
                        Thread.yield();
                        this.m_resultsLabel.setText(OStrings.getString("SW_REPLACE_WAIT_FINISHED"));
                        if (count >= (Integer)this.m_numberModel.getValue()) {
                            String msg1 = MessageFormat.format(OStrings.getString("SW_REPLACE_WAIT_COUNT_QUESTION"), count);
                            int r1 = JOptionPane.showConfirmDialog(this, msg1, OStrings.getString("CONFIRM_DIALOG_TITLE"), 0);
                            if (r1 == 0) {
                                this.doSearch(true);
                            }
                        } else {
                            String msg2 = MessageFormat.format(OStrings.getString("SW_REPLACE_WAIT_COUNT_OK"), count);
                            JOptionPane.showMessageDialog(this, msg2);
                        }
                    }
                    catch (Exception eMissing) {
                        JOptionPane.showMessageDialog(this, eMissing.getMessage());
                    }
                });
            }
            Core.getEditor().activateEntry();
        });
        return bButtons;
    }

    @Override
    protected JComponent modePanel() {
        this.m_modePanel = (SearchModeBox)super.modePanel();
        Box bVertical = Box.createVerticalBox();
        bVertical.add(this.m_modePanel);
        Box bRow2 = Box.createHorizontalBox();
        bVertical.add(bRow2);
        Box bReplace = Box.createHorizontalBox();
        this.m_replaceExact = new JRadioButton(OStrings.getString("SW_REPLACE_ACTION_FOUND"));
        bReplace.add(this.m_replaceExact);
        this.m_replaceWhole = new JRadioButton(OStrings.getString("SW_REPLACE_ACTION_WORDS"));
        bReplace.add(this.m_replaceWhole);
        this.m_replaceSegment = new JRadioButton(OStrings.getString("SW_REPLACE_ACTION_ENTIRE"));
        bReplace.add(this.m_replaceSegment);
        this.m_replaceWithVars = new JCheckBox(OStrings.getString("SW_REPLACE_ACTION_VARS"));
        bReplace.add(this.m_replaceWithVars);
        bReplace.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_REPLACE_ACTION_MODE")));
        bRow2.add(bReplace);
        ButtonGroup bgExpr = new ButtonGroup();
        bgExpr.add(this.m_replaceExact);
        bgExpr.add(this.m_replaceWhole);
        bgExpr.add(this.m_replaceSegment);
        this.m_replaceExact.setSelected(true);
        for (AbstractButton component : this.m_modePanel.getOptionsComponents()) {
            this.addFocusToSearchListener(component);
        }
        bRow2.add(this.wherePanel1());
        return bVertical;
    }

    private void doCancel() {
        UIThreadsUtil.mustBeSwingThread();
        this.dispose();
    }

    @Override
    protected Box optionsPanel() {
        return null;
    }

    @Override
    public Box wherePanel() {
        return null;
    }

    public Box wherePanel1() {
        Box bWhere = Box.createHorizontalBox();
        this.m_orphansSearchCB = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_orphansSearchCB, OStrings.getString("SW_REPLACE_IN_ORPHANS"));
        bWhere.add(this.m_orphansSearchCB);
        bWhere.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_SEARCH_SCOPE")));
        this.addFocusToSearchListener(this.m_orphansSearchCB);
        return bWhere;
    }

    @Override
    protected ReplaceSearcher buildSearcher(Searcher prev) throws IllegalArgumentException {
        if (this.m_searchField.getSelectedItem() == null || this.m_searchField.getSelectedItem().toString().length() == 0) {
            throw new IllegalArgumentException(OStrings.getString("SW_ERROR_MANDATORY_FIELD_SEARCH"));
        }
        ReplaceSearcher res = new ReplaceSearcher(this, Core.getProject(), Integer.MAX_VALUE, false, this.m_modePanel.buildReplaceExpression(this.m_searchField.getSelectedItem().toString(), false, this.m_replaceField.getSelectedItem().toString().toString(), this.m_replaceWithVars.isSelected()), this.m_authorField.isUsed() ? this.m_modePanel.buildExpression(this.m_authorField.getValue(), this.m_authorField.isNot(), false) : null, null, this.m_dateFrom.isUsed() ? this.m_dateFrom.getValue().getTime() : Long.MAX_VALUE, this.m_dateTo.isUsed() ? this.m_dateTo.getValue().getTime() : Long.MIN_VALUE);
        try {
            res.startAt(((ReplaceSearcher)prev).projectEntries());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return res;
    }

    @Override
    protected String[] getFormatVariablesList() {
        return new String[]{"${preamble}", "${creationId}", "${creationDate}", "${sourceText}", "${targetText}", "${note}", "${replacedTarget}", "${fileName}", "${fileNameOnly}", "${filePath}", "${fileShortPath}"};
    }

    @Override
    protected String getFormatOptionName() {
        return "search_window_template_replace";
    }

    @Override
    protected String getFormatOptionDefaultValue() {
        return "${preamble}\n${targetText}\n${replacedTarget}\n\n-----------------------\n";
    }

    @Override
    protected JComponent[] componentsEnabledWhenResults() {
        if (this.m_orphansSearchCB.isSelected()) {
            return new JComponent[]{this.m_replaceAll};
        }
        return new JComponent[]{this.m_replaceInt, this.m_replaceAll};
    }

    @Override
    protected JTextComponent[] textFieldsList() {
        return new JTextComponent[]{(JTextComponent)this.m_searchField.getEditor().getEditorComponent(), (JTextComponent)this.m_replaceField.getEditor().getEditorComponent()};
    }

    public String getReplaceText() {
        return this.m_replaceField.getSelectedItem().toString();
    }

    public String getReplacementMode() {
        if (this.m_replaceSegment.isSelected()) {
            return REPL_SEGMENT;
        }
        if (this.m_replaceWhole.isSelected()) {
            return REPL_WORD_WHOLE;
        }
        return REPL_EXACT;
    }

    @Override
    protected void loadAdvancedOptionPreferences() {
        super.loadAdvancedOptionPreferences();
        this.m_replaceWithVars.setSelected(Preferences.isPreferenceDefault("search_window_replace_withVars", true));
        String replMode = Preferences.getPreferenceDefault("search_window_replace_mode", REPL_SEGMENT);
        this.m_replaceSegment.setSelected(REPL_SEGMENT.equals(replMode));
        this.m_replaceWhole.setSelected(REPL_WORD_WHOLE.equals(replMode));
        this.m_replaceExact.setSelected(REPL_EXACT.equals(replMode));
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        Preferences.setPreference("search_window_replace_withVars", Boolean.toString(this.m_replaceWithVars.isSelected()));
        if (this.m_replaceSegment.isSelected()) {
            Preferences.setPreference("search_window_replace_mode", REPL_SEGMENT);
        } else if (this.m_replaceWhole.isSelected()) {
            Preferences.setPreference("search_window_replace_mode", REPL_WORD_WHOLE);
        } else if (this.m_replaceExact.isSelected()) {
            Preferences.setPreference("search_window_replace_mode", REPL_EXACT);
        }
        Preferences.save();
    }

    public String buildReplacedString(String translation, List<SearchMatch> matches) {
        if (this.m_replaceExact.isSelected()) {
            return ReplaceMatch.buildReplacedString(translation, matches, this.getReplaceText());
        }
        if (this.m_replaceSegment.isSelected()) {
            if (!this.m_replaceWithVars.isSelected()) {
                return this.getReplaceText();
            }
            String repl = this.getReplaceText();
            Matcher replaceMatcher = Pattern.compile("(?<!\\\\)\\$(\\d+)").matcher(repl);
            while (replaceMatcher.find()) {
                int varId = Integer.parseInt(replaceMatcher.group(1));
                repl = replaceMatcher.replaceFirst(translation.substring(matches.get(varId - 1).getStart(), matches.get(varId - 1).getEnd()));
                replaceMatcher.reset(repl);
            }
            return StringUtil.replaceCase(repl, Core.getProject().getProjectProperties().getTargetLanguage().getLocale());
        }
        if (this.m_replaceWhole.isSelected()) {
            return ReplaceMatch.buildReplacedString(translation, this.buildReplacedMatches(translation, matches), this.getReplaceText());
        }
        return null;
    }

    public List<SearchMatch> buildReplacedMatches(String translation, List<SearchMatch> matches) {
        if (this.m_replaceExact.isSelected()) {
            return ReplaceMatch.buildReplacedMatches(translation, matches, this.getReplaceText());
        }
        if (this.m_replaceSegment.isSelected()) {
            return Collections.singletonList(new SearchMatch(0, this.buildReplacedString(translation, matches).length()));
        }
        if (this.m_replaceWhole.isSelected()) {
            ArrayList<SearchMatch> englobedList = new ArrayList<SearchMatch>(matches.size());
            SearchMatch global = null;
            for (SearchMatch m : matches) {
                if (global != null && m.getStart() <= global.getEnd()) continue;
                global = m.englobeWord(translation);
                englobedList.add(global);
            }
            return englobedList;
        }
        return null;
    }

    @Override
    protected boolean englobeWords() {
        return this.m_replaceWhole.isSelected();
    }

    static {
        for (String field : new String[]{"SW_SEARCH_TEXT", "SW_REPLACE_BY"}) {
            for (String mode : new String[]{REPL_EXACT, "KEYWORD", "REGEXP"}) {
                theMap.put(field + ":" + mode, new TreeSet());
            }
        }
        CoreEvents.registerProjectChangeListener(new SearchWindow.SearchesLoader<Set<String>>("ReplaceDialog", theMap));
    }
}

