/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.statistics.StatisticsSettings;
import org.omegat.util.PatternConsts;

public class TagUtil {
    private static final Comparator<Tag> TAG_COMPARATOR = new Comparator<Tag>(){

        @Override
        public int compare(Tag o1, Tag o2) {
            return o1.pos - o2.pos;
        }
    };
    public static final String TAG_SEPARATOR_SENTINEL = "\ue100";
    public static final char TEXT_REPLACEMENT = '\ue100';

    public static List<Tag> getAllTagsInSource() {
        SourceTextEntry ste = Core.getEditor().getCurrentEntry();
        return TagUtil.buildTagList(ste.getSrcText(), ste.getProtectedParts());
    }

    public static List<Tag> getAllTagsMissingFromTarget() {
        ArrayList<Tag> result = new ArrayList<Tag>();
        StringBuilder target = new StringBuilder(Core.getEditor().getCurrentTranslation());
        for (Tag tag : TagUtil.getAllTagsInSource()) {
            int pos = -1;
            pos = target.indexOf(tag.tag);
            if (pos != -1) {
                TagUtil.replaceWith(target, pos, pos + tag.tag.length(), '\ue100');
                continue;
            }
            result.add(tag);
        }
        return result;
    }

    public static List<String> getGroupedMissingTagsFromTarget() {
        String sourceText = Core.getEditor().getCurrentEntry().getSrcText();
        ArrayList<String> result = new ArrayList<String>();
        int index = -1;
        ArrayList<Tag> group = new ArrayList<Tag>();
        List<Tag> tags = TagUtil.getAllTagsMissingFromTarget();
        for (int i = 0; i < tags.size(); ++i) {
            Tag tag = tags.get(i);
            if (sourceText.startsWith(tag.tag, index)) {
                group.add(tag);
                index += tag.tag.length();
            } else {
                TagUtil.dumpGroup(group, result);
                group.clear();
                group.add(tag);
                index = sourceText.indexOf(tag.tag, index) + tag.tag.length();
            }
            if (i + 1 >= tags.size()) continue;
            Tag next = tags.get(i + 1);
            String pair = tag.getPairedTag();
            if ((pair == null || !pair.equals(next.tag)) && (tag.getType() != TagType.SINGLE || next.getType() != TagType.SINGLE)) continue;
            result.add(tag.tag + TAG_SEPARATOR_SENTINEL + next.tag);
        }
        TagUtil.dumpGroup(group, result);
        return result;
    }

    private static void dumpGroup(List<Tag> groupTags, List<String> result) {
        if (groupTags.isEmpty()) {
            return;
        }
        if (groupTags.size() > 1) {
            StringBuilder sb = new StringBuilder();
            for (Tag t : groupTags) {
                sb.append(t.tag);
            }
            result.add(sb.toString());
        }
        for (Tag t : groupTags) {
            result.add(t.tag);
        }
    }

    public static List<Tag> buildTagList(String str, ProtectedPart[] protectedParts) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (protectedParts != null) {
            boolean loopAgain;
            StringBuilder sb = new StringBuilder(str);
            do {
                loopAgain = false;
                for (ProtectedPart pp : protectedParts) {
                    int pos = -1;
                    pos = sb.indexOf(pp.getTextInSourceSegment());
                    if (pos == -1) continue;
                    tags.add(new Tag(pos, pp.getTextInSourceSegment()));
                    TagUtil.replaceWith(sb, pos, pos + pp.getTextInSourceSegment().length(), '\ue100');
                    loopAgain = true;
                }
            } while (loopAgain);
        }
        Collections.sort(tags, TAG_COMPARATOR);
        return tags;
    }

    public static void addExtraTags(List<Tag> resultList, List<Tag> srcTags, String str) {
        StringBuilder sb = new StringBuilder(str);
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        while (placeholderMatcher.find()) {
            int pos;
            if (TagUtil.containsTag(srcTags, placeholderMatcher.group(0)) || (pos = sb.indexOf(placeholderMatcher.group(0))) == -1) continue;
            resultList.add(new Tag(pos, placeholderMatcher.group(0)));
            TagUtil.replaceWith(sb, pos, pos + placeholderMatcher.group(0).length(), '\ue100');
        }
        Collections.sort(resultList, TAG_COMPARATOR);
    }

    public static boolean containsTag(List<Tag> tags, String tag) {
        if (tag == null) {
            return false;
        }
        for (Tag t : tags) {
            if (!t.tag.equals(tag)) continue;
            return true;
        }
        return false;
    }

    private static void replaceWith(StringBuilder sb, int start, int end, char replacement) {
        for (int i = start; i < end; ++i) {
            sb.setCharAt(i, replacement);
        }
    }

    public static String buildTagListForRemove(String str) {
        String res = "";
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        while (placeholderMatcher.find()) {
            res = res + placeholderMatcher.group(0);
        }
        return res;
    }

    public static String getFirstTag(String str) {
        Pattern placeholderPattern = PatternConsts.OMEGAT_TAG;
        Matcher placeholderMatcher = placeholderPattern.matcher(str);
        if (placeholderMatcher.find()) {
            return placeholderMatcher.group(0);
        }
        return null;
    }

    public static List<ProtectedPart> applyCustomProtectedParts(String source, Pattern protectedPartsPatterns, List<ProtectedPart> protectedParts) {
        ArrayList<ProtectedPart> result;
        if (protectedParts != null) {
            for (ProtectedPart pp : protectedParts) {
                source = source.replace(pp.getTextInSourceSegment(), "\b");
            }
            result = protectedParts;
        } else {
            result = new ArrayList();
        }
        Matcher placeholderMatcher = protectedPartsPatterns.matcher(source);
        while (placeholderMatcher.find()) {
            ProtectedPart pp;
            pp = new ProtectedPart();
            pp.setTextInSourceSegment(placeholderMatcher.group());
            pp.setDetailsFromSourceFile(placeholderMatcher.group());
            if (StatisticsSettings.isCountingCustomTags()) {
                pp.setReplacementWordsCountCalculation(placeholderMatcher.group());
            } else {
                pp.setReplacementWordsCountCalculation("\b");
            }
            pp.setReplacementUniquenessCalculation(placeholderMatcher.group());
            pp.setReplacementMatchCalculation(placeholderMatcher.group());
            result.add(pp);
        }
        return result;
    }

    public static String stripXmlTags(String xml) {
        return PatternConsts.OMEGAT_TAG.matcher(xml).replaceAll("");
    }

    public static class TagInfo {
        public final TagType type;
        public final String name;

        public TagInfo(String name, TagType type) {
            this.name = name;
            this.type = type;
        }
    }

    public static enum TagType {
        START,
        END,
        SINGLE;

    }

    public static class Tag {
        public final int pos;
        public final String tag;

        public Tag(int pos, String tag) {
            this.pos = pos;
            this.tag = tag;
        }

        public TagType getType() {
            Matcher m = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(this.tag);
            if (!m.find()) {
                return TagType.SINGLE;
            }
            boolean hasFrontSlash = "/".equals(m.group(1));
            boolean hasBackSlash = "/".equals(m.group(4));
            if (hasFrontSlash && !hasBackSlash) {
                return TagType.END;
            }
            if (!hasFrontSlash && !hasBackSlash) {
                return TagType.START;
            }
            return TagType.SINGLE;
        }

        public String getName() {
            Matcher m = PatternConsts.OMEGAT_TAG_DECOMPILE.matcher(this.tag);
            if (!m.find()) {
                return this.tag;
            }
            boolean hasFrontSlash = "/".equals(m.group(1));
            boolean hasBackSlash = "/".equals(m.group(4));
            if (hasFrontSlash && hasBackSlash) {
                return this.tag;
            }
            return m.group(2) + m.group(3);
        }

        public String getPairedTag() {
            switch (this.getType()) {
                case START: {
                    return "</" + this.getName() + ">";
                }
                case END: {
                    return "<" + this.getName() + ">";
                }
            }
            return null;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.pos;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Tag other = (Tag)obj;
            if (this.pos != other.pos) {
                return false;
            }
            return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
        }

        public String toString() {
            return this.tag + "@" + this.pos;
        }
    }
}

