/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.gui;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class RegexHighlightListener
implements DocumentListener {
    public static final int FLAG_ESCAPE_SEQUENCE = 1;
    public static final int FLAG_PTN_META_CHARACTER = 2;
    public static final int FLAG_JOKER_CHARACTER = 4;
    public static final int FLAG_REPLACE_VARIABLE = 8;
    public static final int FLAG_REPLACE_CASE = 16;
    public static final int FLAG_TEMPLATE_VAR = 32;
    public static final int MODE_REGEX_FIND = 3;
    public static final int MODE_REGEX_REPLACE = 24;
    public static final int MODE_NON_REGEX = 4;
    public static final int MODE_TEMPLATE_ML = 32;
    private final Highlighter h;
    private final Document doc;
    private final int mode;
    public static final Pattern PTN_ESCAPE_SEQUENCE = Pattern.compile("(?<!\\\\)\\\\.");
    public static final Pattern PTN_META_CHAR = Pattern.compile("(?<!\\\\)[\\+\\*\\?\\(\\)\\[\\]\\|\\.\\{\\}]");
    public static final Pattern PTN_JOKER_CHAR = Pattern.compile("[\\*\\?]");
    public static final Pattern PTN_REPLACE_VARIABLE = Pattern.compile("(?<!\\\\)\\$(\\d+)");
    public static final Pattern PTN_REPLACE_CASE = Pattern.compile("(?<!\\\\)\\\\[LlUuE\\\\$]");
    public static final Pattern PTN_TEMPLATE_VARIABLE = Pattern.compile("(?<!\\\\)\\$\\{[\\w\\-]+\\}");
    public static final Map<Pattern, Highlighter.HighlightPainter> PAINTERS = new HashMap<Pattern, Highlighter.HighlightPainter>();

    public RegexHighlightListener(JTextComponent comp, int mode) {
        this.doc = comp.getDocument();
        this.h = comp.getHighlighter();
        this.mode = mode;
        this.recalculate();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.recalculate();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.recalculate();
    }

    private void recalculate() {
        this.h.removeAllHighlights();
        try {
            String text = this.doc.getText(0, this.doc.getLength());
            int flag = 1;
            for (Pattern ptn : new Pattern[]{PTN_ESCAPE_SEQUENCE, PTN_META_CHAR, PTN_JOKER_CHAR, PTN_REPLACE_VARIABLE, PTN_REPLACE_CASE, PTN_TEMPLATE_VARIABLE}) {
                if ((flag & this.mode) == 0) {
                    flag *= 2;
                    continue;
                }
                flag *= 2;
                Matcher m = ptn.matcher(text);
                while (m.find()) {
                    this.h.addHighlight(m.start(), m.end(), PAINTERS.get(ptn));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        PAINTERS.put(PTN_ESCAPE_SEQUENCE, new DefaultHighlighter.DefaultHighlightPainter(Color.CYAN));
        PAINTERS.put(PTN_META_CHAR, new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE));
        PAINTERS.put(PTN_JOKER_CHAR, new DefaultHighlighter.DefaultHighlightPainter(Color.ORANGE));
        PAINTERS.put(PTN_REPLACE_VARIABLE, new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN));
        PAINTERS.put(PTN_REPLACE_CASE, new DefaultHighlighter.DefaultHighlightPainter(Color.CYAN));
        PAINTERS.put(PTN_TEMPLATE_VARIABLE, new DefaultHighlighter.DefaultHighlightPainter(Color.GREEN));
    }
}

