/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util.xml;

import java.util.HashMap;

public class DefaultEntityFilter {
    private static HashMap<Integer, String> m_charMap;
    private static HashMap<String, Integer> m_escMap;

    private static void addMapEntry(int val, String name) {
        m_escMap.put(name, val);
        m_charMap.put(val, name);
    }

    public String convertToEntity(int cp) {
        String s = m_charMap.get(cp);
        if (s != null) {
            return "&" + s + ";";
        }
        return String.valueOf(Character.toChars(cp));
    }

    public int convertToSymbol(String escapeSequence) {
        Integer cp = m_escMap.get(escapeSequence);
        if (cp != null) {
            return cp;
        }
        try {
            return Integer.valueOf(escapeSequence);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static {
        m_escMap = new HashMap(512);
        m_charMap = new HashMap(512);
        DefaultEntityFilter.addMapEntry(39, "apos");
        DefaultEntityFilter.addMapEntry(34, "quot");
        DefaultEntityFilter.addMapEntry(38, "amp");
        DefaultEntityFilter.addMapEntry(60, "lt");
        DefaultEntityFilter.addMapEntry(62, "gt");
        DefaultEntityFilter.addMapEntry(160, "nbsp");
        DefaultEntityFilter.addMapEntry(161, "iexcl");
        DefaultEntityFilter.addMapEntry(162, "cent");
        DefaultEntityFilter.addMapEntry(163, "pound");
        DefaultEntityFilter.addMapEntry(164, "curren");
        DefaultEntityFilter.addMapEntry(165, "yen");
        DefaultEntityFilter.addMapEntry(166, "brvbar");
        DefaultEntityFilter.addMapEntry(167, "sect");
        DefaultEntityFilter.addMapEntry(168, "uml");
        DefaultEntityFilter.addMapEntry(169, "copy");
        DefaultEntityFilter.addMapEntry(170, "ordf");
        DefaultEntityFilter.addMapEntry(171, "laquo");
        DefaultEntityFilter.addMapEntry(172, "not");
        DefaultEntityFilter.addMapEntry(173, "shy");
        DefaultEntityFilter.addMapEntry(174, "reg");
        DefaultEntityFilter.addMapEntry(175, "macr");
        DefaultEntityFilter.addMapEntry(176, "deg");
        DefaultEntityFilter.addMapEntry(177, "plusmn");
        DefaultEntityFilter.addMapEntry(178, "sup2");
        DefaultEntityFilter.addMapEntry(179, "sup3");
        DefaultEntityFilter.addMapEntry(180, "acute");
        DefaultEntityFilter.addMapEntry(181, "micro");
        DefaultEntityFilter.addMapEntry(182, "para");
        DefaultEntityFilter.addMapEntry(183, "middot");
        DefaultEntityFilter.addMapEntry(184, "cedil");
        DefaultEntityFilter.addMapEntry(185, "sup1");
        DefaultEntityFilter.addMapEntry(186, "ordm");
        DefaultEntityFilter.addMapEntry(187, "raquo");
        DefaultEntityFilter.addMapEntry(188, "frac14");
        DefaultEntityFilter.addMapEntry(189, "frac12");
        DefaultEntityFilter.addMapEntry(190, "frac34");
        DefaultEntityFilter.addMapEntry(191, "iquest");
        DefaultEntityFilter.addMapEntry(192, "Agrave");
        DefaultEntityFilter.addMapEntry(193, "Aacute");
        DefaultEntityFilter.addMapEntry(194, "Acirc");
        DefaultEntityFilter.addMapEntry(195, "Atilde");
        DefaultEntityFilter.addMapEntry(196, "Auml");
        DefaultEntityFilter.addMapEntry(197, "Aring");
        DefaultEntityFilter.addMapEntry(198, "AElig");
        DefaultEntityFilter.addMapEntry(199, "Ccedil");
        DefaultEntityFilter.addMapEntry(200, "Egrave");
        DefaultEntityFilter.addMapEntry(201, "Eacute");
        DefaultEntityFilter.addMapEntry(202, "Ecirc");
        DefaultEntityFilter.addMapEntry(203, "Euml");
        DefaultEntityFilter.addMapEntry(204, "Igrave");
        DefaultEntityFilter.addMapEntry(205, "Iacute");
        DefaultEntityFilter.addMapEntry(206, "Icirc");
        DefaultEntityFilter.addMapEntry(207, "Iuml");
        DefaultEntityFilter.addMapEntry(208, "ETH");
        DefaultEntityFilter.addMapEntry(209, "Ntilde");
        DefaultEntityFilter.addMapEntry(210, "Ograve");
        DefaultEntityFilter.addMapEntry(211, "Oacute");
        DefaultEntityFilter.addMapEntry(212, "Ocirc");
        DefaultEntityFilter.addMapEntry(213, "Otilde");
        DefaultEntityFilter.addMapEntry(214, "Ouml");
        DefaultEntityFilter.addMapEntry(215, "times");
        DefaultEntityFilter.addMapEntry(216, "Oslash");
        DefaultEntityFilter.addMapEntry(217, "Ugrave");
        DefaultEntityFilter.addMapEntry(218, "Uacute");
        DefaultEntityFilter.addMapEntry(219, "Ucirc");
        DefaultEntityFilter.addMapEntry(220, "Uuml");
        DefaultEntityFilter.addMapEntry(221, "Yacute");
        DefaultEntityFilter.addMapEntry(222, "THORN");
        DefaultEntityFilter.addMapEntry(223, "szlig");
        DefaultEntityFilter.addMapEntry(224, "agrave");
        DefaultEntityFilter.addMapEntry(225, "aacute");
        DefaultEntityFilter.addMapEntry(226, "acirc");
        DefaultEntityFilter.addMapEntry(227, "atilde");
        DefaultEntityFilter.addMapEntry(228, "auml");
        DefaultEntityFilter.addMapEntry(229, "aring");
        DefaultEntityFilter.addMapEntry(230, "aelig");
        DefaultEntityFilter.addMapEntry(231, "ccedil");
        DefaultEntityFilter.addMapEntry(232, "egrave");
        DefaultEntityFilter.addMapEntry(233, "eacute");
        DefaultEntityFilter.addMapEntry(234, "ecirc");
        DefaultEntityFilter.addMapEntry(235, "euml");
        DefaultEntityFilter.addMapEntry(236, "igrave");
        DefaultEntityFilter.addMapEntry(237, "iacute");
        DefaultEntityFilter.addMapEntry(238, "icirc");
        DefaultEntityFilter.addMapEntry(239, "iuml");
        DefaultEntityFilter.addMapEntry(240, "eth");
        DefaultEntityFilter.addMapEntry(241, "ntilde");
        DefaultEntityFilter.addMapEntry(242, "ograve");
        DefaultEntityFilter.addMapEntry(243, "oacute");
        DefaultEntityFilter.addMapEntry(244, "ocirc");
        DefaultEntityFilter.addMapEntry(245, "otilde");
        DefaultEntityFilter.addMapEntry(246, "ouml");
        DefaultEntityFilter.addMapEntry(247, "divide");
        DefaultEntityFilter.addMapEntry(248, "oslash");
        DefaultEntityFilter.addMapEntry(249, "ugrave");
        DefaultEntityFilter.addMapEntry(250, "uacute");
        DefaultEntityFilter.addMapEntry(251, "ucirc");
        DefaultEntityFilter.addMapEntry(252, "uuml");
        DefaultEntityFilter.addMapEntry(253, "yacute");
        DefaultEntityFilter.addMapEntry(254, "thorn");
        DefaultEntityFilter.addMapEntry(255, "yuml");
        DefaultEntityFilter.addMapEntry(338, "OElig");
        DefaultEntityFilter.addMapEntry(339, "oelig");
        DefaultEntityFilter.addMapEntry(352, "Scaron");
        DefaultEntityFilter.addMapEntry(353, "scaron");
        DefaultEntityFilter.addMapEntry(376, "Yuml");
        DefaultEntityFilter.addMapEntry(402, "fnof");
        DefaultEntityFilter.addMapEntry(710, "circ");
        DefaultEntityFilter.addMapEntry(732, "tilde");
        DefaultEntityFilter.addMapEntry(913, "Alpha");
        DefaultEntityFilter.addMapEntry(914, "Beta");
        DefaultEntityFilter.addMapEntry(915, "Gamma");
        DefaultEntityFilter.addMapEntry(916, "Delta");
        DefaultEntityFilter.addMapEntry(917, "Epsilon");
        DefaultEntityFilter.addMapEntry(918, "Zeta");
        DefaultEntityFilter.addMapEntry(919, "Eta");
        DefaultEntityFilter.addMapEntry(920, "Theta");
        DefaultEntityFilter.addMapEntry(921, "Iota");
        DefaultEntityFilter.addMapEntry(922, "Kappa");
        DefaultEntityFilter.addMapEntry(923, "Lambda");
        DefaultEntityFilter.addMapEntry(924, "Mu");
        DefaultEntityFilter.addMapEntry(925, "Nu");
        DefaultEntityFilter.addMapEntry(926, "Xi");
        DefaultEntityFilter.addMapEntry(927, "Omicron");
        DefaultEntityFilter.addMapEntry(928, "Pi");
        DefaultEntityFilter.addMapEntry(929, "Rho");
        DefaultEntityFilter.addMapEntry(931, "Sigma");
        DefaultEntityFilter.addMapEntry(932, "Tau");
        DefaultEntityFilter.addMapEntry(933, "Upsilon");
        DefaultEntityFilter.addMapEntry(934, "Phi");
        DefaultEntityFilter.addMapEntry(935, "Chi");
        DefaultEntityFilter.addMapEntry(936, "Psi");
        DefaultEntityFilter.addMapEntry(937, "Omega");
        DefaultEntityFilter.addMapEntry(945, "alpha");
        DefaultEntityFilter.addMapEntry(946, "beta");
        DefaultEntityFilter.addMapEntry(947, "gamma");
        DefaultEntityFilter.addMapEntry(948, "delta");
        DefaultEntityFilter.addMapEntry(949, "epsilon");
        DefaultEntityFilter.addMapEntry(950, "zeta");
        DefaultEntityFilter.addMapEntry(951, "eta");
        DefaultEntityFilter.addMapEntry(952, "theta");
        DefaultEntityFilter.addMapEntry(953, "iota");
        DefaultEntityFilter.addMapEntry(954, "kappa");
        DefaultEntityFilter.addMapEntry(955, "lambda");
        DefaultEntityFilter.addMapEntry(956, "mu");
        DefaultEntityFilter.addMapEntry(957, "nu");
        DefaultEntityFilter.addMapEntry(958, "xi");
        DefaultEntityFilter.addMapEntry(959, "omicron");
        DefaultEntityFilter.addMapEntry(960, "pi");
        DefaultEntityFilter.addMapEntry(961, "rho");
        DefaultEntityFilter.addMapEntry(962, "sigmaf");
        DefaultEntityFilter.addMapEntry(963, "sigma");
        DefaultEntityFilter.addMapEntry(964, "tau");
        DefaultEntityFilter.addMapEntry(965, "upsilon");
        DefaultEntityFilter.addMapEntry(966, "phi");
        DefaultEntityFilter.addMapEntry(967, "chi");
        DefaultEntityFilter.addMapEntry(968, "psi");
        DefaultEntityFilter.addMapEntry(969, "omega");
        DefaultEntityFilter.addMapEntry(977, "thetasym");
        DefaultEntityFilter.addMapEntry(978, "upsih");
        DefaultEntityFilter.addMapEntry(982, "piv");
        DefaultEntityFilter.addMapEntry(8194, "ensp");
        DefaultEntityFilter.addMapEntry(8195, "emsp");
        DefaultEntityFilter.addMapEntry(8201, "thinsp");
        DefaultEntityFilter.addMapEntry(8204, "zwnj");
        DefaultEntityFilter.addMapEntry(8205, "zwj");
        DefaultEntityFilter.addMapEntry(8206, "lrm");
        DefaultEntityFilter.addMapEntry(8207, "rlm");
        DefaultEntityFilter.addMapEntry(8211, "ndash");
        DefaultEntityFilter.addMapEntry(8212, "mdash");
        DefaultEntityFilter.addMapEntry(8216, "lsquo");
        DefaultEntityFilter.addMapEntry(8217, "rsquo");
        DefaultEntityFilter.addMapEntry(8218, "sbquo");
        DefaultEntityFilter.addMapEntry(8220, "ldquo");
        DefaultEntityFilter.addMapEntry(8221, "rdquo");
        DefaultEntityFilter.addMapEntry(8222, "bdquo");
        DefaultEntityFilter.addMapEntry(8224, "dagger");
        DefaultEntityFilter.addMapEntry(8225, "Dagger");
        DefaultEntityFilter.addMapEntry(8226, "bull");
        DefaultEntityFilter.addMapEntry(8230, "hellip");
        DefaultEntityFilter.addMapEntry(8240, "permil");
        DefaultEntityFilter.addMapEntry(8242, "prime");
        DefaultEntityFilter.addMapEntry(8243, "Prime");
        DefaultEntityFilter.addMapEntry(8249, "lsaquo");
        DefaultEntityFilter.addMapEntry(8250, "rsaquo");
        DefaultEntityFilter.addMapEntry(8254, "oline");
        DefaultEntityFilter.addMapEntry(8260, "frasl");
        DefaultEntityFilter.addMapEntry(8364, "euro");
        DefaultEntityFilter.addMapEntry(8465, "image");
        DefaultEntityFilter.addMapEntry(8472, "weierp");
        DefaultEntityFilter.addMapEntry(8476, "real");
        DefaultEntityFilter.addMapEntry(8482, "trade");
        DefaultEntityFilter.addMapEntry(8501, "alefsym");
        DefaultEntityFilter.addMapEntry(8592, "larr");
        DefaultEntityFilter.addMapEntry(8593, "uarr");
        DefaultEntityFilter.addMapEntry(8594, "rarr");
        DefaultEntityFilter.addMapEntry(8595, "darr");
        DefaultEntityFilter.addMapEntry(8596, "harr");
        DefaultEntityFilter.addMapEntry(8629, "crarr");
        DefaultEntityFilter.addMapEntry(8656, "lArr");
        DefaultEntityFilter.addMapEntry(8657, "uArr");
        DefaultEntityFilter.addMapEntry(8658, "rArr");
        DefaultEntityFilter.addMapEntry(8659, "dArr");
        DefaultEntityFilter.addMapEntry(8660, "hArr");
        DefaultEntityFilter.addMapEntry(8704, "forall");
        DefaultEntityFilter.addMapEntry(8706, "part");
        DefaultEntityFilter.addMapEntry(8707, "exist");
        DefaultEntityFilter.addMapEntry(8709, "empty");
        DefaultEntityFilter.addMapEntry(8711, "nabla");
        DefaultEntityFilter.addMapEntry(8712, "isin");
        DefaultEntityFilter.addMapEntry(8713, "notin");
        DefaultEntityFilter.addMapEntry(8715, "ni");
        DefaultEntityFilter.addMapEntry(8719, "prod");
        DefaultEntityFilter.addMapEntry(8721, "sum");
        DefaultEntityFilter.addMapEntry(8722, "minus");
        DefaultEntityFilter.addMapEntry(8727, "lowast");
        DefaultEntityFilter.addMapEntry(8730, "radic");
        DefaultEntityFilter.addMapEntry(8733, "prop");
        DefaultEntityFilter.addMapEntry(8734, "infin");
        DefaultEntityFilter.addMapEntry(8736, "ang");
        DefaultEntityFilter.addMapEntry(8743, "and");
        DefaultEntityFilter.addMapEntry(8744, "or");
        DefaultEntityFilter.addMapEntry(8745, "cap");
        DefaultEntityFilter.addMapEntry(8746, "cup");
        DefaultEntityFilter.addMapEntry(8747, "int");
        DefaultEntityFilter.addMapEntry(8756, "there4");
        DefaultEntityFilter.addMapEntry(8764, "sim");
        DefaultEntityFilter.addMapEntry(8773, "cong");
        DefaultEntityFilter.addMapEntry(8776, "asymp");
        DefaultEntityFilter.addMapEntry(8800, "ne");
        DefaultEntityFilter.addMapEntry(8801, "equiv");
        DefaultEntityFilter.addMapEntry(8804, "le");
        DefaultEntityFilter.addMapEntry(8805, "ge");
        DefaultEntityFilter.addMapEntry(8834, "sub");
        DefaultEntityFilter.addMapEntry(8835, "sup");
        DefaultEntityFilter.addMapEntry(8836, "nsub");
        DefaultEntityFilter.addMapEntry(8838, "sube");
        DefaultEntityFilter.addMapEntry(8839, "supe");
        DefaultEntityFilter.addMapEntry(8853, "oplus");
        DefaultEntityFilter.addMapEntry(8855, "otimes");
        DefaultEntityFilter.addMapEntry(8869, "perp");
        DefaultEntityFilter.addMapEntry(8901, "sdot");
        DefaultEntityFilter.addMapEntry(8968, "lceil");
        DefaultEntityFilter.addMapEntry(8969, "rceil");
        DefaultEntityFilter.addMapEntry(8970, "lfloor");
        DefaultEntityFilter.addMapEntry(8971, "rfloor");
        DefaultEntityFilter.addMapEntry(9001, "lang");
        DefaultEntityFilter.addMapEntry(9002, "rang");
        DefaultEntityFilter.addMapEntry(9674, "loz");
        DefaultEntityFilter.addMapEntry(9824, "spades");
        DefaultEntityFilter.addMapEntry(9827, "clubs");
        DefaultEntityFilter.addMapEntry(9829, "hearts");
        DefaultEntityFilter.addMapEntry(9830, "diams");
    }
}

