/*
 * Purpose:	Export source and translation segments of user selected 
 *		files into TMX-file
 * #Files:	For each source file, writes a file with same name with tmx extension added
 * #Format:	TMX v.1.4
 * #Details:	http://wp.me/p3fHEs-6g
 *
 * @author	Thomas Cordonnier (based on script from Kos Ivantsov)
 * @date	2015-02-05
 * @version	0.3
 */

import javax.swing.JOptionPane
import javax.swing.JFileChooser
import org.omegat.util.StringUtil
import org.omegat.util.Preferences
import org.omegat.util.TMXReader2
import static javax.swing.JOptionPane.*
import static org.omegat.util.Platform.*

def prop = project.projectProperties
if (!prop) {
    final def title = 'Export TMX from selected files'
    final def msg   = 'Please try again after you open a project.'
    showMessageDialog null, msg, title, INFORMATION_MESSAGE
    return
}


srcroot = new File(prop.getSourceRoot())
def sourceroot = prop.getSourceRoot().toString() as String

JFileChooser fc = new JFileChooser(
    currentDirectory: srcroot,
    dialogTitle: "Choose files to export",
    fileSelectionMode: JFileChooser.FILES_ONLY, 
    //the file filter must show also directories, in order to be able to look into them
    multiSelectionEnabled: true)

if(fc.showOpenDialog() != JFileChooser.APPROVE_OPTION) {
    console.println "Canceled"
    return
}

if (!(fc.selectedFiles =~ sourceroot.replaceAll(/\\+/, '\\\\\\\\'))) {
        console.println "Selection outside of ${prop.getSourceRoot()} folder"
        final def title = 'Wrong file(s) selected'
        final def msg   = "Files must be in ${prop.getSourceRoot()} folder."
        showMessageDialog null, msg, title, INFORMATION_MESSAGE
        return
    }

String translator = JOptionPane.showInputDialog("Translator login", Preferences.getPreferenceDefault(Preferences.TEAM_AUTHOR,
                System.getProperty("user.name")))
    
if (prop.isSentenceSegmentingEnabled())
    segmenting = TMXReader2.SEG_SENTENCE
else
    segmenting = TMXReader2.SEG_PARAGRAPH

def sourceLocale = prop.getSourceLanguage().toString()
def targetLocale = prop.getTargetLanguage().toString()

def makedirRecursive(File file) { 
    if (! file.exists()) { 
        if (! file.parentFile.exists()) makedirRecursive(file.parentFile);
        file.mkdir();
    }
}

Thread.start {
    fc.selectedFiles.each {
        def fileloc = it.toString()+'.tmx'
        fileloc = fileloc - "$sourceroot"
        def memLoc = "C:\\Users\\${System.getProperty("user.name")}\\AppData\\Local\\DGT\\OmegaT_Projects\\_PROJECT-MEMORIES\\" + fileloc
        fileloc = prop.projectRoot.toString() + "\\euramis\\" + fileloc
        exportfile = new File(fileloc)
        makedirRecursive (exportfile.parentFile)

        exportfile.write("", 'UTF-8')
        exportfile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n", 'UTF-8')
        exportfile.append("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">\n", 'UTF-8')
        exportfile.append("<tmx version=\"1.4\">\n", 'UTF-8')
        exportfile.append(" <header\n", 'UTF-8')
        exportfile.append("  creationtool=\"OmegaTScripting\"\n", 'UTF-8')
        exportfile.append("  segtype=\"" + segmenting + "\"\n", 'UTF-8')
        exportfile.append("  o-tmf=\"OmegaT TMX\"\n", 'UTF-8')
        exportfile.append("  adminlang=\"EN-US\"\n", 'UTF-8')
        exportfile.append("  srclang=\"" + sourceLocale + "\"\n", 'UTF-8')
        exportfile.append("  datatype=\"plaintext\"\n", 'UTF-8')
        exportfile.append(" >\n", 'UTF-8')
        
        exportfile.append(" </header>\n", 'UTF-8')
        exportfile.append("  <body>\n", 'UTF-8')

        def count = 0

        def fl = "${it.toString()}" - "$sourceroot" 
        console.println ("fl = " + fl)
        def matcher = (fl =~ /([A-Z0-9]+)\-([0-9]{4})\-([0-9]{5})\-([0-9]{2})\-([0-9]{2})\-/) 
        def buf = ""
        if (matcher.find()) {
            buf += "        <prop type=\"Att::Req. Serv.\">${matcher[0][1]}</prop>\n"
            buf += "        <prop type=\"Att::Year\">${matcher[0][2]}</prop>\n"
            buf += "        <prop type=\"Txt::Doc. No.\">${matcher[0][3]}${matcher[0][4]}${matcher[0][5]}</prop>\n"
            // buf += "        <prop type=\"Txt::Stored by\">${Preferences.getPreference(Preferences.TEAM_AUTHOR)}</prop>\n"
        }
        project.projectFiles.each {
            if ( "${it.filePath}" == "$fl" ) {
                it.entries.each {
                    def info = project.getTranslationInfo(it)
                    def changeId = info.changer
                    def changeDate = info.changeDate
                    def creationId = info.creator
                    def creationDate = info.creationDate
                    def alt = 'unknown'
                    if (info.isTranslated()) {
                        source = StringUtil.makeValidXML(it.srcText); source = source.replaceAll (/[\u2460-\u2469\u2776-\u277F]/, ""); 
                        target = StringUtil.makeValidXML(info.translation); target = target.replaceAll (/[\u2460-\u2469\u2776-\u277F]/, ""); 
                        exportfile.append("    <tu>\n", 'UTF-8')
                        exportfile.append(buf)
                        exportfile.append("        <prop type=\"Txt::Translator\">${translator ?: changeId ?: creationId ?: alt}</prop>\n")
                        exportfile.append("      <tuv xml:lang=\"" + sourceLocale + "\">\n", 'UTF-8')
                        exportfile.append("        <seg>$source</seg>\n", 'UTF-8')
                        exportfile.append("      </tuv>\n", 'UTF-8')
                        exportfile.append("      <tuv xml:lang=\"" + targetLocale + "\"", 'UTF-8')
                        exportfile.append(" changeid=\"${changeId ?: alt }\"", 'UTF-8')
                        exportfile.append(" changedate=\"${ changeDate > 0 ? new Date(changeDate).format("yyyyMMdd'T'HHmmss'Z'") : alt }\"", 'UTF-8')
                        exportfile.append(" creationid=\"${creationId ?: alt }\"", 'UTF-8')
                        exportfile.append(" creationdate=\"${ creationDate > 0 ? new Date(creationDate).format("yyyyMMdd'T'HHmmss'Z'") : alt }\"", 'UTF-8')
                        exportfile.append(">\n", 'UTF-8')
                        exportfile.append("        <seg>$target</seg>\n", 'UTF-8')
                        exportfile.append("      </tuv>\n", 'UTF-8')
                        exportfile.append("    </tu>\n", 'UTF-8')
                        count++;
                    }
                }		
            }
        }
        
        exportfile.append("  </body>\n", 'UTF-8')
        exportfile.append("</tmx>", 'UTF-8')
        
        def memFile = new File (memLoc)
        memFile.write (exportfile.text, 'UTF-8')
        
        console.println "$count TU's written to " + exportfile.toString()
    }

    showMessageDialog null, "Extraction finished", 'TMX file written', INFORMATION_MESSAGE


    return
}
