/* :name=Call Renumerotation		:description=Calls renumerotation for OmegaT
 * 
 * Call renumerotation from Trados to OmegaT (other direction done by compilation in the core)
 *
 * @author  Thomas Cordonnier
 * @date    2017-09-18
 * @version 0.1
 */



import org.omegat.gui.main.ProjectUICommands
import org.omegat.util.Preferences


final String extraScripts = Preferences.getPreferenceDefault(Preferences.SCRIPTS_DIRECTORY, System.getenv("OMEGAT_HOME") + File.separator + "scripts")  \
                        + File.separator + "extra" + File.separator;
                        
new File(project.projectProperties.sourceRoot).renameTo (new File(new File(project.projectProperties.sourceRoot).parentFile, "source-trados"))
new File(project.projectProperties.sourceRoot).mkdir()

def srcRoot = new File(project.projectProperties.sourceRoot)
def tradosRoot = new File(new File(project.projectProperties.sourceRoot).parentFile, "source-trados")

project.projectFiles.each {
    if (it.filePath.endsWith(".sdlxliff")) {
        def cmd = [ "C:\\PGM\\DGTApps\\Perl516\\bin\\perl",  extraScripts + "renum-to-omegat.pl" ]
        cmd << "${project.projectProperties.projectRoot}\\source-trados\\${it.filePath}"
        def target = it.filePath.substring(0, it.filePath.length() - 9) + ".renum.xlf"
        cmd << "${project.projectProperties.projectRoot}\\source\\" + target
        
        console.println "Execute ${cmd}"
        console.println cmd.execute(  ).text
    } 
    else
        new File(tradosRoot, it.filePath).renameTo (new File(srcRoot, it.filePath))
}


ProjectUICommands.projectReload()

console.println "Finished."
