result.appendSource(entry.srcText).append(": ");

def translations  = entry.getLocTerms(true)
def count = translations.size() - 1

translations.each { tra ->
    def merged = entry.getEntriesFor(tra)

	// Add target text with only origins in tooltips
	result.startTooltip("<html>" + String.join("<br>", merged.collect { // tooltip for target = all origins for this target
		it.origin.longName + " (" + it.origin.engineName + ";" + it.origin.format + ")" 
	}) + "</html>");	
	result.appendTarget(tra, entry.hasPriorities(tra));
	result.endTooltip();
	
	StringBuffer buf = new StringBuffer("<html>"); boolean hasComments = false;
	for (int i = 0; i < merged.size(); i++) {
		if ((merged[i].commentText != null) && (merged[i].commentText.length() > 0)) {
			hasComments = true;
			buf.append(merged[i].origin.longName + " (" + merged[i].origin.engineName + ";" + merged[i].origin.format + ")");
			buf.append("<br>&nbsp;&nbsp;&nbsp;<font color=purple>").append(merged[i].commentText).append("</font> <br> ");
		}
		if (i < merged.size() - 1) buf.append("<br>");
	}
	if (hasComments) {
		if (inTooltip) result.appendComment(" (" + buf.toString() + ")"); 
		else {
			result.startTooltip(buf.toString() + "</html>");
			result.appendComment(" (**)");
			result.endTooltip();
		} 
	}
		
		
	if (count-- > 0) result.append(",");
}

result.append("\n\n");