#NoTrayIcon

#include <File.au3>
#include <Array.au3>
#include <GuiConstantsEx.au3>
#include <GuiListView.au3>
#include <GuiImageList.au3>
#include <WindowsConstants.au3>
#include <StaticConstants.au3>
#include <ButtonConstants.au3>
#include <EditConstants.au3>
#include <TabConstants.au3>
#include <GuiListBox.au3>
#include <ListboxConstants.au3>
#include <Misc.au3>
#include <base64.au3>

Opt("MustDeclareVars", 0)
Opt("RunErrorsFatal", 0)
Opt("ExpandEnvStrings", 1)
Opt("ExpandVarStrings", 1)
Opt("GUICloseOnESC", 0)
Opt("GUICoordMode", 1)
Opt("TrayIcondebug", 1)

AdlibRegister("Backup", 1800000)

;Global Const $LBS_EXTENDEDSEL = 0x800

;dim $FileList, $dir
Global $OTdossier, $mainGUI, $AccessMode, $ProjectStats, $SecemStatus, $backup, $FileList, $dir, $item, $aList[1], $files, $ShortFileList, $aFileList, $line, $debug
;Dim $OTdossier[2]

$SecemStatus = 0


$dev = EnvGet("DEV")
$ver = EnvGet("VER")

$version = "(20171124)$dev$"

$prod = 1
$debug = 1

Global $username = @UserName
;global $username="machame"
;global $username="peurapa"

$verbose = 1

$prog = "OmegaT Project Wizard $version$"
$root = RRoot(@ScriptDir) ; root of OmegaT Wizard installation
$inifile = @ScriptDir & "\ProjectWizard.ini"

If $prod = 0 Then DefDir("Paths", "Dossiers", "\\dossiers-01t.dgt.cec.eu.int\dossierst")
If $prod = 1 Then DefDir("Paths", "Dossiers", "\\dossiers-01.dgt.cec.eu.int\dossiers")

DefDir("Paths", "DGThome", "%LocalAppData%\DGT")
;DefDir("Paths", "OmegaTprojetsPath", "%LocalAppData%\DGT\OmegaT_Projects")
DefDir("Paths", "OmegaTprojetsPath", "")

;debug("OmegaTprojetsPath", OmegaTprojetsPath)

;DefDir ("Paths", "OmegaT", "$root$\OmegaT")

DefDir("Paths", "Revised", "U:\COMMON\OMEGAT-REVISION\Projects-Revised")
DefDir("Paths", "ToRevise", "U:\COMMON\OMEGAT-REVISION\Projects-For-Revision")

DefDir("Paths", "Tradesk", "server")
DefDir("Paths", "Euramis", "server")

DefDir("Paths", "Euramis4Alignment", "\\euralign-01.dgt.cec.eu.int\unixbuffer$\Euramis4Alignment")

DefDir("Paths", "Dictionary_dir", "$root$\OmegaT\dictionaries\EN-EN")
DefDir("Paths", "TradeskLocalPath", "%LocalAppData%\Local Documents - no backup\DGT\Dossiers")
DefDir("Paths", "OmegaTprojetsBkpPath", "H:\CAT\OmegaT_Projects")
DefDir("Paths", "Java_home", "$root$\Java")

DefDir("Paths", "SDLStudioPath", "%LocalAppData%\Local Documents - no backup\DGT")

;DefDir("Paths", "OmegaT_home", "$root$\OmegaT")

DefFile("Wizard", "log", "http://s-dgtcairo/log.php?OT$ver$$dev$")
DefFile("Wizard", "langues", "BG:bg-bg,CS:cs-cz,DA:da-dk,DE:de-de,EL:el-gr,EN:en-gb,ES:es-es,ET:et-ee,FI:fi-fi,FR:fr-fr,GA:ga-ie,HR:hr-hr,HU:hu-hu,IT:it-it,LT:lt-lt,LV:lv-lv,MT:mt-mt,NL:nl-nl,PL:pl-pl,PT:pt-pt,RO:ro-ro,SK:sk-sk,SL:sl-sl,SV:sv-se")

;DefFile("Wizard", "OmegaTCMD", "$root$\OmegaT\OmegaT.cmd")
DefFile("Wizard", "TagWipeCMD", "$root$\bin\Tagwipe.cmd")
DefFile("Wizard", "IateCMD", "$root$\bin\Iate.cmd")
DefFile("Wizard", "IateFull", "$root$\bin\IateFull.cmd")
DefFile("Wizard", "WordsListCMD", "$root$\bin\WordsList.cmd")
DefFile("Wizard", "VLC", "C:\Program Files (x86)\VideoLAN\VLC\VLC.exe")

DefFile("Wizard", "Helpfile", "$root$\OmegaT\docs\other\DGT OMEGAT AND ITS WIZARD - QUICK GUIDE.docx")
DefFile("Wizard", "GuideFile", "$root$\OmegaT\docs\other\DGT OMEGAT AND ITS WIZARD - GUIDE.docx")
DefFile("Wizard", "Newsfile", "$root$\OmegaT\docs\other\DGT OMEGAT News.docx")
DefFile("Wizard", "OtherFiles", "$root$\OmegaT\docs")
DefFile("Wizard", "VideoFiles", "$root$\OmegaT\Videos")

DefFile("Teambase", "host", "http://teambase:8888")

; Create project directories

DefDir("Paths", "OmegaTConfig", "$OmegaTprojetsPath$\_CONFIG-PERSONAL$DEV$")

;DirCreate("%LocalAppData%\DGT\OmegaT_Projects\_PROJECT-MEMORIES")
;DirCreate("%LocalAppData%\DGT\OmegaT_Projects\_PROJECT-ARCHIVE")

$robo = 'robocopy.exe'

If $prod = 0 Then $CATproxy = "http://www.test.cc.cec/tradesk/mandesk-ws/1.0/CatClientProxyService" ; TEST !!!
If $prod = 1 Then $CATproxy = "http://www.cc.cec/tradesk/mandesk-ws/1.0/CatClientProxyService" ; PROD !!!!

Global $langList = _ArrayToString(StringRegExp($langues, "(\D\D):\D\D-\D\D", 3), "|")

$dictionary_dir = StringReplace($dictionary_dir, "\", "/")

if StringLower($log)  <> "none" then
	local $server = StringRegExp ( $log, "http://(.+?)/", 1)
;	_Msg("Contacting s-dgtcairo ...", 1)
	_Msg("Contacting " & $server[0] & " ...", 1)
	InetGet("$log$;" & "$version$,%username%;%EC_USER_DEPARTMENT%", "", 1, 0)
endif

$LocalAppData = RegRead("HKEY_CURRENT_USER\Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders", "Local AppData")

If RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Src") = '' Then RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Src", "REG_SZ", "EN")
If RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Tgt") = '' Then RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Tgt", "REG_SZ", "FR")

Main()

;
; enf of MAIN program
;


Func Main()
	Local $add, $read, $remove, $clear, $mylist, $create, $msg, $news, $other

	$mainGUI = GUICreate($prog, 990, 600) ; will create a dialog box that when displayed is centered
	;	GUISetBkColor(0x8AC1E6)
	GUISetBkColor(0x8CB4E8) ; colors from http://www.cc.cec/DGT/__QAT/TrueColorChart.htm
	;	GUICtrlSetDefBkColor(0x00CC99)

	$help = GUICtrlCreateButton("&Quick Guide", 795, 0, 75, 20); 805, 0, 75, 20) ; 905, 0, 75, 20
	GUICtrlSetBkColor($help, 0x00ff00)
	GUICtrlSetTip($help, "Project Wizard help")

	$guide = GUICtrlCreateButton("Gui&de", 720, 0, 75, 20) ;730, 0, 75, 20) ; 830, 0, 75, 20
	;	GUICtrlSetBkColor ( $other, 0x00CC99)
	GUICtrlSetTip($other, "Guide")

	$other = GUICtrlCreateButton("Other Gui&des", 645, 0, 75, 20) ;655, 0, 75, 20) ; 755, 0, 75, 20
	;	GUICtrlSetBkColor ( $other, 0x00CC99)
	GUICtrlSetTip($other, "Other documents and guides")

	$news = GUICtrlCreateButton("Ne&ws", 570, 0, 75, 20) ; 580, 0, 75, 20) ; 680, 0, 75, 20
	GUICtrlSetBkColor($news, 0xFFFF66)
	GUICtrlSetTip($news, "What's New in DGT OmegaT")

	$stats = GUICtrlCreateButton("Stats", 495, 0, 75, 20); 505, 0, 75, 20) ; 605, 0, 75, 20
	;	GUICtrlSetBkColor ( $news, 0xFFFF66)
	GUICtrlSetTip($stats, "Current Project Statistics")

	$video = GUICtrlCreateButton("Videos", 420, 0, 75, 20) ; 430, 0, 75, 20) ; 530, 0, 75, 20
	;	GUICtrlSetBkColor ( $news, 0xFFFF66)
	GUICtrlSetTip($video, "Demo Videos")

	GUICtrlCreateGroup("Documents", 10, 15, 95, 80)
	$add = GUICtrlCreateButton("&Add", 20, 30, 75, 25)
	GUICtrlSetTip($add, "Add documents to project document list")

	$remove = GUICtrlCreateButton("&Remove", 20, 60, 75, 25)
	GUICtrlSetTip($remove, "Remove documents from project document list")

	;	global $mylist = GUICtrlCreateList("", 115,  20, 865, 450)
	Global $mylist = GUICtrlCreateList("", 115, 20, 755, 450)


	Global $tagWipe = GUICtrlCreateCheckbox("Tag&Wipe", 20, 100, 75, 20)
	GUICtrlSetState($tagWipe, $GUI_CHECKED)
	GUICtrlSetTip($tagWipe, "TagWipe is applied")

	Global $iate = GUICtrlCreateCheckbox("&IATE", 20, 120, 75, 20)
	;	GUICtrlSetState ( $iate, $GUI_CHECKED )
	GUICtrlSetState($iate, RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Iate"))

	GUICtrlSetTip($iate, "Extract IATE glossary")

	Global $secem = GUICtrlCreateCheckbox("SECEM", 20, 140, 75, 20)
	GUICtrlSetState($secem, $GUI_UNCHECKED)
	GUICtrlSetTip($secem, "SECEM mode (no backup)")

	Global $xliff = GUICtrlCreateCheckbox("SDLxliff", 20, 160, 75, 20)
	GUICtrlSetState($xliff, $GUI_UNCHECKED)
	GUICtrlSetTip($xliff, "SDLxliff mode")

;
; Project
;

	GUICtrlCreateGroup("Projects", 10, 185, 95, 280)

	$create = GUICtrlCreateButton("&Create", 20, 200, 75, 25)
	GUICtrlSetTip($create, "Create project with selected documents")

	$select = GUICtrlCreateButton("&Select", 20, 230, 75, 25)
	GUICtrlSetTip($select, "Select project")

	$update = GUICtrlCreateButton("&Update", 20, 260, 75, 25)
	GUICtrlSetTip($update, "Update current project with selected documents")

	$browse = GUICtrlCreateButton("&Browse", 20, 290, 75, 25)
	GUICtrlSetTip($browse, "Browse current project")

	$teambase = GUICtrlCreateButton("Tea&m Base", 20, 350, 75, 25)
	GUICtrlSetTip($teambase, "Shared memories")

	$clear = GUICtrlCreateButton("C&lear", 20, 380, 75, 25)
	GUICtrlSetTip($clear, "Clear document selection")

	$backup = GUICtrlCreateButton("Back&Up", 20, 410, 75, 25)
	GUICtrlSetTip($backup, "Force Backup")

	;	$upload = GUICtrlCreateButton("Se&nd",		20, 430, 75, 25)
	;	GUICtrlSetTip ( $upload, "Send to Tradesk - Euramis" )

;
; Open Project with OmegaT
;
	Global $runOT = GUICtrlCreateButton("&Open", 20, 480, 75, 25)
	GUICtrlSetBkColor($runOT, 0x00CC00)
	GUICtrlSetTip($runOT, "Open selected project")

;
; Revision
;

	GUICtrlCreateGroup("REVISION", 875, 15, 110, 400, -1) ; 905, 0, 75, 20
	GUICtrlSetFont ( -1, 7.5, 600)


;	GUICtrlCreateGroup("Translator", 882, 15, 95, 200) ; 905, 0, 75, 20
	GUICtrlCreateGroup("Translator", 882, 27, 95, 190) ; 905, 0, 75, 20

;	Global $TraToRev = GUICtrlCreateButton("To Revision", 892, 30, 75, 25)
	Global $TraToRev = GUICtrlCreateButton("Send", 892, 44, 75, 25)
	GUICtrlSetTip(-1, "Send project to reviser")

;	Global $TraFromRev = GUICtrlCreateButton("Open Revision", 892, 60, 75, 25)
	Global $TraFromRev = GUICtrlCreateButton("Get", 892, 75, 75, 25)
	GUICtrlSetTip(-1, "Select a revised project")

	Global $TraBrowse = GUICtrlCreateButton("Browse", 892, 106, 75, 25)
	GUICtrlSetTip(-1, "Browse projects to be revised")

	Global $Flag1SECEM = GUICtrlCreateLabel("SECEM", 892, 160, 75, 25, $SS_CENTER)
	GUICtrlSetState ( $Flag1SECEM, $GUI_HIDE )
	GUICtrlSetColor ( -1, 0xFF0000 )
	GUICtrlSetFont ( -1, 16, 800)

	GUICtrlCreateGroup("Reviser", 882, 220, 95, 185) ; 905, 0, 75, 20

	Global $RevFromRev = GUICtrlCreateButton("Get", 892, 235, 75, 25)
	GUICtrlSetTip(-1, "Select a project to revise")

	Global $RevToRev = GUICtrlCreateButton("Send", 892, 265, 75, 25)
	GUICtrlSetTip(-1, "Send a revised project")

	Global $RevBrowse = GUICtrlCreateButton("Browse", 892, 296, 75, 25)
	GUICtrlSetTip(-1, "Browse revised projects")

	Global $Flag2SECEM = GUICtrlCreateLabel("SECEM", 892, 350, 75, 25, $SS_CENTER)
	GUICtrlSetState ( $Flag2SECEM, $GUI_HIDE )
	GUICtrlSetColor ( -1, 0xFF0000 )
	GUICtrlSetFont ( -1, 16, 800)


;
;	Finalize -> Euramis/TRAdesk
;

;	GUICtrlCreateGroup("Euramis/Tradesk", 882, 420, 95, 47)
	GUICtrlCreateGroup("Euramis/Tradesk", 875, 420, 110, 47)

	$upload = GUICtrlCreateButton("Se&nd", 892, 435, 75, 25)
	GUICtrlSetTip($upload, "Send to Tradesk - Euramis")


	GUICtrlCreateLabel("&Project", 115, 485, 50, 25)
	Global $OTdir = GUICtrlCreateInput("", 175, 480, 400, 25)
	GUICtrlSetTip($OTdir, "Project name")

	GUICtrlSetFont(-1, 11)
	GUICtrlSetData(-1, RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Last"))

	$lsrc = GUICtrlCreateLabel("&Source", 620, 485, 50, 25) ;650, 485, 50, 25)
	Global $src = GUICtrlCreateCombo("", 680, 480, 50, 225) ;710, 480, 50, 225)
	GUICtrlSetTip($src, "Select Source language")
	GUICtrlSetData($src, $langList, RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Src"))

	$ltgt = GUICtrlCreateLabel("&Target", 770, 485, 50, 25) ;820, 485, 50, 25)
	Global $tgt = GUICtrlCreateCombo("", 820, 480, 50, 225); 870, 480, 50, 225)
	GUICtrlSetTip($tgt, "Select Target language")
	GUICtrlSetData($tgt, $langList, RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Tgt"))

	Global $message = GUICtrlCreateLabel("", 10, 520, 970, 70, 0x1000)
	GUICtrlSetFont($message, 9)

	_ReduceMemory()

	GUISetState()
	_Msg("", 0)

	$msg = 0
	While 1
		;		$msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()

		Select
			Case $msg = $add
				AddFile()
			Case $msg = $clear
				ClearList()
			Case $msg = $select
				SelectPrj()
			Case $msg = $remove
				Remove()
			Case $msg = $secem
				Secem()
;			Case $msg = $xliff
;				GUICtrlSetState($tagWipe, $GUI_UNCHECKED)
			Case $msg = $iate
				RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Iate", "REG_SZ", GUICtrlRead($iate))
			Case $msg = $browse
				Browse()
			Case $msg = $runOT
				RunOT()
			Case $msg = $update
;				update()
				Create()
			Case $msg = $backup
				Backup()
			Case $msg = $create
				Create()
			Case $msg = $src
				Src()
			Case $msg = $tgt
				Tgt()
			Case $msg = $help
				Help()
			Case $msg = $guide
				Guide()
			Case $msg = $other
				Other()
			Case $msg = $video
				Video()
			Case $msg = $news
				News()
			Case $msg = $stats
				Stats()
			Case $msg = $teambase
				Shared_memory(GUICtrlRead($src), GUICtrlRead($tgt)) ;GUICtrlRead ($src) ; TeamBase wizard !!!
			Case $msg = $upload
				Upload()
			Case $msg = $TraToRev
				TraToRev()
			Case $msg = $TraFromRev
				TraFromRev()
			Case $msg = $RevFromRev
				RevFromRev()
			Case $msg = $RevToRev
				RevToRev()
			Case $msg = $TraBrowse
				TraBrowse()
			Case $msg = $Revbrowse
				RevBrowse()

			Case $msg = $GUI_EVENT_CLOSE
				ExitLoop

		EndSelect
	WEnd
EndFunc   ;==>Main

Func Src()
	Global $srcID = GUICtrlRead($src)
	$langCode = StringRegExp($langues, "(?i)($srcID$):(\D\D-\D\D)", 1)
	RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Src", "REG_SZ", $srcID)
	;	debug('src', $srcID & " - " & $langCode[1])
	Return ($langCode[1])
EndFunc   ;==>Src

Func Tgt()
	Global $tgtID = GUICtrlRead($tgt)
	$langCode = StringRegExp($langues, "(?i)($tgtID$):(\D\D-\D\D)", 1)
	RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Tgt", "REG_SZ", $tgtID)
	;	debug('tgt', $tgtID & " - " & $langCode[1])
	Return ($langCode[1])
EndFunc   ;==>Tgt

Func Backup()
	If $SecemStatus = 1 Then Return
	$project = GUICtrlRead($OTdir)
	If $project = "" Then
		GUICtrlSetData($message, "Cannot backup a 'blank' project !!!")
		Return
	EndIf
	If FileExists($OmegaTprojetsPath & "\" & $project) = 0 Then
		GUICtrlSetData($message, "Project '$project$' does not exist yet !!!")
		Return
	EndIf

	Local $srcID = GUICtrlRead($src)
	Local $tgtID = GUICtrlRead($tgt)

	Local $src = $OmegaTprojetsPath & "\" & $project
	Local $dst = $OmegaTprojetsBkpPath & "\" & $project
	$FileList = _FileListToArray("$src$\source", "*", 1)

	If UBound($FileList) = 0 Then
		GUICtrlSetData($message, "Cannot backup a 'blank' project !!!")
		Return
	EndIf

	Local $msg = 'Storing Project "$project$" to "$OmegaTprojetsBkpPath$" ...' & @CRLF
	GUICtrlSetData($message, $msg)

	$roboline = '$robo$ "$src$" "$dst$" "*.*" /np /r:10 /w:0 /e'
	RunWait($roboline, @WindowsDir, @SW_HIDE)

	$msg &= 'Project "$project$" has been stored into "$OmegaTprojetsBkpPath$" ...' & @CRLF

	GUICtrlSetData($message, $msg)
	Sleep(1000)

	$project_save = "$src$\OmegaT\project_save.tmx"

	;	debug("project_save", $project_save)
	;
	;	copy tmx to Dossiers\$dossier\OmegaT\draft_Project-$srcID-$tgtID_%username%.tmx
	;
	$msg = ""

	For $i = 1 To $FileList[0]
		Local $aDossier = StringRegExp($FileList[$i], "^(([^-]+)-(\d+-\d+))", 1)

		If @error < 1 Then
			Local $dg = $aDossier[1]
			Local $dossier = $aDossier[0]
		Else
			ContinueLoop
		EndIf

		Local $FileTo = $dossiers & "\" & $dg & "\" & $dossier & '\pret\' & $dossier & "-DRAFT-" & @UserName & ".tmx"

		;		debug($i, $project_save & @CRLF & $FileTo)

		if ( FileGetTime ( $project_save, 0, 1) <> FileGetTime ( $FileTo, 0, 1)) then
			FileCopy($project_save, $FileTo, 9) ; 1 + 8
			$msg = "$i$ - project_save.tmx saved as " & $dossier & '\pret\' & $dossier & "-DRAFT-" & @UserName & ".tmx" & @CRLF
			GUICtrlSetData($message, $msg)
		endif
	Next
	sleep (1000)
	$msg = "Backup done!"
	GUICtrlSetData($message, $msg)

EndFunc   ;==>Backup

Func SelectPrj()
	ClearList()

;	Debug("SelecPrj", $OmegaTprojetsPath)
;	Debug("SelecPrj", $DGThome)

	;	Local $var = FileSelectFolder("Choose a Project", $DGThome, 2, $OmegaTprojetsPath & "\" & RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Last"))
;	Local $var = FileSelectFolder("Choose a Project", $DGThome, 2, $OmegaTprojetsPath, $mainGUI)
	Local $var = FileSelectFolder("Choose a Project", "", 2, $OmegaTprojetsPath, $mainGUI)

	if FileExists("$var$\Omegat.project") = 0 then
		msg("$var$ is not a valid OmegaT Project !")
		return (0)
	endif

	DirCreate("$var$\Euramis\sent")
	Local $dir = StringSplit($var, '\')
	$OTdossier = $OTdir

	If StringRegExp($var, "_SECEM", 0) = 1 Then
		GUICtrlSetState($secem, $GUI_CHECKED)
		Secem()
	Else
		GUICtrlSetState($secem, $GUI_UNCHECKED)
		Secem()
	EndIf

	GUICtrlSetData($OTdir, $dir[$dir[0]])
	GUICtrlSetState($runOT, $GUI_ENABLE)
	GUICtrlSetBkColor($runOT, 0x00CC00)

	GUICtrlSetData($message, "Project has been selected, you could open it now!")

EndFunc   ;==>SelectPrj

Func Browse()

	$item = GUICtrlRead($OTdir)
	If $item = "" Then
		GUICtrlSetData($message, "Cannot browse a 'blank' project !!!")
		Return
	EndIf

	If FileExists($OmegaTprojetsPath & "\" & $item) = 0 Then
		GUICtrlSetData($message, "Project '$item$' does not exist yet !!!")
		Return
	EndIf

	GUICtrlSetData($message, 'Browse OmegaT Project "$item$" ...')

	;	Run ('explorer.exe /e,/root,"' & $OmegaTprojetsPath & "\" & $item)
	Run('explorer.exe /select,' & $OmegaTprojetsPath & "\" & $item)

EndFunc   ;==>Browse

Func RunOT()
	$item = GUICtrlRead($OTdir)
	If $item = "" Then
		GUICtrlSetData($message, "Cannot OPEN a 'blank' project !!!")
		GUICtrlSetBkColor($runOT, 0xBFBFBF)
		GUICtrlSetState($runOT, $GUI_DISABLE)
		Return
	EndIf
	If FileExists($OmegaTprojetsPath & "\" & $item) = 0 Then
		GUICtrlSetData($message, "Project '$item$' does not exist yet !!!")
		GUICtrlSetBkColor($runOT, 0xBFBFBF)
		GUICtrlSetState($runOT, $GUI_DISABLE)
		Return
	EndIf
	If FileExists($OmegaTprojetsPath & "\" & $item & "\omegat.project") = 0 Then
		GUICtrlSetData($message, "File 'omegat.project' does not exist: Create or Update before !!!")
		GUICtrlSetBkColor($runOT, 0xBFBFBF)
		GUICtrlSetState($runOT, $GUI_DISABLE)
		Return
	EndIf
	If WinExists("OmegaT-") Then
		GUICtrlSetData($message, 'OmegaT is running : close it before opening another project ...')
		Sleep(3000)
		WinActivate("OmegaT-")
		Return
	EndIf

	_Msg("Opening OmegaT Project ...", 1)
	;	Backup()

	local $use = IniRead($inifile, "Wizard", "OTmemUse", "50")
	local $OmegaTCMD =  IniRead($inifile, "Wizard", "OmegaTCMD", "")

;	var("OmegatCMD", $OmegaTCMD)

	$use = $use / 100
	Local $mem = MemGetStats()
	$mem = int($mem[1] * $use / 1024)

	EnvSet("config-dir", $OmegaTConfig)
	EnvSet("JAVA_HOME", $Java_Home)

;
;	wizard calculates available memory and starts OmegaT
;
;	if inside ProjectWizard.ini the key "OmegaTCMD" exists is taken in account
;

	if $OmegaTCMD = "" then
		$OmegaT = '"$java_home$\bin\javaw.exe" -Xmx$mem$M -Xms$mem$M -jar $root$\OmegaT\OmegaT.jar --config-dir=$OmegaTConfig$ ' & $OmegaTprojetsPath & "\" & $item
	else
		$OmegaT = $OmegaTCMD & " " & $OmegaTprojetsPath & "\" & $item
	endif

;	var("OmegaT", $omegaT)

	Run($OmegaT, "", @SW_HIDE)

	RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Last", "REG_SZ", $item)
	GUICtrlSetData($message, '')
	If WinWait("Project Files", "", 10) Then
		_Msg("Opening Project ...", 0)
		WinActivate("OmegaT-")
		WinActivate("Project Files")
	EndIf
	_Msg("Opening Project ...", 0)
	_ReduceMemory()
EndFunc   ;==>RunOT

Func Create()
	If $FileList = '' Then
		GUICtrlSetData($message, "Cannot create a project with a blank filelist !!!")
		Return
	EndIf

;var("filelist", $filelist)

	$OmegaTprojetsPath = $OmegaTprojetsPath ; needed to expand environment variables
;	Debug("$OmegaTprojetsPath",$OmegaTprojetsPath)

	$item = GUICtrlRead($OTdir)
	If $item = "" Then
		GUICtrlSetData($message, "Cannot create a 'blank' project !!!")
		;		Debug($prog, "Cannot create a 'blank' project !!!")
		Return
	EndIf
	GUICtrlSetData($message, 'Creating or updating OmegaT Project "$item$" ...')
	;	sleep(1000)
	; -------------------------
	Local $dirlist = StringSplit("dictionary euramis\sent glossary mt omegat source TagWipe target tm\auto tm\tmx2source tm\penalty-50", " ")
	For $i = 1 To $dirlist[0]
		;		GUICtrlSetData($message, "Creating " & $item & "\" & $dirlist[$i] & " ...")
		;		sleep(100)
		DirCreate($OmegaTprojetsPath & "\" & $item & "\" & $dirlist[$i])
	Next
	;	GUICtrlSetData($message, "")
	; ------------------------- Create OmegaT Project

	Local $OP = FileOpen("$OmegaTprojetsPath$\$item$\omegat.project", 2 + 8)
	FileWriteLine($OP, '<?xml version="1.0" encoding="UTF-8" standalone="yes"?>')
	FileWriteLine($OP, '<omegat>')
	FileWriteLine($OP, '  <project version="1.0">')
	FileWriteLine($OP, '    <source_dir>__DEFAULT__</source_dir>')
	FileWriteLine($OP, '    <target_dir>__DEFAULT__</target_dir>')
	FileWriteLine($OP, '    <glossary_dir>__DEFAULT__</glossary_dir>')
	FileWriteLine($OP, '    <glossary_file>__DEFAULT__</glossary_file>')
	FileWriteLine($OP, '    <dictionary_dir>__DEFAULT__</dictionary_dir>')
	FileWriteLine($OP, '    <source_lang>' & Src() & '</source_lang>')
	FileWriteLine($OP, '    <target_lang>' & Tgt() & '</target_lang>')

	if GUICtrlRead($xliff) = $GUI_CHECKED Then
		FileWriteLine($OP, '    <sentence_seg>false</sentence_seg>')
	Else
		FileWriteLine($OP, '    <sentence_seg>true</sentence_seg>')
	EndIf

	FileWriteLine($OP, '    <support_default_translations>true</support_default_translations>')
	FileWriteLine($OP, '  </project>')
	FileWriteLine($OP, '</omegat>')
	FileClose($OP)

	; ------------------------- copy OmegaT segmentation rule to "$OmegaTprojetsPath$\$item$\OmegaT"
	; ------------------------- copy of TagWipe inside project\TagWipe

	if $secem = 1 Then
		$ProjectStats = "$OmegaTprojetsPath$\_SECEM\$item$\OTStats_" & GUICtrlRead($OTdir) & ".xlsx"
	Else
		$ProjectStats = "$OmegaTprojetsPath$\$item$\OTStats_" & GUICtrlRead($OTdir) & ".xlsx"
	EndIf


;	$ProjectStats = "$OmegaTprojetsPath$\$item$\OTStats_" & GUICtrlRead($OTdir) & ".xlsx"
;	Debug("Projectstats", $ProjectStats)

	FileCopy("$root$\OmegaT\docs\Other\PERSONAL-STATISTICS.xlsx", "$ProjectStats$", 0)
	FileCopy("$root$\OmegaT\config\segmentation.conf", "$OmegaTprojetsPath$\$item$\OmegaT\segmentation.conf", 0)
;Debug($TagWipeCMD, FileExists($TagWipeCMD))
	local $err = FileCopy($TagWipeCMD, "$OmegaTprojetsPath$\$item$\TagWipe\TagWipe.cmd", 0)

;	Debug("tagwipe src", $TagWipeCMD)
;	Debug("tagwipe dst", "$OmegaTprojetsPath$\$item$\TagWipe\TagWipe.cmd")
;	Debug("tagwipe err", $err)

;	if GUICtrlRead($xliff) = $GUI_CHECKED Then
;		Update_xliff()
;	Else
		Update_office()
;	Endif

EndFunc

Func Update_office()

	local $tmp
	Local $src
	Local $dst

	$TagWipeCMD = "$OmegaTprojetsPath$\$item$\TagWipe\TagWipe.cmd"

	; ------------------------- Copy file to DGT\OmegaT_projects
	GUICtrlSetData($message, "Copying file(s) into OmegaT Projects ...")


	$dst = "$OmegaTprojetsPath$\$item$\source\"

	$dirlist = StringSplit($FileList, "|")

;	if GUICtrlRead($xliff) = $GUI_CHECKED Then
;		xliff()
;	Else

;#var( 'filelist', $filelist)
;#_ArrayDisplay($dirlist, "dirlist")
;#var('Dirlist Count', $dirlist[0])

	For $i = 1 To $dirlist[0]
		If $dirlist[$i] = '' Then ContinueLoop
		GUICtrlSetData($message, "Copying " & $dirlist[$i] & " ...")
;#		Debug('Copy file', $dirlist[$i])
		$err = FileCopy($dirlist[$i], '$dst$', 1)
	Next

	; ------------------------- Import memories
	GUICtrlSetData($message, "Importing memories ...")

	local $aFiles = _FileListToArray($dst, "*.*", 1 )
	if $aFiles = 0 then
		msg( "No files found inside $dst$")
		return
	endif


	for $i=1 to $aFiles[0]
		$tmp = StringRegExp($aFiles[$i], "(\S+?)-(\d+-\d+)-.+$", 1)
		if @error =	1 then ContinueLoop

		$src = $dossiers & "\" & $tmp[0] & "\" & $tmp[0] & "-" & $tmp[1] & "\pret"
		$dst = "$OmegaTprojetsPath$\$item$"

		; import TM

		local $roboline = '$robo$ "$src$" "$dst$\tm" "*$srcID$-$tgtID$-*.tmx" /np /r:10 /w:0 /xf *-mt.tmx draft_*.tmx'
		GUICtrlSetData($message, "Importing $srcID$-$tgtID$ tmx's ...")
		RunWait($roboline, @WindowsDir, @SW_MINIMIZE)

		; import MT

		$roboline = '$robo$ "$src$" "$dst$\mt" "*$srcID$-$tgtID$-mt.tmx" /np /r:1 /w:0'
		GUICtrlSetData($message, "Importing $srcID$-$tgtID$-mt tmx's ...")
		RunWait($roboline, @WindowsDir, @SW_MINIMIZE)

	next

	$dst = "$OmegaTprojetsPath$\$item$\source\"

	Wipe($dst)
	Iate('$dst$', "$srcID$-$tgtID$")

	Backup()
	GUICtrlSetData($message, "You can now Open Project !")
	GUICtrlSetState($runOT, $GUI_ENABLE)
	GUICtrlSetBkColor($runOT, 0x00CC00)

	GUICtrlSetData($mylist, "|")
;	GUICtrlSetData($mylist, "")

	_ReduceMemory()

EndFunc   ;==>Update

Func Update_Xliff ()

	; ------------------------- Copy file to DGT\OmegaT_projects
	GUICtrlSetData($message, "Copying file(s) into OmegaT Projects ...")

;	$dst = "$OmegaTprojetsPath$\$item$\source"
	$dst = "$OmegaTprojetsPath$\$item$\sdlxliff-ori"


	$dirlist = StringSplit($FileList, "|")

	For $i = 1 To $dirlist[0]
		If $dirlist[$i] = '' Then ContinueLoop
		local $tmp = StringRegExp($dirlist[$i], "^(.+)\\(\S+)$", 1)
		local $src = $tmp[0]
		local $doc = $tmp[1]

		GUICtrlSetData($message, "Copying " & $dirlist[$i] & " ...")
		local $roboline = '$robo$ "$src$" "$dst$" *.sdlxliff /np /r:10 /w:0'
		RunWait($roboline, @WindowsDir, @SW_MINIMIZE)

	Next

	; ------------------------- Import memories
	GUICtrlSetData($message, "Importing memories ...")

	local $aFiles = _FileListToArray($dst, "*.*", 1 )
	if $aFiles = 0 then
		msg( "No files found inside $dst$")
		return
	endif

	local $tmp;
	Local $src ;= $Dossiers & "\" & $dg[0] & "\" & $uniq[$i] & "\pret"
	Local $dst ;= $OmegaTprojetsPath & "\" & $item

	for $i=1 to $aFiles[0]
		$tmp = StringRegExp($aFiles[$i], "(\S+?)-(\d+-\d+)-.+$", 1)
		if @error = 1 then ContinueLoop

		$src = $dossiers & "\" & $tmp[0] & "\" & $tmp[0] & "-" & $tmp[1] & "\pret"
		$dst = "$OmegaTprojetsPath$\$item$"

		; import TM

		local $roboline = '$robo$ "$src$" "$dst$\tm" "*$srcID$-$tgtID$-*.tmx" /np /r:10 /w:0 /xf *-mt.tmx draft_*.tmx'
		GUICtrlSetData($message, "Importing $srcID$-$tgtID$ tmx's ...")
		RunWait($roboline, @WindowsDir, @SW_MINIMIZE)

		$roboline = '$robo$ "$src$" "$dst$\mt" "*$srcID$-$tgtID$-mt.tmx" /np /r:1 /w:0'
		GUICtrlSetData($message, "Importing $srcID$-$tgtID$-mt tmx's ...")
		RunWait($roboline, @WindowsDir, @SW_MINIMIZE)

	next

	$dst = "$OmegaTprojetsPath$\$item$\source\"
	Iate('$dst$', "$srcID$-$tgtID$")

	Backup()
	GUICtrlSetData($message, "File(s) copied into OmegaT Projects ..." & @CRLF & "You can now Open Project !")
	GUICtrlSetState($runOT, $GUI_ENABLE)
	GUICtrlSetBkColor($runOT, 0x00CC00)

	GUICtrlSetData($mylist, "|")
;	GUICtrlSetData($mylist, "")

	_ReduceMemory()

EndFunc

Func Wipe($path)
;	Debug("Wipe", $path)
	If GUICtrlRead($tagWipe) = $GUI_UNCHECKED Then Return

	Tgt()
	;	If FileExists($path) = 0 then Return
	$files = _FileListToArray($path, '*.*', 1)
	If IsArray($files) = 0 Then Return
	For $i = 1 To $files[0]
		$new = StringRegExpReplace($files[$i], "-\w\w-OR\w", "-" & $tgtID & "-TRA")
		FileMove($path & "\" & $files[$i], $path & "\" & $new, 1)
		GUICtrlSetData($message, "Wiping Tags for " & $new & " ...")
		RunWait($TagWipeCMD & ' "' & $path & "\" & $new & '"', '', @SW_HIDE)
;		Debug("wipe", $TagWipeCMD & ' "' & $path & "\" & $new & '"')
;		ClipPut($TagWipeCMD & ' "' & $path & "\" & $new & '"')
		sleep(500)
	Next
	_ReduceMemory()
EndFunc   ;==>Wipe

Func Iate($path, $lang)

;	debug("Iate", "$path$ - $lang$")

	If GUICtrlRead($iate) = $GUI_UNCHECKED Then Return
	If FileExists($path) = 0 Then Return

	GUICtrlSetData($message, "Creating IATE list of words ... ")
	RunWait('$WordsListCMD$ "$path$"', "", @SW_HIDE)

	GUICtrlSetData($message, "Creating IATE $lang$ glossary ... ")
	RunWait('$IateCMD$ "$path$..\glossary\$lang$.txt"', "", @SW_HIDE)

EndFunc ;==> Iate


Func FileExt($file)
	$tmp = StringRegExp($file, "(.+)\.(.+?)$", 1)
	Return StringLower($tmp[1])
EndFunc   ;==>FileExt

Func File($file)
	$tmp = StringRegExp($file, "(.+)\.(.+?)$", 1)
	Return StringLower($tmp[0])
EndFunc   ;==>File

Func ClearList()
	$FileList = ""
	$ShortFileList = ""
	$line = ""
	$files = ''
	$OTdossier = ""
;	$aList = ''
;	$aFileList = ''
	GUICtrlSetData($mylist, "|")
	GUICtrlSetData($message, '')
	GUICtrlSetData($OTdir, '')
	GUICtrlSetBkColor($runOT, 0xBFBFBF)
	GUICtrlSetState($runOT, $GUI_DISABLE)
EndFunc   ;==>ClearList

Func Read()
	$item = GUICtrlRead($mylist, $GUI_CHECKED)
	;	Debug("Read", $item)
	Msg($item & ' read !!!')
EndFunc   ;==>Read

Func Remove()
	$item = GUICtrlRead($mylist, $GUI_CHECKED)
	;	$filelist = StringReplace ( $filelist, $item, "", 1)
	;	$filelist = StringRegExpReplace ( $filelist, "\|+", "|")
	;	$filelist = StringRegExpReplace ( $filelist, "\|$", "")

	$ShortFileList = StringReplace($ShortFileList, $item, "", 1)
	$ShortFileList = StringRegExpReplace($ShortFileList, "\|+", "|")
	$ShortFileList = StringRegExpReplace($ShortFileList, "\|$", "")

	$FileList = StringRegExpReplace($FileList, "[^\|]+?$item$", "")
	$FileList = StringReplace($FileList, "||", "|")
	$FileList = StringRegExpReplace($FileList, "^\||\|$", "")

	GUICtrlSetData($mylist, "")
	;	GUICtrlSetData($mylist, $fileList)
	GUICtrlSetData($mylist, $ShortFileList)
	Msg($item & ' removed !!!')

	;	Debug("Filelist", $filelist)

EndFunc   ;==>Remove

Func AddFile()
	src()
	tgt()

	GUICtrlSetBkColor($runOT, 0xBFBFBF)
	GUICtrlSetState($runOT, $GUI_DISABLE)

	if GUICtrlRead($OTdir) <> "" then
		$TradeskLocalPath = $TradeskLocalPath & "\" & GUICtrlRead($OTdir)
	EndIf

;	if GUICtrlRead($xliff) = $GUI_CHECKED Then
;		xliff()
;	Else
		office()
;	Endif

EndFunc   ;==>AddFile

Func Office()
	global $files = FileOpenDialog("Choose file", $TradeskLocalPath, "Dossiers (*.docx;*.xls?;*.pptx;*.xml;*.htm?;*.sdlxliff;*.xliff)", 4)

	If $files = '' Then Return

	if StringInStr($files, "Sensitive") <> 0 Then
		GUICtrlSetState($secem, $GUI_CHECKED)
		secem()
	EndIf

;	Debug("files", $files)

	local $tmp = StringSplit ( $files, "|")
;	_ArrayDisplay($tmp, "tmp")

	if $tmp[0] = 1 then
		$alist = $tmp
		_ArrayDelete($alist, 0)
	Else
		$alist = $tmp
		for $i = 2 to $alist[0]
			if $alist[$i] = '' then ContinueLoop
			$alist[$i] = $alist[1] & "\" & $alist[$i]
		next
		_ArrayDelete($alist, 1)
		_ArrayDelete($alist, 0)
	EndIf

	local $tmp = _ArrayToString($alist, "|")

	$FileList = $FileList & $tmp & "|" ; persistent value
	$tmp = StringSplit ( $FileList, "|")
	$tmp = _ArrayUnique($tmp,1,1)
	_ArrayDelete($tmp, 0)

	$FileList =  _ArrayToString($tmp, "|")

	$shtmp = $tmp
	for $i = 0 to ubound($shtmp)-1
		if $shtmp[$i] = '' then ContinueLoop
		local $tmp = StringRegExp($shtmp[$i], ".+\\(.+?)$",1)
		$Shtmp[$i] = $tmp[0]
	next

	$ShFileList =  _ArrayToString($shtmp, "|")

	$OTdossier = StringRegExp($FileList, ".+\\(.+-\d\d\d\d-\d\d\d\d\d)-.+?\Z",1)

	if @error = 1 then
		$OTdossier = @UserName & "-" & @year & @mon & @mday & "-" &@hour & @min & @sec
		GUICtrlSetData($OTdir, $OTdossier)
;		debug("$OTdossier", $OTdossier)
	else
		if (isarray($OTdossier) = 0 ) then return
		if GUICtrlRead($OTdir) = '' then
			GUICtrlSetData($OTdir, $OTdossier[0])
			RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Last", "REG_SZ", $OTdossier[0])
		endif
	EndIf

	$line = "Added document(s): (Cancel or ESC to stop adding)" & '|' & $files
	$line = StringRegExpReplace($line, "\|+", @CRLF)
	Msg($line)

	GUICtrlSetData($mylist, "")
	GUICtrlSetData($mylist, $ShFileList)

EndFunc   ;==>AddFile


Func Xliff()
	return
EndFunc

Func _Xliff()
	local $file
	Local $prjpath = FileSelectFolder("Choose Project", "$SDLStudioPath$", 2)

	if StringInStr($prjpath, "Sensitive") <> 0 Then
		GUICtrlSetState($secem, $GUI_CHECKED)
		secem()
	EndIf

	local $prj = StringRegExp($prjPath, ".+\\(\w+-\d+-\d+)-.+?$",1)

;	Local $search = FileFindFirstFile ("$prjpath$\" & src() & "\*.sdlxliff")
	Local $search = FileFindFirstFile ("$prjpath$\" & tgt() & "\*.sdlxliff")

	$tmp = FileFindNextFile($search)
	If @error Then
		Debug($prog, "Files " & $srcID & "-" & $tgtID & " not found!")
		Return ; ExitLoop
	EndIf

; ----------------- takes target of sdlxliff file

;	$file = "$prjpath$\" & src() & "\" & $tmp
	$file = "$prjpath$\" & tgt() & "\" & $tmp
	local $doc = StringRegExp($file, ".+\\(\S+?)$",1)

	$FileList &= "|" & $file
	$FileList = StringRegExpReplace($FileList, "^|", "")

	$FileList = UniqList($FileList)

	$ShortFileList &= "|" & $doc[0]
	$ShortFileList = StringRegExpReplace($ShortFileList, "^|", "")

	$ShortFileList = UniqList($ShortFileList)

	$files &= "|" & $file
	$Files = StringRegExpReplace($Files, "^|", "")

	$OTdossier = StringRegExp($FileList, "\\(\S+?-\d{4}-\d{5})-.+?$",1)

	if (isarray($OTdossier) = 0 ) then return

	if GUICtrlRead($OTdir) = '' then
		GUICtrlSetData($OTdir, $OTdossier[0])
		RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "Last", "REG_SZ", $OTdossier[0])
	EndIf

	Local $line = "Added document: " & $file
	Msg($line)

	GUICtrlSetData($mylist, "")
	GUICtrlSetData($mylist, $ShortFileList)

EndFunc

Func UniqList($FileList)

	Local $aRecords = StringSplit ( $filelist, "|")
	_ArrayDelete($aRecords, 0)

	_ArraySort($aRecords)

	$aRecords = _ArrayUnique($aRecords)
	_ArrayDelete($aRecords, 0)

	$FileList = _ArrayToString($aRecords)

	return ($FileList)
EndFunc

Func arrayUniq($arr)
	Local $i
	Local $seen = ""
	For $i = 0 To UBound($arr) - 1
		If Not StringInStr($seen, $arr[$i]) Then $seen = $seen & $arr[$i] & "|"
	Next
	$seen = StringTrimRight($seen, 1)
	Return StringSplit($seen, '|')
EndFunc   ;==>arrayUniq

Func _ReduceMemory($i_PID = -1)

	If $i_PID <> -1 Then
		Local $ai_Handle = DllCall("kernel32.dll", 'int', 'OpenProcess', 'int', 0x1f0fff, 'int', False, 'int', $i_PID)
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', $ai_Handle[0])
		DllCall('kernel32.dll', 'int', 'CloseHandle', 'int', $ai_Handle[0])
	Else
		Local $ai_Return = DllCall("psapi.dll", 'int', 'EmptyWorkingSet', 'long', -1)
	EndIf

	Return $ai_Return[0]
EndFunc   ;==>_ReduceMemory

Func _Msg($msg, $state)
	$Width = StringLen($msg) * 8
	$Height = 40
	$left = @DesktopWidth - $Width - 10
	$top = @DesktopHeight - $Height - 40

	If $state = 1 Then
		SplashTextOn("", $msg, $Width, $Height, $left, $top, 5, "Tahoma", 11)
	Else
		SplashOff()
	EndIf
EndFunc   ;==>_Msg

Func DefDir($section, $key, $default)
	if StringLower($default) = "server" then
		Assign($key, $dir, 2)
		return
	endif

	$dir = IniRead($inifile, $section, $key, $default)
	DirCreate($dir)
	Assign($key, $dir, 2)
EndFunc   ;==>DefDir

Func DefFile($section, $key, $default)
	$dir = IniRead($inifile, $section, $key, $default)
	Assign($key, $dir, 2)
EndFunc   ;==>DefFile

Func RRoot($root)
	While 1
		$root = StringRegExpReplace($root, "^(.+)\\.+?$", "$1", 1)
		If FileExists("$root$\OmegaT") Then Return ($root)
		If StringRegExp($root, '^.:$') Then Return ("NotFound!")
	WEnd
	Exit
EndFunc   ;==>RRoot

Func Shared_memory($src, $tgt)

	If GUICtrlRead($OTdir) = "" Then
		GUICtrlSetData($message, 'Cannot connect to TeamBase a blank project!!!')
		Return
	EndIf

	Opt("GUICloseOnESC", 1)
	Local $sharedlist, $close, $msg, $shared, $choosed, $list, $array, $larray, $regex, $mode, $ownerList, $ownedList, $owned

	Local $OTdossier = GUICtrlRead($OTdir)

	$xml = BinaryToString(InetRead("$host$/list?src=$src$&tra=$tgt$", 1))
	$p = StringRegExp($xml, "name='(.+?)'", 3)

	For $i = 0 To UBound($p) - 1
		$list &= $p[$i] & "|" ;@CRLF
	Next

	$prop = FileFindFirstFile("$OmegaTprojetsPath$\$OTdossier$\tm\*.properties")
	If $prop = 1 Then
		$AccessMode = "r"
	Else
		$AccessMode = "w"
	EndIf

	$connectionList = ''
	;	$prop = FileFindFirstFile("$OmegaTprojetsPath$\$OTdossier$\tm\*.properties")
	While 1
		Local $file = FileFindNextFile($prop)
		If @error Then ExitLoop
		$file = StringReplace($file, '-$src$-$tgt$.properties', '')
		$connectionList &= $file & "|"
	WEnd
	FileClose($prop)

	$guiShared = GUICreate("TeamBase Memories", 900, 442, -1, -1, -1, -1, $mainGUI)

	GUICtrlCreateLabel("Available shared memories", 5, 5)
	$sharedlist = GUICtrlCreateList("", 3, 20, 295, 360)
	GUICtrlSetData($sharedlist, $list)
	$shared = GUICtrlCreateInput("", 5, 382, 200, 25)
	GUICtrlSetData($shared, GUICtrlRead($OTdir))
	$mode = GUICtrlCreateButton("", 209, 382, 88, 25)
	$connect = GUICtrlCreateButton("Connect &To Shared", 5, 412, 293, 25)

	If $AccessMode = "r" Then
		GUICtrlSetData($mode, "R&ead")
	Else
		GUICtrlSetData($mode, "R&ead/Write")
	EndIf

	GUICtrlCreateLabel("Shared memories linked to my project", 305, 5)
	$connectedlist = GUICtrlCreateList("", 303, 20, 295, 360)
	GUICtrlSetData($connectedlist, $connectionList)

	$connected = GUICtrlCreateInput("", 305, 382, 200, 25)
	$cmode = GUICtrlCreateButton("", 509, 382, 88, 25)
	$disconnect = GUICtrlCreateButton("Disconnect &From Shared", 305, 412, 293, 25)

	GUICtrlCreateLabel("Shared memories I own", 605, 5)
	$ownerList = GUICtrlCreateList("", 603, 20, 293, 360)
	;	GUICtrlSetData($ownerList, $ownedList)
	GUICtrlSetData($ownerList, RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "MyMemories"))
	$owned = GUICtrlCreateInput("", 605, 382, 290, 25)
	$deleteTM = GUICtrlCreateButton("Delete shared memory", 605, 412, 290, 25)

	WinSetOnTop("TeamBase Memories", "", 1)

	GUISetState(@SW_SHOW, $guiShared)

	$msg = 0
	While $msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()

		Select
			Case $msg = $mode
				If GUICtrlRead($mode) = "R&ead/Write" Then
					$AccessMode = "r"
					GUICtrlSetData($mode, "R&ead")
				Else
					$AccessMode = "w"
					GUICtrlSetData($mode, "R&ead/Write")
				EndIf

			Case $msg = $sharedlist
				GUICtrlSetData($shared, GUICtrlRead($sharedlist))

			Case $msg = $connectedlist
				GUICtrlSetData($connected, GUICtrlRead($connectedlist))
				If (ReadFile("$OmegaTprojetsPath$\$OTdossier$\tm\" & GUICtrlRead($connectedlist) & '-$src$-$tgt$.properties', "update") = 'true') Then
					GUICtrlSetData($cmode, "Re&ad/Write")
				Else
					GUICtrlSetData($cmode, "Re&ad")
				EndIf

			Case $msg = $cmode
				If GUICtrlRead($connectedlist) = '' Then ContinueLoop
				If GUICtrlRead($cmode) = "Re&ad/Write" Then
					GUICtrlSetData($cmode, "Re&ad")
					UpdateFile("$OmegaTprojetsPath$\$OTdossier$\tm\" & GUICtrlRead($connectedlist) & '-$src$-$tgt$.properties', 'update', 'false')
					GUICtrlSetData($message, 'Connected to TeamBase memory ' & GUICtrlRead($connectedlist) & ' in read access.')
				Else
					GUICtrlSetData($cmode, "Re&ad/Write")
					UpdateFile("$OmegaTprojetsPath$\$OTdossier$\tm\" & GUICtrlRead($connectedlist) & '-$src$-$tgt$.properties', 'update', 'true')
					GUICtrlSetData($message, 'Connected to TeamBase memory ' & GUICtrlRead($connectedlist) & ' in read/write access.')
				EndIf

			Case $msg = $connect
				If GUICtrlRead($shared) = "" Then ContinueLoop
				Create_TM_connector(GUICtrlRead($shared), StringUpper($src), StringUpper($tgt))
				ExitLoop

			Case $msg = $disconnect
				If GUICtrlRead($connectedlist) = "" Then ContinueLoop
				FileDelete("$OmegaTprojetsPath$\$OTdossier$\tm\" & GUICtrlRead($connectedlist) & '-$src$-$tgt$.properties')
				GUICtrlSetData($message, 'Disconnected from TeamBase memory ' & GUICtrlRead($connectedlist) & '.')
				ExitLoop

			Case $msg = $ownerList
				GUICtrlSetData($owned, GUICtrlRead($ownerList))

			Case $msg = $deleteTM
				If GUICtrlRead($owned) = "" Then ContinueLoop
				DropMyMemory(GUICtrlRead($owned))
				ExitLoop
		EndSelect
	WEnd
	Opt("GUICloseOnESC", 0)
	GUIDelete($guiShared)
	_ReduceMemory()

EndFunc   ;==>Shared_memory

Func Stats()

;	if $secem = 1 then
;			local $dst = IniRead($inifile, "Paths", "OmegaTprojetsPath", "%LocalAppData%\DGT\OmegaT_Projects") & "\_SECEM"
;	Else
;			local $dst = IniRead($inifile, "Paths", "OmegaTprojetsPath", "%LocalAppData%\DGT\OmegaT_Projects")
;	endif

	FileMove("$OmegaTprojetsPath$\" & GUICtrlRead($OTdir) & "\OTStats_*.xlsx", "$dst$\" & GUICtrlRead($OTdir) & "\OTStats_" & GUICtrlRead($OTdir) & ".xlsx",1)
	$StatFile = "$OmegaTprojetsPath$\" & GUICtrlRead($OTdir) & "\OTStats_" & GUICtrlRead($OTdir) & ".xlsx"
	;	Debug("Excel Stats", $statfile )
	ShellExecute("excel.exe", " " & " /s $StatFile$")
EndFunc   ;==>Stats

Func News()
	ShellExecute("winword.exe", "/q /m /a " & '"$NewsFile$"')
EndFunc   ;==>News

Func Guide()
	ShellExecute("winword.exe", "/q /m /a " & '"$GuideFile$"')
EndFunc   ;==>Guide

Func Help()
	ShellExecute("winword.exe", "/q /m /a " & '"$HelpFile$"')
EndFunc   ;==>Help

Func Other()
	Opt("GUICloseOnESC", 1)
	Local $FileList = _FileListToArray($OtherFiles, "*", 1)
	Local $list, $doc, $documents
	Local $pos = MouseGetPos()

	For $i = 1 To $FileList[0]
		$list &= $FileList[$i] & "|"
	Next

	$documents = GUICreate("Other Guides", 350, 230, -1, -1, -1, 1, $mainGUI)
	$n1 = GUICtrlCreateList("", 1, 1, 350, 202)
	GUICtrlSetData(-1, $list, "3 - PUBLIC-OmegaT for Beginners.pdf")
	$n2 = GUICtrlCreateButton("&View", 2, 204, 348, 25)

	GUISetState()

	$msg = 0
	While $msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()

		Select
			Case $msg = $n2
				$doc = GUICtrlRead($n1)
				ExitLoop
		EndSelect
	WEnd
	GUIDelete($documents)

	If StringInStr($doc, ".docx") Then ShellExecute("winword.exe", '/m /q /a "' & "$OtherFiles$\" & $doc & '"', "", "open", @SW_MAXIMIZE)
	If StringInStr($doc, ".pdf") Then Run("$root$\bin\SumatraPDF.exe " & '"$otherfiles$\' & $doc & '"', '', @SW_MAXIMIZE)
	If StringInStr($doc, ".html") Then ShellExecute('"' & "$Otherfiles$\" & $doc & '"')
	If StringInStr($doc, ".htm") Then ShellExecute('"' & "$Otherfiles$\" & $doc & '"')

	Opt("GUICloseOnESC", 0)
EndFunc   ;==>Other

Func Video()
	Opt("GUICloseOnESC", 1)
	Local $FileList = _FileListToArray($VideoFiles, "*.*", 1)

	Local $list, $doc, $documents
	Local $pos = MouseGetPos()

	For $i = 1 To $FileList[0]
		$list &= $FileList[$i] & "|"
	Next

	Local $documents = GUICreate("Video's", 350, 230, -1, -1, -1, 1, $mainGUI)
	Local $n1 = GUICtrlCreateList("", 1, 1, 350, 202)
	GUICtrlSetData(-1, $list, "")
	$n2 = GUICtrlCreateButton("&View", 2, 204, 348, 25)

	GUISetState()

	$msg = 0
	While $msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()

		Select
			Case $msg = $n2
				$doc = GUICtrlRead($n1)
				ExitLoop
		EndSelect
	WEnd
	GUIDelete($documents)

	Run("$vlc$ " & '"$Videofiles$\' & $doc & '"', '', @SW_MAXIMIZE)

	Opt("GUICloseOnESC", 0)
EndFunc   ;==>Video


Func Secem()
	If GUICtrlRead($secem) = $GUI_CHECKED Then
		$SecemStatus = 1
		GUICtrlSetState($backup, $GUI_DISABLE)
		GUICtrlSetState ( $Flag1SECEM, $GUI_SHOW )
		GUICtrlSetState ( $Flag2SECEM, $GUI_SHOW )
		$OmegaTprojetsPath = IniRead($inifile, "Paths", "OmegaTprojetsPath", "%LocalAppData%\DGT\OmegaT_Projects") & "\_SECEM"
	Else
		$SecemStatus = 0
		GUICtrlSetState($backup, $GUI_ENABLE)
		GUICtrlSetState ( $Flag1SECEM, $GUI_HIDE )
		GUICtrlSetState ( $Flag2SECEM, $GUI_HIDE )
		Global $OmegaTprojetsPath = IniRead($inifile, "Paths", "OmegaTprojetsPath", "%LocalAppData%\DGT\OmegaT_Projects")
	EndIf
	;	Debug("secem()", $OmegaTprojetsPath )
EndFunc   ;==>Secem


Func Upload()
	If $SecemStatus = 1 Then
		GUICtrlSetData($message, 'You are translating a SECEM project!!!')
		Return
	EndIf

	If GUICtrlRead($OTdir) = "" Then
		GUICtrlSetData($message, 'Cannot send a blank project!!!')
		Return
	EndIf

	Opt("GUICloseOnESC", 1)
	Global $FileList, $finalizeList, $guiFinalize, $add, $remove

	;	$fileList = _FileListToArray("$src$\source", "*", 1)

	$FileList = Current_Project_Files()

	Local $array = StringSplit($FileList, "|")
	Local $larray = UBound($array) - 2

	; to comment
	;	Debug("Filelist", $filelist)
	;	Debug("Filelist Count", $larray)
	GUICtrlSetData($message, $larray & ' file(s) will be sent to TRADESK')

	Local $guiUpload = GUICreate("Send to TRAdesk - Euramis", 700, 400, -1, -1)

	;	WinSetOnTop ( "Finalize", "", 1)
	GUISetState()

	$finalizeList = GUICtrlCreateList("", 115, 20, 565, 360)
	;	GUICtrlSetData($fileList, $finalizeList)
	GUICtrlSetData($finalizeList, $FileList)

	GUICtrlCreateGroup("Files List", 10, 15, 95, 110)
	Local $add = GUICtrlCreateButton("&Add", 20, 30, 75, 25)
	GUICtrlSetTip($add, "Add document to list")

	Local $remove = GUICtrlCreateButton("&Remove", 20, 60, 75, 25)
	GUICtrlSetTip($remove, "Remove selected document from list")

	Local $clear = GUICtrlCreateButton("&Clear", 20, 90, 75, 25)
	GUICtrlSetTip($clear, "Clear list of documents")

	Local $uploadTMX = GUICtrlCreateButton("To &Euramis", 20, 320, 75, 25)
	GUICtrlSetTip($uploadTMX, "Send Memories to Euramis")

	Local $uploadTRA = GUICtrlCreateButton("To &TRAdesk", 20, 350, 75, 25)
	GUICtrlSetTip($uploadTRA, "Send documents to TRAdesk")


	$msg = 0
	While $msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()
		Select
			Case $msg = $add
				Upload_Add()
			Case $msg = $remove
				Upload_Remove(GUICtrlRead($finalizeList))
			Case $msg = $clear
				Upload_Clear()
			Case $msg = $uploadTMX
				Upload_TMX()
			Case $msg = $uploadTRA
				Send_TRADESK()

			Case $msg = $GUI_EVENT_CLOSE
				ExitLoop
		EndSelect
	WEnd

	Opt("GUICloseOnESC", 0)
	$FileList = ""
	GUIDelete($guiUpload)
	_ReduceMemory()

EndFunc   ;==>Upload

Func Upload_Add()
	Local $OTdossier = GUICtrlRead($OTdir)
;	Local $FinalizePath = "$OmegaTprojetsPath$\$OTdossier$"
	Local $FinalizePath = "$OmegaTprojetsPath$\$OTdossier$\target"

	Local $file = FileOpenDialog("Choose file", $FinalizePath, "Dossiers (*.*)", 1)
	While ($file <> "")

		If $file = '' Then ExitLoop
		Local $temp = StringRegExp($file, "(^.+)\\.+$", 1)
		If @error = 0 Then $FinalizePath = $temp[0]

		$file = StringReplace($file, $OmegaTprojetsPath & "\", "")

		$FileList &= "|$file$"
		$FileList = StringReplace($FileList, "||", "|")
		GUICtrlSetData($finalizeList, "")
		GUICtrlSetData($finalizeList, $FileList)
		$file = FileOpenDialog("Choose file", $FinalizePath, "Dossiers (*.*)", 1)

	WEnd

EndFunc   ;==>Upload_Add

Func Upload_Remove($file)
	$FileList = StringReplace($FileList, $file, "")
	$FileList = StringReplace($FileList, "||", "|")
	GUICtrlSetData($finalizeList, "")
	GUICtrlSetData($finalizeList, $FileList)

	Local $array = StringSplit($FileList, "|")
	Local $larray = UBound($array) - 2

	GUICtrlSetData($message, $larray & ' file(s) will be sent to TRADESK')

EndFunc   ;==>Upload_Remove

Func Upload_Clear()
	$filelist = ""
	GUICtrlSetData($finalizeList, "")
EndFunc   ;==>Upload_Clear

Func Upload_TMX()

	Debug("Upload_TMX", $Euramis4Alignment)
;	return(0)

	Local $OTdossier = GUICtrlRead($OTdir)
;	Local $Euramis4Alignment = "\\euralign-01.dgt.cec.eu.int\unixbuffer$\Euramis4Alignment"
	Local $Euramis4Alignment = IniRead($inifile, "paths", "Euramis4Alignment","")
	Local $search = FileFindFirstFile("$OmegaTprojetsPath$\$OTdossier$\Euramis\*.tmx")
	Local $count = 0

	Local $srcID = GUICtrlRead($src)
	Local $tgtID = GUICtrlRead($tgt)

	local $username = StringUpper ( @UserName )

	if IniRead($inifile, "wizard", "EuramisProject", "0") = 1 Then
		local $project = GUICtrlRead($OTdir)
		$Euramis4Alignment = "$Euramis4Alignment$\$project$"
	EndIf


	While 1
		Local $file = FileFindNextFile($search)
		If @error Then ExitLoop

		local $tmp = StringRegExp ( $file, "(\w+)-(\d+)-(\d+)-(\d\d)-(\d\d)-(\w\w-\w\w\w-\d\d)" , 1)
		local $tmp1 = StringRegExp ( $file, "((((\w+)-\d+-\d+)-\d\d-\d\d)-\w\w-\w\w\w-\d\d)" , 1)

		local $EuramisFile = "$Euramis4Alignment$\SAVE_$username$_" & $tmp[0] & "-" & $tmp[1] & "-" & $tmp[2] & $tmp[3] & $tmp[4] & "-$srcID$-$tgtID$-EXP.tmx"

;		local $EuramisFile = "$Euramis4Alignment$\SAVE_$username$_" & $tmp[0] & "-" & $tmp[1] & "-" & $tmp[2] & $tmp[3] & $tmp[4] & "-$srcID$-$tgtID$-EXP.tmx"
;		local $EuramisFile = "$Euramis4Alignment$\TEST_SAVE_$username$_" & $tmp[0] & "-" & $tmp[1] & "-" & $tmp[2] & $tmp[3] & $tmp[4] & "-$srcID$-$tgtID$-EXP.tmx"

;		Debug("EuramisFile", $EuramisFile)
;		return(0)

		local $DossierTmx = $Dossiers & "\" & $tmp1[3] & "\" & $tmp1[2] & "\final\" & $tmp1[0] & "-$srcID$-$tgtID$.tmx"
		local $PretFile =  $Dossiers & "\" & $tmp1[3] & "\" & $tmp1[2] & "\pret\" & $tmp1[0] & "-$srcID$-$tgtID$.tmx"

		if $tmp[0] = "" then
			local $EuramisFile = "$Euramis4Alignment$\SAVE_$username$_$file$"

			local $DossierTmx = $Dossiers & "\final\" & $file
			local $PretFile =  $Dossiers & "\pret\" & $file

		EndIf

	Debug("Upload_TMX:EuramisFile", $EuramisFile)
	Debug("Upload_TMX:DossierTmx", $DossierTmx)
	Debug("Upload_TMX:PretFile", $PretFile)



		filecopy("$OmegaTprojetsPath$\$OTdossier$\Euramis\$file$", $EuramisFile, 1 + 8)

		filecopy("$OmegaTprojetsPath$\$OTdossier$\Euramis\$file$", $DossierTmx, 1 + 8)
		filecopy("$OmegaTprojetsPath$\$OTdossier$\Euramis\$file$", $PretFile, 1 + 8)

		FileMove("$OmegaTprojetsPath$\$OTdossier$\Euramis\$file$", "$OmegaTprojetsPath$\$OTdossier$\Euramis\Sent", 1)

 		msg($file & ' sent to Euramis')
		$count += 1
	WEnd
	FileClose($search)

	msg($count & ' file(s) sent to Euramis')

EndFunc   ;==>Upload_TMX

Func Send_TRADESK()

	If $FileList = "" Then Return

	Local $count = 0
	Local $array = StringSplit($FileList, "|")
	Local $larray = UBound($array) - 1

	For $i = 1 To $larray
		If $array[$i] = '' Then ContinueLoop

		Local $file = $array[$i]
		Local $temp = StringRegExp($array[$i], "\\.+\\(.+?)$", 1)
		Local $filename = $temp[0]

		$count += 1

		if StringLower($Tradesk) <> "server" then
			local $doc = $filename
			Local $project = GUICtrlRead($OTdir)
			local $temp = StringRegExp($doc, "^(.+-\d{4}-\d{5})-", 1)
			Local $DestPrj = $temp[0]
;			Debug("dest", $destprj)

			if FileExists ( "$Tradesk$\$DestPrj$\$filename$" ) then
				local $answ = MsgBox(4 + 48, "Ext: Send to TRADESK", $filename & @CRLF & "is already present in TRADESK!" & @CRLF & "Would you replace it?")
				if $answ = 6 then
					filecopy($OmegaTprojetsPath & "\$project$\target\" & $doc, "$Tradesk$\$DestPrj$\", 8+1)
					GUICtrlSetData($message, $filename & ' has been replaced into TRADESK')
				Else
					GUICtrlSetData($message, $filename & ' has not been replaced into TRADESK')
				EndIf
			else
				filecopy($OmegaTprojetsPath & "\$project$\target\" & $doc, "$Tradesk$\$DestPrj$\", 8+1)
				GUICtrlSetData($message, $filename & ' has been added into TRADESK')
				endif
			ContinueLoop
		EndIf


		If (GetDocUID($filename) = 1) Then
			;			Debug('docUID - test', GetDocUID($filename))
			;			Debug('Add', $filename)
			GUICtrlSetData($message, "Adding " & $filename & ' to TRADESK')
			TradeskAdd($file)
			;			GUICtrlSetData($message, $filename & ' has been added to TRADESK')
		Else
			;			Debug('Replace', $filename)
			GUICtrlSetData($message, "Replacing " & $filename & ' into TRADESK')
			TradeskReplace($file)
			;			GUICtrlSetData($message, $filename & ' has been replaced into TRADESK')
		EndIf
	Next
	;	GUICtrlSetData($message, $count & ' file(s) has(have) been sent to TRADESK')

EndFunc   ;==>Send_TRADESK

Func Current_Project_Files()
	Local $answer
	Local $OTdossier = GUICtrlRead($OTdir)
	Local $search = FileFindFirstFile("$OmegaTprojetsPath$\$OTdossier$\Target\*.*")

	While 1
		Local $file = FileFindNextFile($search)
		If @error Then ExitLoop
		$file = "$OTdossier$\Target\$file$"
		$answer &= $file & "|"
	WEnd
	FileClose($search)
	Return ($answer)

EndFunc   ;==>Current_Project_Files

Func TradeskAdd($doc)

	Local $array = StringRegExp($doc, "\\.+\\(.+?)$", 1)
	Local $filename = $array[0]
	Local $project = GUICtrlRead($OTdir)

;	if StringLower($Tradesk) <> "server" then
;		if FileExists ( "$Tradesk$\$project$\$filename$" ) then
;			local $answ = MsgBox(4 + 48, "Ext: Send to TRADESK", $filename & @CRLF & "is already present in TRADESK!" & @CRLF & "Would you replace it?")
;			if $answ = 6 then
;				filecopy($OmegaTprojetsPath & "\" & $doc, "$Tradesk$\$project$\", 8+1)
;				GUICtrlSetData($message, $filename & ' has been replaced into TRADESK')
;			Else
;				GUICtrlSetData($message, $filename & ' has not been replaced into TRADESK')
;			EndIf
;		else
;			filecopy($OmegaTprojetsPath & "\" & $doc, "$Tradesk$\$project$\", 8+1)
;			GUICtrlSetData($message, $filename & ' has been added into TRADESK')
;		endif
;		Return (0)
;	EndIf

	Local $file = FileOpen($OmegaTprojetsPath & "\" & $doc, 16)

	Local $filecontent = FileRead($file, -1)
	Local $filesize = @extended
	Local $content = _base64Encode($filecontent, $filesize)
	FileClose($file)

	Local $array = StringRegExp($doc, "(\w+)-(\d{4})-(\d{5})-(\d\d)-(\d\d)-(\w\w)-(\w+)-(\d\d)\.(\w+)", 1)

	If (@error > 0) Then
		GUICtrlSetData($message, $filename & ' is not a standard DGT filename!')
		MsgBox(0, "Func TradeskAdd", $filename & ' is not a standard DGT filename!')
		Return (1)
	EndIf

	;Debug("Func TradeskAdd-2", $doc)

	Local $requester = $array[0]
	Local $year = $array[1]
	Local $number = $array[2]
	Local $version = $array[3]
	Local $part = $array[4]
	Local $language = $array[5]
	Local $documentType = $array[6]
	Local $subpart = $array[7]
	Local $format = $array[8]

	; Create the SOAP Envelope
	Local $strEnvelope = '' & _
			'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:eu="http://eu.europa.ec.dgt.desktops/">' & @CRLF & _
			'   <soapenv:Header/>' & @CRLF & _
			'   <soapenv:Body>' & @CRLF & _
			'      <eu:addDocument>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <filename>$filename$</filename>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <description></description>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <requestReference>' & @CRLF & _
			'            <number>$number$</number>' & @CRLF & _
			'            <part>$part$</part>' & @CRLF & _
			'            <!--Optional:-->' & @CRLF & _
			'            <requestType>$documentType$</requestType>' & @CRLF & _
			'            <!--Optional:-->' & @CRLF & _
			'            <requester>$requester$</requester>' & @CRLF & _
			'            <year>$year$</year>' & @CRLF & _
			'         </requestReference>' & @CRLF & _
			'         <version>$version$</version>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <documentType>$documentType$</documentType>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <language>$language$</language>' & @CRLF & _
			'         <subpart>$subpart$</subpart>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <format>$format$</format>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <file>$content$</file>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <username>$username$</username>' & @CRLF & _
			'      </eu:addDocument>' & @CRLF & _
			'   </soapenv:Body>' & @CRLF & _
			'</soapenv:Envelope>'

	;Debug("ADD Envelope", $strEnvelope)

	$objHTTP = ObjCreate("Microsoft.XMLHTTP")
	$objReturn = ObjCreate("Msxml2.DOMdocument.3.0")

	$objHTTP.open("post", $CATproxy, False)

	; Set a standard SOAP/ XML header for the content-type
	$objHTTP.setRequestHeader("Content-Type", "text/xml; charset=utf-8")

	; Make the SOAP call
	$objHTTP.send($strEnvelope)

	; Get the return envelope
	$strReturn = $objHTTP.responseText

	;Debug("Tradesk-Add reponse", $strReturn)
	;ClipPut($strReturn)

	If StringInStr($strReturn, "<faultstring>The document already exists</faultstring>") <> 0 Then
		GUICtrlSetData($message, $filename & ' already exists')
		Return (1)
	ElseIf StringInStr($strReturn, "<faultstring>You are not authorized to perform this action</faultstring>") <> 0 Then
		GUICtrlSetData($message, 'You are not authorized to perform this action')
		Return (1)
	Else
		GUICtrlSetData($message, $filename & ' has been added')
		Return (0)
	EndIf

EndFunc   ;==>TradeskAdd

Func TradeskReplace($doc)

	Local $array = StringRegExp($doc, "\\.+\\(.+?)$", 1)
	Local $filename = $array[0]

;	if StringLower($Tradesk) <> "server" then
;		if FileExists ( "$Tradesk$\$project$\$filename$" ) then
;			local $answ = MsgBox(4 + 48, "Ext: Send to TRADESK", $filename & @CRLF & "is already present in TRADESK!" & @CRLF & "Would you replace it?")
;			if $answ = 6 then
;				filecopy($OmegaTprojetsPath & "\" & $doc, "$Tradesk$\$project$\", 8+1)
;				GUICtrlSetData($message, $filename & ' has been replaced into TRADESK')
;			Else
;				GUICtrlSetData($message, $filename & ' has not been replaced into TRADESK')
;			EndIf
;		else
;			filecopy($OmegaTprojetsPath & "\" & $doc, "$Tradesk$\$project$\", 8+1)
;			GUICtrlSetData($message, $filename & ' has been added into TRADESK')
;		endif
;		Return (0)
;	EndIf


	MsgBox(4 + 48, "Send to TRADESK", $filename & @CRLF & "is already present in TRADESK!" & @CRLF & "Would you replace it?")
	local $answ = MsgBox(4 + 48, "Send to TRADESK", $filename & @CRLF & "is already present in TRADESK!" & @CRLF & "Would you replace it?")
	if $answ = 7 then return(0)

	Local $file = FileOpen($OmegaTprojetsPath & "\" & $doc, 16)

	Local $filecontent = FileRead($file, -1)
	Local $filesize = @extended
	Local $content = _base64Encode($filecontent, $filesize)
	FileClose($file)

	Local $docUID = GetDocUID($filename)

	$strEnvelope = '' & _
			'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:eu="http://eu.europa.ec.dgt.desktops/">' & @CRLF & _
			'   <soapenv:Header/>' & @CRLF & _
			'   <soapenv:Body>' & @CRLF & _
			'      <eu:replaceDocument>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <documentUID>$docUID$</documentUID>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <filename>$filename$</filename>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <file>$content$</file>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <username>$username$</username>' & @CRLF & _
			'      </eu:replaceDocument>' & @CRLF & _
			'   </soapenv:Body>' & @CRLF & _
			'</soapenv:Envelope>'

	$objHTTP = ObjCreate("Microsoft.XMLHTTP")
	$objReturn = ObjCreate("Msxml2.DOMdocument.3.0")

	;prod
	$objHTTP.open("post", $CATproxy, False)

	; Set a standard SOAP/ XML header for the content-type
	$objHTTP.setRequestHeader("Content-Type", "text/xml; charset=utf-8")

	; Make the SOAP call
	$objHTTP.send($strEnvelope)

	; Get the return envelope
	$strReturn = $objHTTP.responseText

	;Debug('Envelope', $strEnvelope)
	;Debug('Envelope', $strReturn)

	If StringInStr($strReturn, "<faultstring>") > 0 Then
		GUICtrlSetData($message, $filename & ' could not be replaced')
		Return (1)
	Else
		GUICtrlSetData($message, $filename & ' has been replaced')
		Return (0)
	EndIf

EndFunc   ;==>TradeskReplace

Func GetDocUID($doc)

	;Debug("Funv GetDocUID", $doc)

	Local $array = StringRegExp($doc, "^(\w+)-(\d{4})-(\d{5})-(\d\d)-(\d\d)-(\w\w)-(\w+)-(\d\d)\.(\w+)", 1)

	If (@error > 0) Then
		;	Debug("Funv GetDocUID", $doc)
		Return (1)
	EndIf

	Local $requester = $array[0]
	Local $year = $array[1]
	Local $number = $array[2]
	Local $version = $array[3]
	Local $part = $array[4]
	Local $language = $array[5]
	Local $documentType = $array[6]
	Local $subpart = $array[7]
	Local $format = $array[8]

	; Create the SOAP Envelope
	Local $strEnvelope = '' & _
			'<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/" xmlns:eu="http://eu.europa.ec.dgt.desktops/">' & @CRLF & _
			'   <soapenv:Header/>' & @CRLF & _
			'   <soapenv:Body>' & @CRLF & _
			'      <eu:searchDocuments>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <requestReference>' & @CRLF & _
			'            <number>$number$</number>' & @CRLF & _
			'            <part>$part$</part>' & @CRLF & _
			'            <!--Optional:-->' & @CRLF & _
			'            <requestType/>' & @CRLF & _
			'            <!--Optional:-->' & @CRLF & _
			'            <requester>$requester$</requester>' & @CRLF & _
			'            <year>$year$</year>' & @CRLF & _
			'         </requestReference>' & @CRLF & _
			'         <version>$version$</version>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <documentType>$documentType$</documentType>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <language>$language$</language>' & @CRLF & _
			'         <!--Optional:-->' & @CRLF & _
			'         <subpart>$subpart$</subpart>' & @CRLF & _
			'      </eu:searchDocuments>' & @CRLF & _
			'   </soapenv:Body>' & @CRLF & _
			'</soapenv:Envelope>'

	;Debug('Envelope', $strEnvelope)

	$objHTTP = ObjCreate("Microsoft.XMLHTTP")
	$objReturn = ObjCreate("Msxml2.DOMdocument.3.0")

	;prod
	$objHTTP.open("post", $CATproxy, False)

	; Set a standard SOAP/ XML header for the content-type
	$objHTTP.setRequestHeader("Content-Type", "text/xml; charset=utf-8")

	; Make the SOAP call
	$objHTTP.send($strEnvelope)

	; Get the return envelope
	$strReturn = $objHTTP.responseText

	;Debug('docUID Reponse Text', $strReturn)

	Local $array = StringRegExp($strReturn, "<docUID>([^<]+)</docUID>", 1)
	If (@error = 1) Then
		Return (1)
	Else
		Local $docUID = $array[0]
		;	Debug('docUID :', $docUID)
		Return ($docUID)
	EndIf

EndFunc   ;==>GetDocUID

Func verbose($msg)
	If $verbose Then MsgBox(0, "Verbose", $msg)
EndFunc   ;==>verbose

Func format($str)
	StringFormat()
EndFunc   ;==>format

Func UpdateFile($file, $key, $val)
	If exist($file) = -1 Then Return
	$hFile = FileOpen($file, 256)
	$Text = FileRead($hFile, FileGetSize($file))
	FileClose($hFile)

	$Text = StringRegExpReplace($Text, "\b$key$\s*=\s*.+\b", "$key$=$val$")

	$hFile = FileOpen($file, 256 + 2)
	FileWrite($hFile, $Text)
	FileClose($hFile)
EndFunc   ;==>UpdateFile

Func ReadFile($file, $key)
	If exist($file) = -1 Then Return
	$Text = FileRead($file, FileGetSize($file))
	$val = StringRegExp($Text, "$key$\s*=\s*(\S+)", 1)
	Return ($val[0])
EndFunc   ;==>ReadFile

Func exist($file)
	If FileGetSize($file) = 0 Then
		;		MsgBox(48, 'Error', '$file$ do not exist')
		Return (-1)
	EndIf
EndFunc   ;==>exist

Func Create_TM_connector($prj, $src, $tgt)

	Local $OTdossier = GUICtrlRead($OTdir)

	;	Debug("Create_TM_connector",  "$prj$, $src$, $tgt$")

	;
	; 	keep=AUT !!!!
	;

	;	$get = "$host$/createdb?src=$src$&tra=$tgt$&projname=$prj$&struct=free&keep=all&prop=on"
	$get = "$host$/createdb?src=$src$&tra=$tgt$&projname=$prj$&struct=free&keep=AUT&prop=on"

	$oHTTP = ObjCreate("winhttp.winhttprequest.5.1")
	$oHTTP.Open("GET", $get, False)

	$oHTTP.Send()
	$oReceived = $oHTTP.ResponseText
	$oStatusCode = $oHTTP.Status


	If StringRegExp($oReceived, "already exist") = 1 Then
		;		Debug("OmegaT Wizard", "Error table $prj$ already exist")
		Get_TM($prj, $src, $tgt)
		;		exit
	EndIf

	If StringRegExp($oReceived, "OK") = 1 Then
		Get_TM($prj, $src, $tgt)
		MyMemory($prj, $src, $tgt)
		;		exit
	EndIf

	If StringRegExp($oReceived, "ERROR") = 1 Then
		;		Debug("OmegaT Wizard", "Error creating table $prj$")
		;		exit
	EndIf

EndFunc   ;==>Create_TM_connector

Func Get_TM($prj, $src, $tra)

	Local $OTdossier = GUICtrlRead($OTdir)

	$get = "$host$/omegat?projname=$prj$&srcLang=$src$&traLang=$tra$"
	$file = "$OmegaTprojetsPath$\$OTdossier$\tm\$prj$-$src$-$tra$.properties"

	Local $down = InetGet($get, $file, 1)

	InetClose($down)
	;	Debug("down", $down)
	Return ($down)
EndFunc   ;==>Get_TM

Func MyMemory($prj, $src, $tra)

	Local $sMyMemories = RegRead("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "MyMemories")
	If $sMyMemories = "" Then
		$sMyMemories &= "$prj$-$src$-$tra$"
	Else
		$sMyMemories &= "|" & "$prj$-$src$-$tra$"
	EndIf

	Local $aMyMemories = StringSplit($sMyMemories, "|")
	Local $aUnique = _ArrayUnique($aMyMemories, 0, 1, 0, 0)

	$sMyMemories = ""
	For $i = 0 To UBound($aUnique) - 1
		$sMyMemories &= $aUnique[$i]
		If ($i < UBound($aUnique) - 1) Then $sMyMemories &= "|"
	Next

	RegWrite("HKEY_CURRENT_USER\Software\DGT\OmegaT ProjectWizard", "MyMemories", "REG_SZ", $sMyMemories)
	Return ($sMyMemories)

EndFunc   ;==>MyMemory

Func DropMyMemory($memory)
	Local $aStrings = StringRegExp($memory, "^(.+)-(\w\w)-(\w\w)$", 1)

	Local $projname = $aStrings[0]
	Local $src = $aStrings[1]
	Local $tra = $aStrings[2]

	;	local $req = "$host$dropdb?src=$src$&tra=$tra$&projname=$projname$"

	Local $req = "$host$\" & IniRead($inifile, "teambase", "dropdb", "")

	MsgBox(0, "DropMyMemory", $req)
	;	Debug("DropMyMemory", "dossier: $dossier$" & @CRLF & "src: $src$" & @CRLF & "tra: $tra$")

EndFunc   ;==>DropMyMemory

Func OmegaT_TM($memory)
	Local $aStrings = StringRegExp($memory, "^(.+)-(\w\w)-(\w\w)$", 1)

	Local $projname = $aStrings[0]
	Local $src = $aStrings[1]
	Local $tra = $aStrings[2]

	;	local $req = "$host$dropdb?src=$src$&tra=$tra$&projname=$projname$"

	Local $req = "$host$\" & IniRead($inifile, "teambase", "OmegaT-TM", "")

	MsgBox(0, "OmegaT-TM", $req)


EndFunc   ;==>OmegaT_TM


Func TraToRev()
	local $filelist, $selected, $sel, $aSel, $i, $path, $target_files

	local $prj = GUICtrlRead($OTdir)
	local $dir = $prj & "_For-Revision-" & @UserName

	local $src = $OmegaTprojetsPath & "\" & $prj
	local $dst = $ToRevise

;Debug("src", $src)
;Debug("dst", $dst)

	if $SecemStatus = 1 then
;		Debug("TraToRev", $src)
		local $ToRevise = "Select Destination Folder"
		if FileExists("$src$\omegat.project") = 0 then
			msg("SECEM project do not exist!")
			return(0)
		EndIf
	EndIf

;Debug("TraToRev", "$src$\omegat.project" )
	if FileReadLine ( "$src$\omegat.project" ) = "" then
		msg("Cannot send for Revision the opened $prj$ project!")
		beep()
		return(0)
	EndIf

	local $OmegaTexport = "$src$\export-omegat"
	local $ProjectSave = "$src$\omegat"

	DirCreate($OmegaTexport) ;

; count target files,
; if only one in list create export-omegat and put inside $src\OmegaT\project_save.tmx as the only_file.tmx
;

	$target_files = _FileListToArray("$src$\Target", "*.*", 1)

	if ($target_files = 0) then
;		Debug("Target array", "no files")
		msg("No Target Files")
		return (0)
	endif

	if ($target_files <> 0) then
;		Debug("$src$\Target",  $target_files[0])
		if ($target_files[0] = 1) Then
			local $file = $target_files[1]
;			Debug("file_ext", $file)
			$file = StringRegExpReplace ( $file, "\.\w+?$", "")
;			Debug("file_noext", $file)
;			Debug("$src$\OmegaT\project_save.tmx", FileExists("$src$\OmegaT\project_save.tmx"))
			if FileExists("$src$\OmegaT\project_save.tmx") = 1 then
				filecopy ("$src$\OmegaT\project_save.tmx", "$src$\export-omegat\$file$.tmx", 1)
			Else
				msg("project_save.tmx do not exist, you have never saved your project")
				return(0)
			EndIf
		EndIf
	endif

	local $aOmegaTexport = _FileListToArray ( $OmegaTexport, "*.tmx", 1)
	if @error Then
		msg("Omegat-export not found!")
		return(0)
	EndIf

	local $aProjectSave = _FileListToArray ( $ProjectSave, "*.tmx", 1)
	if @error Then
		msg("Omegat_save not found!")
		return(0)
	EndIf


	local $SendRevGUI = GUICreate("Send For Revision",740, 330, -1, -1, -1 , -1, $mainGUI)
	GUISetBkColor(0x8CB4E8)

	local $iDir  = GUICtrlCreateInput($dir, 20, 20, 700, 25)
	GUICtrlSetFont(-1, 9)
	GUICtrlSetBkColor (-1, 0xCCCCCC )
	GUICtrlSetStyle(-1, $BS_LEFT + $BS_FLAT)
	GUICtrlSetTip(-1, "Revision Project Name")

	local $bDir = GUICtrlCreateButton ( $dst, 20, 50, 700, 25, -1, -1)
;	GUICtrlSetBkColor (-1, 0xffffff )
	GUICtrlSetFont(-1, 9)
	GUICtrlSetStyle(-1, $BS_LEFT + $BS_FLAT)
	GUICtrlSetTip(-1, "Click to change Destination Folder")

; set to Project_save.tmx

	local $sTMX = 1
	local $aArray = $aProjectSave
	local $tmxDir = $ProjectSave

	if FileExists($OmegaTexport) > 0 then
		local $sTMX = 0
		$aArray = $aOmegaTexport
		local $tmxDir = $OmegaTexport
	EndIf

	local $bExport = GUICtrlCreateButton ( $tmxDir, 20, 80, 700, 25, -1, -1)
	GUICtrlSetFont(-1, 9)
	GUICtrlSetStyle(-1, $BS_LEFT + $BS_FLAT)

	if $sTMX then
		GUICtrlSetTip($bExport, "Click to switch Project Save")
	else
		GUICtrlSetTip($bExport, "Click to switch OmegaT Export Folder")
	endif

	$filelist = ""
	for $i = 1 to $aArray[0]
		$filelist = $filelist & $aArray[$i] & "|"
	next
	msg(($i-1) & " files will be sent.")

	local $list = GUICtrlCreateList ( "", 20, 110, 700, 175, BitOR($LBS_SORT,$LBS_EXTENDEDSEL), -1) ; ,$LBS_STANDARD,$WS_BORDER,$WS_VSCROLL
	GUICtrlSetBkColor (-1, 0xCCCCCC )
	GUICtrlSetFont(-1, 9)
	GUICtrlSetTip(-1, "Documents to send (CTRL + click to select more)")
	GUICtrlSetData(-1, $filelist)

	local $ok = GUICtrlCreateButton ("Send", 20, 290, 100, 25, -1, -1)
	local $cancel = GUICtrlCreateButton ( "Cancel", 620, 290, 100, 25, -1, -1)


	GUISetState(@SW_SHOW)

	While 1
		;		$msg <> $GUI_EVENT_CLOSE
		$msg = GUIGetMsg()

		Select
			Case $msg = $bDir
				Local $dst = FileSelectFolder("Select Destination Folder", "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 3,  $ToRevise, $mainGUI)
				if @error then Exitloop
				GUICtrlSetData($bDir, $dst)

			Case $msg = $bExport
				if $sTMX = 1 then
					$sTMX = 0
					$tmxDir = $OmegaTexport
					$aArray = _FileListToArray ( $tmxDir, "*.tmx", 1)
					if @error then
						msg("No files found in Omegat_Export!")
						ContinueLoop
					EndIf
					$filelist = ""

					for $i = 1 to $aArray[0]
						$filelist = $filelist & $aArray[$i] & "|"
					next
					msg(($i-1) & " files will be sent.")

					GUICtrlSetData($list, "|")
					GUICtrlSetData($list, $filelist)
					GUICtrlSetData($bExport, $tmxDir)
					GUICtrlSetTip($bExport, "Click to switch Project Save")

				Else
					$sTMX = 1
					$tmxDir = $ProjectSave
					$aArray = _FileListToArray ( $tmxDir, "*.tmx", 1)
					if @error then
						msg("Project_save.tmx not found in OmegaT!")
						ContinueLoop
					EndIf
					$filelist = ""

					for $i = 1 to $aArray[0]
						$filelist = $filelist & $aArray[$i] & "|"
					next
					msg(($i-1) & " file(s) will be sent.")

					GUICtrlSetData($list, "|")
					GUICtrlSetData($list, $filelist)
					GUICtrlSetData($bExport, $tmxDir)
					GUICtrlSetTip($bExport, "Click to switch OmegaT Export Folder")

				endif

			Case $msg = $list
				msg(_GUICtrlListBox_GetSelCount($list) & " file(s) will be sent.")

			Case $msg = $ok
				$dir = GUICtrlRead($iDir)
				msg("Sending Project $dir$ for Revision ...")

				$aSel = _GUICtrlListBox_GetSelItemsText($list)
				if $aSel[0] = 0 then $aSel = $aArray

				$roboline = '$robo$ "$src$" "$dst$\$dir$" "*.*" /np /r:10 /w:0 /e /mir'
				RunWait($roboline, @WindowsDir, @SW_HIDE)
;
;	check if OmegaT.project present ...
;

				for $i = 1 to $aSel[0]
;					msgbox(0,"tm\draft", $aSel[$i])
					filecopy("$src$\omegat\" & $aSel[$i], "$dst$\$dir$\tm\auto\draft\",9)
					filecopy("$dst$\$dir$\export-omegat\" & $aSel[$i], "$dst$\$dir$\tm\auto\draft\",9)		; filecopy( %1, %2, 9)
					filemove("$dst$\$dir$\export-omegat\" & $aSel[$i], "$dst$\$dir$\export-omegat\processed\",9) 	; filemove( %1, %2, 9)
				next
				FileDelete("$dst$\$dir$\omegat\*.tmx*")
				FileDelete("$dst$\$dir$\omegat\last_entry.*")

				msg("Project $dir$ for Revision sent ...")
				ExitLoop

			Case $msg = $cancel
				msg("")
				ExitLoop

			Case $msg = $GUI_EVENT_CLOSE
				msg("")
				ExitLoop

		EndSelect
	WEnd
	GUIDelete($SendRevGUI)

EndFunc


Func RevToRev() ; ===> (SEND) Upload revised project
	local $prj = GUICtrlRead($OTdir)
	local $dir = StringRegExpReplace ( $prj, "_For-Revision-\w{7}", "_Revised-" & @username)

	$dir  = InputBox ( "Send Revised Project", "Project Name" , $dir, "", 400, 115, Default, Default, 0, $mainGUI)
	if @error = 1 then return

	if $SecemStatus = 1 then local $Revised = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"

	Local $var = FileSelectFolder("Choose a dir where put the Project", "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}", 2,  $Revised, $mainGUI)
	if @error = 1 then return

;	Debug("Send For Revision", "$var$\$dir$")
	local $src = "$OmegaTprojetsPath$\$prj$"
	local $dst = "$var$\$dir$"

	msg("Sending Project $dir$ for Revision ...")
	$roboline = '$robo$ "$src$" "$dst$" "*.*" /np /r:10 /w:0 /e /mir'

;	Debug("", $roboline)
	RunWait($roboline, @WindowsDir, @SW_HIDE)

;
;	check if Omegat.project is present in destination
;	msg : close OmegaT
;	redo robocopy until file OmegaT.project is present
;

	msg("Project $dir$ for Revision sent ...")

EndFunc   ;==>FromRev

Func TraFromRev() ; ===> (GET) Download Revised Project

	if $SecemStatus = 1 then local $Revised = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"
	Local $var = FileSelectFolder("Choose a Revised Project", $Revised, 2)
	if @error = 1 then return

	Local $array = StringRegExp($var, "([^\\]+?)$", 1)
	local $prj = $array[0]
	local $src = $var
	local $dst = "$OmegaTprojetsPath$\$prj$"

	if FileExists("$src$\Omegat.project") = 0 then
		msg("$var$ is not a valid OmegaT Project !")
		return (0)
	endif

	msg("Getting $var$ ...")
	$roboline = '$robo$ "$src$" "$dst$" "*.*" /np /r:10 /w:0 /e /mir'
	RunWait($roboline, @WindowsDir, @SW_HIDE)
	msg("Now you can open the Project $prj$")
	GUICtrlSetData($OTdir, $prj)

EndFunc   ;==>FromRev

Func RevFromRev() ; ===> Download Project to Revise

	if $SecemStatus = 1 then local $ToRevise = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"
	Local $var = FileSelectFolder("Choose a Project to revise", $ToRevise, 2)
	if @error = 1 then return

	Local $array = StringRegExp($var, "([^\\]+?)$", 1)
	local $prj = $array[0]
	local $src = $var
	local $dst = "$OmegaTprojetsPath$\$prj$"

	if FileExists("$src$\Omegat.project") = 0 then
		msg("$var$ is not a valid OmegaT Project !")
		return (0)
	endif

	msg("Getting $var$ ...")
	$roboline = '$robo$ "$src$" "$dst$" "*.*" /np /r:10 /w:0 /e /mir'
	RunWait($roboline, @WindowsDir, @SW_HIDE)
	msg("Now you can open the Project $prj$")
	GUICtrlSetData($OTdir, $prj)

EndFunc   ;==>ToRev

Func TraBrowse() ; ===> Browse Projects to revise
	if $SecemStatus = 1 then local $ToRevise = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"
	Run('explorer.exe /n /e,' & $ToRevise)
EndFunc

Func RevBrowse() ; ===> Browse revised Projects
	if $SecemStatus = 1 then local $Revised = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}"
	Run('explorer.exe /n /e,' & $Revised)
EndFunc

Func Msg($msg)
	GUICtrlSetData($message, $msg & @CRLF)
EndFunc

Func var($var, $val)
	msgbox(0, $var, $val)
;	exit 0
Endfunc

Func Debug($func, $msg)
	if $debug = 0 then return
	msgbox(0, $func, $msg)
EndFunc