package dgt.jwizard.act;

import java.io.File;
import java.util.Properties;
import java.util.List;

import javax.swing.*;

public class AddLocalFileAction implements AddFileAction {
	
	/** Label displayed in the window **/
	public String getLabel() {
		return "Local file(s)";
	}
	
	private JFileChooser fChooser = new JFileChooser (); {
		fChooser.setMultiSelectionEnabled(true);
		fChooser.setFileFilter(new javax.swing.filechooser.FileNameExtensionFilter(
			"Dossiers (*.docx;*.xls?;*.pptx;*.xml;*.htm?;*.sdlxliff;*.xliff)",
			"docx", "xlsx", "pptx", "xml", "htm", "html", "xliff", "xlf", "sdlxliff"));
		fChooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);		
	}
	
	public File[] doSelectFiles(dgt.jwizard.ui.JWizard wizard) {
		File path = new File(wizard.GLOBAL_CONFIG.getProperty("Paths.TradeskLocalPath") + File.separator + wizard.fdProject.getText());
		if (! path.exists()) path = path.getParentFile();
		fChooser.setCurrentDirectory(path); 
		if (fChooser.showOpenDialog(wizard) == JFileChooser.APPROVE_OPTION) {
			File[] res = fChooser.getSelectedFiles(); List<File> subFiles = new java.util.ArrayList<>();
			for (File f: res)
				if (f.isDirectory()) addDir(f, subFiles);
			if (subFiles.size() == 0) return res;
			else {
				for (File f: res)
					if (! f.isDirectory()) subFiles.add(f);
				return subFiles.toArray(res);
			}
		}
		return null;
	}
	
	private static void addDir (File dir, List<File> subFiles) {
		for (File f: dir.listFiles())
			if (f.isDirectory()) addDir(f, subFiles); 
			else subFiles.add(f);
	}
	
}