package dgt.jwizard.act;

import dgt.jwizard.ui.JWizard;

import java.io.*;
import java.nio.file.*;

import static dgt.jwizard.ui.SwingUtils.*;

public class BackupTask extends Thread {

	public static final java.util.regex.Pattern DGT_PROJ = java.util.regex.Pattern.compile("(\\w+)-(\\d{4}-\\d{5})(-\\d{2})?(-\\d{2})?");

	private final JWizard mainWindow;
	private final String projName;
	public boolean active = true;
	public int interval = 1800_000;

	public BackupTask(JWizard wizard, String projName, boolean active) { this.mainWindow = wizard; this.projName = projName; this.active = active; }
	
	@Override public void run() {
		while (active) 
			try {
				Thread.sleep(interval);
				if (active) BackupProject();
			} catch (InterruptedException e) {
			}
		BackupProject();
	}
	
	private void BackupProject() {		
		mainWindow.msgArea.setText("Storing Project '" + projName + "' to '" + mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + "' ...\n");
		File path = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + projName);
		try {
			if ((!active) && mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy") != null) {
				String[] roboCall = new String[] {
					mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy"),
					path.toString(), mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + File.separator + projName, "*.*", 
					"/np", "/r:10", "/w:0", "/e"
				};
				final Process proc = Runtime.getRuntime().exec (roboCall);
				proc.getInputStream().close(); 
				mainWindow.msgArea.append(String.join(" ", roboCall) + "\n");
				try (BufferedReader is = new BufferedReader(new InputStreamReader(proc.getErrorStream()))) { 
					String line; while ((line = is.readLine()) != null) mainWindow.msgArea.append(line);
				}
			}
			else copyDirectory(path, new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + File.separator + projName), true);
			mainWindow.msgArea.append("\nProject '" + projName + "' has been stored to '" + mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsBkpPath") + "'");
			Thread.sleep(1000);
		} catch (Exception e) {
			mainWindow.msgArea.append(e.getClass().getName() + ": " + e.getMessage());
		}
		try {
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path.toString() + File.separator + "source"), "*.*")) {
				File projectSave = new File(path, "OmegaT" + File.separator + "project_save.tmx"); int i = 1;
				for (Path p: dirStream) {
					java.util.regex.Matcher mProj = DGT_PROJ.matcher(p.toFile().getName());
					if (mProj.find()) { 
						String dossiersPath = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
						dossiersPath += mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret";
						dossiersPath += File.separator + mProj.group() + "-DRAFT-" + System.getProperty("user.name") + ".tmx";
						Files.copy(projectSave.toPath(), Paths.get(dossiersPath), StandardCopyOption.REPLACE_EXISTING);
						mainWindow.msgArea.append("\n" + (i++) + " - project_save.tmx saved as " + dossiersPath);
					}
				}
			}
			Thread.sleep(1000);
			mainWindow.msgArea.append("\nBackup done!");	
		} catch (Exception e) {
			mainWindow.msgArea.append(e.getClass().getName() + ": " + e.getMessage());
		}
	}
	
}