package dgt.jwizard.act;

import java.awt.event.*;
import java.util.regex.*;
import java.io.File;
import java.nio.file.*;

import javax.swing.JOptionPane;
import javax.swing.ListModel;

public class SendToTradeskPath implements ActionListener {

	private dgt.jwizard.ui.JWizard mainWindow;
	private dgt.jwizard.ui.EuramisWindow euramisWin;

	public SendToTradeskPath(dgt.jwizard.ui.JWizard mainWindow, dgt.jwizard.ui.EuramisWindow euramisWin) {
		this.mainWindow = mainWindow; this.euramisWin = euramisWin;
	}
	
	public void LogToMain(String text) { 
		mainWindow.msgArea.setText(mainWindow.msgArea.getText() + "\n" + text);
	}
	

	private static final Pattern DOSSIER_PTN = Pattern.compile("^(.+-\\d{4}-\\d{5})-");
	
	public void actionPerformed(ActionEvent ev) {		
		ListModel<File> model = euramisWin.finalizeListBox.getModel();
		File tradeskPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Tradesk"));
		File targetPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator 
			+ mainWindow.fdProject.getText() + File.separator + "target");
		if (! targetPath.exists()) targetPath = new File (targetPath.getParentFile(), "target");
		for(int i = 0; i < model.getSize(); i++){
			File f = model.getElementAt(i); if (! f.isAbsolute()) f = new File(targetPath, f.getPath());
			Matcher matcher1 = DOSSIER_PTN.matcher(f.getName()); 
			String projDir = (matcher1.find()) ? matcher1.group(1) : f.getName();
			File tradeskProjFile = new File(tradeskPath, projDir + File.separator + f.getName());
			if (tradeskProjFile.exists())
				if (JOptionPane.showConfirmDialog(mainWindow, 
					f.getName() + "\n is already present in TRADESK!\n Would you replace it?", 
					"Ext: Send to TRADESK",
					JOptionPane.YES_NO_OPTION) 
				== JOptionPane.NO_OPTION)
					LogToMain(f.getName() + " has not been replaced into TRADESK");
				else 
					try {
						Files.copy(f.toPath(), tradeskProjFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
						LogToMain(f.getName() + " has been replaced into TRADESK");
					} catch (Exception e) {
						LogToMain(e.getMessage());
					}
			else 
				try {
					tradeskProjFile.getParentFile().mkdirs();
					Files.copy(f.toPath(), tradeskProjFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
					LogToMain(f.getName() + " has been added into TRADESK");
				} catch (Exception e) {
					LogToMain(e.getMessage());
				}
		}
	}
		
}