package dgt.jwizard.act;

import java.io.*;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.*;
import java.util.regex.*;
import java.util.Base64;
import java.util.Map;
import java.util.HashMap;

import javax.swing.*;

import dgt.lib.SoapCall;

public class SendToTradeskSoap implements ActionListener {
	
	private dgt.jwizard.ui.JWizard mainWindow;
	private dgt.jwizard.ui.EuramisWindow euramisWin;

	public SendToTradeskSoap(dgt.jwizard.ui.JWizard mainWindow, dgt.jwizard.ui.EuramisWindow euramisWin) {
		this.mainWindow = mainWindow; this.euramisWin = euramisWin;
	}
	
	public void LogToMain(String text) { 
		mainWindow.msgArea.setText(mainWindow.msgArea.getText() + "\n" + text);
	}
	
	private static final Pattern DOSSIER_PTN = Pattern.compile("^(\\w+)-(\\d{4})-(\\d{5})-(\\d\\d)-(\\d\\d)(?:-(\\d\\d))?-([A-Z]{2})-([A-Z]{3})-(\\d\\d)\\.(\\w+)");
	
	private SoapCall caller = null;
	
	public void actionPerformed(ActionEvent ev) {		
		try { SendToTradeskServer(); }
		catch (Exception e) {
			JOptionPane.showMessageDialog(euramisWin, e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE);
		}
	}
	
	private void SendToTradeskServer() throws Exception {
		if (caller == null) 
			if ("config".equalsIgnoreCase(mainWindow.GLOBAL_CONFIG.getProperty("http.secure")))
				caller = new SoapCall(mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"),
					mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.user"),mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.pass"));
			else if ("ask".equalsIgnoreCase(mainWindow.GLOBAL_CONFIG.getProperty("http.secure"))) {
				JDialog passDialog = new JDialog(euramisWin); passDialog.setTitle("Please give internet credentials"); passDialog.setModal(true); 
				Container pane = passDialog.getContentPane();  pane.setLayout(new GridLayout(3,2));
				pane.add (new JLabel("User name:")); JTextField fUser = new JTextField(); pane.add(fUser);
				pane.add (new JLabel("Password:")); JPasswordField fPass = new JPasswordField(); pane.add(fPass);
				JButton btnOk = new JButton("OK"), btnCancel = new JButton("Cancel"); pane.add(btnOk); pane.add(btnCancel);
				btnCancel.addActionListener(ev -> passDialog.setVisible(false));
				btnOk.addActionListener(ev -> { 
					passDialog.setVisible(false);
					caller = new SoapCall(mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"),
						fUser.getText(),fPass.getText());
				});
				passDialog.setBounds(euramisWin.getX() + 100, euramisWin.getY() + 100, 500, 120); passDialog.setVisible(true);
				if (caller == null) return; // if called cancel
			}
			else
				caller = new SoapCall(mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"));
		ListModel<File> model = euramisWin.finalizeListBox.getModel();
		File targetPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator 
			+ mainWindow.fdProject.getText() + File.separator + "target-native");
		if (! targetPath.exists()) targetPath = new File (targetPath.getParentFile(), "target");
		PrintStream tradeskLog = new PrintStream(targetPath.getParentFile().getPath() + File.separator + "SendToTradesk.log");
		tradeskLog.println("Sending files from " + targetPath + " to Tradesk"); mainWindow.msgArea.setText("Sending files to Tradesk");
		int success = 0, failed = 0;
		for(int i = 0; i < model.getSize(); i++) {
			File f = model.getElementAt(i); if (! f.isAbsolute()) f = new File(targetPath, f.getPath());
			String docUid = GetDocUid(f);
			tradeskLog.println("For file " + f + ", doc uid = " + docUid);
			org.w3c.dom.Document call = null;
			try { 
				if ((docUid == null) || (docUid.trim().length() == 0)) call = TradeskAdd (f); else call = TradeskReplace(f, docUid); 
				success++;
			} catch (Exception e) { 
				if (e.getMessage().contains("thentication")) {
					JOptionPane.showMessageDialog(euramisWin, "Could not authenticate, please check user/password", "alert", JOptionPane.ERROR_MESSAGE);
					return;
				}
				tradeskLog.println("" + f + ": Exception: " + e); failed++;
			} finally {
				tradeskLog.println("Call result:"); if (call == null) tradeskLog.println("null"); else SoapCall.dump(call, tradeskLog);	
				LogToMain(f.getName() + " has " + (call == null ? "not " : "") + " been "
					+ ( ((docUid == null) || (docUid.trim().length() == 0)) ? "added" : "replaced" ) + " in TraDesk");
			}
		}
		LogToMain("" + success + "/" + model.getSize() + " files sent OK, " + failed + " failed");
		tradeskLog.println("OK:" + success + "; failed:" + failed + "; total: " + model.getSize()); tradeskLog.close();
	}
	
	private Map<String, Object> FileToTradeskParams(File f, boolean withName) throws Exception {
		Matcher matcher1 = DOSSIER_PTN.matcher(f.getName());
		if (! matcher1.find()) throw new Exception("Not a valid Tradesk dossier name: " + f.getName());
		Map<String, String> reqRef = new HashMap<>();
		reqRef.put("requester", matcher1.group(1)); reqRef.put("year", matcher1.group(2)); reqRef.put("number", matcher1.group(3));		
		Map<String, Object> cmdRef = new HashMap<>(); cmdRef.put("requestReference", reqRef);
		cmdRef.put("version", matcher1.group(4)); reqRef.put("part", matcher1.group(5)); 
		if ((matcher1.group(6) != null) && (matcher1.group(6).length() == 2)) cmdRef.put("subpart", matcher1.group(6)); else cmdRef.put("subpart", matcher1.group(9));
		cmdRef.put("language", matcher1.group(7)); cmdRef.put("documentType", matcher1.group(8)); reqRef.put("requestType", "TRA");
		if (withName) { cmdRef.put("filename", f.getName()); cmdRef.put("format", matcher1.group(10)); }
		return cmdRef;
	}
	
	private String GetDocUid(File f) {
		try {
			return SoapCall.findElementContent(caller.call("searchDocuments", FileToTradeskParams(f, false), null), "docUID|documentUID");
		} catch (Exception e) {
			return null;	// doc does not exist yet
		}
	}
	
	private org.w3c.dom.Document TradeskAdd(File f) throws Exception {
		LogToMain("Adding " + f.getName() + " to TRADESK");
		Map<String, Object> cmdRef = FileToTradeskParams(f, true);
		cmdRef.put("username", System.getProperty("user.name"));
		cmdRef.put("file", encodeFile(f));
		return caller.call("addDocument", cmdRef, null);
	}
	
	private org.w3c.dom.Document TradeskReplace(File f, String docUid) throws Exception {
		if (JOptionPane.showConfirmDialog(mainWindow, 
			f.getName() + "\n is already present in TRADESK!\n Would you replace it?", 
			"Ext: Send to TRADESK",
			JOptionPane.YES_NO_OPTION) 
			== JOptionPane.NO_OPTION) return null;		
		LogToMain("Replacing " + f.getName() + " into TRADESK");
		Map<String, Object> cmdRef = new HashMap<>();
		cmdRef.put("username", System.getProperty("user.name"));
		cmdRef.put("file", encodeFile(f)); cmdRef.put("filename", f.getName()); cmdRef.put("documentUID", docUid);
		return caller.call("replaceDocument", cmdRef, null);
	}
	
    private String encodeFile (File theFile) throws IOException {
        try (InputStream inz = new FileInputStream(theFile)) {
            byte[] fileContent = new byte[(int) theFile.length()];
            try { inz.read(fileContent); } catch (IOException io) { io.printStackTrace(); }
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(fileContent);
        }
	}
	
}