package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.io.*;
import java.util.zip.*;
import java.nio.file.*;

import org.openide.awt.Mnemonics;

import static dgt.jwizard.ui.SwingUtils.*;

public class CreateProjectDialog extends JDialog {
	
	private JWizard mainWindow;
	private PanelProjects panel;

	public CreateProjectDialog(JWizard mainWindow, PanelProjects panel, ActionEvent ev, final File projPath) {
		super(mainWindow, "Project options"); setModal(true);
		this.mainWindow = mainWindow; this.panel = panel;
		
		boolean needsTagwipe = false, needsXliff = false; 
		for (java.util.Enumeration<File> e = ((DefaultListModel) mainWindow.documentsListBox.getModel()).elements(); e.hasMoreElements();) {
			String name = e.nextElement().getName().toLowerCase();
			if (name.endsWith(".docx")) needsTagwipe = true; if (! name.endsWith(".sdlxliff")) needsXliff = true; 
		}
		getContentPane().setLayout(new BoxLayout(getContentPane(), BoxLayout.Y_AXIS));
		final JCheckBox tagWipeOption = new JCheckBox(); Mnemonics.setLocalizedText(tagWipeOption, "Apply Tag&Wipe"); if (needsTagwipe) this.getContentPane().add(tagWipeOption);
		final JCheckBox iateOption = new JCheckBox(); Mnemonics.setLocalizedText(iateOption, "Extract &IATE glossary"); this.getContentPane().add(iateOption);
		final JCheckBox xliffOption = new JCheckBox(); Mnemonics.setLocalizedText(xliffOption, "SDL&xliff mode"); if (needsXliff) this.getContentPane().add(xliffOption);
		tagWipeOption.setSelected(needsTagwipe); iateOption.setSelected(false); xliffOption.setSelected(needsXliff);
		final JPanel pBtn = new JPanel(); getContentPane().add(pBtn); pBtn.setLayout(new BorderLayout());
		final JButton bOk = new JButton("OK"); pBtn.add (bOk, BorderLayout.WEST); bOk.addActionListener(okev -> { 
			this.setVisible(false); CreateOk(okev, projPath, ev.getActionCommand(), tagWipeOption.isSelected(), iateOption.isSelected(), xliffOption.isSelected()); 
		});
		final JButton bCancel = new JButton("Cancel"); pBtn.add (bCancel, BorderLayout.EAST); bCancel.addActionListener(cev -> this.setVisible(false));
		this.pack(); this.setBounds(mainWindow.getX() + 50, mainWindow.getY() + 50, this.getWidth(), this.getHeight());
	}
	
	private void CreateOk(ActionEvent ev, File projPath, String command, boolean tagWipe, boolean iate, boolean xliff) {
		PrintStream log = System.err;
		mainWindow.msgArea.setText(command.substring(0, command.length() - 1) + "ing OmegaT Project \"" + mainWindow.fdProject.getText() + "\" ...");
		LogMessage(log, command.substring(0, command.length() - 1) + "ing OmegaT Project \"" + mainWindow.fdProject.getText() + "\" ...");
		for (String subdirs: new String[] { "dictionary", "euramis\\sent", "glossary", "mt", "omegat", "source", 
			"TagWipe", "target", "tm\\auto", "tm\\tmx2source", "tm\\penalty-50" })
				new File(projPath, subdirs).mkdirs();
		try { log = new PrintStream(new File(projPath, "wizard-" + command + ".log")); } catch (Exception e) { log = System.err; e.printStackTrace(log); }
		log.println("Running wizard " + JWizard.VERSION + " command " + command);
		try {
			try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(projPath, "omegat.project"))))) {
				out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
				out.println("<omegat>");
				out.println("  <project version=\"1.0\">");
				out.println("    <source_dir>__DEFAULT__</source_dir>");
				out.println("    <target_dir>__DEFAULT__</target_dir>");
				out.println("    <glossary_dir>__DEFAULT__</glossary_dir>");
				out.println("    <glossary_file>__DEFAULT__</glossary_file>");
				out.println("    <dictionary_dir>__DEFAULT__</dictionary_dir>");
				out.println("    <source_lang>" + languageWithCountry(mainWindow.GLOBAL_CONFIG, mainWindow.srcBox.getSelectedItem().toString()) + "</source_lang>");
				out.println("    <target_lang>" + languageWithCountry(mainWindow.GLOBAL_CONFIG, mainWindow.traBox.getSelectedItem().toString()) + "</target_lang>");
				out.println("    <sentence_seg>" + (!xliff) + "</sentence_seg>");
				out.println("    <support_default_translations>true</support_default_translations>");
				out.println("  </project>");
				out.println("</omegat>");
			}
			File dest = new File(projPath, "OTStats_" + projPath.getName() + ".xlsx");
			if ((! dest.exists()) && new File(mainWindow.GLOBAL_CONFIG.getProperty("file.xls_stats")).exists()) Files.copy(Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("file.xls_stats")), dest.toPath());
			if (! xliff) {
				dest = new File(mainWindow.GLOBAL_CONFIG.getProperty("file.seg_rules"));
				if (dest.exists()) 
					try { Files.copy(dest.toPath(), new File(projPath, "omegat" + File.separator + dest.getName()).toPath()); LogMessage(log, "Copied " + dest + " to " + projPath + File.separator + "omegat"); }
					catch (FileAlreadyExistsException fae) { LogMessage(log, "Segmentation rules already exist: " + projPath + File.separator + "omegat" + File.separator + dest.getName()); }
					catch (Exception other) { other.printStackTrace(log); }
				else LogMessage(log, "Did not find segmentation rules: " + dest);
			}
			
			// UpdateOffice()
			LogMessage(log, "Copying file(s) into OmegaT Projects ..."); dest = new File(projPath, "source");
			DefaultListModel list = (DefaultListModel) mainWindow.documentsListBox.getModel();			
			java.util.regex.Pattern ORI_LANG = java.util.regex.Pattern.compile(mainWindow.srcBox.getSelectedItem().toString().toUpperCase() + "-OR[IC]");
			for (java.util.Enumeration<File> e = list.elements(); e.hasMoreElements();) {
				File f = e.nextElement(); 
				if (f.getName().endsWith(".sdlxliff")) TestResegment(f.toPath(), null, log); // eventually resegment it					
				String newName = ORI_LANG.matcher(f.getName()).replaceAll("00-" + mainWindow.traBox.getSelectedItem().toString().toUpperCase() + "-TRA"); 
				LogMessage(log, "Copying " + f + " to source/" + newName); 
				File destFile = new File(dest, newName); 
				if (destFile.exists()) { 
					if (JOptionPane.showConfirmDialog(mainWindow, destFile + " already exists. Overwrite?", "Alert", JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) 
						Files.copy (f.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
				}
				else Files.copy (f.toPath(), destFile.toPath());
			}
			String langJokers = mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString();
			File srcDir = new File(projPath, "source"); 
			if (tagWipe) Wipe (srcDir, log); if (iate) IATE(srcDir, langJokers, log); 
			if (xliff) {
				String canReuseStr = mainWindow.GLOBAL_CONFIG.getProperty("SdlTradosProjects.Automated.Reuse").trim();
				boolean canReuseBool = "true".equals(canReuseStr) || (tagWipe && "isWipe".equals(canReuseStr)) || ((! tagWipe) && "noWipe".equals(canReuseStr));
				CreateTradosProjects(srcDir, canReuseBool, log);
			}
			LogMessage(log, "Searching memories to import ...");
			if (list.size() == 0) LogMessage(log, "No files found");
			new ImportTmxDialog(mainWindow, this, list, new File(projPath, "tm"), langJokers, log).setVisible(true);
			list.clear(); panel.Backup(ev);
			dest = new File(new File(projPath, "TagWipe"), "TagWipe.cmd");
			if (!dest.exists()) Files.copy (new File(mainWindow.GLOBAL_CONFIG.getProperty("exe.TagWipeCMD")).toPath(), dest.toPath());
			mainWindow.runOtButton.setBackground(new java.awt.Color(0, 0xCC, 0)); mainWindow.runOtButton.setEnabled(true);
			mainWindow.msgArea.setText("You can now Open Project !");			
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getClass() + " :\n"  + e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE);
			e.printStackTrace(log);
		} finally {
			try { log.close(); } catch (Exception ec){}
		}
	}
		
	/* ------------------------------ Utility functions -------------------------- */
	
	public static String languageWithCountry(java.util.Properties config, String lang) {
		if (lang.contains("-")) return lang;
		String country = config.getProperty("country." + lang.toLowerCase()); 
		if (country == null) country = lang; else if (country.length() == 0) country = lang;
		return lang + "-" + country;
	}
	
	private void LogMessage(PrintStream out, String msg) { out.println(msg); mainWindow.msgArea.append(msg); }
	
	/* ------------------------------ External processes -------------------------- */
	
	private void ExecAndLog(String[] params, PrintStream log) throws IOException, InterruptedException  {
		LogMessage(log, "Run " + String.join(" ", params)); 
		final Process proc = Runtime.getRuntime().exec (params);
		try (BufferedReader reader = new BufferedReader(new InputStreamReader (proc.getInputStream()))) {
			String line; while ((line = reader.readLine()) != null) { log.println("\t" + line); }
		} 
		try (BufferedReader reader = new BufferedReader(new InputStreamReader (proc.getErrorStream()))) {
			String line; while ((line = reader.readLine()) != null) { log.println("\t" + line); }
		}
		proc.waitFor();	
	}
	
	private void Wipe(File sourceDir, PrintStream log) {	
		String cmd = mainWindow.GLOBAL_CONFIG.getProperty("exe.TagWipeCMD");
		if ((cmd == null) || (! new File(cmd).exists())) { log.println("Could not find Tagwipe cmd (" + cmd + ")"); return; }
		try {
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(sourceDir.toPath(), "*.docx")) {
				for (Path p: dirStream) {
					LogMessage(log, "Wipe " + p + " ... "); JFrame waitDlg = showLongProcessDialog(this, "Wipe " + p + " ... ");
					ExecAndLog(new String[] { cmd, p.toString() }, log); waitDlg.setVisible(false);
				}
			}
		} catch (Exception e) {
			e.printStackTrace(log);
		}
	}
	
	private void IATE(File sourceDir, String langJokers, PrintStream log) {
		if (! sourceDir.exists()) return;
		LogMessage(log, "Creating IATE list of words ... ");
		String cmd = mainWindow.GLOBAL_CONFIG.getProperty("exe.WordsListCMD");
		if (new File(cmd).exists()) 
			try { ExecAndLog(new String[] { cmd, sourceDir.toString() }, log); } catch (Exception e) { e.printStackTrace(log); return; }
		else {
			LogMessage(log, "Cannot find " + cmd); return;			
		}
		LogMessage(log, "Creating IATE " + langJokers + " glossary ... ");
		cmd = mainWindow.GLOBAL_CONFIG.getProperty("exe.IateCMD");
		if (new File(cmd).exists()) 
			try {
				File dest = new File(sourceDir.getParentFile(), "glossary"); dest = new File(dest, langJokers + ".txt");
				JFrame waitDlg = showLongProcessDialog(this, "Creating IATE " + langJokers + " glossary ... ");
				ExecAndLog(new String[] { cmd, dest.toString() }, log);
				waitDlg.setVisible(false);
			} catch (Exception e) {
				e.printStackTrace(log);
			}
		else {
			LogMessage(log, "Cannot find " + cmd); return;			
		}
	}

	/* ------------------------------ Trados interaction -------------------------- */
	
	private void CreateTradosProjects(File sourceDir, boolean canReuse, PrintStream log) throws IOException, InterruptedException {	
		String cmd = mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine");
		if ((cmd == null) || (! new File(cmd).exists())) { log.println("Could not find Trados cmd (" + cmd + ")"); return; }
		try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(sourceDir.toPath(), "*.*")) {
			for (Path p: dirStream) 
				if (p.getFileName().toString().toLowerCase().endsWith(".sdlxliff")) { LogMessage(log, "File " + p + " already in Xliff format. Pass."); continue; }
				else if (mainWindow.secemOption.isSelected()) {
					File destDir = SecemProjectPath(p.getFileName().toString());
					LogMessage(log, "File " + p + ": check for Trados SECEM project " + destDir + " --> " + destDir.exists());
					if (destDir.exists()) { TestResegment(p, destDir, log); MoveTradosFile(sourceDir, p, destDir, log); }
					else JOptionPane.showMessageDialog(mainWindow, destDir.getName() + ": \nSECEM SDLXLIFF project must be created from CAT client");
				}
				else {
					File destDir = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects")); 
					destDir = new File(destDir, TradosProjectName(p.getFileName().toString()));
					LogMessage(log, "File " + p + ": check for Trados project " + destDir + " --> " + destDir.exists());
					if (destDir.exists()) {
						String message = destDir + " already exists.\nDo you want to rewrite (YES) or re-use existing (NO)?";
						if (new File(destDir, "Products").exists()) message += "\nWarning: This project is finalized, modification via OmegaT may not work!";
						switch (JOptionPane.showConfirmDialog(mainWindow, message, "Alert", JOptionPane.YES_NO_OPTION)) {
							case JOptionPane.NO_OPTION: LogMessage(log, "User selected to re-use"); TestResegment(p, destDir, log); MoveTradosFile(sourceDir, p, destDir, log); break;
							case JOptionPane.YES_OPTION: LogMessage(log, "User selected to overwrite"); SwingUtils.delTree(destDir); CreateTradosFile(sourceDir, p, destDir, canReuse, log); break;
						}
					}
					else CreateTradosFile(sourceDir, p, destDir, canReuse, log);
				}
		}
	}
	
	public File SecemProjectPath(String fileName) {
		File destDir = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects")); 
		destDir = new File(destDir.getParentFile(), "Sensitive Projects");
		return new File(destDir, TradosProjectName(fileName));		
	}
	
	public String TradosProjectName(String fileName) {
		fileName = fileName.substring(0, fileName.indexOf('.')).toUpperCase();
		fileName = fileName.replace(
			"-" + mainWindow.traBox.getSelectedItem().toString() + "-TRA", 
			"-" + mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString()
		);
		fileName = fileName.replace(
			"-" + mainWindow.srcBox.getSelectedItem().toString() + "-ORI", 
			"-00-" + mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString()
		);
		return fileName;
	}
	
	private void CreateTradosFile (File sourceDir, Path nativeFile, File destDir, boolean canReuse, PrintStream log) throws IOException, InterruptedException {
		mainWindow.msgArea.setText("Creating trados project for " + nativeFile + " ... \n"); repaint();
		// First, try to re-use Automation's project, if exists
		java.util.regex.Matcher dgtMatch = BackupTask.DGT_PROJ.matcher(nativeFile.getFileName().toString()); if (canReuse && dgtMatch.find()) {
			File ongoingPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers"));
			ongoingPath = new File(ongoingPath, dgtMatch.group(1)); ongoingPath = new File(ongoingPath, dgtMatch.group(1) + "-" + dgtMatch.group(2)); 
			ongoingPath = new File(ongoingPath, "archive"); 
			String nativeName = TradosProjectName(nativeFile.getFileName().toString());
			nativeName += "-ARCHIVE-AUTOCREATED.sdlppx";
			ongoingPath = new File(ongoingPath, nativeName);
			LogMessage(log, "Search Trados project " + ongoingPath.getName() + " in ongoing file system (" + ongoingPath.getParent() + ")");
			if (ongoingPath.exists()) {
				LogMessage(log, "Found, extracting to " + destDir);
				try (ZipInputStream zis = new ZipInputStream(new FileInputStream(ongoingPath))) {
					byte[] buffer = new byte[1024]; int len; ZipEntry entry;
					while ((entry = zis.getNextEntry()) != null) { // copy as is
						File destFile = new File(destDir, entry.getName()); destFile.getParentFile().mkdirs();
						try (FileOutputStream fos = new FileOutputStream(destFile)) { 
							while ((len = zis.read(buffer)) > 0) fos.write(buffer, 0, len);
						}
					}
				}
				// Change sdlproj file : replace ProjectPackage with Project
				for (File child: destDir.listFiles())
					if (child.getName().toLowerCase().endsWith(".sdlproj")) {
						try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(child)))) {
							try (PrintStream outp = new PrintStream(child.toString() + ".tmp")) {
								String line; while ((line = reader.readLine()) != null) {
									line = line.replace("<PackageProject", "<Project").replace("</PackageProject", "</Project");
									outp.print(line); if (! line.endsWith("\n")) outp.println("");
								}
							}
						}
						child.delete(); new File(child.toString() + ".tmp").renameTo(new File(child.toString().replaceAll("-\\d{4,8}-\\d{1,2}h\\d{1,2}m\\d{1,2}s\\.",".")));
					}
				MoveTradosFile(sourceDir, nativeFile, destDir, log); return;
			}
		}
		// If not present, then we call the command line
		LogMessage(log, (canReuse ? "Project not in ongoing file system" : "Not using auto projects") + ", calling Trados to " + destDir.getName());
		String srcLang = mainWindow.srcBox.getSelectedItem().toString(), traLang = mainWindow.traBox.getSelectedItem().toString();
		srcLang = languageWithCountry(mainWindow.GLOBAL_CONFIG, srcLang.toLowerCase()); traLang = languageWithCountry(mainWindow.GLOBAL_CONFIG, traLang.toLowerCase()); 
		String[] params = { 
			mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine"), "--create-full", 
			destDir.toString(), srcLang, traLang, nativeFile.toString() 
		};
		JFrame waitDlg = showLongProcessDialog(this, "Creating Trados Project " + destDir + " ... ");		
		log.println("Execute " + String.join(" ", params)); ExecAndLog(params, log);
		MoveTradosFile(sourceDir, nativeFile, destDir, log);
		LogMessage(log, "Project created OK"); waitDlg.setVisible(false);
	}
	
	private void TestResegment (Path nativeFile, File destDir, PrintStream log) throws IOException, InterruptedException {
		File destFile = destDir == null ? nativeFile.toFile().getParentFile()
			: new File(destDir, languageWithCountry(mainWindow.GLOBAL_CONFIG, mainWindow.traBox.getSelectedItem().toString()));
		if (nativeFile.toString().endsWith(".sdlxliff")) destFile = new File(destFile, nativeFile.getFileName().toString()); 
		else destFile = new File(destFile, nativeFile.getFileName().toString() + ".sdlxliff");
		
		LogMessage(log, "" + destFile + " exists, check for segmentation...");
		try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(destFile)))) {
			String line; while ((line = reader.readLine()) != null) if (line.contains("mtype=\"seg\"")) {
				LogMessage(log, "" + destFile + " already segmented."); return;
			}
		}
		
		// If we are still here, we need to call command line for segmentation
		destFile = destFile.getParentFile().getParentFile();
		for (File f: destFile.listFiles()) if (f.getName().endsWith(".sdlproj")) {
			LogMessage(log, "Call Trados segmentation for project " + f);
			String[] params = { mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine"), "--Translate",  f.toString() };
			ExecAndLog(params, log);
			return;
		}
	}
	
	private void MoveTradosFile (File sourceDir, Path nativeFile, File destDir, PrintStream log) throws IOException, InterruptedException {
		File nativeSrcDir = new File(sourceDir.getParentFile(), "source-native"); nativeSrcDir.mkdirs();
		log.println("Move " + nativeFile + " to " + nativeSrcDir); 
		Files.move(nativeFile, Paths.get(nativeSrcDir + File.separator + nativeFile.getFileName()), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);		
		String traLang = languageWithCountry(mainWindow.GLOBAL_CONFIG, mainWindow.traBox.getSelectedItem().toString());
		String srcLang = languageWithCountry(mainWindow.GLOBAL_CONFIG, mainWindow.srcBox.getSelectedItem().toString());
		log.println("Copy " 
			+ destDir.toString() + File.separator + traLang + File.separator + nativeFile.getFileName() + ".sdlxliff"
			+ " to "
			+ sourceDir.toString() + File.separator + nativeFile.getFileName() + ".sdlxliff");
		/*Files.copy(
			Paths.get(destDir.toString() + File.separator + traLang + File.separator + nativeFile.getFileName() + ".sdlxliff"), 
			Paths.get(sourceDir.toString() + File.separator + nativeFile.getFileName() + ".sdlxliff")
		);*/
		try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(destDir, traLang + File.separator + nativeFile.getFileName() + ".sdlxliff")), "UTF-8"))) {
			try (PrintWriter out = new PrintWriter(new File(sourceDir, nativeFile.getFileName() + ".sdlxliff"), "UTF-8")) {
				String line; while ((line = reader.readLine()) != null) {
					line = line.replaceAll("</(body|xliff|header|trans-unit|sdl:cxts)><", "</$1>\n<");
					if (! line.contains("<file original=")) out.print(line);
					else {
						out.println(line.substring(0, line.indexOf("<file original=")));
						out.print("<file original=\""); out.print(destDir + File.separator + srcLang + File.separator + nativeFile.getFileName()); out.print("\"");
						line = line.substring(line.indexOf("file original=") + 14);
						line = line.substring(line.indexOf("\"") + 1); line = line.substring(line.indexOf("\"") + 1); 
						out.print(line);
					}
				}
			}
		}
	}
	
}