package dgt.jwizard.ui;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;
import java.util.regex.Pattern;
import java.util.regex.Matcher;

import java.io.*;
import java.nio.file.*;

import static dgt.jwizard.ui.SwingUtils.*;

public class EuramisWindow extends JFrame {
	
	public JList<File> finalizeListBox;
	private JWizard mainWindow;
	
	public EuramisWindow(JWizard mainWindow) {
		super ("Send to TRAdesk - Euramis"); this.mainWindow = mainWindow;
		setIconImage(new ImageIcon(getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
		setBounds(0, 0, 600, 400); getContentPane().setLayout(null);
		getRootPane().getInputMap(JComponent.WHEN_IN_FOCUSED_WINDOW).put(KeyStroke.getKeyStroke(KeyEvent.VK_ESCAPE, 0, false), "ESCAPE");
        getRootPane().getActionMap().put("ESCAPE", new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                EuramisWindow.this.dispatchEvent(new WindowEvent(EuramisWindow.this, WindowEvent.WINDOW_CLOSING));
            }
        });
		java.awt.Dimension dim = java.awt.Toolkit.getDefaultToolkit().getScreenSize(); this.setLocation(dim.width/2-this.getSize().width/2 + 50, dim.height/2-this.getSize().height/2 + 50);
		finalizeListBox = new JList<File>(new DefaultListModel<File>()); finalizeListBox.setBounds(165, 20, 400, 320); getContentPane().add(finalizeListBox);
		File projPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim());
		if (! projPath.exists()) {
			JOptionPane.showMessageDialog(null, "Project '" + mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		boolean okToTradesk = true;
		try {
			projPath = new File(projPath, "target-native");
			if (! projPath.exists()) projPath = new File(projPath.getParentFile(), "target");
			if (! projPath.exists()) {
				JOptionPane.showMessageDialog(mainWindow, 
					"Target directory does not exist, \nPlease call 'Create translated documents' in OmegaT", 
					"alert", JOptionPane.ERROR_MESSAGE); 
				okToTradesk = false;
			}
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(projPath.toPath(), "*.*")) {
				for (Path p: dirStream) ((DefaultListModel) finalizeListBox.getModel()).addElement (projPath.toPath().relativize(p).toFile());
			}
		} catch (Exception e) {
		}

		JPanel pFilesList = new JPanel(); pFilesList.setBorder(new TitledBorder("Files List")); pFilesList.setLayout(null);
		pFilesList.setBounds(10, 15, 140, 130); getContentPane().add(pFilesList);
		createButton(pFilesList, "&Add", "Add document to list", new Rectangle(25, 25, 85, 25), null, this::Add); 
		createButton(pFilesList, "&Remove", "Remove selected document from list", new Rectangle(25, 55, 85, 25), null, ev -> SwingUtils.RemoveFromJList(this, this.finalizeListBox)); 
		createButton(pFilesList, "&Clear", "Clear list of documents", new Rectangle(25, 85, 85, 25), null, ev -> ((DefaultListModel) finalizeListBox.getModel()).removeAllElements()); 

		createButton(getContentPane(), "To &Euramis", "Send Memories to Euramis", new Rectangle(20, 250, 130, 25), null, this::SendToEuramis); 
		ActionListener sendTradeskMethod = null;
		String method = mainWindow.GLOBAL_CONFIG.getProperty("Tradesk.method");
		if ("file".equalsIgnoreCase(method)) sendTradeskMethod = new dgt.jwizard.act.SendToTradeskPath(mainWindow, this);
		else sendTradeskMethod = new dgt.jwizard.act.SendToTradeskSoap(mainWindow, this);				
		JButton btnToTradesk = createButton(getContentPane(), "To &TRAdesk", "Send documents to TRAdesk", new Rectangle(20, 280, 130, 25), null, sendTradeskMethod); 
		if (! okToTradesk) btnToTradesk.setEnabled(false);
	}
	
	private void Add(ActionEvent ev) {
		File targetPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator 
			+ mainWindow.fdProject.getText() + File.separator + "target-native");
		if (! targetPath.exists()) targetPath = new File(targetPath.getParentFile(), "target");
		JFileChooser fChooser = new JFileChooser (targetPath); fChooser.setMultiSelectionEnabled(true);
		fChooser.setFileFilter(new javax.swing.filechooser.FileNameExtensionFilter(
			"Dossiers (*.docx;*.xls?;*.pptx;*.xml;*.htm?;*.sdlxliff;*.xliff)",
			"docx", "xlsx", "pptx", "xml", "htm", "html", "xliff", "xlf", "sdlxliff"));
		while (fChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
			File[] selected = fChooser.getSelectedFiles();
			if ((selected == null) || (selected.length == 0)) break;
			DefaultListModel model = (DefaultListModel) finalizeListBox.getModel();
			for (File f: selected) {
				File rel = targetPath.toPath().relativize(f.toPath()).toFile();
				if (! model.contains(rel)) model.addElement(rel);
			}
		}
	}
	
	private Pattern TMX_PTN = Pattern.compile("(\\w+)-(\\d{4})-(\\d{5})-(\\d{2})-(\\d{2})-((?:\\d{2}-)?[A-Za-z]{2}-[A-Za-z]{3}-\\d\\d)");
	
	private void SendToEuramis(ActionEvent ev) {
		String alignDir = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Euramis4Alignment");
		if ("true".equals(mainWindow.GLOBAL_CONFIG.getProperty("wizard.EuramisProject"))) 
			alignDir += File.separator + mainWindow.fdProject.getText();
		String path = mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator 
			+ mainWindow.fdProject.getText() + File.separator + "Euramis";
		try {
			try (PrintStream log = new PrintStream(path + File.separator + ".." + File.separator + "wizard-to-euramis.log")) {
				try {
					int count = 0;
					try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path), "*.tmx")) {
						for (Path curFile: dirStream) {
							log.println("File " + curFile + ": \n"); 
							String euramisFile = alignDir + File.separator + "SAVE_" + System.getProperty("user.name").toUpperCase() + "_"; 
							String dossierTmx = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
							String pretFile = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
							String curFileName = curFile.getName(curFile.getNameCount() - 1).toString(); 
							Matcher dsrMatch = TMX_PTN.matcher(curFileName);
							if (dsrMatch.find()) {
								euramisFile += expandMatcher(dsrMatch, "$1-$2-$3$4$5-{src}-{tra}-EXP.tmx");
								dossierTmx += expandMatcher(dsrMatch, "$1/$1-$2-$3/final/$0-{src}-{tra}.tmx");
								pretFile += expandMatcher(dsrMatch, "$1/$1-$2-$3/pret/$0-{src}-{tra}.tmx");
							} else {
								euramisFile += curFileName;
								dossierTmx += "final" + File.separator + curFileName;
								pretFile += "pret" + File.separator + curFileName;
							}
							for (String dest: new String[] { euramisFile, dossierTmx, pretFile }) {
								log.println("\t" + dest + "\n"); 
								Files.copy(curFile, Paths.get(dest), StandardCopyOption.REPLACE_EXISTING);
							}
							curFile.toFile().renameTo(new File(path + File.separator + "sent" + File.separator + curFileName));
							LogToMain ("" + curFile + " sent to Euramis"); count++;
							
							log.println("\t-->\t" + path + File.separator + "sent" + File.separator + curFileName);
						}
					}
					LogToMain ("" + count + " file(s) sent to Euramis");
				} catch (Exception e) {
					log.println(e.getClass().getName() + ": " + e.getMessage());
					e.printStackTrace(log);
					JOptionPane.showMessageDialog(null, e.getClass().getName(), "alert", JOptionPane.ERROR_MESSAGE); 
				}
			}
		} catch (IOException io) {
			JOptionPane.showMessageDialog(null, io.getClass().getName(), "alert", JOptionPane.ERROR_MESSAGE);
		}
	}
	
	private Pattern REGEX_VARIABLE = Pattern.compile("(?<!\\\\)((?:\\\\\\\\)*)\\$(\\d+)");
	
	private String expandMatcher(Matcher matcher1, String expression) {
		expression = expression.replace("{src}", mainWindow.srcBox.getSelectedItem().toString()).replace("{tra}", mainWindow.traBox.getSelectedItem().toString());
		Matcher varMatch = REGEX_VARIABLE.matcher(expression); StringBuffer buf = new StringBuffer();
		while (varMatch.find()) varMatch.appendReplacement(buf, varMatch.group(1) + matcher1.group(Integer.parseInt(varMatch.group(2))));
		varMatch.appendTail(buf); return buf.toString().replace("/", File.separator);
	}

	public void LogToMain(String text) { 
		mainWindow.msgArea.setText(mainWindow.msgArea.getText() + "\n" + text);
	}
}