package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;

import javax.swing.*;

import java.io.*;
import java.nio.file.*;

public class ImportTmxDialog extends JDialog {
	
	private JWizard mainWindow;
	private CreateProjectDialog parent;
	private File tmxPath;
	private JPanel tmxSameDoc = new JPanel(), tmxSameDossier = new JPanel(), tmxOthers = new JPanel();
	
	public ImportTmxDialog(JWizard mainWindow, CreateProjectDialog parent, DefaultListModel list, File tmxPath, String langJokers, PrintStream log) throws IOException {
		super(parent, true); setTitle("TMX files to import");
		this.mainWindow = mainWindow; this.tmxPath = tmxPath; this.parent = parent;
				
		tmxSameDoc.setLayout(new BoxLayout(tmxSameDoc, BoxLayout.Y_AXIS)); tmxSameDossier.setLayout(new BoxLayout(tmxSameDossier, BoxLayout.Y_AXIS)); tmxOthers.setLayout(new BoxLayout(tmxOthers, BoxLayout.Y_AXIS));		
		final Path DOSSIERS_PATH = Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers"));
		java.util.Map<String,JCheckBox> boxes = new java.util.HashMap<>();
		for (java.util.Enumeration<File> e = list.elements(); e.hasMoreElements();) {
			File f = e.nextElement();
			final java.util.regex.Matcher mProj = BackupTask.DGT_PROJ.matcher(f.getName());
			if (! mProj.find()) continue;
			
			LogMessage(log, "Exploring " + mProj.group() + " " + langJokers + " tmx's ...");
			if (mainWindow.secemOption.isSelected()) {
				File tradosPath = new File(parent.SecemProjectPath(f.getName()), "RefTm");
				if (tradosPath.exists()) browseDirectory(tradosPath.toPath(), langJokers, mProj, boxes, log);
			}
			String curDossierPret = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
			curDossierPret += mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret";
			if (! new File(curDossierPret).exists()) { LogMessage(log, "\t" + curDossierPret + " not found"); continue; }
			browseDirectory(Paths.get(curDossierPret), langJokers, mProj, boxes, log);
		}
		java.awt.Container pane = this.getContentPane(); pane.setLayout (new BoxLayout(pane, BoxLayout.Y_AXIS));
		pane.add(new JLabel("Same document, version and part")); pane.add(new JScrollPane(tmxSameDoc)); pane.add(ChangeButtonsPanel(tmxSameDoc));
		pane.add(new JLabel("Same dossier, other version and part")); pane.add(new JScrollPane(tmxSameDossier)); pane.add(ChangeButtonsPanel(tmxSameDossier));
		pane.add(new JLabel("Other TMX from pret folder"));	pane.add(new JScrollPane(tmxOthers)); pane.add(ChangeButtonsPanel(tmxOthers));
		pane.add (new JPanel()); 
		JPanel pButtons = new JPanel(); pButtons.setLayout(new BoxLayout(pButtons, BoxLayout.X_AXIS)); pane.add(pButtons);
		JButton btnOk = new JButton("OK"); pButtons.add(btnOk); btnOk.addActionListener(ev -> DoImport(log));
		this.setBounds(mainWindow.getX() + 100, mainWindow.getY() + 100, 600, 630);
	}
	
	private void browseDirectory (Path dir, String langJokers, 
		java.util.regex.Matcher mProj, java.util.Map<String,JCheckBox> boxes, PrintStream log
	) throws IOException {
		try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir, "*" + langJokers + "*.tmx")) {
			LogMessage(log, "\tExploring " + dir + File.separator + "*" + langJokers + "*.tmx");
			boolean isPretDir = dir.toString().toLowerCase().contains("pret");
		DIRLOOP:
			for (Path p: dirStream) 
				if (p.getFileName().toString().toLowerCase().startsWith("draft_")) { 
					LogMessage(log, "\t\tPass " + p); continue DIRLOOP; 
				} else if (findInProject(tmxPath, p)) {
					LogMessage(log, "\t\tAlready in directory: " + p); continue DIRLOOP; 							
				} else {
					String name = p.getFileName().toString(); LogMessage(log, "\t\tAdding " + name);
					if (isPretDir)
						name = mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret" + File.separator + name;
					else {
						name = dir.toString() + File.separator + name;
						name = name.substring(name.indexOf("Sensitive Projects") + ("Sensitive Projects" + File.separator).length());
					}
					JCheckBox box0 = boxes.get(name); if (box0 == null) boxes.put(name, box0 = new JCheckBox(name,true));
					if (name.contains("RefTm")) box0.setBackground(new java.awt.Color(0xFF,0xE0,0xE0));
					name = name.substring(name.lastIndexOf(File.separator) + File.separator.length());
					if (name.startsWith(mProj.group())) tmxSameDoc.add(box0);
					else if (name.startsWith(mProj.group(1) + "-" + mProj.group(2))) {
						if (! arrayContains(tmxSameDoc.getComponents(), box0)) tmxSameDossier.add(box0);
					} else {
						if (! (arrayContains(tmxSameDoc.getComponents(), box0) || arrayContains(tmxSameDossier.getComponents(), box0))) tmxOthers.add(box0);
					}
				}
		}		
	}
	
	private static boolean arrayContains(Object[] array, Object value) {
		if (array == null) return false;
		for (Object obj: array) if (obj == value) return true;
		return false;
	}
	
	private static boolean findInProject(File projPath, Path p) {
		if (new File(projPath, p.getFileName().toString()).exists()) return true;
		for (File sub: projPath.listFiles())
			if (sub.isDirectory() && findInProject(sub, p)) return true;
		return false;
	}
	
	private JPanel ChangeButtonsPanel(final JPanel tmxPanel) {
		JPanel pChangeButtons = new JPanel(); pChangeButtons.setLayout(new BoxLayout(pChangeButtons, BoxLayout.X_AXIS)); 
		JButton btnAddAll, btnRemoveAll;
		pChangeButtons.add (btnAddAll = new JButton("Select all")); pChangeButtons.add (btnRemoveAll = new JButton("Unselect all")); 
		btnAddAll.addActionListener(ev -> {
			for (java.awt.Component comp: tmxPanel.getComponents())
				try { ((JCheckBox) comp).setSelected(true); } catch (Exception e){}
		});
		btnRemoveAll.addActionListener(ev -> {
			for (java.awt.Component comp: tmxPanel.getComponents())
				try { ((JCheckBox) comp).setSelected(false); } catch (Exception e){}
		});
		return pChangeButtons;
	}
		
	private void LogMessage(PrintStream out, String msg) { out.println(msg); mainWindow.msgArea.append(msg); }

	private void DoImport(PrintStream log) {
		LogMessage(log, "Importing memories ... ");
		for (JPanel panel: new JPanel[] { tmxSameDoc, tmxSameDossier, tmxOthers })
		COMPLOOP:
			for (java.awt.Component comp: panel.getComponents())
				try {
					JCheckBox box = (JCheckBox) comp; if (! box.isSelected()) continue COMPLOOP;
					String fileName = box.getText();						
					File dest = tmxPath; if (fileName.toLowerCase().endsWith("-mt.tmx")) { dest = new File(dest.getParentFile(), "mt"); dest.mkdirs(); }
					dest = new File(dest, fileName.substring(fileName.lastIndexOf(File.separator) + 1)); if (dest.exists()) continue;
					if (fileName.toLowerCase().contains(File.separator + "pret" + File.separator)) {
						LogMessage(log, "\t" + (mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator + fileName) + " --> " + dest);
						Files.copy (Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator + fileName), dest.toPath()); 
					} else {	// File from SECEM
						File tradosPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects")); 
						tradosPath = new File(tradosPath.getParentFile(), "Sensitive Projects");
						LogMessage(log, "\t" + (tradosPath + File.separator + fileName) + " --> " + dest);
						Files.copy (Paths.get(tradosPath + File.separator + fileName), dest.toPath()); 							
					}
				} catch (ClassCastException cce) {
					
				} catch (IOException io) {
					LogMessage(log, io.getClass().getName() + ": " + io.getMessage());
				}
		this.setVisible(false);		
	}
	
}