package dgt.jwizard.ui;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;
import java.util.Properties;
import java.util.LinkedList;
import java.util.regex.*;

import java.io.File;
import java.nio.file.*;

import org.openide.awt.Mnemonics;

import static dgt.jwizard.ui.SwingUtils.*;
import dgt.jwizard.act.*;

public class JWizard extends JFrame {
	
	public static final String VERSION = "2.5.3";	
	
	public static final Color DEFAULT_BACKGROUND = new Color(0x8C, 0xB4, 0xE8); // colors from http://www.cc.cec/DGT/__QAT/TrueColorChart.htm
	
	public static void main(String[] args) {
		new JWizard().setVisible(true);
	}
	
	protected static final Pattern PTN_ENV_VAR = Pattern.compile("\\%(\\w+)\\%", Pattern.CASE_INSENSITIVE + Pattern.UNICODE_CASE);
	public Properties GLOBAL_CONFIG = new Properties(), PERSO_CONFIG = new Properties();
	
	// Used components
	public final JList<File> documentsListBox;
	public final JTextField fdProject;
	public final JTextArea msgArea;
	public final JComboBox srcBox, traBox;
	public final JCheckBox secemOption;
	public final JButton runOtButton;
	
	public JWizard() {
		super ("OmegaT Project Wizard " + VERSION + " " + environment()); 
		setIconImage(new ImageIcon(getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
		try { 
			Properties GLOBAL_CONFIG_tmp = new Properties(); GLOBAL_CONFIG_tmp.load (new java.io.FileInputStream("global-config.properties")); 			
			for (Object key: GLOBAL_CONFIG_tmp.keySet()) {
				if (key.toString().startsWith(";")) continue;
				// GLOBAL_CONFIG[key] =~ s!%(.+)%!System.getEnv($1)!g
				Matcher envMatch = PTN_ENV_VAR.matcher(GLOBAL_CONFIG_tmp.getProperty(key.toString()));
				StringBuffer sb = new StringBuffer();
				while (envMatch.find()) {
					String val = System.getenv(envMatch.group(1)); if (val == null) {
						JOptionPane.showMessageDialog(this, "Error in config: " + envMatch.group(1) + " not found", "alert", JOptionPane.ERROR_MESSAGE); 
						val = "";
					}
					envMatch.appendReplacement(sb, val.replace("\\","\\\\"));
				}
				envMatch.appendTail(sb);
				GLOBAL_CONFIG.setProperty(key.toString(), sb.toString());
			}
		} catch (Exception e) {
			JOptionPane.showMessageDialog(this, "Cannot load global config. Cannot work.", "alert", JOptionPane.ERROR_MESSAGE); 
			e.printStackTrace();
			System.exit(1);
		}
		try { PERSO_CONFIG.load (new java.io.FileInputStream("user-config.properties")); } 
		catch (Exception e) {} // keep defaults
		setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		setBounds(0, 0, 950, 670); 
		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize(); this.setLocation(dim.width/2-this.getSize().width/2, dim.height/2-this.getSize().height/2);
		
		Container pane = this.getContentPane(); pane.setBackground(DEFAULT_BACKGROUND); 
		pane.setLayout (null); // copy dimensions from original wizard
		
		createButton(pane, "&Quick Guide", "Project Wizard help", new Rectangle(795, 0, 125, 20), new Color(0, 0xFF, 0), openFile("helpButton.Helpfile")); 
		createButton(pane, "Gui&de", "Guide", new Rectangle(720, 0, 75, 20), null /*new Color(0, 0xCC, 0x99) */, openFile("helpButton.Guide")); 
		createButton(pane, "Other Gui&des", "Other documents and guides", new Rectangle(645, 0, 75, 20), null /*new Color(0, 0xCC, 0x99) */, openFile("helpButton.OtherGuides")); 
		createButton(pane, "Ne&ws", "What's New in DGT OmegaT", new Rectangle(570, 0, 75, 20), new Color(0xFF, 0xFF, 0x66),openFile("helpButton.News")); 
		createButton(pane, "Stats", "Current Project Statistics", new Rectangle(495, 0, 75, 20), null /* new Color(0xFF, 0xFF, 0x66) */,ev -> ViewStats()); 
		createButton(pane, "Videos", "Demo Videos", new Rectangle(420, 0, 75, 20), null /* new Color(0xFF, 0xFF, 0x66) */,ev -> Videos()); 
		
		this.documentsListBox = new JList<File>(new DefaultListModel<File>()); pane.add(documentsListBox); documentsListBox.setBounds(165, 30, 610, 450);
				
		JPanel panDocuments = new JPanel(); pane.add(panDocuments); panDocuments.setBounds(10, 15, 95, 90); panDocuments.setBackground(DEFAULT_BACKGROUND);
		panDocuments.setBorder(new TitledBorder("Documents")); 
		createButton(panDocuments, "&Add", "Add documents to project document list", new Rectangle(20, 30, 75, 25), null /* new Color(0xFF, 0xFF, 0x66) */, ev -> AddFile()); 
		createButton(panDocuments, "&Remove", "Remove documents from project document list", new Rectangle(20, 60, 75, 25), null /* new Color(0xFF, 0xFF, 0x66) */, ev -> SwingUtils.RemoveFromJList(this, this.documentsListBox)); 
		
		this.secemOption = new JCheckBox("SECEM");
		pane.add(secemOption); secemOption.setBounds(20, 150, 75, 20); secemOption.setBackground(DEFAULT_BACKGROUND);
		secemOption.setToolTipText("SECEM mode (no backup)"); secemOption.setSelected(false);

		PanelProjects panProjects = new PanelProjects(this); pane.add(panProjects); panProjects.setBounds(10, 205, 145, 280); panProjects.setBackground(DEFAULT_BACKGROUND);
		
		this.runOtButton = createButton(pane, "&Open", "Open selected project", new Rectangle(20, 500, 75, 25), new Color(0, 0xCC, 0), ev -> StartOmegaT());
		
		PanelRevision panRevision = new PanelRevision(this); pane.add(panRevision); panRevision.setBounds(785, 25, 135, 320);
		secemOption.addChangeListener(ev -> { panRevision.panRevTranslator.toggleSecem(); panRevision.panRevRevisor.toggleSecem(); });
		
		JPanel panEuramis = new JPanel(); pane.add(panEuramis); panEuramis.setBounds(785, 355, 135, 100); panEuramis.setBackground(DEFAULT_BACKGROUND);
		panEuramis.setBorder(new TitledBorder("Euramis/Tradesk")); panEuramis.setLayout(null);
		createButton(panEuramis, "Send", "Send to Tradesk - Euramis", new Rectangle(10,18, 95, 25), null /* new Color(0xFF, 0xFF, 0x66) */,ev -> Upload()); 
		
		JLabel lbProject = new JLabel(); Mnemonics.setLocalizedText(lbProject, "&Project"); pane.add(lbProject); 
		lbProject.setBounds(115, 495, 50, 25); lbProject.setBackground(DEFAULT_BACKGROUND);
		this.fdProject = new JTextField(); pane.add(fdProject); fdProject.setBounds(175, 495, 400, 25);
		fdProject.setToolTipText("Project name");
		if (PERSO_CONFIG.getProperty("project.name") != null) fdProject.setText(PERSO_CONFIG.getProperty("project.name")); 
		
		JLabel srcLabel = new JLabel(); Mnemonics.setLocalizedText(srcLabel, "&Source"); 
		pane.add(srcLabel); srcLabel.setBackground(DEFAULT_BACKGROUND); srcLabel.setBounds(620, 495, 50, 25);
		this.srcBox = new JComboBox(GLOBAL_CONFIG.getProperty("languages.list").split(",")); pane.add(srcBox); srcBox.setBounds(680, 495, 50, 25); srcBox.setToolTipText("Select Source language");
		if (PERSO_CONFIG.getProperty("lang.src") != null) srcBox.setSelectedItem(PERSO_CONFIG.getProperty("lang.src")); else srcBox.setSelectedItem("EN");
		JLabel traLabel = new JLabel(); Mnemonics.setLocalizedText(traLabel, "&Target"); 
		pane.add(traLabel); traLabel.setBackground(DEFAULT_BACKGROUND); traLabel.setBounds(770, 495, 50, 25);
		this.traBox = new JComboBox(GLOBAL_CONFIG.getProperty("languages.list").split(",")); pane.add(traBox); traBox.setBounds(820, 495, 50, 25); traBox.setToolTipText("Select Target language");
		if (PERSO_CONFIG.getProperty("lang.tra") != null) traBox.setSelectedItem(PERSO_CONFIG.getProperty("lang.tra")); else srcBox.setSelectedItem("FR");
		srcBox.addItemListener (ev -> setPropValue(srcBox, "lang.src")); traBox.addItemListener (ev -> setPropValue(traBox, "lang.tra"));
		
		this.msgArea = new JTextArea(); JScrollPane scrollArea = new JScrollPane(msgArea); pane.add(scrollArea); scrollArea.setBounds(10, 540, 900, 70); msgArea.setEditable(false);
		msgArea.setBackground(new Color(0x9D, 0xC5, 0xF9));
	}
	
	private ActionListener openFile (String propName) {
		return ev -> {
			String fileName = GLOBAL_CONFIG.getProperty(propName);
			if (fileName == null) JOptionPane.showMessageDialog(null, "Property not configured: " + propName, "alert", JOptionPane.ERROR_MESSAGE);  
			else if (fileName.length() == 0) JOptionPane.showMessageDialog(null, "Property not configured: " + propName, "alert", JOptionPane.ERROR_MESSAGE);  
			else
				try { Desktop.getDesktop().open (new File(fileName)); }
				catch (Exception e) { JOptionPane.showMessageDialog(null, "Cannot load " + fileName, "alert", JOptionPane.ERROR_MESSAGE);  }
		};
	}
	
	private void setPropValue(JComboBox box, String propName) {
		PERSO_CONFIG.setProperty(propName, box.getSelectedItem().toString());
		try { PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}
	}
	private void setPropValue(JCheckBox box, String propName) {
		PERSO_CONFIG.setProperty(propName, box.isSelected() ? "true" : "false");
		try { PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}
	}
	
	// -------------------------------- Button actions ---------------------
	
	private void BrowseProject() {
		if ((fdProject.getText() == null) || (fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot browse a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File path = new File(GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + fdProject.getText().trim());
		if (! path.exists()) {
			JOptionPane.showMessageDialog(null, "Project '" + fdProject.getText() + "' does not exist yet !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		msgArea.setText("Browsing project \"" + fdProject.getText() + "\" ...");
		try { Desktop.getDesktop().open (path); }
		catch (Exception e) { JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", JOptionPane.ERROR_MESSAGE);  }
	}
		
	private void AddFile() {
		runOtButton.setBackground(new Color(0xBF, 0xBF, 0xBF)); runOtButton.setEnabled(false);
		JDialog dlgAdd = new JDialog(this, "Select add method"); dlgAdd.setModal(true);
		dlgAdd.getContentPane().setLayout(new BoxLayout(dlgAdd.getContentPane(), BoxLayout.Y_AXIS));
		/*for (AddFileAction action: AddFileAction.ALL_ACTIONS) {
			JButton btn = new JButton(action.getLabel()); dlgAdd.getContentPane().add(btn);
			btn.addActionListener (ev -> {*/
			
				AddFileAction action = AddFileAction.ALL_ACTIONS[0]; 
			
				File[] selected = action.doSelectFiles(this); if (selected == null) return;
				for (File f: selected) if (f.getPath().toString().contains("Sensitive")) { secemOption.setSelected(true); break; }
				DefaultListModel model = (DefaultListModel) documentsListBox.getModel();
				StringBuffer message = new StringBuffer("Added document(s): \n");
				for (File f: selected) if (! model.contains(f)) { model.addElement(f); message.append(f.toString()).append("\n"); }
				msgArea.setText(message.toString());
				if ((fdProject.getText() == null) || (fdProject.getText().trim().length() == 0)) {
					java.util.regex.Pattern DGT_PROJ = java.util.regex.Pattern.compile("(\\w+-\\d{4}-\\d{5})");
					for (File f: selected) {
						Matcher mProj = DGT_PROJ.matcher(f.getName());
						if (mProj.find()) { 
							fdProject.setText(mProj.group(1)); 
							PERSO_CONFIG.setProperty("project.name", mProj.group(1));
							try { PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}
							return; 
						}
					}
					// Still here? use Date
					fdProject.setText(System.getProperty("user.name") + "-" 
						+ new java.text.SimpleDateFormat("yyyyMMdd-HHmmss").format(new java.util.Date())); 
					PERSO_CONFIG.setProperty("project.name", fdProject.getText());
					try { PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}					
				}
			/*});
		}
		dlgAdd.getContentPane().add(new JLabel()); // separator
		JButton btnCancel = new JButton("Cancel");  dlgAdd.getContentPane().add(btnCancel); 
		btnCancel.addActionListener (ev -> dlgAdd.setVisible(false));
		dlgAdd.setBounds(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 100, 100); dlgAdd.pack(); 
		dlgAdd.setVisible(true);*/
	}
	
	private void Upload() {
		if (secemOption.isSelected()) {
			JOptionPane.showMessageDialog(null, "You are translating a SECEM project!!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		if ((fdProject.getText() == null) || (fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot send a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		msgArea.setText("" + ((DefaultListModel) documentsListBox.getModel()).size() + " file(s) will be sent to TRADESK");
		((DefaultListModel) documentsListBox.getModel()).removeAllElements();
		new EuramisWindow(this).setVisible(true);
	}
	
	private void ViewStats() {
		String dst = GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath");
		if (secemOption.isSelected()) dst += File.separator + "_SECEM";
		dst += File.separator + fdProject.getText().trim();
		File destDir = new File(dst);
		File statsFile = new File(destDir, "OTStats_" + fdProject.getText().trim() + ".xlsx");
		if (! statsFile.exists())	// project changed name?
			for (File f0: destDir.listFiles()) 
				if (f0.getName().startsWith("OTStats_") && f0.getName().endsWith(".xlsx")) {
					f0.renameTo (statsFile); break;
				}
		try {
			Runtime.getRuntime().exec(new String[] { GLOBAL_CONFIG.getProperty("exe.Excel"), "/s", statsFile.toString() });
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	private void Videos() {
		if ((GLOBAL_CONFIG.getProperty("Paths.Videos") == null) || (GLOBAL_CONFIG.getProperty("Paths.Videos").trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Videos directory not set !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File videosDir = new File(GLOBAL_CONFIG.getProperty("Paths.Videos"));
		if (! (videosDir.exists() && videosDir.isDirectory())) {
			JOptionPane.showMessageDialog(null, "Videos directory not found (" + videosDir + ")", "alert", JOptionPane.ERROR_MESSAGE); return;			
		}
		JDialog videosDlg = new JDialog(this, false); videosDlg.setBounds(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 350, 230);
		videosDlg.getContentPane().setLayout(new BorderLayout());
		JList<Path> videosList = new JList<Path>(new DefaultListModel<Path>()); videosDlg.add(videosList, BorderLayout.NORTH);
		try {
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(videosDir.toPath(), "*.*")) {
				for (Path p: dirStream) ((DefaultListModel) videosList.getModel()).addElement (videosDir.toPath().relativize(p));
			}
		} catch (Exception e) {
			
		}
		JButton btnView = new JButton("View"); videosDlg.getContentPane().add(btnView, BorderLayout.SOUTH);
		btnView.addActionListener (ev -> {
			try {
				Runtime.getRuntime().exec (new String[] { GLOBAL_CONFIG.getProperty("exe.vlc"), new File(videosDir, videosList.getSelectedValue().toString()).toString() });
			} catch (Exception e) {
				JOptionPane.showMessageDialog(null, "Could not open " + videosList.getSelectedValue() + " : \n" + e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE); return;
			}
		});
		videosDlg.setVisible(true);
	}
	
	private void StartOmegaT() {
		if ((fdProject.getText() == null) || (fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot OPEN a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File projDir = new File(GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + fdProject.getText().trim());
		if (! projDir.exists()) if (secemOption.isSelected()) projDir = new File(new File(projDir.getParentFile(), "_Secem"), fdProject.getText().trim());
		if (! projDir.exists()) {
			JOptionPane.showMessageDialog(null, "Project " + fdProject.getText() + " does not exist yet !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		if (! new File(projDir, "omegat.project").exists()) {
			JOptionPane.showMessageDialog(null, "File 'omegat.project' does not exist: Create or Update before !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		/*if (new File("OmegaT.sock").exists()) {
			JOptionPane.showMessageDialog(null, "OmegaT is running : close it before opening another project ...", "alert", JOptionPane.ERROR_MESSAGE); return;
		}*/
		PERSO_CONFIG.setProperty("project.name", fdProject.getText());
		msgArea.setText("Opening OmegaT Project ...");
		
		LinkedList<String> omegatCmd = new LinkedList<>(); omegatCmd.add(GLOBAL_CONFIG.getProperty("exe.omegat"));
		if ((omegatCmd.get(0) == null) || (omegatCmd.get(0).trim().length() == 0)) {
			omegatCmd.set(0, System.getenv().get("JAVA_HOME"));
			if ((omegatCmd.get(0) == null) || (omegatCmd.get(0).trim().length() == 0)) {
				 JOptionPane.showMessageDialog(null, "Cannot run OmegaT:\nEither set JAVA_HOME environment variable\nor 'exe.omegat' in global-config.properties", "alert", JOptionPane.ERROR_MESSAGE); 
				 return;
			}
			omegatCmd.set(0, omegatCmd.get(0) + "\\bin\\javaw.exe");
			byte percent = 50; try { percent = Byte.parseByte("omegat.memuse"); } catch (Exception e){}
			double mem = Runtime.getRuntime().maxMemory() * (percent / 100.0);
			int useMiB = (int) (mem / 1024.0 / 1024.0);
			omegatCmd.add ("-Xmx" + useMiB +"M");  omegatCmd.add ("-Xms" + useMiB +"M");
			String config = GLOBAL_CONFIG.getProperty("Paths.OmegaTConfig");
			if ((config != null) && (config.trim().length() > 0)) omegatCmd .add("--config-dir=" + config);			
		}
		omegatCmd.add (projDir.toString());
		new Thread(() -> {
			java.io.PrintStream log; try { log = new java.io.PrintStream("OmegaT.run"); } catch (Exception e) { log = System.err; }
			log.println(String.join(" ", omegatCmd.toArray(new String[0])));
			try { 
				final Process proc = Runtime.getRuntime().exec (omegatCmd.toArray(new String[0])); 
				this.runOtButton.setEnabled(false); repaint();
				BackupTask timer = new BackupTask(this, fdProject.getText().trim(), true);
				try { timer.interval = Integer.parseInt(GLOBAL_CONFIG.getProperty("backup.interval")) * 60_000; } catch (Exception e) {} 
				if (! secemOption.isSelected()) if (timer.interval > 0) timer.start();
				proc.getInputStream().close(); /*try (java.io.BufferedReader is = new java.io.BufferedReader(new java.io.InputStreamReader(proc.getInputStream()))) { 
					String line; while ((line = is.readLine()) != null) log.println(line);
				}*/
				try (java.io.BufferedReader is = new java.io.BufferedReader(new java.io.InputStreamReader(proc.getErrorStream()))) { 
					String line; while ((line = is.readLine()) != null) log.println(line);
				}
				//proc.getInputStream().close(); proc.getErrorStream().close();
				/*try (java.io.PrintStream fos = new java.io.PrintStream("OmegaT.sock")) { fos.println("sock"); }*/
				while (proc.isAlive()) proc.waitFor(5000, java.util.concurrent.TimeUnit.MILLISECONDS);					
				this.runOtButton.setEnabled(true); repaint(); timer.active = false;
				/*new File("OmegaT.sock").delete();*/
			}
			catch (Exception e) { JOptionPane.showMessageDialog(null, e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE); }
		}).start();	
	}
}