package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;

import java.io.*;

import static dgt.jwizard.ui.SwingUtils.*;

public class PanelProjects extends JPanel {
	
	private JWizard mainWindow;
	
	public PanelProjects(JWizard mainWindow) {
		this.mainWindow = mainWindow;
		setBorder(new TitledBorder("Projects")); this.setLayout(null);
		SwingUtils.IntWrapper Y = new SwingUtils.IntWrapper(); Y.val = -10;
		createButton("&Create", "Create project with selected documents", Y, this::CreateProject); 
		createButton("&Select", "Select project", Y,this::SelectProject); 
		createButton("&Update", "Update current project with selected documents", Y, this::CreateProject); 
		createButton("&Browse ", "Browse current project", Y, this::BrowseProject); 
		Y.val = 150;
		createButton("Tea&m Base", "Shared memories", Y, this::OpenTeambaseWindow); 
		createButton("C&lear", "Clear document selection", Y, this::ClearList); 
		createButton("Back&Up ", "Force Backup", Y, this::Backup); 
		
		dirChooser = new JFileChooser (new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath")));		
		dirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		dirChooser.setPreferredSize(new Dimension((int) dirChooser.getPreferredSize().getWidth() + 100, (int) dirChooser.getPreferredSize().getHeight()));
		dirChooser.getActionMap().get("viewTypeDetails").actionPerformed(null);
	}
	
	private static final Color BTN_COLOR = null; /* new Color(0xFF, 0xFF, 0x66) */
	
	private JButton createButton(String label, String tooltip, SwingUtils.IntWrapper Y, ActionListener listener) {
		Y.val += 30;
		if (label.length() <= 7) return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(38, Y.val, 75, 25), BTN_COLOR, listener); 
		if (label.length() <= 8) return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(33, Y.val, 85, 25), BTN_COLOR, listener);
		return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(20, Y.val, 110, 25), BTN_COLOR, listener);
	}
	
	// -------------------------------- Button actions ---------------------
	
	private void BrowseProject(ActionEvent ev) {
		if ((mainWindow.fdProject.getText() == null) || (mainWindow.fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot browse a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File path = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim());
		if (! path.exists()) {
			JOptionPane.showMessageDialog(null, "Project '" + mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		mainWindow.msgArea.setText("Browsing project \"" + mainWindow.fdProject.getText() + "\" ...");
		try { Desktop.getDesktop().open (path); }
		catch (Exception e) { JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", JOptionPane.ERROR_MESSAGE);  }		
	}

	private JFileChooser dirChooser;
	
	private void SelectProject(ActionEvent ev) {
		// dirChooser = new JFileChooser (new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath")));
		JTable chooserTable = (JTable) (dgt.lib.SwingUtils.getDescendantsOfType(JTable.class, dirChooser).get(0));
		chooserTable.getRowSorter().toggleSortOrder(3); chooserTable.getRowSorter().toggleSortOrder(3);
		javax.swing.table.TableColumn col0 = chooserTable.getColumnModel().getColumn(0); col0.setPreferredWidth(col0.getPreferredWidth() + 100);
		if (dirChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
			File selected = dirChooser.getSelectedFile();
			try {
				try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(selected, "omegat.project"))))) {
					String line; int idx; while ((line = reader.readLine()) != null) {
						if ((idx = line.indexOf("<source_lang>")) >= 0) {
							line = line.substring(idx + 13); line = line.substring(0, 2);
							mainWindow.srcBox.setSelectedItem(line.toUpperCase());
						}
						if ((idx = line.indexOf("<target_lang>")) >= 0) {
							line = line.substring(idx + 13); line = line.substring(0, 2);
							mainWindow.traBox.setSelectedItem(line.toUpperCase());
						}
					}
				}
			} catch (FileNotFoundException fnf) {
				JOptionPane.showMessageDialog(null, dirChooser.getSelectedFile() + " is not a valid OmegaT Project !", "alert", JOptionPane.ERROR_MESSAGE); return;
			} catch (Exception eOther) {
				JOptionPane.showMessageDialog(null, eOther.getMessage(), "alert", JOptionPane.ERROR_MESSAGE); return;
			}
			new File(selected, "Euramis\\sent").mkdirs();
			mainWindow.secemOption.setSelected(selected.toString().toUpperCase().contains("_SECEM"));
			mainWindow.fdProject.setText(selected.getName());
			mainWindow.PERSO_CONFIG.setProperty("project.name", selected.getName()); try { mainWindow.PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}
			mainWindow.runOtButton.setBackground(new java.awt.Color(0x0, 0xCC, 0x0));
			mainWindow.runOtButton.setEnabled(true);		
			mainWindow.msgArea.setText("Project has been selected, you could open it now!");
			((DefaultListModel) mainWindow.documentsListBox.getModel()).removeAllElements();
		}
	}
	
	private void CreateProject(ActionEvent ev) {
		String command = ev.getActionCommand().toLowerCase(); // should be create or update
		if (mainWindow.documentsListBox.getModel().getSize() < 1) {
			JOptionPane.showMessageDialog(mainWindow, "Cannot " + command + " a project with a blank filelist !!!", "alert", JOptionPane.ERROR_MESSAGE); return;			
		}
		if ((mainWindow.fdProject.getText() == null) || (mainWindow.fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(mainWindow, "Cannot " + command + " a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		mainWindow.PERSO_CONFIG.setProperty("project.name", mainWindow.fdProject.getText()); try { mainWindow.PERSO_CONFIG.store (new java.io.FileOutputStream("user-config.properties"), ""); } catch (Exception e) {}
		if (mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") == null) {
			JOptionPane.showMessageDialog(mainWindow, "Please configure projects path !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File projPathParent = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath")); 
		if (mainWindow.secemOption.isSelected()) projPathParent = new File (projPathParent, "_Secem");
		final File projPath = new File (projPathParent, mainWindow.fdProject.getText().trim());
		if (command.equals("create") && projPath.exists()) {
			JOptionPane.showMessageDialog(mainWindow, "Project " + projPath.getName() + " exists. Use &Update instead", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		if (command.equals("update") && !projPath.exists()) {
			JOptionPane.showMessageDialog(mainWindow, "Project " + projPath.getName() + " does not exist. Use &Create instead", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		
		new CreateProjectDialog(mainWindow, this, ev, projPath).setVisible(true);
	}
	
	private void ClearList(ActionEvent ev) {
		((DefaultListModel) mainWindow.documentsListBox.getModel()).clear(); 
		mainWindow.fdProject.setText("");
		mainWindow.runOtButton.setBackground(new java.awt.Color(0xBF, 0xBF, 0xBF));
		mainWindow.runOtButton.setEnabled(false);		
	}
	
	protected void Backup(ActionEvent ev) {
		if (mainWindow.secemOption.isSelected()) return;
		if ((mainWindow.fdProject.getText() == null) || (mainWindow.fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot backup a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		File path = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim());
		if (! path.exists()) {
			JOptionPane.showMessageDialog(null, "Project '" + mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		new BackupTask(mainWindow, mainWindow.fdProject.getText().trim(), false).start();
	}
		
	private void OpenTeambaseWindow(ActionEvent ev) {
		if ((mainWindow.fdProject.getText() == null) || (mainWindow.fdProject.getText().trim().length() == 0)) {
			JOptionPane.showMessageDialog(null, "Cannot connect to TeamBase a 'blank' project !!!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		new TeambaseWindow(mainWindow).setVisible(true);
	}
}