package dgt.jwizard.ui;

import javax.swing.*;
import javax.swing.border.TitledBorder;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import java.io.*;
import java.nio.file.*;

import org.openide.awt.Mnemonics;

import static dgt.jwizard.ui.SwingUtils.*;

public class PanelRevision extends JPanel {
	
	private JWizard mainWindow;
	protected SubPanel panRevTranslator, panRevRevisor;
	
	public PanelRevision(JWizard mainWindow) {
		this.mainWindow = mainWindow;
		setBorder(new TitledBorder("REVISION")); this.setLayout(null); setBackground(JWizard.DEFAULT_BACKGROUND);
		
		this.panRevTranslator = new SubPanel("Translator"); this.add(panRevTranslator); panRevTranslator.setBounds(8, 18, 125,150); 
		panRevTranslator.createButton("Send", "Send project to reviser",ev -> SendToRevisor()); 
		panRevTranslator.createButton("Get", "Select a revised project", ev -> DoGet("Choose a Revised Project", "Revised")); 
		panRevTranslator.createButton("Browse", "Browse projects to be revised", ev -> BrowsePath("ToRevise")); 

		this.panRevRevisor = new SubPanel("Reviser"); this.add(panRevRevisor); panRevRevisor.setBounds(8, 168, 125,150);
		panRevRevisor.createButton("Get", "Select a project to revise", ev -> DoGet("Choose a Project to revise", "ToRevise")); 
		panRevRevisor.createButton("Send", "Send a revised project", ev -> SendRevised()); 
		panRevRevisor.createButton("Browse", "Browse revised projects", ev -> BrowsePath("Revised")); 		
	}
	
	private static final Color BTN_COLOR = null; /* new Color(0xFF, 0xFF, 0x66) */

	protected class SubPanel extends JPanel {
	
		private int y = 18 - 30;
		private JLabel flagSecem = new JLabel("SECEM");
	
		private SubPanel(String title) {
			setBorder(new TitledBorder(title)); this.setLayout(null); this.setBackground(JWizard.DEFAULT_BACKGROUND);
				
			flagSecem.setBounds(40,112, 95, 25); this.add(flagSecem); toggleSecem();
			flagSecem.setFont(new Font(flagSecem.getFont().getName(), Font.PLAIN, 15)); flagSecem.setForeground (Color.red);			
		}
			
		private JButton createButton(String label, String tooltip, ActionListener listener) {
			this.y += 30;
			return SwingUtils.createButton(this, label.trim(), tooltip, new Rectangle(10,this.y,95,25), BTN_COLOR, listener);
		}
		
		public final void toggleSecem() { flagSecem.setVisible(mainWindow.secemOption.isSelected()); }
	}
	
	// -------------------------------- Button actions ---------------------
	
	private static final String SECEM_UUID = "::{20D04FE0-3AEA-1069-A2D8-08002B30309D}";
	
	private void BrowsePath(String pathName) {
		String path = mainWindow.GLOBAL_CONFIG.getProperty("Paths." + pathName);
		if (mainWindow.secemOption.isSelected()) path += SECEM_UUID;
		try { Desktop.getDesktop().open (new File(path)); }
		catch (Exception e) { JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", JOptionPane.ERROR_MESSAGE);  }
	}
	
	private void DoGet(String dialogTitle, String baseDir) {
		String SECEM = ""; if (mainWindow.secemOption.isSelected()) SECEM = SECEM_UUID; 
		JFileChooser dirChooser = new JFileChooser (new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths." + baseDir) + SECEM));
		dirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		dirChooser.setDialogTitle(dialogTitle);
		if (dirChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
			File selected = dirChooser.getSelectedFile();
			if (! new File(selected, "omegat.project").exists()) {
				JOptionPane.showMessageDialog(null, dirChooser.getSelectedFile() + " is not a valid OmegaT Project !", "alert", JOptionPane.ERROR_MESSAGE); return;
			}
			mainWindow.msgArea.setText("Getting " + selected + " ... ");
			try {
				File dest = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + selected.getName());
				copyDirectory(selected, dest, true);
				mainWindow.fdProject.setText(dest.getName());
				mainWindow.msgArea.setText("Now you can open the Project " + dest.getName());
			} catch (Exception e) {
				mainWindow.msgArea.setText(e.getMessage());
			}
		}		
	}
	
	private void SendRevised() {
		final String fromDir = mainWindow.fdProject.getText(); String toDir = fromDir.replaceAll("_For-Revision-\\w{7}", "_Revised-" + System.getProperty("user.name"));
		toDir = JOptionPane.showInputDialog(this, "Project Name", toDir);
		String SECEM = ""; if (mainWindow.secemOption.isSelected()) SECEM = SECEM_UUID; 
		JFileChooser dirChooser = new JFileChooser (new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Revised") + SECEM));
		dirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
		dirChooser.setDialogTitle("Choose a dir where put the Project");
		if (dirChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
			File selected = dirChooser.getSelectedFile();
			mainWindow.msgArea.setText("Sending Project " + fromDir + " to " + toDir + " for Revision ... ");
			try {
				File src = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + fromDir);
				if (! src.exists()) throw new Exception("Project " + fromDir + " not found");
				copyDirectory(src, new File(selected, toDir), true);
				mainWindow.msgArea.append("\nProject " + fromDir + " for Revision sent ...");
			} catch (Exception e) {
				mainWindow.msgArea.append("\n" + e.getClass() + ":" + e.getMessage());
			}
		}
	}
	
	private void SendToRevisor() {		
		File projDir = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim());
		File destDir = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.ToRevise"));
		File projFile = new File(projDir, "omegat.project");
		
		if (mainWindow.secemOption.isSelected()) {
			// local $ToRevise = "Select Destination Folder" ---> ????????
			if (! projFile.exists()) {
				JOptionPane.showMessageDialog(null, "SECEM project do not exist!", "alert", JOptionPane.ERROR_MESSAGE); return;
			}
		}
		if (projFile.length() < 1) {
			JOptionPane.showMessageDialog(null, "Cannot send for Revision the opened " + mainWindow.fdProject.getText() + " project!", "alert", JOptionPane.ERROR_MESSAGE); return;
		}
		
		File omegaTexport = new File(projDir, "export-omegat"); omegaTexport.mkdirs();
		File projectSave = new File(projDir, "omegat");
		if (! projectSave.exists()) {
			JOptionPane.showMessageDialog(null, "Omegat_save not found!", "alert", JOptionPane.ERROR_MESSAGE); return;			
		}
		DefaultListModel<Path> aOmegaTexport = new DefaultListModel<>(), aProjectSave = new DefaultListModel<>();
		try {
			/*File targetDir = new File(projDir, "target-native");
			if (! targetDir.exists()) targetDir = new File(projDir, "target");
			if (! targetDir.exists()) targetDir = new File(projDir, "target.tmp"); 
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(targetDir.toPath(), "*.*")) {
				boolean hasTargetFiles = false;
				for (Path p: dirStream) {
					hasTargetFiles = true; // almost one file
					File projTMX = new File(projectSave, "project_save.tmx");
					if (! projTMX.exists()) {
						JOptionPane.showMessageDialog(null, "project_save.tmx do not exist, you have never saved your project", "alert", JOptionPane.ERROR_MESSAGE); return;
					} else {
						Files.copy(projTMX.toPath(), new File(omegaTexport, p.toFile().getName().substring(0, p.toFile().getName().indexOf('.')) + ".tmx").toPath(), StandardCopyOption.REPLACE_EXISTING);
						break; // only first file is treated
					}
				}
				if (! hasTargetFiles) {
					JOptionPane.showMessageDialog(null, "No Target Files", "alert", JOptionPane.ERROR_MESSAGE); return;			
				}
			}*/
			Path streamPath = omegaTexport.toPath();
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(streamPath, "*.tmx")) {
				for (Path p: dirStream) aOmegaTexport.addElement(streamPath.relativize(p));
			}
			streamPath = projectSave.toPath();
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(streamPath, "*.tmx")) {
				for (Path p: dirStream) aProjectSave.addElement(streamPath.relativize(p));
			}
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getClass().getName() + ":" + e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE); return;			
		} 
		mainWindow.msgArea.setText("" + aOmegaTexport.size() + " file(s) will be sent.");
		final JDialog sendDlg = new JDialog(mainWindow, false); sendDlg.setBounds(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 740, 390);
		sendDlg.getContentPane().setLayout(null); sendDlg.setBackground(JWizard.DEFAULT_BACKGROUND);
		JTextField iDir = new JTextField(); sendDlg.getContentPane().add(iDir); iDir.setBounds(20,20,700,25); iDir.setToolTipText("Revision Project Name");
		iDir.setText(mainWindow.fdProject.getText() + "_For-Revision-" + System.getProperty("user.name"));
		JButton bDir = new JButton(destDir.toString()); sendDlg.getContentPane().add(bDir); bDir.setBounds(20,50,700,25); bDir.setToolTipText("Click to change Destination Folder");
		bDir.addActionListener(ev -> {
			JFileChooser dirChooser = new JFileChooser (destDir);
			dirChooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
			dirChooser.setDialogTitle("Select Destination Folder");
			if (dirChooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) 
				bDir.setText(dirChooser.getSelectedFile().toString());
		});
		JList<Path> fileList = new JList<Path>(new DefaultListModel<Path>()); 
		sendDlg.getContentPane().add(fileList); fileList.setBounds(20, 110, 700, 175);
		JLabel lblSize = new JLabel ("" + aOmegaTexport.size() + " file(s) will be sent."); sendDlg.getContentPane().add(lblSize); lblSize.setBounds(80, 290, 300, 25);
		fileList.addListSelectionListener(ev -> { 
			String msg = "" + fileList.getSelectedIndices().length + " file(s) will be sent.";
			lblSize.setText(msg);  mainWindow.msgArea.setText(msg); 
		});
		class SwitchButton extends JButton implements ActionListener {
			boolean sTMX = ! (omegaTexport.exists() && omegaTexport.listFiles().length > 0); 
			File tmxDir = sTMX ? projectSave : omegaTexport;
			DefaultListModel<Path> aArray = sTMX ? aProjectSave : aOmegaTexport;
			
			public SwitchButton() {
				addActionListener(this); setLabel(tmxDir.toString()); fileList.setModel(aArray);
				setToolTipText(sTMX ? "Click to switch Project Save" : "Click to switch OmegaT Export Folder");
				if (sTMX) { setEnabled(false); setToolTipText("OmegaT Export folder is empty, cannot change unless you run create-euramis-export script"); }
			}
			
			public void actionPerformed (ActionEvent ev) {
				if (sTMX) { 
					sTMX = false; tmxDir = omegaTexport; aArray = aOmegaTexport; 
					if (aOmegaTexport.isEmpty()) {
						String msg = "No files found in Omegat_Export!"; lblSize.setText(msg);  mainWindow.msgArea.setText(msg); return;
					} 
				} else { 
					sTMX = true; tmxDir = projectSave; aArray = aProjectSave; 
					if (aProjectSave.isEmpty()) {
						String msg = "Project_save.tmx not found in OmegaT!"; lblSize.setText(msg);  mainWindow.msgArea.setText(msg); return;
					}
				}
				fileList.setModel(aArray); setLabel(tmxDir.toString()); 
				String msg = "" + aArray.getSize() + " file(s) to be sent"; lblSize.setText(msg);  mainWindow.msgArea.setText(msg);
				setToolTipText(sTMX ? "Click to switch Project Save" : "Click to switch OmegaT Export Folder");				
			}
		}
		SwitchButton bExport = new SwitchButton(); sendDlg.getContentPane().add(bExport); bExport.setBounds(20,80,700,25);
		JButton btnSend = new JButton("Send"), btnCancel = new JButton("Cancel"); 
		sendDlg.getContentPane().add(btnCancel);  btnCancel.setBounds(620, 320, 100, 25); 
		btnCancel.addActionListener (ev -> { mainWindow.msgArea.setText(""); sendDlg.setVisible(false); });
		sendDlg.getContentPane().add(btnSend); btnSend.setBounds(20, 320, 100, 25); btnSend.addActionListener (ev -> {
			String msg = "Sending Project " + iDir.getText() + " for Revision ...\n"; lblSize.setText(msg); mainWindow.msgArea.setText(msg); 
			PrintStream log; try { log = new PrintStream(new File(projDir, "wizard-sendToRevisor.log")); } catch (Exception e) { log = System.err; }
			JFrame longProc = showLongProcessDialog(sendDlg, msg);
			// $robo$ "$src$" "$dst$\$dir$" "*.*" /np /r:10 /w:0 /e /mir'
			try {
				if (mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy") != null) {
					String[] roboCall = {
						mainWindow.GLOBAL_CONFIG.getProperty("exe.roboCopy"),
						projDir.toString(), bDir.getText() + File.separator + iDir.getText(), "*.*", 
						"/np", "/r:10", "/w:0", "/e", "/mir"
					};
					final Process proc = Runtime.getRuntime().exec (roboCall);
					proc.getInputStream().close(); 
					log.println(System.currentTimeMillis() + " : JWizard " + JWizard.VERSION);
					log.println(String.join(" ", roboCall) + "\n");
					try (java.io.BufferedReader is = new java.io.BufferedReader(new java.io.InputStreamReader(proc.getErrorStream()))) { 
						String line; while ((line = is.readLine()) != null) log.println(line);
					}
					log.println(System.currentTimeMillis() + " : Robocopy finished");
				} else
					copyDirectoryAndPurge(projDir, new File(bDir.getText(), iDir.getText()));
			} catch (Exception e) {
				log.println("Error: \n"); e.printStackTrace(log);
				JOptionPane.showMessageDialog(sendDlg, e.getClass().getName() + " : " + e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE); return;
			}
			mainWindow.msgArea.append("Distant directory created\n"); log.println("Distant directory created\n");
			File destProjDir = new File(bDir.getText() + File.separator + iDir.getText());
			File draftPath = new File(destProjDir, "tm" + File.separator + "auto" + File.separator + "draft"); draftPath.mkdirs();
			File otDir = new File(destProjDir, "omegat"); 
			if (bExport.sTMX) 
				copyWithLog(new File(otDir, "project_save.tmx"), new File(draftPath, "project_save.tmx"), log);
			else {
				java.util.List<Path> selection = fileList.getSelectedValuesList();
				if (selection.isEmpty()) {
					ListModel<Path> model = fileList.getModel(); selection = new java.util.ArrayList<Path> (model.getSize());
					for (int i = 0; i < model.getSize(); i++) selection.add(model.getElementAt(i));
				}
				File exportDir = new File(destProjDir, "export-omegat"); File preProc = new File(exportDir, "processed"); preProc.mkdirs();
				for (Path p: selection) {
					File export = new File(exportDir, p.toFile().getName());
					copyWithLog(export, new File(draftPath, p.toFile().getName()), log);					
					export.renameTo(new File(preProc, export.getName()));
				}
			}
			for (File f: new File(destProjDir, "omegat").listFiles())
				if (f.getName().startsWith("last_entry.")) f.delete();
				else if (f.getName().contains(".tmx.")) f.delete();
			log.println("Project " + iDir.getText() + " for Revision sent ..."); log.close();
			mainWindow.msgArea.append("Project " + iDir.getText() + " for Revision sent ..."); sendDlg.setVisible(false); longProc.setVisible(false);
		});
		sendDlg.setVisible(true);
	}
	
	private void copyWithLog(File src, File dest, PrintStream log) {
		mainWindow.msgArea.append("Copy " + src + " to " + dest); log.print("Copy " + src + " to " + dest);
		try { 
			Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING); 
			mainWindow.msgArea.append(" --> OK\n"); log.println(" -> OK"); 
		}
		catch (Exception e) {
			mainWindow.msgArea.append(" --> Failed (see log)");
			log.println(" --> Failed"); e.printStackTrace(log); 
		}
	}
	
}