package dgt.jwizard.ui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;

import java.io.File;
import java.nio.file.*;

import org.openide.awt.Mnemonics;

public class SwingUtils {

	static JButton createButton(Container pane, String label, String tooltip, Rectangle bounds, Color color, ActionListener listener) {
		JButton btn = new JButton(label); if (label.contains("&")) Mnemonics.setLocalizedText(btn, label); 
		btn.setActionCommand(label.replace("&", ""));
		pane.add(btn); btn.setBounds(bounds); if (color != null) btn.setBackground(color);
		if (listener != null) btn.addActionListener(listener);
		btn.setToolTipText(tooltip); return btn;		
	}
	
	public static void copyDirectory(File sourceLocation, File targetLocation, boolean erase) throws java.io.IOException {
        if (sourceLocation.isDirectory()) {
            if (!targetLocation.exists()) targetLocation.mkdir();
            String[] children = sourceLocation.list();
            for (int i=0; i<children.length; i++) 
                copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]), erase);
        } else {
			if (targetLocation.exists()) {
				if ((targetLocation.length() == sourceLocation.length()) && (targetLocation.lastModified() >= sourceLocation.lastModified())) return;
			}
			if (erase) Files.copy (sourceLocation.toPath(), targetLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
			else Files.copy (sourceLocation.toPath(), targetLocation.toPath());
			targetLocation.setLastModified(sourceLocation.lastModified());
        }
    }
	
	public static void copyDirectoryAndPurge(File sourceLocation, File targetLocation) throws java.io.IOException {
        if (! sourceLocation.isDirectory()) Files.copy (sourceLocation.toPath(), targetLocation.toPath(), StandardCopyOption.REPLACE_EXISTING);
		else {
			if (targetLocation.exists()) 
				for (File child: targetLocation.listFiles())
					if (! new File(sourceLocation, child.getName()).exists()) delTree(child);
			copyDirectory(sourceLocation, targetLocation, true);
		}
    }
	
	public static void delTree(File f) throws java.io.FileNotFoundException {
		if (f.isDirectory()) for (File c : f.listFiles()) delTree(c);
		if (!f.delete()) throw new java.io.FileNotFoundException("Failed to delete file: " + f);		
	}
	
	static class IntWrapper { int val; }
	
	public static void RemoveFromJList(JFrame parent, JList<?> theList) {
		int[] selection = theList.getSelectedIndices();
		if ((selection == null) || (selection.length == 0)) {
			if (JOptionPane.showConfirmDialog(parent, "No file selected in the list. Remove all?", "Alert",  JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION)
				((DefaultListModel) theList.getModel()).clear();
		} else {
			if (JOptionPane.showConfirmDialog(parent, "Delete these " + selection.length + " file(s)?", "Alert",  JOptionPane.YES_NO_OPTION) == JOptionPane.YES_OPTION) {
				DefaultListModel model = (DefaultListModel) theList.getModel();
				for (int i = model.size() - 1; i >= 0; i--) // reverse so that indices do not change
					LJ: for (int j: selection) if (j == i) { model.removeElementAt(j); break LJ; }
			}
		}
	}
	
	public static String environment() {
		try {
			Path p = new File(SwingUtils.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).toPath();
			String res = environment(p.getParent()); 
			if (! java.util.regex.Pattern.compile("-(dev|test|acc|leg|prod)").matcher(res.toLowerCase()).find()) res += "-PROD";
			if (! res.contains("(")) return "(" + res + ")"; else return res;
		} catch (Exception e) {
			return "(unknown environment)";
		}
	}

	private static String environment(Path p) throws java.io.IOException {
		while (p != null) {
			if (p.getFileName().startsWith("OmegaT-")) return p.getFileName().toString().substring(7);
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(p, "ver.*")) {
				for (Path curFile: dirStream) return curFile.getFileName().toString().substring(4);
			}
			p = p.getParent();
		}
		return "unknown environment";
	}
	
	public static JFrame showLongProcessDialog(JDialog parent, String msg) {
		JFrame runDlg = new JFrame(msg); runDlg.setBounds(parent.getX() + 50, parent.getY() + 50, 20 + 10 * msg.length(), 20); 
		runDlg.setVisible(true); return runDlg;
	}
	
}