package dgt.jwizard.ui;

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
import java.net.URL;
import java.util.regex.*;
import java.nio.file.*;
import java.io.*;

import static dgt.jwizard.ui.SwingUtils.*;
import org.openide.awt.Mnemonics;

public class TeambaseWindow extends JFrame {
	private JWizard mainWindow;
	private JList<String> sharedList, projMemList, ownMemList;
	private JTextField sharedChoice, projMemChoice, ownMemChoice;
	private JButton modeBtn, cModeBtn;
	
	//private String ownedMemoriesPropName;
	
	public TeambaseWindow(JWizard mainWindow) {
		super ("TeamBase Memories"); this.mainWindow = mainWindow;
		setIconImage(new ImageIcon(getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
		setBounds(0, 0, 1080, 480); getContentPane().setLayout(null);
		JScrollPane scroll;
		
		JLabel lAv = new JLabel("Available shared memories"); getContentPane().add(lAv); lAv.setBounds(5,5,345,15);
		this.sharedList = new JList<String>(new DefaultListModel()); getContentPane().add(scroll = new JScrollPane(sharedList)); scroll.setBounds(3, 20, 345, 360);
		this.sharedChoice = new JTextField(); getContentPane().add(sharedChoice); sharedChoice.setBounds(5, 382, 200, 25);
		this.sharedList.addListSelectionListener(ev -> {
			if (this.sharedList.getSelectedIndex() >= 0) this.sharedChoice.setText(this.sharedList.getModel().getElementAt(this.sharedList.getSelectedIndex()));
		});
		this.modeBtn = createButton(getContentPane(), "Re&ad/Write", "", new Rectangle(209, 382, 138, 25), null, ev -> {
			if (modeBtn.getText().contains("Write")) modeBtn.setText("R&ead"); else modeBtn.setText("R&ead/Write");
		});
		createButton(getContentPane(), "Connect &To Shared", "", new Rectangle(5, 412, 343, 25), null, this::Connect);
		java.util.Set<String> ownedMemoriesSet = new java.util.TreeSet<String>();
		try {
			Pattern PTN_NAME = Pattern.compile("name='(.+?)'"), PTN_OWN = Pattern.compile("is-owner='true'");
			DefaultListModel model = (DefaultListModel) sharedList.getModel();
			try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(buildUrl("list", this.sharedChoice)).openStream()))) {
				String line; while ((line = reader.readLine()) != null) {
					Matcher m = PTN_NAME.matcher(line); if (m.find()) model.addElement(m.group(1));
					if (PTN_OWN.matcher(line).find()) ownedMemoriesSet.add(m.group(1).toUpperCase());
				}
			}
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getMessage(), "get memories:" + e.getClass(), JOptionPane.ERROR_MESSAGE);
		}
		
		JLabel lProjMem = new JLabel("Shared memories linked to my project"); getContentPane().add(lProjMem); lProjMem.setBounds(355,5,345,15);
		this.projMemList = new JList<String>(new DefaultListModel<String>()); getContentPane().add(scroll = new JScrollPane(projMemList)); scroll.setBounds(353, 20, 345, 360);
		this.projMemChoice = new JTextField(); getContentPane().add(projMemChoice); projMemChoice.setBounds(355, 382, 200, 25); projMemChoice.setEditable(false);
		this.projMemList.addListSelectionListener(ev -> {
			if (this.projMemList.getSelectedIndex() >= 0) {
				this.projMemChoice.setText(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
				String projPath = memoryFileName(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
				try {
					try (FileInputStream fis = new FileInputStream(projPath)) {
						java.util.Properties prop = new java.util.Properties(); prop.load(fis);
						if (! "false".equalsIgnoreCase(prop.getProperty("update"))) 
							Mnemonics.setLocalizedText(this.cModeBtn, "Re&ad/Write");
						else
							Mnemonics.setLocalizedText(this.cModeBtn, "R&ead");						
					}
				} catch (Exception e) {
					
				}
			}
		});
		this.cModeBtn = createButton(getContentPane(), "Re&ad/Write", "", new Rectangle(559, 382, 138, 25), null, ev -> {
			if (cModeBtn.getText().contains("Write")) Mnemonics.setLocalizedText(cModeBtn, "R&ead"); else Mnemonics.setLocalizedText(cModeBtn, "Re&ad/Write");
			String projPath = memoryFileName(this.projMemList.getModel().getElementAt(this.projMemList.getSelectedIndex()));
			try {
				java.util.Properties prop = new java.util.Properties(); 
				try (FileInputStream fis = new FileInputStream(projPath)) { prop.load(fis); }
				prop.setProperty("update", Boolean.toString(cModeBtn.getText().contains("Write")));
				try (FileOutputStream fos = new FileOutputStream(projPath)) { prop.store(fos,""); }				
			} catch (Exception e) {
				
			}			
		});
		JButton disconnectBtn = createButton(getContentPane(), "Disconnect &From Shared", "", new Rectangle(355, 412, 343, 25), null, this::Disconnect);
		try {
			Path projPath = Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim() + File.separator + "tm");
			String pattern = "*-" + mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString() + ".properties";
			DefaultListModel model = (DefaultListModel) projMemList.getModel();
			try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(projPath, pattern)) {
				for (Path p: dirStream) {
					String name = p.getFileName().toString();
					name = name.substring(0, name.indexOf('.')); // .properties
					name = name.substring(0, name.lastIndexOf('-')); name = name.substring(0, name.lastIndexOf('-')); // -src-lang
					model.addElement(name);
				}
			}
		} catch (java.nio.file.NoSuchFileException nsf) {
			((DefaultListModel) projMemList.getModel()).addElement("Project not opened");
			((DefaultListModel) projMemList.getModel()).addElement("(" + mainWindow.fdProject.getText() + ")");
			projMemList.setEnabled(false); disconnectBtn.setEnabled(false);
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getClass() + ":\n" + e.getMessage(), "open connections list:alert", JOptionPane.ERROR_MESSAGE);
		}
		
		JLabel lOwnMem = new JLabel("Shared memories I own"); getContentPane().add(lOwnMem); lOwnMem.setBounds(705,5,345,15);
		DefaultListModel<String> ownModel = new DefaultListModel<String>();
		//this.ownedMemoriesPropName = mainWindow.srcBox.getSelectedItem().toString() + ":" + mainWindow.traBox.getSelectedItem().toString() + ".ownedMemories";
		this.ownMemList = new JList<String>(ownModel); getContentPane().add(scroll = new JScrollPane(ownMemList)); scroll.setBounds(703, 20, 345, 360);
		/*if (mainWindow.PERSO_CONFIG.getProperty(ownedMemoriesPropName) != null)
			for (String mem: mainWindow.PERSO_CONFIG.getProperty(ownedMemoriesPropName).split(";")) ownedMemoriesSet.add(mem);*/
		for (String mem: ownedMemoriesSet) ownModel.addElement(mem);
		this.ownMemChoice = new JTextField(); getContentPane().add(ownMemChoice); ownMemChoice.setBounds(705, 382, 345, 25); ownMemChoice.setEditable(false);
		this.ownMemList.addListSelectionListener(ev -> {
			if (this.ownMemList.getSelectedIndex() >= 0) this.ownMemChoice.setText(this.ownMemList.getModel().getElementAt(this.ownMemList.getSelectedIndex()));
		});
		createButton(getContentPane(), "&Delete shared memory", "", new Rectangle(705, 412, 343, 25), null, this::Delete);
	}
	
	private String memoryFileName(String memoryName) {
		return mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator 
			+ mainWindow.fdProject.getText().trim() + File.separator + "tm" + File.separator
			+ memoryName + "-" + mainWindow.srcBox.getSelectedItem().toString() + "-" + mainWindow.traBox.getSelectedItem().toString() + ".properties";
	}
	
	private String buildUrl(String cmd, JTextField nameField) {
		String url = mainWindow.GLOBAL_CONFIG.getProperty("teambase.memrest.server") + mainWindow.GLOBAL_CONFIG.getProperty("teambase.memrest.command." + cmd);
		url = url.replace("$src$", mainWindow.srcBox.getSelectedItem().toString()).replace("$tra$", mainWindow.traBox.getSelectedItem().toString());
		url = url.replace("$projname$", nameField.getText());
		return url;
	}
	
	private void Connect(ActionEvent ev) {
		try {
			ConnectToSelected();
		} catch (Exception e) {
			try { 
				// Create the memory		
				try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(buildUrl("createdb", this.sharedChoice)).openStream()))) {
					String line; while ((line = reader.readLine()) != null) {
						if (line.contains("failed")) {
							Matcher m = Pattern.compile("cause\\s*=\\s*(\\W)(.+)\\1").matcher(line);
							if (m.find()) throw new Exception(m.group(2));
						}
					}
				}
				/*String owned = mainWindow.PERSO_CONFIG.getProperty(ownedMemoriesPropName); 
				if (owned == null) owned = this.sharedChoice.getText();
				else if (owned.trim().length() == 0) owned = this.sharedChoice.getText();
				else owned += ";" + this.sharedChoice.getText();
				mainWindow.PERSO_CONFIG.setProperty(ownedMemoriesPropName, owned); 
				try { mainWindow.PERSO_CONFIG.store (new FileOutputStream("user-config.properties"), ""); } catch (Exception e1) {}*/
				((DefaultListModel) ownMemList.getModel()).addElement(this.sharedChoice.getText().toUpperCase()); 
				
				ConnectToSelected(); 
			} catch (Exception e2) {
				JOptionPane.showMessageDialog(null, e2.getMessage(), "connect:alert", JOptionPane.ERROR_MESSAGE);
			}
		}
	}
	
	private void ConnectToSelected() throws Exception {
		String url = buildUrl("OmegaT-tm", this.sharedChoice);
		url = url.replace("update=true", "update=" + Boolean.toString(modeBtn.getText().contains("Write"))); 
		try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(url).openStream()))) {
			String projPath = memoryFileName(this.sharedChoice.getText());
			try (PrintWriter out = new PrintWriter(new FileOutputStream(projPath))) {
				String line; while ((line = reader.readLine()) != null) {
					if (line.contains("project not found")) throw new Exception("Memory does not exist");
					else out.println(line);
				}
			}
			File f = new File(projPath); if (f.length() == 0) { f.delete(); throw new Exception("Could not build OmegaT file, maybe memory does not exist"); }
		}
		if (! (((DefaultListModel) projMemList.getModel()).contains(this.sharedChoice.getText())))
			((DefaultListModel) projMemList.getModel()).addElement(this.sharedChoice.getText()); 
	}
	
	private void Disconnect(ActionEvent ev) {
		if (this.projMemChoice.getText() == null) return;
		if (this.projMemChoice.getText().trim().length() == 0) return;
		
		try {
			File f = new File(memoryFileName(projMemChoice.getText())); boolean exist = f.exists(); f.delete();
			if (exist) mainWindow.msgArea.setText("Disconnected from TeamBase memory " + projMemChoice.getText());
			((DefaultListModel) projMemList.getModel()).removeElement(this.projMemChoice.getText()); 
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getClass() + ":" + e.getMessage(), "disconnect:alert", JOptionPane.ERROR_MESSAGE);
			e.printStackTrace();
		}
	}
	
	private void Delete(ActionEvent ev) {
		if (this.ownMemChoice.getText() == null) return;
		if (this.ownMemChoice.getText().trim().length() == 0) return;
		
		try {
			try (BufferedReader reader = new BufferedReader(new InputStreamReader(new URL(buildUrl("dropdb", this.ownMemChoice)).openStream()))) {
				String line; while ((line = reader.readLine()) != null) {
					if (line.contains("failed")) {
						Matcher m = Pattern.compile("cause\\s*=\\s*(\\W)(.+)\\1").matcher(line);
						if (m.find()) throw new Exception(m.group(2));
					}
				}
			}
		} catch (Exception e) {
			JOptionPane.showMessageDialog(null, e.getMessage(), "alert", JOptionPane.ERROR_MESSAGE);
		}
		
		projMemChoice.setText(ownMemChoice.getText()); Disconnect(ev);
		((DefaultListModel) sharedList.getModel()).removeElement(this.ownMemChoice.getText());
		((DefaultListModel) projMemList.getModel()).removeElement(this.ownMemChoice.getText());
		((DefaultListModel) ownMemList.getModel()).removeElement(this.ownMemChoice.getText());
	}

}