package dgt.lib;

import java.util.Map;

import java.io.PrintWriter;
import java.io.File;

import javax.xml.soap.*;
import javax.xml.xpath.*;
import javax.xml.transform.*;

import org.w3c.dom.Document;

public class SoapCall {
		
	private final String service_url, namespace_uri;
	private final String user, pass;
	
	public SoapCall(String namespace_uri, String service_url) { this.namespace_uri = namespace_uri; this.service_url = service_url; this.user = this.pass = null; }
	public SoapCall(String namespace_uri, String service_url, String user, String pass) { this.namespace_uri = namespace_uri;  this.service_url = service_url; this.user = user; this.pass = pass; }
	
	public Document call(String command, Map<String,Object> xmlParams, PrintWriter log) throws Exception {
		SOAPConnectionFactory soapConnectionFactory = SOAPConnectionFactory.newInstance();
		SOAPConnection soapConnection = soapConnectionFactory.createConnection();
		SOAPMessage res = soapConnection.call(createSOAPRequest(command, xmlParams, log), service_url);
		if (res.getSOAPBody().hasFault())
			throw new Exception ("SOAP fault: " + res.getSOAPBody().getFault().getFaultString());
		else 
			return res.getSOAPBody().extractContentAsDocument();
	}
	
	private void createSubElements(SOAPElement dest, Map<String,Object> xmlParams) throws SOAPException {
		for (Map.Entry<String,Object> entry: xmlParams.entrySet()) {
			SOAPElement ref = dest.addChildElement(entry.getKey());
			if (entry.getValue() instanceof String) ref.addTextNode(entry.getValue().toString());
			if (entry.getValue() instanceof Map) createSubElements(ref, (Map<String,Object>) entry.getValue());
		}
	}
	
	public static String findElementContent (Document doc, String name) throws Exception {
        XPath xpath = XPathFactory.newInstance().newXPath();
		if (name.contains("|")) {
			for (String name0: name.split("\\|")) {
				String res = findElementContent(doc, name0);
				if (res != null) if (res.length() > 0) return res;
			}
			return "";
		}
		return xpath.evaluate("//" + name, doc, XPathConstants.STRING).toString();
	}
	
	public static void dump (Document doc, PrintWriter res) throws Exception {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		transformer.transform(new javax.xml.transform.dom.DOMSource(doc), new javax.xml.transform.stream.StreamResult(res));
		res.println("");
	}
	
	public static void dump (Document doc, java.io.PrintStream res) throws Exception {
		TransformerFactory tf = TransformerFactory.newInstance();
		Transformer transformer = tf.newTransformer();
		transformer.transform(new javax.xml.transform.dom.DOMSource(doc), new javax.xml.transform.stream.StreamResult(res));
		res.println("");
	}
	
	private SOAPMessage createSOAPRequest(String command, Map<String,Object> xmlParams, PrintWriter log) throws SOAPException {
		MessageFactory messageFactory = MessageFactory.newInstance();
        SOAPMessage soapMessage = messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();

        // SOAP Envelope
        SOAPEnvelope envelope = soapPart.getEnvelope();
        envelope.addNamespaceDeclaration("eu", namespace_uri);

        // SOAP Body
        SOAPBody soapBody = envelope.getBody();
		SOAPElement commandElement = soapBody.addChildElement(command, "eu"); 
		createSubElements(commandElement, xmlParams);
		
        //soapMessage.getMimeHeaders().addHeader("SOAPAction", namespace_uri + "#" + command);
		if (user != null) {
			String authorization = user+":"+pass; authorization = java.util.Base64.getEncoder().encodeToString(authorization.getBytes());
			soapMessage.getMimeHeaders().addHeader("Authorization", "Basic " + authorization);		
		}
        soapMessage.saveChanges();
		if (log != null)
			try { 
				java.io.ByteArrayOutputStream bOut = new java.io.ByteArrayOutputStream();
				soapMessage.writeTo(bOut); String st = bOut.toString();
				if (st.length() < 4096) log.println( "SOAP Message (size = " + st.length() + ") : " + st );
				else log.println( "SOAP Message (size = " + st.length() + ") : " + st.substring(0, st.indexOf("<file>") + 20) + "[...]" + st.substring(st.indexOf("</file>") - 20) );
			}
			catch (Exception e) {}
			//try { dump (soapBody.extractContentAsDocument(), log); } catch (Exception e) {}
		return soapMessage;
	}
	
}