/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.act;

import dgt.jwizard.act.AddFileAction;
import dgt.jwizard.ui.JWizard;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public class AddLocalFileAction
implements AddFileAction {
    private JFileChooser fChooser = new JFileChooser();

    public AddLocalFileAction() {
        this.fChooser.setMultiSelectionEnabled(true);
        this.fChooser.setFileFilter(new FileNameExtensionFilter("Dossiers (*.docx;*.xls?;*.pptx;*.xml;*.htm?;*.sdlxliff;*.xliff)", "docx", "xlsx", "pptx", "xml", "htm", "html", "xliff", "xlf", "sdlxliff"));
        this.fChooser.setFileSelectionMode(2);
    }

    @Override
    public String getLabel() {
        return "Local file(s)";
    }

    @Override
    public File[] doSelectFiles(JWizard wizard) {
        File path = new File(wizard.GLOBAL_CONFIG.getProperty("Paths.TradeskLocalPath") + File.separator + wizard.fdProject.getText());
        if (!path.exists()) {
            path = path.getParentFile();
        }
        this.fChooser.setCurrentDirectory(path);
        if (this.fChooser.showOpenDialog(wizard) == 0) {
            File[] res = this.fChooser.getSelectedFiles();
            ArrayList<File> subFiles = new ArrayList<File>();
            for (File f : res) {
                if (!f.isDirectory()) continue;
                AddLocalFileAction.addDir(f, subFiles);
            }
            if (subFiles.size() == 0) {
                return res;
            }
            for (File f : res) {
                if (f.isDirectory()) continue;
                subFiles.add(f);
            }
            return subFiles.toArray(res);
        }
        return null;
    }

    private static void addDir(File dir, List<File> subFiles) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                AddLocalFileAction.addDir(f, subFiles);
                continue;
            }
            subFiles.add(f);
        }
    }
}

