/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.act;

import dgt.jwizard.ui.EuramisWindow;
import dgt.jwizard.ui.JWizard;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ListModel;

public class SendToTradeskPath
implements ActionListener {
    private JWizard mainWindow;
    private EuramisWindow euramisWin;
    private static final Pattern DOSSIER_PTN = Pattern.compile("^(.+-\\d{4}-\\d{5})-");

    public SendToTradeskPath(JWizard mainWindow, EuramisWindow euramisWin) {
        this.mainWindow = mainWindow;
        this.euramisWin = euramisWin;
    }

    public void LogToMain(String text) {
        this.mainWindow.msgArea.setText(this.mainWindow.msgArea.getText() + "\n" + text);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        ListModel<File> model = this.euramisWin.finalizeListBox.getModel();
        File tradeskPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Tradesk"));
        File targetPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText() + File.separator + "target");
        if (!targetPath.exists()) {
            targetPath = new File(targetPath.getParentFile(), "target");
        }
        for (int i = 0; i < model.getSize(); ++i) {
            Matcher matcher1;
            String projDir;
            File tradeskProjFile;
            File f = model.getElementAt(i);
            if (!f.isAbsolute()) {
                f = new File(targetPath, f.getPath());
            }
            if ((tradeskProjFile = new File(tradeskPath, (projDir = (matcher1 = DOSSIER_PTN.matcher(f.getName())).find() ? matcher1.group(1) : f.getName()) + File.separator + f.getName())).exists()) {
                if (JOptionPane.showConfirmDialog(this.mainWindow, f.getName() + "\n is already present in TRADESK!\n Would you replace it?", "Ext: Send to TRADESK", 0) == 1) {
                    this.LogToMain(f.getName() + " has not been replaced into TRADESK");
                    continue;
                }
                try {
                    Files.copy(f.toPath(), tradeskProjFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    this.LogToMain(f.getName() + " has been replaced into TRADESK");
                }
                catch (Exception e) {
                    this.LogToMain(e.getMessage());
                }
                continue;
            }
            try {
                tradeskProjFile.getParentFile().mkdirs();
                Files.copy(f.toPath(), tradeskProjFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                this.LogToMain(f.getName() + " has been added into TRADESK");
                continue;
            }
            catch (Exception e) {
                this.LogToMain(e.getMessage());
            }
        }
    }
}

