/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.act;

import dgt.jwizard.ui.EuramisWindow;
import dgt.jwizard.ui.JWizard;
import dgt.lib.SoapCall;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.ListModel;
import org.w3c.dom.Document;

public class SendToTradeskSoap
implements ActionListener {
    private JWizard mainWindow;
    private EuramisWindow euramisWin;
    private static final Pattern DOSSIER_PTN = Pattern.compile("^(\\w+)-(\\d{4})-(\\d{5})-(\\d\\d)-(\\d\\d)(?:-(\\d\\d))?-([A-Z]{2})-([A-Z]{3})-(\\d\\d)\\.(\\w+)");
    private SoapCall caller = null;

    public SendToTradeskSoap(JWizard mainWindow, EuramisWindow euramisWin) {
        this.mainWindow = mainWindow;
        this.euramisWin = euramisWin;
    }

    public void LogToMain(String text) {
        this.mainWindow.msgArea.setText(this.mainWindow.msgArea.getText() + "\n" + text);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        try {
            this.SendToTradeskServer();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.euramisWin, e.getMessage(), "alert", 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SendToTradeskServer() throws Exception {
        if (this.caller == null) {
            if ("config".equalsIgnoreCase(this.mainWindow.GLOBAL_CONFIG.getProperty("http.secure"))) {
                this.caller = new SoapCall(this.mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), this.mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"), this.mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.user"), this.mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.pass"));
            } else if ("ask".equalsIgnoreCase(this.mainWindow.GLOBAL_CONFIG.getProperty("http.secure"))) {
                JDialog passDialog = new JDialog(this.euramisWin);
                passDialog.setTitle("Please give internet credentials");
                passDialog.setModal(true);
                Container pane = passDialog.getContentPane();
                pane.setLayout(new GridLayout(3, 2));
                pane.add(new JLabel("User name:"));
                JTextField fUser = new JTextField();
                pane.add(fUser);
                pane.add(new JLabel("Password:"));
                JPasswordField fPass = new JPasswordField();
                pane.add(fPass);
                JButton btnOk = new JButton("OK");
                JButton btnCancel = new JButton("Cancel");
                pane.add(btnOk);
                pane.add(btnCancel);
                btnCancel.addActionListener(ev -> passDialog.setVisible(false));
                btnOk.addActionListener(ev -> {
                    passDialog.setVisible(false);
                    this.caller = new SoapCall(this.mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), this.mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"), fUser.getText(), fPass.getText());
                });
                passDialog.setBounds(this.euramisWin.getX() + 100, this.euramisWin.getY() + 100, 500, 120);
                passDialog.setVisible(true);
                if (this.caller == null) {
                    return;
                }
            } else {
                this.caller = new SoapCall(this.mainWindow.GLOBAL_CONFIG.getProperty("http.Namespace.eu"), this.mainWindow.GLOBAL_CONFIG.getProperty("http.CATproxy.url"));
            }
        }
        ListModel<File> model = this.euramisWin.finalizeListBox.getModel();
        File targetPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText() + File.separator + "target-native");
        if (!targetPath.exists()) {
            targetPath = new File(targetPath.getParentFile(), "target");
        }
        PrintStream tradeskLog = new PrintStream(targetPath.getParentFile().getPath() + File.separator + "SendToTradesk.log");
        tradeskLog.println("Sending files from " + targetPath + " to Tradesk");
        this.mainWindow.msgArea.setText("Sending files to Tradesk");
        int success = 0;
        int failed = 0;
        for (int i = 0; i < model.getSize(); ++i) {
            Document call;
            String docUid;
            File f;
            block16: {
                f = model.getElementAt(i);
                if (!f.isAbsolute()) {
                    f = new File(targetPath, f.getPath());
                }
                docUid = this.GetDocUid(f);
                tradeskLog.println("For file " + f + ", doc uid = " + docUid);
                call = null;
                try {
                    call = docUid == null || docUid.trim().length() == 0 ? this.TradeskAdd(f) : this.TradeskReplace(f, docUid);
                    ++success;
                    tradeskLog.println("Call result:");
                    if (call != null) break block16;
                    tradeskLog.println("null");
                }
                catch (Exception e) {
                    block19: {
                        block17: {
                            block18: {
                                try {
                                    if (!e.getMessage().contains("thentication")) break block17;
                                    JOptionPane.showMessageDialog(this.euramisWin, "Could not authenticate, please check user/password", "alert", 0);
                                    tradeskLog.println("Call result:");
                                    if (call != null) break block18;
                                    tradeskLog.println("null");
                                }
                                catch (Throwable throwable) {
                                    tradeskLog.println("Call result:");
                                    if (call == null) {
                                        tradeskLog.println("null");
                                    } else {
                                        SoapCall.dump(call, tradeskLog);
                                    }
                                    this.LogToMain(f.getName() + " has " + (call == null ? "not " : "") + " been " + (docUid == null || docUid.trim().length() == 0 ? "added" : "replaced") + " in TraDesk");
                                    throw throwable;
                                }
                            }
                            SoapCall.dump(call, tradeskLog);
                            this.LogToMain(f.getName() + " has " + (call == null ? "not " : "") + " been " + (docUid == null || docUid.trim().length() == 0 ? "added" : "replaced") + " in TraDesk");
                            return;
                        }
                        tradeskLog.println("" + f + ": Exception: " + e);
                        ++failed;
                        tradeskLog.println("Call result:");
                        if (call != null) break block19;
                        tradeskLog.println("null");
                    }
                    SoapCall.dump(call, tradeskLog);
                    this.LogToMain(f.getName() + " has " + (call == null ? "not " : "") + " been " + (docUid == null || docUid.trim().length() == 0 ? "added" : "replaced") + " in TraDesk");
                    continue;
                }
            }
            SoapCall.dump(call, tradeskLog);
            this.LogToMain(f.getName() + " has " + (call == null ? "not " : "") + " been " + (docUid == null || docUid.trim().length() == 0 ? "added" : "replaced") + " in TraDesk");
            continue;
        }
        this.LogToMain("" + success + "/" + model.getSize() + " files sent OK, " + failed + " failed");
        tradeskLog.println("OK:" + success + "; failed:" + failed + "; total: " + model.getSize());
        tradeskLog.close();
    }

    private Map<String, Object> FileToTradeskParams(File f, boolean withName) throws Exception {
        Matcher matcher1 = DOSSIER_PTN.matcher(f.getName());
        if (!matcher1.find()) {
            throw new Exception("Not a valid Tradesk dossier name: " + f.getName());
        }
        HashMap<String, String> reqRef = new HashMap<String, String>();
        reqRef.put("requester", matcher1.group(1));
        reqRef.put("year", matcher1.group(2));
        reqRef.put("number", matcher1.group(3));
        HashMap<String, Object> cmdRef = new HashMap<String, Object>();
        cmdRef.put("requestReference", reqRef);
        cmdRef.put("version", matcher1.group(4));
        reqRef.put("part", matcher1.group(5));
        if (matcher1.group(6) != null && matcher1.group(6).length() == 2) {
            cmdRef.put("subpart", matcher1.group(6));
        } else {
            cmdRef.put("subpart", matcher1.group(9));
        }
        cmdRef.put("language", matcher1.group(7));
        cmdRef.put("documentType", matcher1.group(8));
        reqRef.put("requestType", "TRA");
        if (withName) {
            cmdRef.put("filename", f.getName());
            cmdRef.put("format", matcher1.group(10));
        }
        return cmdRef;
    }

    private String GetDocUid(File f) {
        try {
            return SoapCall.findElementContent(this.caller.call("searchDocuments", this.FileToTradeskParams(f, false), null), "docUID|documentUID");
        }
        catch (Exception e) {
            return null;
        }
    }

    private Document TradeskAdd(File f) throws Exception {
        this.LogToMain("Adding " + f.getName() + " to TRADESK");
        Map<String, Object> cmdRef = this.FileToTradeskParams(f, true);
        cmdRef.put("username", System.getProperty("user.name"));
        cmdRef.put("file", this.encodeFile(f));
        return this.caller.call("addDocument", cmdRef, null);
    }

    private Document TradeskReplace(File f, String docUid) throws Exception {
        if (JOptionPane.showConfirmDialog(this.mainWindow, f.getName() + "\n is already present in TRADESK!\n Would you replace it?", "Ext: Send to TRADESK", 0) == 1) {
            return null;
        }
        this.LogToMain("Replacing " + f.getName() + " into TRADESK");
        HashMap<String, Object> cmdRef = new HashMap<String, Object>();
        cmdRef.put("username", System.getProperty("user.name"));
        cmdRef.put("file", this.encodeFile(f));
        cmdRef.put("filename", f.getName());
        cmdRef.put("documentUID", docUid);
        return this.caller.call("replaceDocument", cmdRef, null);
    }

    private String encodeFile(File theFile) throws IOException {
        try (FileInputStream inz = new FileInputStream(theFile);){
            byte[] fileContent = new byte[(int)theFile.length()];
            try {
                ((InputStream)inz).read(fileContent);
            }
            catch (IOException io) {
                io.printStackTrace();
            }
            Base64.Encoder encoder = Base64.getEncoder();
            String string = encoder.encodeToString(fileContent);
            return string;
        }
    }
}

