/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;
import dgt.jwizard.ui.ImportTmxDialog;
import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.PanelProjects;
import dgt.jwizard.ui.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.openide.awt.Mnemonics;

public class CreateProjectDialog
extends JDialog {
    private JWizard mainWindow;
    private PanelProjects panel;

    public CreateProjectDialog(JWizard mainWindow, PanelProjects panel, ActionEvent ev, File projPath) {
        super((Frame)mainWindow, "Project options");
        this.setModal(true);
        this.mainWindow = mainWindow;
        this.panel = panel;
        boolean needsTagwipe = false;
        boolean needsXliff = false;
        Enumeration e = ((DefaultListModel)mainWindow.documentsListBox.getModel()).elements();
        while (e.hasMoreElements()) {
            String name = ((File)e.nextElement()).getName().toLowerCase();
            if (name.endsWith(".docx")) {
                needsTagwipe = true;
            }
            if (name.endsWith(".sdlxliff")) continue;
            needsXliff = true;
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JCheckBox tagWipeOption = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)tagWipeOption, (String)"Apply Tag&Wipe");
        if (needsTagwipe) {
            this.getContentPane().add(tagWipeOption);
        }
        JCheckBox iateOption = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)iateOption, (String)"Extract &IATE glossary");
        this.getContentPane().add(iateOption);
        JCheckBox xliffOption = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)xliffOption, (String)"SDL&xliff mode");
        if (needsXliff) {
            this.getContentPane().add(xliffOption);
        }
        tagWipeOption.setSelected(needsTagwipe);
        iateOption.setSelected(false);
        xliffOption.setSelected(needsXliff);
        JPanel pBtn = new JPanel();
        this.getContentPane().add(pBtn);
        pBtn.setLayout(new BorderLayout());
        JButton bOk = new JButton("OK");
        pBtn.add((Component)bOk, "West");
        bOk.addActionListener(okev -> {
            this.setVisible(false);
            this.CreateOk(okev, projPath, ev.getActionCommand(), tagWipeOption.isSelected(), iateOption.isSelected(), xliffOption.isSelected());
        });
        JButton bCancel = new JButton("Cancel");
        pBtn.add((Component)bCancel, "East");
        bCancel.addActionListener(cev -> this.setVisible(false));
        this.pack();
        this.setBounds(mainWindow.getX() + 50, mainWindow.getY() + 50, this.getWidth(), this.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void CreateOk(ActionEvent ev, File projPath, String command, boolean tagWipe, boolean iate, boolean xliff) {
        PrintStream log = System.err;
        this.mainWindow.msgArea.setText(command.substring(0, command.length() - 1) + "ing OmegaT Project \"" + this.mainWindow.fdProject.getText() + "\" ...");
        this.LogMessage(log, command.substring(0, command.length() - 1) + "ing OmegaT Project \"" + this.mainWindow.fdProject.getText() + "\" ...");
        for (String subdirs : new String[]{"dictionary", "euramis\\sent", "glossary", "mt", "omegat", "source", "TagWipe", "target", "tm\\auto", "tm\\tmx2source", "tm\\penalty-50"}) {
            new File(projPath, subdirs).mkdirs();
        }
        try {
            log = new PrintStream(new File(projPath, "wizard-" + command + ".log"));
        }
        catch (Exception e) {
            log = System.err;
            e.printStackTrace(log);
        }
        log.println("Running wizard 2.5.3 command " + command);
        try {
            try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new FileOutputStream(new File(projPath, "omegat.project"))));){
                out.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
                out.println("<omegat>");
                out.println("  <project version=\"1.0\">");
                out.println("    <source_dir>__DEFAULT__</source_dir>");
                out.println("    <target_dir>__DEFAULT__</target_dir>");
                out.println("    <glossary_dir>__DEFAULT__</glossary_dir>");
                out.println("    <glossary_file>__DEFAULT__</glossary_file>");
                out.println("    <dictionary_dir>__DEFAULT__</dictionary_dir>");
                out.println("    <source_lang>" + CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, this.mainWindow.srcBox.getSelectedItem().toString()) + "</source_lang>");
                out.println("    <target_lang>" + CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, this.mainWindow.traBox.getSelectedItem().toString()) + "</target_lang>");
                out.println("    <sentence_seg>" + !xliff + "</sentence_seg>");
                out.println("    <support_default_translations>true</support_default_translations>");
                out.println("  </project>");
                out.println("</omegat>");
            }
            File dest = new File(projPath, "OTStats_" + projPath.getName() + ".xlsx");
            if (!dest.exists() && new File(this.mainWindow.GLOBAL_CONFIG.getProperty("file.xls_stats")).exists()) {
                Files.copy(Paths.get(this.mainWindow.GLOBAL_CONFIG.getProperty("file.xls_stats"), new String[0]), dest.toPath(), new CopyOption[0]);
            }
            if (!xliff) {
                dest = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("file.seg_rules"));
                if (dest.exists()) {
                    try {
                        Files.copy(dest.toPath(), new File(projPath, "omegat" + File.separator + dest.getName()).toPath(), new CopyOption[0]);
                        this.LogMessage(log, "Copied " + dest + " to " + projPath + File.separator + "omegat");
                    }
                    catch (FileAlreadyExistsException fae) {
                        this.LogMessage(log, "Segmentation rules already exist: " + projPath + File.separator + "omegat" + File.separator + dest.getName());
                    }
                    catch (Exception other) {
                        other.printStackTrace(log);
                    }
                } else {
                    this.LogMessage(log, "Did not find segmentation rules: " + dest);
                }
            }
            this.LogMessage(log, "Copying file(s) into OmegaT Projects ...");
            dest = new File(projPath, "source");
            DefaultListModel list = (DefaultListModel)this.mainWindow.documentsListBox.getModel();
            Pattern ORI_LANG = Pattern.compile(this.mainWindow.srcBox.getSelectedItem().toString().toUpperCase() + "-OR[IC]");
            Enumeration e = list.elements();
            while (e.hasMoreElements()) {
                File f = (File)e.nextElement();
                if (f.getName().endsWith(".sdlxliff")) {
                    this.TestResegment(f.toPath(), null, log);
                }
                String newName = ORI_LANG.matcher(f.getName()).replaceAll("00-" + this.mainWindow.traBox.getSelectedItem().toString().toUpperCase() + "-TRA");
                this.LogMessage(log, "Copying " + f + " to source/" + newName);
                File destFile = new File(dest, newName);
                if (destFile.exists()) {
                    if (JOptionPane.showConfirmDialog(this.mainWindow, destFile + " already exists. Overwrite?", "Alert", 0) != 0) continue;
                    Files.copy(f.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    continue;
                }
                Files.copy(f.toPath(), destFile.toPath(), new CopyOption[0]);
            }
            String langJokers = this.mainWindow.srcBox.getSelectedItem().toString() + "-" + this.mainWindow.traBox.getSelectedItem().toString();
            File srcDir = new File(projPath, "source");
            if (tagWipe) {
                this.Wipe(srcDir, log);
            }
            if (iate) {
                this.IATE(srcDir, langJokers, log);
            }
            if (xliff) {
                String canReuseStr = this.mainWindow.GLOBAL_CONFIG.getProperty("SdlTradosProjects.Automated.Reuse").trim();
                boolean canReuseBool = "true".equals(canReuseStr) || tagWipe && "isWipe".equals(canReuseStr) || !tagWipe && "noWipe".equals(canReuseStr);
                this.CreateTradosProjects(srcDir, canReuseBool, log);
            }
            this.LogMessage(log, "Searching memories to import ...");
            if (list.size() == 0) {
                this.LogMessage(log, "No files found");
            }
            new ImportTmxDialog(this.mainWindow, this, list, new File(projPath, "tm"), langJokers, log).setVisible(true);
            list.clear();
            this.panel.Backup(ev);
            dest = new File(new File(projPath, "TagWipe"), "TagWipe.cmd");
            if (!dest.exists()) {
                Files.copy(new File(this.mainWindow.GLOBAL_CONFIG.getProperty("exe.TagWipeCMD")).toPath(), dest.toPath(), new CopyOption[0]);
            }
            this.mainWindow.runOtButton.setBackground(new Color(0, 204, 0));
            this.mainWindow.runOtButton.setEnabled(true);
            this.mainWindow.msgArea.setText("You can now Open Project !");
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.getClass() + " :\n" + e.getMessage(), "alert", 0);
            e.printStackTrace(log);
        }
        finally {
            try {
                log.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String languageWithCountry(Properties config, String lang) {
        if (lang.contains("-")) {
            return lang;
        }
        String country = config.getProperty("country." + lang.toLowerCase());
        if (country == null) {
            country = lang;
        } else if (country.length() == 0) {
            country = lang;
        }
        return lang + "-" + country;
    }

    private void LogMessage(PrintStream out, String msg) {
        out.println(msg);
        this.mainWindow.msgArea.append(msg);
    }

    private void ExecAndLog(String[] params, PrintStream log) throws IOException, InterruptedException {
        this.LogMessage(log, "Run " + String.join((CharSequence)" ", params));
        Process proc = Runtime.getRuntime().exec(params);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                log.println("\t" + line);
            }
        }
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        var5_5 = null;
        try {
            while ((line = reader.readLine()) != null) {
                log.println("\t" + line);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var5_5 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
        proc.waitFor();
    }

    private void Wipe(File sourceDir, PrintStream log) {
        String cmd = this.mainWindow.GLOBAL_CONFIG.getProperty("exe.TagWipeCMD");
        if (cmd == null || !new File(cmd).exists()) {
            log.println("Could not find Tagwipe cmd (" + cmd + ")");
            return;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(sourceDir.toPath(), "*.docx");){
            for (Path p : dirStream) {
                this.LogMessage(log, "Wipe " + p + " ... ");
                JFrame waitDlg = SwingUtils.showLongProcessDialog(this, "Wipe " + p + " ... ");
                this.ExecAndLog(new String[]{cmd, p.toString()}, log);
                waitDlg.setVisible(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace(log);
        }
    }

    private void IATE(File sourceDir, String langJokers, PrintStream log) {
        if (!sourceDir.exists()) {
            return;
        }
        this.LogMessage(log, "Creating IATE list of words ... ");
        String cmd = this.mainWindow.GLOBAL_CONFIG.getProperty("exe.WordsListCMD");
        if (new File(cmd).exists()) {
            try {
                this.ExecAndLog(new String[]{cmd, sourceDir.toString()}, log);
            }
            catch (Exception e) {
                e.printStackTrace(log);
                return;
            }
        } else {
            this.LogMessage(log, "Cannot find " + cmd);
            return;
        }
        this.LogMessage(log, "Creating IATE " + langJokers + " glossary ... ");
        cmd = this.mainWindow.GLOBAL_CONFIG.getProperty("exe.IateCMD");
        if (new File(cmd).exists()) {
            try {
                File dest = new File(sourceDir.getParentFile(), "glossary");
                dest = new File(dest, langJokers + ".txt");
                JFrame waitDlg = SwingUtils.showLongProcessDialog(this, "Creating IATE " + langJokers + " glossary ... ");
                this.ExecAndLog(new String[]{cmd, dest.toString()}, log);
                waitDlg.setVisible(false);
            }
            catch (Exception e) {
                e.printStackTrace(log);
            }
        } else {
            this.LogMessage(log, "Cannot find " + cmd);
            return;
        }
    }

    private void CreateTradosProjects(File sourceDir, boolean canReuse, PrintStream log) throws IOException, InterruptedException {
        String cmd = this.mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine");
        if (cmd == null || !new File(cmd).exists()) {
            log.println("Could not find Trados cmd (" + cmd + ")");
            return;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(sourceDir.toPath(), "*.*");){
            for (Path p : dirStream) {
                File destDir;
                if (p.getFileName().toString().toLowerCase().endsWith(".sdlxliff")) {
                    this.LogMessage(log, "File " + p + " already in Xliff format. Pass.");
                    continue;
                }
                if (this.mainWindow.secemOption.isSelected()) {
                    destDir = this.SecemProjectPath(p.getFileName().toString());
                    this.LogMessage(log, "File " + p + ": check for Trados SECEM project " + destDir + " --> " + destDir.exists());
                    if (destDir.exists()) {
                        this.TestResegment(p, destDir, log);
                        this.MoveTradosFile(sourceDir, p, destDir, log);
                        continue;
                    }
                    JOptionPane.showMessageDialog(this.mainWindow, destDir.getName() + ": \nSECEM SDLXLIFF project must be created from CAT client");
                    continue;
                }
                destDir = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects"));
                destDir = new File(destDir, this.TradosProjectName(p.getFileName().toString()));
                this.LogMessage(log, "File " + p + ": check for Trados project " + destDir + " --> " + destDir.exists());
                if (destDir.exists()) {
                    String message = destDir + " already exists.\nDo you want to rewrite (YES) or re-use existing (NO)?";
                    if (new File(destDir, "Products").exists()) {
                        message = message + "\nWarning: This project is finalized, modification via OmegaT may not work!";
                    }
                    switch (JOptionPane.showConfirmDialog(this.mainWindow, message, "Alert", 0)) {
                        case 1: {
                            this.LogMessage(log, "User selected to re-use");
                            this.TestResegment(p, destDir, log);
                            this.MoveTradosFile(sourceDir, p, destDir, log);
                            break;
                        }
                        case 0: {
                            this.LogMessage(log, "User selected to overwrite");
                            SwingUtils.delTree(destDir);
                            this.CreateTradosFile(sourceDir, p, destDir, canReuse, log);
                        }
                    }
                    continue;
                }
                this.CreateTradosFile(sourceDir, p, destDir, canReuse, log);
            }
        }
    }

    public File SecemProjectPath(String fileName) {
        File destDir = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects"));
        destDir = new File(destDir.getParentFile(), "Sensitive Projects");
        return new File(destDir, this.TradosProjectName(fileName));
    }

    public String TradosProjectName(String fileName) {
        fileName = fileName.substring(0, fileName.indexOf(46)).toUpperCase();
        fileName = fileName.replace("-" + this.mainWindow.traBox.getSelectedItem().toString() + "-TRA", "-" + this.mainWindow.srcBox.getSelectedItem().toString() + "-" + this.mainWindow.traBox.getSelectedItem().toString());
        fileName = fileName.replace("-" + this.mainWindow.srcBox.getSelectedItem().toString() + "-ORI", "-00-" + this.mainWindow.srcBox.getSelectedItem().toString() + "-" + this.mainWindow.traBox.getSelectedItem().toString());
        return fileName;
    }

    private void CreateTradosFile(File sourceDir, Path nativeFile, File destDir, boolean canReuse, PrintStream log) throws IOException, InterruptedException {
        this.mainWindow.msgArea.setText("Creating trados project for " + nativeFile + " ... \n");
        this.repaint();
        Matcher dgtMatch = BackupTask.DGT_PROJ.matcher(nativeFile.getFileName().toString());
        if (canReuse && dgtMatch.find()) {
            File ongoingPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers"));
            ongoingPath = new File(ongoingPath, dgtMatch.group(1));
            ongoingPath = new File(ongoingPath, dgtMatch.group(1) + "-" + dgtMatch.group(2));
            ongoingPath = new File(ongoingPath, "archive");
            String nativeName = this.TradosProjectName(nativeFile.getFileName().toString());
            nativeName = nativeName + "-ARCHIVE-AUTOCREATED.sdlppx";
            ongoingPath = new File(ongoingPath, nativeName);
            this.LogMessage(log, "Search Trados project " + ongoingPath.getName() + " in ongoing file system (" + ongoingPath.getParent() + ")");
            if (ongoingPath.exists()) {
                Throwable throwable;
                this.LogMessage(log, "Found, extracting to " + destDir);
                try (File[] zis = new ZipInputStream(new FileInputStream(ongoingPath));){
                    ZipEntry entry;
                    byte[] buffer = new byte[1024];
                    while ((entry = zis.getNextEntry()) != null) {
                        File destFile = new File(destDir, entry.getName());
                        destFile.getParentFile().mkdirs();
                        FileOutputStream fos = new FileOutputStream(destFile);
                        throwable = null;
                        try {
                            int len;
                            while ((len = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, len);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (fos == null) continue;
                            if (throwable != null) {
                                try {
                                    fos.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            fos.close();
                        }
                    }
                }
                for (File child : destDir.listFiles()) {
                    if (!child.getName().toLowerCase().endsWith(".sdlproj")) continue;
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(child)));){
                        throwable = null;
                        try (PrintStream outp = new PrintStream(child.toString() + ".tmp");){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                line = line.replace("<PackageProject", "<Project").replace("</PackageProject", "</Project");
                                outp.print(line);
                                if (line.endsWith("\n")) continue;
                                outp.println("");
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                    }
                    child.delete();
                    new File(child.toString() + ".tmp").renameTo(new File(child.toString().replaceAll("-\\d{4,8}-\\d{1,2}h\\d{1,2}m\\d{1,2}s\\.", ".")));
                }
                this.MoveTradosFile(sourceDir, nativeFile, destDir, log);
                return;
            }
        }
        this.LogMessage(log, (canReuse ? "Project not in ongoing file system" : "Not using auto projects") + ", calling Trados to " + destDir.getName());
        String srcLang = this.mainWindow.srcBox.getSelectedItem().toString();
        String traLang = this.mainWindow.traBox.getSelectedItem().toString();
        srcLang = CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, srcLang.toLowerCase());
        traLang = CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, traLang.toLowerCase());
        CharSequence[] params = new String[]{this.mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine"), "--create-full", destDir.toString(), srcLang, traLang, nativeFile.toString()};
        JFrame waitDlg = SwingUtils.showLongProcessDialog(this, "Creating Trados Project " + destDir + " ... ");
        log.println("Execute " + String.join((CharSequence)" ", params));
        this.ExecAndLog((String[])params, log);
        this.MoveTradosFile(sourceDir, nativeFile, destDir, log);
        this.LogMessage(log, "Project created OK");
        waitDlg.setVisible(false);
    }

    private void TestResegment(Path nativeFile, File destDir, PrintStream log) throws IOException, InterruptedException {
        File destFile = destDir == null ? nativeFile.toFile().getParentFile() : new File(destDir, CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, this.mainWindow.traBox.getSelectedItem().toString()));
        destFile = nativeFile.toString().endsWith(".sdlxliff") ? new File(destFile, nativeFile.getFileName().toString()) : new File(destFile, nativeFile.getFileName().toString() + ".sdlxliff");
        this.LogMessage(log, "" + destFile + " exists, check for segmentation...");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(destFile)));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("mtype=\"seg\"")) continue;
                this.LogMessage(log, "" + destFile + " already segmented.");
                return;
            }
        }
        destFile = destFile.getParentFile().getParentFile();
        for (File f : destFile.listFiles()) {
            if (!f.getName().endsWith(".sdlproj")) continue;
            this.LogMessage(log, "Call Trados segmentation for project " + f);
            String[] params = new String[]{this.mainWindow.GLOBAL_CONFIG.getProperty("exe.TradosCommandLine"), "--Translate", f.toString()};
            this.ExecAndLog(params, log);
            return;
        }
    }

    private void MoveTradosFile(File sourceDir, Path nativeFile, File destDir, PrintStream log) throws IOException, InterruptedException {
        File nativeSrcDir = new File(sourceDir.getParentFile(), "source-native");
        nativeSrcDir.mkdirs();
        log.println("Move " + nativeFile + " to " + nativeSrcDir);
        Files.move(nativeFile, Paths.get(nativeSrcDir + File.separator + nativeFile.getFileName(), new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        String traLang = CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, this.mainWindow.traBox.getSelectedItem().toString());
        String srcLang = CreateProjectDialog.languageWithCountry(this.mainWindow.GLOBAL_CONFIG, this.mainWindow.srcBox.getSelectedItem().toString());
        log.println("Copy " + destDir.toString() + File.separator + traLang + File.separator + nativeFile.getFileName() + ".sdlxliff" + " to " + sourceDir.toString() + File.separator + nativeFile.getFileName() + ".sdlxliff");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(destDir, traLang + File.separator + nativeFile.getFileName() + ".sdlxliff")), "UTF-8"));
             PrintWriter out = new PrintWriter(new File(sourceDir, nativeFile.getFileName() + ".sdlxliff"), "UTF-8");){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!(line = line.replaceAll("</(body|xliff|header|trans-unit|sdl:cxts)><", "</$1>\n<")).contains("<file original=")) {
                    out.print(line);
                    continue;
                }
                out.println(line.substring(0, line.indexOf("<file original=")));
                out.print("<file original=\"");
                out.print(destDir + File.separator + srcLang + File.separator + nativeFile.getFileName());
                out.print("\"");
                line = line.substring(line.indexOf("file original=") + 14);
                line = line.substring(line.indexOf("\"") + 1);
                line = line.substring(line.indexOf("\"") + 1);
                out.print(line);
            }
        }
    }
}

