/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.act.SendToTradeskPath;
import dgt.jwizard.act.SendToTradeskSoap;
import dgt.jwizard.ui.JWizard;
import dgt.jwizard.ui.SwingUtils;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class EuramisWindow
extends JFrame {
    public JList<File> finalizeListBox;
    private JWizard mainWindow;
    private Pattern TMX_PTN = Pattern.compile("(\\w+)-(\\d{4})-(\\d{5})-(\\d{2})-(\\d{2})-((?:\\d{2}-)?[A-Za-z]{2}-[A-Za-z]{3}-\\d\\d)");
    private Pattern REGEX_VARIABLE = Pattern.compile("(?<!\\\\)((?:\\\\\\\\)*)\\$(\\d+)");

    public EuramisWindow(JWizard mainWindow) {
        super("Send to TRAdesk - Euramis");
        this.mainWindow = mainWindow;
        this.setIconImage(new ImageIcon(this.getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
        this.setBounds(0, 0, 600, 400);
        this.getContentPane().setLayout(null);
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0, false), "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EuramisWindow.this.dispatchEvent(new WindowEvent(EuramisWindow.this, 201));
            }
        });
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2 + 50, dim.height / 2 - this.getSize().height / 2 + 50);
        this.finalizeListBox = new JList(new DefaultListModel());
        this.finalizeListBox.setBounds(165, 20, 400, 320);
        this.getContentPane().add(this.finalizeListBox);
        File projPath = new File(mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + mainWindow.fdProject.getText().trim());
        if (!projPath.exists()) {
            JOptionPane.showMessageDialog(null, "Project '" + mainWindow.fdProject.getText() + "' does not exist yet !!!", "alert", 0);
            return;
        }
        boolean okToTradesk = true;
        try {
            projPath = new File(projPath, "target-native");
            if (!projPath.exists()) {
                projPath = new File(projPath.getParentFile(), "target");
            }
            if (!projPath.exists()) {
                JOptionPane.showMessageDialog(mainWindow, "Target directory does not exist, \nPlease call 'Create translated documents' in OmegaT", "alert", 0);
                okToTradesk = false;
            }
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(projPath.toPath(), "*.*");){
                for (Path p : dirStream) {
                    ((DefaultListModel)this.finalizeListBox.getModel()).addElement(projPath.toPath().relativize(p).toFile());
                }
            }
        }
        catch (Exception dirStream) {
            // empty catch block
        }
        JPanel pFilesList = new JPanel();
        pFilesList.setBorder(new TitledBorder("Files List"));
        pFilesList.setLayout(null);
        pFilesList.setBounds(10, 15, 140, 130);
        this.getContentPane().add(pFilesList);
        SwingUtils.createButton(pFilesList, "&Add", "Add document to list", new Rectangle(25, 25, 85, 25), null, this::Add);
        SwingUtils.createButton(pFilesList, "&Remove", "Remove selected document from list", new Rectangle(25, 55, 85, 25), null, ev -> SwingUtils.RemoveFromJList(this, this.finalizeListBox));
        SwingUtils.createButton(pFilesList, "&Clear", "Clear list of documents", new Rectangle(25, 85, 85, 25), null, ev -> ((DefaultListModel)this.finalizeListBox.getModel()).removeAllElements());
        SwingUtils.createButton(this.getContentPane(), "To &Euramis", "Send Memories to Euramis", new Rectangle(20, 250, 130, 25), null, this::SendToEuramis);
        ActionListener sendTradeskMethod = null;
        String method = mainWindow.GLOBAL_CONFIG.getProperty("Tradesk.method");
        sendTradeskMethod = "file".equalsIgnoreCase(method) ? new SendToTradeskPath(mainWindow, this) : new SendToTradeskSoap(mainWindow, this);
        JButton btnToTradesk = SwingUtils.createButton(this.getContentPane(), "To &TRAdesk", "Send documents to TRAdesk", new Rectangle(20, 280, 130, 25), null, sendTradeskMethod);
        if (!okToTradesk) {
            btnToTradesk.setEnabled(false);
        }
    }

    private void Add(ActionEvent ev) {
        File[] selected;
        File targetPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText() + File.separator + "target-native");
        if (!targetPath.exists()) {
            targetPath = new File(targetPath.getParentFile(), "target");
        }
        JFileChooser fChooser = new JFileChooser(targetPath);
        fChooser.setMultiSelectionEnabled(true);
        fChooser.setFileFilter(new FileNameExtensionFilter("Dossiers (*.docx;*.xls?;*.pptx;*.xml;*.htm?;*.sdlxliff;*.xliff)", "docx", "xlsx", "pptx", "xml", "htm", "html", "xliff", "xlf", "sdlxliff"));
        while (fChooser.showOpenDialog(this) == 0 && (selected = fChooser.getSelectedFiles()) != null && selected.length != 0) {
            DefaultListModel model = (DefaultListModel)this.finalizeListBox.getModel();
            for (File f : selected) {
                File rel = targetPath.toPath().relativize(f.toPath()).toFile();
                if (model.contains(rel)) continue;
                model.addElement(rel);
            }
        }
    }

    private void SendToEuramis(ActionEvent ev) {
        String alignDir = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Euramis4Alignment");
        if ("true".equals(this.mainWindow.GLOBAL_CONFIG.getProperty("wizard.EuramisProject"))) {
            alignDir = alignDir + File.separator + this.mainWindow.fdProject.getText();
        }
        String path = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.mainWindow.fdProject.getText() + File.separator + "Euramis";
        try (PrintStream log = new PrintStream(path + File.separator + ".." + File.separator + "wizard-to-euramis.log");){
            try {
                int count = 0;
                try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(Paths.get(path, new String[0]), "*.tmx");){
                    for (Path curFile : dirStream) {
                        log.println("File " + curFile + ": \n");
                        String euramisFile = alignDir + File.separator + "SAVE_" + System.getProperty("user.name").toUpperCase() + "_";
                        String dossierTmx = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
                        String pretFile = this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
                        String curFileName = curFile.getName(curFile.getNameCount() - 1).toString();
                        Matcher dsrMatch = this.TMX_PTN.matcher(curFileName);
                        if (dsrMatch.find()) {
                            euramisFile = euramisFile + this.expandMatcher(dsrMatch, "$1-$2-$3$4$5-{src}-{tra}-EXP.tmx");
                            dossierTmx = dossierTmx + this.expandMatcher(dsrMatch, "$1/$1-$2-$3/final/$0-{src}-{tra}.tmx");
                            pretFile = pretFile + this.expandMatcher(dsrMatch, "$1/$1-$2-$3/pret/$0-{src}-{tra}.tmx");
                        } else {
                            euramisFile = euramisFile + curFileName;
                            dossierTmx = dossierTmx + "final" + File.separator + curFileName;
                            pretFile = pretFile + "pret" + File.separator + curFileName;
                        }
                        for (String dest : new String[]{euramisFile, dossierTmx, pretFile}) {
                            log.println("\t" + dest + "\n");
                            Files.copy(curFile, Paths.get(dest, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                        }
                        curFile.toFile().renameTo(new File(path + File.separator + "sent" + File.separator + curFileName));
                        this.LogToMain("" + curFile + " sent to Euramis");
                        ++count;
                        log.println("\t-->\t" + path + File.separator + "sent" + File.separator + curFileName);
                    }
                }
                this.LogToMain("" + count + " file(s) sent to Euramis");
            }
            catch (Exception e) {
                log.println(e.getClass().getName() + ": " + e.getMessage());
                e.printStackTrace(log);
                JOptionPane.showMessageDialog(null, e.getClass().getName(), "alert", 0);
            }
        }
        catch (IOException io) {
            JOptionPane.showMessageDialog(null, io.getClass().getName(), "alert", 0);
        }
    }

    private String expandMatcher(Matcher matcher1, String expression) {
        expression = expression.replace("{src}", this.mainWindow.srcBox.getSelectedItem().toString()).replace("{tra}", this.mainWindow.traBox.getSelectedItem().toString());
        Matcher varMatch = this.REGEX_VARIABLE.matcher(expression);
        StringBuffer buf = new StringBuffer();
        while (varMatch.find()) {
            varMatch.appendReplacement(buf, varMatch.group(1) + matcher1.group(Integer.parseInt(varMatch.group(2))));
        }
        varMatch.appendTail(buf);
        return buf.toString().replace("/", File.separator);
    }

    public void LogToMain(String text) {
        this.mainWindow.msgArea.setText(this.mainWindow.msgArea.getText() + "\n" + text);
    }
}

