/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.act.BackupTask;
import dgt.jwizard.ui.CreateProjectDialog;
import dgt.jwizard.ui.JWizard;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ImportTmxDialog
extends JDialog {
    private JWizard mainWindow;
    private CreateProjectDialog parent;
    private File tmxPath;
    private JPanel tmxSameDoc = new JPanel();
    private JPanel tmxSameDossier = new JPanel();
    private JPanel tmxOthers = new JPanel();

    public ImportTmxDialog(JWizard mainWindow, CreateProjectDialog parent, DefaultListModel list, File tmxPath, String langJokers, PrintStream log) throws IOException {
        super((Dialog)parent, true);
        this.setTitle("TMX files to import");
        this.mainWindow = mainWindow;
        this.tmxPath = tmxPath;
        this.parent = parent;
        this.tmxSameDoc.setLayout(new BoxLayout(this.tmxSameDoc, 1));
        this.tmxSameDossier.setLayout(new BoxLayout(this.tmxSameDossier, 1));
        this.tmxOthers.setLayout(new BoxLayout(this.tmxOthers, 1));
        Path DOSSIERS_PATH = Paths.get(mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers"), new String[0]);
        HashMap<String, JCheckBox> boxes = new HashMap<String, JCheckBox>();
        Enumeration e = list.elements();
        while (e.hasMoreElements()) {
            File tradosPath;
            File f = (File)e.nextElement();
            Matcher mProj = BackupTask.DGT_PROJ.matcher(f.getName());
            if (!mProj.find()) continue;
            this.LogMessage(log, "Exploring " + mProj.group() + " " + langJokers + " tmx's ...");
            if (mainWindow.secemOption.isSelected() && (tradosPath = new File(parent.SecemProjectPath(f.getName()), "RefTm")).exists()) {
                this.browseDirectory(tradosPath.toPath(), langJokers, mProj, boxes, log);
            }
            String curDossierPret = mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator;
            if (!new File(curDossierPret = curDossierPret + mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret").exists()) {
                this.LogMessage(log, "\t" + curDossierPret + " not found");
                continue;
            }
            this.browseDirectory(Paths.get(curDossierPret, new String[0]), langJokers, mProj, boxes, log);
        }
        Container pane = this.getContentPane();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.add(new JLabel("Same document, version and part"));
        pane.add(new JScrollPane(this.tmxSameDoc));
        pane.add(this.ChangeButtonsPanel(this.tmxSameDoc));
        pane.add(new JLabel("Same dossier, other version and part"));
        pane.add(new JScrollPane(this.tmxSameDossier));
        pane.add(this.ChangeButtonsPanel(this.tmxSameDossier));
        pane.add(new JLabel("Other TMX from pret folder"));
        pane.add(new JScrollPane(this.tmxOthers));
        pane.add(this.ChangeButtonsPanel(this.tmxOthers));
        pane.add(new JPanel());
        JPanel pButtons = new JPanel();
        pButtons.setLayout(new BoxLayout(pButtons, 0));
        pane.add(pButtons);
        JButton btnOk = new JButton("OK");
        pButtons.add(btnOk);
        btnOk.addActionListener(ev -> this.DoImport(log));
        this.setBounds(mainWindow.getX() + 100, mainWindow.getY() + 100, 600, 630);
    }

    private void browseDirectory(Path dir, String langJokers, Matcher mProj, Map<String, JCheckBox> boxes, PrintStream log) throws IOException {
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(dir, "*" + langJokers + "*.tmx");){
            this.LogMessage(log, "\tExploring " + dir + File.separator + "*" + langJokers + "*.tmx");
            boolean isPretDir = dir.toString().toLowerCase().contains("pret");
            for (Path p : dirStream) {
                if (p.getFileName().toString().toLowerCase().startsWith("draft_")) {
                    this.LogMessage(log, "\t\tPass " + p);
                    continue;
                }
                if (ImportTmxDialog.findInProject(this.tmxPath, p)) {
                    this.LogMessage(log, "\t\tAlready in directory: " + p);
                    continue;
                }
                String name = p.getFileName().toString();
                this.LogMessage(log, "\t\tAdding " + name);
                if (isPretDir) {
                    name = mProj.group(1) + File.separator + mProj.group(1) + "-" + mProj.group(2) + File.separator + "pret" + File.separator + name;
                } else {
                    name = dir.toString() + File.separator + name;
                    name = name.substring(name.indexOf("Sensitive Projects") + ("Sensitive Projects" + File.separator).length());
                }
                JCheckBox box0 = boxes.get(name);
                if (box0 == null) {
                    box0 = new JCheckBox(name, true);
                    boxes.put(name, box0);
                }
                if (name.contains("RefTm")) {
                    box0.setBackground(new Color(255, 224, 224));
                }
                if ((name = name.substring(name.lastIndexOf(File.separator) + File.separator.length())).startsWith(mProj.group())) {
                    this.tmxSameDoc.add(box0);
                    continue;
                }
                if (name.startsWith(mProj.group(1) + "-" + mProj.group(2))) {
                    if (ImportTmxDialog.arrayContains(this.tmxSameDoc.getComponents(), box0)) continue;
                    this.tmxSameDossier.add(box0);
                    continue;
                }
                if (ImportTmxDialog.arrayContains(this.tmxSameDoc.getComponents(), box0) || ImportTmxDialog.arrayContains(this.tmxSameDossier.getComponents(), box0)) continue;
                this.tmxOthers.add(box0);
            }
        }
    }

    private static boolean arrayContains(Object[] array, Object value) {
        if (array == null) {
            return false;
        }
        for (Object obj : array) {
            if (obj != value) continue;
            return true;
        }
        return false;
    }

    private static boolean findInProject(File projPath, Path p) {
        if (new File(projPath, p.getFileName().toString()).exists()) {
            return true;
        }
        for (File sub : projPath.listFiles()) {
            if (!sub.isDirectory() || !ImportTmxDialog.findInProject(sub, p)) continue;
            return true;
        }
        return false;
    }

    private JPanel ChangeButtonsPanel(JPanel tmxPanel) {
        JPanel pChangeButtons = new JPanel();
        pChangeButtons.setLayout(new BoxLayout(pChangeButtons, 0));
        JButton btnAddAll = new JButton("Select all");
        pChangeButtons.add(btnAddAll);
        JButton btnRemoveAll = new JButton("Unselect all");
        pChangeButtons.add(btnRemoveAll);
        btnAddAll.addActionListener(ev -> {
            for (Component comp : tmxPanel.getComponents()) {
                try {
                    ((JCheckBox)comp).setSelected(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        btnRemoveAll.addActionListener(ev -> {
            for (Component comp : tmxPanel.getComponents()) {
                try {
                    ((JCheckBox)comp).setSelected(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        return pChangeButtons;
    }

    private void LogMessage(PrintStream out, String msg) {
        out.println(msg);
        this.mainWindow.msgArea.append(msg);
    }

    private void DoImport(PrintStream log) {
        this.LogMessage(log, "Importing memories ... ");
        for (JPanel panel : new JPanel[]{this.tmxSameDoc, this.tmxSameDossier, this.tmxOthers}) {
            for (Component comp : panel.getComponents()) {
                try {
                    JCheckBox box = (JCheckBox)comp;
                    if (!box.isSelected()) continue;
                    String fileName = box.getText();
                    File dest = this.tmxPath;
                    if (fileName.toLowerCase().endsWith("-mt.tmx")) {
                        dest = new File(dest.getParentFile(), "mt");
                        dest.mkdirs();
                    }
                    if ((dest = new File(dest, fileName.substring(fileName.lastIndexOf(File.separator) + 1))).exists()) continue;
                    if (fileName.toLowerCase().contains(File.separator + "pret" + File.separator)) {
                        this.LogMessage(log, "\t" + this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator + fileName + " --> " + dest);
                        Files.copy(Paths.get(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.Dossiers") + File.separator + fileName, new String[0]), dest.toPath(), new CopyOption[0]);
                        continue;
                    }
                    File tradosPath = new File(this.mainWindow.GLOBAL_CONFIG.getProperty("Paths.SdlTradosProjects"));
                    tradosPath = new File(tradosPath.getParentFile(), "Sensitive Projects");
                    this.LogMessage(log, "\t" + tradosPath + File.separator + fileName + " --> " + dest);
                    Files.copy(Paths.get(tradosPath + File.separator + fileName, new String[0]), dest.toPath(), new CopyOption[0]);
                }
                catch (ClassCastException box) {
                }
                catch (IOException io) {
                    this.LogMessage(log, io.getClass().getName() + ": " + io.getMessage());
                }
            }
        }
        this.setVisible(false);
    }
}

