/*
 * Decompiled with CFR 0.152.
 */
package dgt.jwizard.ui;

import dgt.jwizard.act.AddFileAction;
import dgt.jwizard.act.BackupTask;
import dgt.jwizard.ui.EuramisWindow;
import dgt.jwizard.ui.PanelProjects;
import dgt.jwizard.ui.PanelRevision;
import dgt.jwizard.ui.SwingUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.openide.awt.Mnemonics;

public class JWizard
extends JFrame {
    public static final String VERSION = "2.5.3";
    public static final Color DEFAULT_BACKGROUND = new Color(140, 180, 232);
    protected static final Pattern PTN_ENV_VAR = Pattern.compile("\\%(\\w+)\\%", 66);
    public Properties GLOBAL_CONFIG = new Properties();
    public Properties PERSO_CONFIG = new Properties();
    public final JList<File> documentsListBox;
    public final JTextField fdProject;
    public final JTextArea msgArea;
    public final JComboBox srcBox;
    public final JComboBox traBox;
    public final JCheckBox secemOption;
    public final JButton runOtButton;

    public static void main(String[] args) {
        new JWizard().setVisible(true);
    }

    public JWizard() {
        super("OmegaT Project Wizard 2.5.3 " + SwingUtils.environment());
        this.setIconImage(new ImageIcon(this.getClass().getResource("/dgt/jwizard/ui/smiley-write.png")).getImage());
        try {
            Properties GLOBAL_CONFIG_tmp = new Properties();
            GLOBAL_CONFIG_tmp.load(new FileInputStream("global-config.properties"));
            for (Object key : GLOBAL_CONFIG_tmp.keySet()) {
                if (key.toString().startsWith(";")) continue;
                Matcher envMatch = PTN_ENV_VAR.matcher(GLOBAL_CONFIG_tmp.getProperty(key.toString()));
                StringBuffer sb = new StringBuffer();
                while (envMatch.find()) {
                    String val = System.getenv(envMatch.group(1));
                    if (val == null) {
                        JOptionPane.showMessageDialog(this, "Error in config: " + envMatch.group(1) + " not found", "alert", 0);
                        val = "";
                    }
                    envMatch.appendReplacement(sb, val.replace("\\", "\\\\"));
                }
                envMatch.appendTail(sb);
                this.GLOBAL_CONFIG.setProperty(key.toString(), sb.toString());
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Cannot load global config. Cannot work.", "alert", 0);
            e.printStackTrace();
            System.exit(1);
        }
        try {
            this.PERSO_CONFIG.load(new FileInputStream("user-config.properties"));
        }
        catch (Exception e) {
            // empty catch block
        }
        this.setDefaultCloseOperation(3);
        this.setBounds(0, 0, 950, 670);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(dim.width / 2 - this.getSize().width / 2, dim.height / 2 - this.getSize().height / 2);
        Container pane = this.getContentPane();
        pane.setBackground(DEFAULT_BACKGROUND);
        pane.setLayout(null);
        SwingUtils.createButton(pane, "&Quick Guide", "Project Wizard help", new Rectangle(795, 0, 125, 20), new Color(0, 255, 0), this.openFile("helpButton.Helpfile"));
        SwingUtils.createButton(pane, "Gui&de", "Guide", new Rectangle(720, 0, 75, 20), null, this.openFile("helpButton.Guide"));
        SwingUtils.createButton(pane, "Other Gui&des", "Other documents and guides", new Rectangle(645, 0, 75, 20), null, this.openFile("helpButton.OtherGuides"));
        SwingUtils.createButton(pane, "Ne&ws", "What's New in DGT OmegaT", new Rectangle(570, 0, 75, 20), new Color(255, 255, 102), this.openFile("helpButton.News"));
        SwingUtils.createButton(pane, "Stats", "Current Project Statistics", new Rectangle(495, 0, 75, 20), null, ev -> this.ViewStats());
        SwingUtils.createButton(pane, "Videos", "Demo Videos", new Rectangle(420, 0, 75, 20), null, ev -> this.Videos());
        this.documentsListBox = new JList(new DefaultListModel());
        pane.add(this.documentsListBox);
        this.documentsListBox.setBounds(165, 30, 610, 450);
        JPanel panDocuments = new JPanel();
        pane.add(panDocuments);
        panDocuments.setBounds(10, 15, 95, 90);
        panDocuments.setBackground(DEFAULT_BACKGROUND);
        panDocuments.setBorder(new TitledBorder("Documents"));
        SwingUtils.createButton(panDocuments, "&Add", "Add documents to project document list", new Rectangle(20, 30, 75, 25), null, ev -> this.AddFile());
        SwingUtils.createButton(panDocuments, "&Remove", "Remove documents from project document list", new Rectangle(20, 60, 75, 25), null, ev -> SwingUtils.RemoveFromJList(this, this.documentsListBox));
        this.secemOption = new JCheckBox("SECEM");
        pane.add(this.secemOption);
        this.secemOption.setBounds(20, 150, 75, 20);
        this.secemOption.setBackground(DEFAULT_BACKGROUND);
        this.secemOption.setToolTipText("SECEM mode (no backup)");
        this.secemOption.setSelected(false);
        PanelProjects panProjects = new PanelProjects(this);
        pane.add(panProjects);
        panProjects.setBounds(10, 205, 145, 280);
        panProjects.setBackground(DEFAULT_BACKGROUND);
        this.runOtButton = SwingUtils.createButton(pane, "&Open", "Open selected project", new Rectangle(20, 500, 75, 25), new Color(0, 204, 0), ev -> this.StartOmegaT());
        PanelRevision panRevision = new PanelRevision(this);
        pane.add(panRevision);
        panRevision.setBounds(785, 25, 135, 320);
        this.secemOption.addChangeListener(ev -> {
            panRevision.panRevTranslator.toggleSecem();
            panRevision.panRevRevisor.toggleSecem();
        });
        JPanel panEuramis = new JPanel();
        pane.add(panEuramis);
        panEuramis.setBounds(785, 355, 135, 100);
        panEuramis.setBackground(DEFAULT_BACKGROUND);
        panEuramis.setBorder(new TitledBorder("Euramis/Tradesk"));
        panEuramis.setLayout(null);
        SwingUtils.createButton(panEuramis, "Send", "Send to Tradesk - Euramis", new Rectangle(10, 18, 95, 25), null, ev -> this.Upload());
        JLabel lbProject = new JLabel();
        Mnemonics.setLocalizedText((JLabel)lbProject, (String)"&Project");
        pane.add(lbProject);
        lbProject.setBounds(115, 495, 50, 25);
        lbProject.setBackground(DEFAULT_BACKGROUND);
        this.fdProject = new JTextField();
        pane.add(this.fdProject);
        this.fdProject.setBounds(175, 495, 400, 25);
        this.fdProject.setToolTipText("Project name");
        if (this.PERSO_CONFIG.getProperty("project.name") != null) {
            this.fdProject.setText(this.PERSO_CONFIG.getProperty("project.name"));
        }
        JLabel srcLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)srcLabel, (String)"&Source");
        pane.add(srcLabel);
        srcLabel.setBackground(DEFAULT_BACKGROUND);
        srcLabel.setBounds(620, 495, 50, 25);
        this.srcBox = new JComboBox<String>(this.GLOBAL_CONFIG.getProperty("languages.list").split(","));
        pane.add(this.srcBox);
        this.srcBox.setBounds(680, 495, 50, 25);
        this.srcBox.setToolTipText("Select Source language");
        if (this.PERSO_CONFIG.getProperty("lang.src") != null) {
            this.srcBox.setSelectedItem(this.PERSO_CONFIG.getProperty("lang.src"));
        } else {
            this.srcBox.setSelectedItem("EN");
        }
        JLabel traLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)traLabel, (String)"&Target");
        pane.add(traLabel);
        traLabel.setBackground(DEFAULT_BACKGROUND);
        traLabel.setBounds(770, 495, 50, 25);
        this.traBox = new JComboBox<String>(this.GLOBAL_CONFIG.getProperty("languages.list").split(","));
        pane.add(this.traBox);
        this.traBox.setBounds(820, 495, 50, 25);
        this.traBox.setToolTipText("Select Target language");
        if (this.PERSO_CONFIG.getProperty("lang.tra") != null) {
            this.traBox.setSelectedItem(this.PERSO_CONFIG.getProperty("lang.tra"));
        } else {
            this.srcBox.setSelectedItem("FR");
        }
        this.srcBox.addItemListener(ev -> this.setPropValue(this.srcBox, "lang.src"));
        this.traBox.addItemListener(ev -> this.setPropValue(this.traBox, "lang.tra"));
        this.msgArea = new JTextArea();
        JScrollPane scrollArea = new JScrollPane(this.msgArea);
        pane.add(scrollArea);
        scrollArea.setBounds(10, 540, 900, 70);
        this.msgArea.setEditable(false);
        this.msgArea.setBackground(new Color(157, 197, 249));
    }

    private ActionListener openFile(String propName) {
        return ev -> {
            String fileName = this.GLOBAL_CONFIG.getProperty(propName);
            if (fileName == null) {
                JOptionPane.showMessageDialog(null, "Property not configured: " + propName, "alert", 0);
            } else if (fileName.length() == 0) {
                JOptionPane.showMessageDialog(null, "Property not configured: " + propName, "alert", 0);
            } else {
                try {
                    Desktop.getDesktop().open(new File(fileName));
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(null, "Cannot load " + fileName, "alert", 0);
                }
            }
        };
    }

    private void setPropValue(JComboBox box, String propName) {
        this.PERSO_CONFIG.setProperty(propName, box.getSelectedItem().toString());
        try {
            this.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setPropValue(JCheckBox box, String propName) {
        this.PERSO_CONFIG.setProperty(propName, box.isSelected() ? "true" : "false");
        try {
            this.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void BrowseProject() {
        if (this.fdProject.getText() == null || this.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot browse a 'blank' project !!!", "alert", 0);
            return;
        }
        File path = new File(this.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.fdProject.getText().trim());
        if (!path.exists()) {
            JOptionPane.showMessageDialog(null, "Project '" + this.fdProject.getText() + "' does not exist yet !!!", "alert", 0);
            return;
        }
        this.msgArea.setText("Browsing project \"" + this.fdProject.getText() + "\" ...");
        try {
            Desktop.getDesktop().open(path);
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, "Cannot access to " + path, "alert", 0);
        }
    }

    private void AddFile() {
        this.runOtButton.setBackground(new Color(191, 191, 191));
        this.runOtButton.setEnabled(false);
        JDialog dlgAdd = new JDialog((Frame)this, "Select add method");
        dlgAdd.setModal(true);
        dlgAdd.getContentPane().setLayout(new BoxLayout(dlgAdd.getContentPane(), 1));
        AddFileAction action = AddFileAction.ALL_ACTIONS[0];
        File[] selected = action.doSelectFiles(this);
        if (selected == null) {
            return;
        }
        for (File f : selected) {
            if (!f.getPath().toString().contains("Sensitive")) continue;
            this.secemOption.setSelected(true);
            break;
        }
        DefaultListModel model = (DefaultListModel)this.documentsListBox.getModel();
        StringBuffer message = new StringBuffer("Added document(s): \n");
        for (File f : selected) {
            if (model.contains(f)) continue;
            model.addElement(f);
            message.append(f.toString()).append("\n");
        }
        this.msgArea.setText(message.toString());
        if (this.fdProject.getText() == null || this.fdProject.getText().trim().length() == 0) {
            Pattern DGT_PROJ = Pattern.compile("(\\w+-\\d{4}-\\d{5})");
            for (File f : selected) {
                Matcher mProj = DGT_PROJ.matcher(f.getName());
                if (!mProj.find()) continue;
                this.fdProject.setText(mProj.group(1));
                this.PERSO_CONFIG.setProperty("project.name", mProj.group(1));
                try {
                    this.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
            this.fdProject.setText(System.getProperty("user.name") + "-" + new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date()));
            this.PERSO_CONFIG.setProperty("project.name", this.fdProject.getText());
            try {
                this.PERSO_CONFIG.store(new FileOutputStream("user-config.properties"), "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void Upload() {
        if (this.secemOption.isSelected()) {
            JOptionPane.showMessageDialog(null, "You are translating a SECEM project!!!", "alert", 0);
            return;
        }
        if (this.fdProject.getText() == null || this.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot send a 'blank' project !!!", "alert", 0);
            return;
        }
        this.msgArea.setText("" + ((DefaultListModel)this.documentsListBox.getModel()).size() + " file(s) will be sent to TRADESK");
        ((DefaultListModel)this.documentsListBox.getModel()).removeAllElements();
        new EuramisWindow(this).setVisible(true);
    }

    private void ViewStats() {
        File destDir;
        File statsFile;
        String dst = this.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath");
        if (this.secemOption.isSelected()) {
            dst = dst + File.separator + "_SECEM";
        }
        if (!(statsFile = new File(destDir = new File(dst = dst + File.separator + this.fdProject.getText().trim()), "OTStats_" + this.fdProject.getText().trim() + ".xlsx")).exists()) {
            for (File f0 : destDir.listFiles()) {
                if (!f0.getName().startsWith("OTStats_") || !f0.getName().endsWith(".xlsx")) continue;
                f0.renameTo(statsFile);
                break;
            }
        }
        try {
            Runtime.getRuntime().exec(new String[]{this.GLOBAL_CONFIG.getProperty("exe.Excel"), "/s", statsFile.toString()});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void Videos() {
        if (this.GLOBAL_CONFIG.getProperty("Paths.Videos") == null || this.GLOBAL_CONFIG.getProperty("Paths.Videos").trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Videos directory not set !!!", "alert", 0);
            return;
        }
        File videosDir = new File(this.GLOBAL_CONFIG.getProperty("Paths.Videos"));
        if (!videosDir.exists() || !videosDir.isDirectory()) {
            JOptionPane.showMessageDialog(null, "Videos directory not found (" + videosDir + ")", "alert", 0);
            return;
        }
        JDialog videosDlg = new JDialog((Frame)this, false);
        videosDlg.setBounds(this.getX() + this.getWidth() / 2, this.getY() + this.getHeight() / 2, 350, 230);
        videosDlg.getContentPane().setLayout(new BorderLayout());
        JList videosList = new JList(new DefaultListModel());
        videosDlg.add(videosList, "North");
        try (DirectoryStream<Path> dirStream2 = Files.newDirectoryStream(videosDir.toPath(), "*.*");){
            for (Path p : dirStream2) {
                ((DefaultListModel)videosList.getModel()).addElement(videosDir.toPath().relativize(p));
            }
        }
        catch (Exception dirStream2) {
            // empty catch block
        }
        JButton btnView = new JButton("View");
        videosDlg.getContentPane().add((Component)btnView, "South");
        btnView.addActionListener(ev -> {
            try {
                Runtime.getRuntime().exec(new String[]{this.GLOBAL_CONFIG.getProperty("exe.vlc"), new File(videosDir, ((Path)videosList.getSelectedValue()).toString()).toString()});
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, "Could not open " + videosList.getSelectedValue() + " : \n" + e.getMessage(), "alert", 0);
                return;
            }
        });
        videosDlg.setVisible(true);
    }

    private void StartOmegaT() {
        if (this.fdProject.getText() == null || this.fdProject.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(null, "Cannot OPEN a 'blank' project !!!", "alert", 0);
            return;
        }
        File projDir = new File(this.GLOBAL_CONFIG.getProperty("Paths.OmegaTprojetsPath") + File.separator + this.fdProject.getText().trim());
        if (!projDir.exists() && this.secemOption.isSelected()) {
            projDir = new File(new File(projDir.getParentFile(), "_Secem"), this.fdProject.getText().trim());
        }
        if (!projDir.exists()) {
            JOptionPane.showMessageDialog(null, "Project " + this.fdProject.getText() + " does not exist yet !!!", "alert", 0);
            return;
        }
        if (!new File(projDir, "omegat.project").exists()) {
            JOptionPane.showMessageDialog(null, "File 'omegat.project' does not exist: Create or Update before !!!", "alert", 0);
            return;
        }
        this.PERSO_CONFIG.setProperty("project.name", this.fdProject.getText());
        this.msgArea.setText("Opening OmegaT Project ...");
        LinkedList<String> omegatCmd = new LinkedList<String>();
        omegatCmd.add(this.GLOBAL_CONFIG.getProperty("exe.omegat"));
        if (omegatCmd.get(0) == null || ((String)omegatCmd.get(0)).trim().length() == 0) {
            omegatCmd.set(0, System.getenv().get("JAVA_HOME"));
            if (omegatCmd.get(0) == null || ((String)omegatCmd.get(0)).trim().length() == 0) {
                JOptionPane.showMessageDialog(null, "Cannot run OmegaT:\nEither set JAVA_HOME environment variable\nor 'exe.omegat' in global-config.properties", "alert", 0);
                return;
            }
            omegatCmd.set(0, (String)omegatCmd.get(0) + "\\bin\\javaw.exe");
            int percent = 50;
            try {
                percent = Byte.parseByte("omegat.memuse");
            }
            catch (Exception exception) {
                // empty catch block
            }
            double mem = (double)Runtime.getRuntime().maxMemory() * ((double)percent / 100.0);
            int useMiB = (int)(mem / 1024.0 / 1024.0);
            omegatCmd.add("-Xmx" + useMiB + "M");
            omegatCmd.add("-Xms" + useMiB + "M");
            String config = this.GLOBAL_CONFIG.getProperty("Paths.OmegaTConfig");
            if (config != null && config.trim().length() > 0) {
                omegatCmd.add("--config-dir=" + config);
            }
        }
        omegatCmd.add(projDir.toString());
        new Thread(() -> {
            PrintStream log;
            try {
                log = new PrintStream("OmegaT.run");
            }
            catch (Exception e) {
                log = System.err;
            }
            log.println(String.join((CharSequence)" ", omegatCmd.toArray(new String[0])));
            try {
                Process proc = Runtime.getRuntime().exec(omegatCmd.toArray(new String[0]));
                this.runOtButton.setEnabled(false);
                this.repaint();
                BackupTask timer = new BackupTask(this, this.fdProject.getText().trim(), true);
                try {
                    timer.interval = Integer.parseInt(this.GLOBAL_CONFIG.getProperty("backup.interval")) * 60000;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!this.secemOption.isSelected() && timer.interval > 0) {
                    timer.start();
                }
                proc.getInputStream().close();
                try (BufferedReader is = new BufferedReader(new InputStreamReader(proc.getErrorStream()));){
                    String line;
                    while ((line = is.readLine()) != null) {
                        log.println(line);
                    }
                }
                while (proc.isAlive()) {
                    proc.waitFor(5000L, TimeUnit.MILLISECONDS);
                }
                this.runOtButton.setEnabled(true);
                this.repaint();
                timer.active = false;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(null, e.getMessage(), "alert", 0);
            }
        }).start();
    }
}

